<?php
 namespace Workerman\Connection; use Workerman\Events\EventInterface; use Workerman\Worker; use \Exception; class AsyncUdpConnection extends UdpConnection { public $onConnect = null; public $onClose = null; protected $connected = false; protected $_contextOption = null; public function __construct($remote_address, $context_option = null) { list($scheme, $address) = \explode(':', $remote_address, 2); if ($scheme !== 'udp') { $scheme = \ucfirst($scheme); $this->protocol = '\\Protocols\\' . $scheme; if (!\class_exists($this->protocol)) { $this->protocol = "\\Workerman\\Protocols\\$scheme"; if (!\class_exists($this->protocol)) { throw new Exception("class \\Protocols\\$scheme not exist"); } } } $this->_remoteAddress = \substr($address, 2); $this->_contextOption = $context_option; } public function baseRead($socket) { $recv_buffer = \stream_socket_recvfrom($socket, Worker::MAX_UDP_PACKAGE_SIZE, 0, $remote_address); if (false === $recv_buffer || empty($remote_address)) { return false; } if ($this->onMessage) { if ($this->protocol) { $parser = $this->protocol; $recv_buffer = $parser::decode($recv_buffer, $this); } ++ConnectionInterface::$statistics['total_request']; try { \call_user_func($this->onMessage, $this, $recv_buffer); } catch (\Exception $e) { Worker::log($e); exit(250); } catch (\Error $e) { Worker::log($e); exit(250); } } return true; } public function send($send_buffer, $raw = false) { if (false === $raw && $this->protocol) { $parser = $this->protocol; $send_buffer = $parser::encode($send_buffer, $this); if ($send_buffer === '') { return; } } if ($this->connected === false) { $this->connect(); } return \strlen($send_buffer) === \stream_socket_sendto($this->_socket, $send_buffer, 0); } public function close($data = null, $raw = false) { if ($data !== null) { $this->send($data, $raw); } Worker::$globalEvent->del($this->_socket, EventInterface::EV_READ); \fclose($this->_socket); $this->connected = false; if ($this->onClose) { try { \call_user_func($this->onClose, $this); } catch (\Exception $e) { Worker::log($e); exit(250); } catch (\Error $e) { Worker::log($e); exit(250); } } $this->onConnect = $this->onMessage = $this->onClose = null; return true; } public function connect() { if ($this->connected === true) { return; } if ($this->_contextOption) { $context = \stream_context_create($this->_contextOption); $this->_socket = \stream_socket_client("udp://{$this->_remoteAddress}", $errno, $errmsg, 30, \STREAM_CLIENT_CONNECT, $context); } else { $this->_socket = \stream_socket_client("udp://{$this->_remoteAddress}", $errno, $errmsg); } if (!$this->_socket) { Worker::safeEcho(new \Exception($errmsg)); return; } \stream_set_blocking($this->_socket, false); if ($this->onMessage) { Worker::$globalEvent->add($this->_socket, EventInterface::EV_READ, array($this, 'baseRead')); } $this->connected = true; if ($this->onConnect) { try { \call_user_func($this->onConnect, $this); } catch (\Exception $e) { Worker::log($e); exit(250); } catch (\Error $e) { Worker::log($e); exit(250); } } } } 