<?php
 namespace GatewayWorker; use Workerman\Worker; use Workerman\Lib\Timer; class Register extends Worker { public $name = 'Register'; public $reloadable = false; public $secretKey = ''; protected $_gatewayConnections = array(); protected $_workerConnections = array(); protected $_startTime = 0; public function run() { $this->onConnect = array($this, 'onConnect'); $this->onMessage = array($this, 'onMessage'); $this->onClose = array($this, 'onClose'); $this->_startTime = time(); $this->protocol = '\Workerman\Protocols\Text'; $this->reusePort = false; parent::run(); } public function onConnect($connection) { $connection->timeout_timerid = Timer::add(10, function () use ($connection) { Worker::log("Register auth timeout (".$connection->getRemoteIp()."). See http://doc2.workerman.net/register-auth-timeout.html"); $connection->close(); }, null, false); } public function onMessage($connection, $buffer) { Timer::del($connection->timeout_timerid); $data = @json_decode($buffer, true); if (empty($data['event'])) { $error = "Bad request for Register service. Request info(IP:".$connection->getRemoteIp().", Request Buffer:$buffer). See http://doc2.workerman.net/register-auth-timeout.html"; Worker::log($error); return $connection->close($error); } $event = $data['event']; $secret_key = isset($data['secret_key']) ? $data['secret_key'] : ''; switch ($event) { case 'gateway_connect': if (empty($data['address'])) { echo "address not found\n"; return $connection->close(); } if ($secret_key !== $this->secretKey) { Worker::log("Register: Key does not match ".var_export($secret_key, true)." !== ".var_export($this->secretKey, true)); return $connection->close(); } $this->_gatewayConnections[$connection->id] = $data['address']; $this->broadcastAddresses(); break; case 'worker_connect': if ($secret_key !== $this->secretKey) { Worker::log("Register: Key does not match ".var_export($secret_key, true)." !== ".var_export($this->secretKey, true)); return $connection->close(); } $this->_workerConnections[$connection->id] = $connection; $this->broadcastAddresses($connection); break; case 'ping': break; default: Worker::log("Register unknown event:$event IP: ".$connection->getRemoteIp()." Buffer:$buffer. See http://doc2.workerman.net/register-auth-timeout.html"); $connection->close(); } } public function onClose($connection) { if (isset($this->_gatewayConnections[$connection->id])) { unset($this->_gatewayConnections[$connection->id]); $this->broadcastAddresses(); } if (isset($this->_workerConnections[$connection->id])) { unset($this->_workerConnections[$connection->id]); } } public function broadcastAddresses($connection = null) { $data = array( 'event' => 'broadcast_addresses', 'addresses' => array_unique(array_values($this->_gatewayConnections)), ); $buffer = json_encode($data); if ($connection) { $connection->send($buffer); return; } foreach ($this->_workerConnections as $con) { $con->send($buffer); } } } 