<?php
 namespace GatewayWorker; use Workerman\Connection\TcpConnection; use Workerman\Worker; use Workerman\Lib\Timer; use Workerman\Connection\AsyncTcpConnection; use GatewayWorker\Protocols\GatewayProtocol; use GatewayWorker\Lib\Context; class BusinessWorker extends Worker { public $gatewayConnections = array(); public $registerAddress = '127.0.0.1:1236'; public $eventHandler = 'Events'; public $processTimeout = 30; public $processTimeoutHandler = '\\Workerman\\Worker::log'; public $secretKey = ''; public $sendToGatewayBufferSize = 10240000; protected $_onWorkerStart = null; protected $_onWorkerReload = null; protected $_onWorkerStop= null; protected $_registerConnection = null; protected $_connectingGatewayAddresses = array(); protected $_gatewayAddresses = array(); protected $_waitingConnectGatewayAddresses = array(); protected $_eventOnConnect = null; protected $_eventOnMessage = null; protected $_eventOnClose = null; protected $_eventOnWebSocketConnect = null; protected $_sessionVersion = array(); const PERSISTENCE_CONNECTION_PING_INTERVAL = 25; public function __construct($socket_name = '', $context_option = array()) { parent::__construct($socket_name, $context_option); $backrace = debug_backtrace(); $this->_autoloadRootPath = dirname($backrace[0]['file']); } public function run() { $this->_onWorkerStart = $this->onWorkerStart; $this->_onWorkerReload = $this->onWorkerReload; $this->_onWorkerStop = $this->onWorkerStop; $this->onWorkerStop = array($this, 'onWorkerStop'); $this->onWorkerStart = array($this, 'onWorkerStart'); $this->onWorkerReload = array($this, 'onWorkerReload'); parent::run(); } protected function onWorkerStart() { if (function_exists('opcache_reset')) { opcache_reset(); } if (!class_exists('\Protocols\GatewayProtocol')) { class_alias('GatewayWorker\Protocols\GatewayProtocol', 'Protocols\GatewayProtocol'); } if (!is_array($this->registerAddress)) { $this->registerAddress = array($this->registerAddress); } $this->connectToRegister(); \GatewayWorker\Lib\Gateway::setBusinessWorker($this); \GatewayWorker\Lib\Gateway::$secretKey = $this->secretKey; if ($this->_onWorkerStart) { call_user_func($this->_onWorkerStart, $this); } if (is_callable($this->eventHandler . '::onWorkerStart')) { call_user_func($this->eventHandler . '::onWorkerStart', $this); } if (function_exists('pcntl_signal')) { pcntl_signal(SIGALRM, array($this, 'timeoutHandler'), false); } else { $this->processTimeout = 0; } if (is_callable($this->eventHandler . '::onConnect')) { $this->_eventOnConnect = $this->eventHandler . '::onConnect'; } if (is_callable($this->eventHandler . '::onMessage')) { $this->_eventOnMessage = $this->eventHandler . '::onMessage'; } else { echo "Waring: {$this->eventHandler}::onMessage is not callable\n"; } if (is_callable($this->eventHandler . '::onClose')) { $this->_eventOnClose = $this->eventHandler . '::onClose'; } if (is_callable($this->eventHandler . '::onWebSocketConnect')) { $this->_eventOnWebSocketConnect = $this->eventHandler . '::onWebSocketConnect'; } } protected function onWorkerReload($worker) { $worker->reloadable = false; Timer::add(0.05, array('Workerman\Worker', 'stopAll')); if ($this->_onWorkerReload) { call_user_func($this->_onWorkerReload, $this); } } protected function onWorkerStop() { if ($this->_onWorkerStop) { call_user_func($this->_onWorkerStop, $this); } if (is_callable($this->eventHandler . '::onWorkerStop')) { call_user_func($this->eventHandler . '::onWorkerStop', $this); } } public function connectToRegister() { foreach ($this->registerAddress as $register_address) { $register_connection = new AsyncTcpConnection("text://{$register_address}"); $secret_key = $this->secretKey; $register_connection->onConnect = function () use ($register_connection, $secret_key, $register_address) { $register_connection->send('{"event":"worker_connect","secret_key":"' . $secret_key . '"}'); if (strpos($register_address, '127.0.0.1') !== 0) { $register_connection->ping_timer = Timer::add(self::PERSISTENCE_CONNECTION_PING_INTERVAL, function () use ($register_connection) { $register_connection->send('{"event":"ping"}'); }); } }; $register_connection->onClose = function ($register_connection) { if(!empty($register_connection->ping_timer)) { Timer::del($register_connection->ping_timer); } $register_connection->reconnect(1); }; $register_connection->onMessage = array($this, 'onRegisterConnectionMessage'); $register_connection->connect(); } } public function onRegisterConnectionMessage($register_connection, $data) { $data = json_decode($data, true); if (!isset($data['event'])) { echo "Received bad data from Register\n"; return; } $event = $data['event']; switch ($event) { case 'broadcast_addresses': if (!is_array($data['addresses'])) { echo "Received bad data from Register. Addresses empty\n"; return; } $addresses = $data['addresses']; $this->_gatewayAddresses = array(); foreach ($addresses as $addr) { $this->_gatewayAddresses[$addr] = $addr; } $this->checkGatewayConnections($addresses); break; default: echo "Receive bad event:$event from Register.\n"; } } public function onGatewayMessage($connection, $data) { $cmd = $data['cmd']; if ($cmd === GatewayProtocol::CMD_PING) { return; } Context::$client_ip = $data['client_ip']; Context::$client_port = $data['client_port']; Context::$local_ip = $data['local_ip']; Context::$local_port = $data['local_port']; Context::$connection_id = $data['connection_id']; Context::$client_id = Context::addressToClientId($data['local_ip'], $data['local_port'], $data['connection_id']); $_SERVER = array( 'REMOTE_ADDR' => long2ip($data['client_ip']), 'REMOTE_PORT' => $data['client_port'], 'GATEWAY_ADDR' => long2ip($data['local_ip']), 'GATEWAY_PORT' => $data['gateway_port'], 'GATEWAY_CLIENT_ID' => Context::$client_id, ); if ($cmd !== GatewayProtocol::CMD_ON_CLOSE && isset($this->_sessionVersion[Context::$client_id]) && $this->_sessionVersion[Context::$client_id] !== crc32($data['ext_data'])) { $_SESSION = Context::$old_session = \GatewayWorker\Lib\Gateway::getSession(Context::$client_id); $this->_sessionVersion[Context::$client_id] = crc32($data['ext_data']); } else { if (!isset($this->_sessionVersion[Context::$client_id])) { $this->_sessionVersion[Context::$client_id] = crc32($data['ext_data']); } if ($data['ext_data'] != '') { Context::$old_session = $_SESSION = Context::sessionDecode($data['ext_data']); } else { Context::$old_session = $_SESSION = null; } } if ($this->processTimeout) { pcntl_alarm($this->processTimeout); } switch ($cmd) { case GatewayProtocol::CMD_ON_CONNECT: if ($this->_eventOnConnect) { call_user_func($this->_eventOnConnect, Context::$client_id); } break; case GatewayProtocol::CMD_ON_MESSAGE: if ($this->_eventOnMessage) { call_user_func($this->_eventOnMessage, Context::$client_id, $data['body']); } break; case GatewayProtocol::CMD_ON_CLOSE: unset($this->_sessionVersion[Context::$client_id]); if ($this->_eventOnClose) { call_user_func($this->_eventOnClose, Context::$client_id); } break; case GatewayProtocol::CMD_ON_WEBSOCKET_CONNECT: if ($this->_eventOnWebSocketConnect) { call_user_func($this->_eventOnWebSocketConnect, Context::$client_id, $data['body']); } break; } if ($this->processTimeout) { pcntl_alarm(0); } if ($_SESSION !== null && !is_array($_SESSION)) { throw new \Exception('$_SESSION must be an array. But $_SESSION=' . var_export($_SESSION, true) . ' is not array.'); } if ($_SESSION !== Context::$old_session && $cmd !== GatewayProtocol::CMD_ON_CLOSE) { $session_str_now = $_SESSION !== null ? Context::sessionEncode($_SESSION) : ''; \GatewayWorker\Lib\Gateway::setSocketSession(Context::$client_id, $session_str_now); $this->_sessionVersion[Context::$client_id] = crc32($session_str_now); } Context::clear(); } public function onGatewayClose($connection) { $addr = $connection->remoteAddress; unset($this->gatewayConnections[$addr], $this->_connectingGatewayAddresses[$addr]); if (isset($this->_gatewayAddresses[$addr]) && !isset($this->_waitingConnectGatewayAddresses[$addr])) { Timer::add(1, array($this, 'tryToConnectGateway'), array($addr), false); $this->_waitingConnectGatewayAddresses[$addr] = $addr; } } public function tryToConnectGateway($addr) { if (!isset($this->gatewayConnections[$addr]) && !isset($this->_connectingGatewayAddresses[$addr]) && isset($this->_gatewayAddresses[$addr])) { $gateway_connection = new AsyncTcpConnection("GatewayProtocol://$addr"); $gateway_connection->remoteAddress = $addr; $gateway_connection->onConnect = array($this, 'onConnectGateway'); $gateway_connection->onMessage = array($this, 'onGatewayMessage'); $gateway_connection->onClose = array($this, 'onGatewayClose'); $gateway_connection->onError = array($this, 'onGatewayError'); $gateway_connection->maxSendBufferSize = $this->sendToGatewayBufferSize; if (TcpConnection::$defaultMaxSendBufferSize == $gateway_connection->maxSendBufferSize) { $gateway_connection->maxSendBufferSize = 50 * 1024 * 1024; } $gateway_data = GatewayProtocol::$empty; $gateway_data['cmd'] = GatewayProtocol::CMD_WORKER_CONNECT; $gateway_data['body'] = json_encode(array( 'worker_key' =>"{$this->name}:{$this->id}", 'secret_key' => $this->secretKey, )); $gateway_connection->send($gateway_data); $gateway_connection->connect(); $this->_connectingGatewayAddresses[$addr] = $addr; } unset($this->_waitingConnectGatewayAddresses[$addr]); } public function checkGatewayConnections($addresses_list) { if (empty($addresses_list)) { return; } foreach ($addresses_list as $addr) { if (!isset($this->_waitingConnectGatewayAddresses[$addr])) { $this->tryToConnectGateway($addr); } } } public function onConnectGateway($connection) { $this->gatewayConnections[$connection->remoteAddress] = $connection; unset($this->_connectingGatewayAddresses[$connection->remoteAddress], $this->_waitingConnectGatewayAddresses[$connection->remoteAddress]); } public function onGatewayError($connection, $error_no, $error_msg) { echo "GatewayConnection Error : $error_no ,$error_msg\n"; } public function getAllGatewayAddresses() { return $this->_gatewayAddresses; } public function timeoutHandler($signal) { switch ($signal) { case SIGALRM: $e = new \Exception("process_timeout", 506); $trace_str = $e->getTraceAsString(); $trace_str = $e->getMessage() . ":\n" . substr($trace_str, strpos($trace_str, "\n") + 1) . "\n"; if (!$this->processTimeoutHandler || !call_user_func($this->processTimeoutHandler, $trace_str, $e)) { Worker::stopAll(); } break; } } } 