# 🎉 Welcome to the contributing guide! 🎉

First of all, THANK YOU for taking the time to contribute to this project! 🙌 Before you dive in, let’s go over a few guidelines to make the process as smooth (and enjoyable!) as possible.

## 💻 How to Get Started

1. **Choose an issue:**
   - Browse through the [existing issues](https://github.com/move-fast-and-break-things/minerva/issues) to find something you'd like to work on.
   - If you find an issue you'd like to work on, please comment on it to let others know you're working on it.

2. **Create an issue:**
   - If you don't find an existing issue that matches what you want to work on, you can [create a new issue](https://github.com/move-fast-and-break-things/minerva/issues/new).
   - Please provide as much detail as possible in the issue description.
   - Wait for the issue to get discussed and approved by the repository maintainers.
   - Once it is approved, please comment on it to let others know you're working on it.

## 🚀 Ready to Rock? Here's How to Submit Your Changes!

1. **Fork the repository (skip this if you have the write access to the repository):** click **"Fork"** on the repository page to create a copy in your account.

2. **Clone the repository:**
   - If you do not have the write access, clone your fork and create your branch from `main`
   - If you have the write access, clone the repository directly and create your branch from `main`

3. **Work on the issue:** make changes to the codebase. Code your heart out! ✨
4. **Commit your changes:** use descriptive commit messages explaining your changes. We follow [the conventional commits specification](https://www.conventionalcommits.org/en/v1.0.0/).
5. **Push and open a pull request:** push your branch and open a pull request with a clear description of your changes.

## 🎉 From Code to PR: Your Guide to Submitting a Pull Request

To ensure a smooth review process, please follow these guidelines when submitting a pull request:

1. **Ensure your code is up-to-date:**
   - Before starting your work, make sure to pull the latest changes from the `main` branch.
   - If there are conflicts between your branch and `main`, resolve them locally before submitting your PR.

2. **Branch naming:** use a descriptive branch name that reflects the changes.

3. **Commit messages:**
   - Write clear and concise commit messages that explain the purpose of the changes.
   - Use the present tense, e.g., "Add login feature" instead of "Added login feature."

4. **Description:**
   - Provide a clear description of the changes made in the pull request.
   - If the changes are related to a specific issue, reference in the PR description.

5. **Ask questions:** ❓ if you’re not sure about something, don’t hesitate to ask! We’re here to help each other.

6. **Include a demo:** please show the impact of your changes by including before/after screenshots or a short demo video. Visuals make everything better. 😎

7. **Test your changes:** make sure to test your changes locally to ensure they work as expected.

8. **Pull request title:**
   - Use a descriptive title for your pull request, such as "Fix search button alignment".
   - Follow [the conventional commit specification](https://www.conventionalcommits.org/en/v1.0.0/)

9. **Request a review:**
   - Once your PR is ready, request a review from one of the maintainers.
   - Be open to feedback and make changes as requested.

## 🧐 Code Review Process

### 💌 How to Receive Code Review

As a contributor submitting a pull request, please follow these guidelines when receiving feedback:

1. **Be open to feedback:** 🤗
   - Code review is a collaborative process aimed at improving the codebase.
   - Be open to suggestions and don't take feedback personally. You are not your code.

2. **Understand the feedback:**
   - Read through the review comments carefully. If something is unclear, feel free to ask for clarification.

3. **Make the necessary changes:**
   - Address the feedback by making changes to your code.
   - Commit your changes to the same branch and push the updates.

4. **Notify reviewers:** add a comment on the pull request to notify the reviewers that you have made the requested changes.

5. **Discuss further if needed:**
   - If you disagree with a suggestion, explain your reasoning respectfully in the comments.
   - Collaborate with the reviewer to find the best solution.

6. **Stay engaged:**
   - Be responsive to further comments or questions.
   - Code review is an iterative process. Continue to improve your pull request based on feedback until it's ready to be merged.
   - If the PR is approved, the contributor or maintainer can merge it.

### 🔍 How to Perform a Code Review

If you are a contributor or maintainer and you want to review a pull request, please follow these guidelines:

1. **Understand the changes:**
   - Read the pull request description to understand the proposed changes.
   - Look at the related issues (if mentioned) to understand the context.

2. **Review the code:**
   - Be a code detective! 🕵️‍♂️ Check the code for clarity, readability.
   - Verify that the code is efficient and free of obvious bugs or security issues.

3. **Provide constructive feedback:** 💬
   - Leave comments on specific lines or sections of the code.
   - Be constructive and polite in your feedback. Suggest improvements and explain why certain changes might be beneficial.
   - Use phrases like "Consider...", "Could we...", or "It might be better to..." to keep the feedback positive.

4. **Approve or request changes:**
   - If the pull request is good to go, approve it.
   - If in doubt, pull the branch locally and verify that it works as expected before approving it.
   - If it needs changes, select "Request Changes" and leave detailed feedback on what should be improved.

Thank you for contributing! You are amazing, and your work is greatly appreciated. Let's build incredible things together ✨
