export const GoogleTranslateLanguages: Record<string, string> = {
  Automatic: 'auto',
  Afrikaans: 'af',
  Albanian: 'sq',
  Amharic: 'am',
  Arabic: 'ar',
  Armenian: 'hy',
  Azerbaijani: 'az',
  Basque: 'eu',
  Belarusian: 'be',
  Bengali: 'bn',
  Bosnian: 'bs',
  Bulgarian: 'bg',
  Catalan: 'ca',
  Cebuano: 'ceb',
  Chichewa: 'ny',
  Chinese_Simplified: 'zh-CN',
  Chinese_Traditional: 'zh-TW',
  Corsican: 'co',
  Croatian: 'hr',
  Czech: 'cs',
  Danish: 'da',
  Dutch: 'nl',
  English: 'en',
  Esperanto: 'eo',
  Estonian: 'et',
  Filipino: 'tl',
  Finnish: 'fi',
  French: 'fr',
  Frisian: 'fy',
  Galician: 'gl',
  Georgian: 'ka',
  German: 'de',
  Greek: 'el',
  Gujarati: 'gu',
  Haitian_Creole: 'ht',
  Hausa: 'ha',
  Hawaiian: 'haw',
  Hebrew: 'iw',
  Hindi: 'hi',
  Hmong: 'hmn',
  Hungarian: 'hu',
  Icelandic: 'is',
  Igbo: 'ig',
  Indonesian: 'id',
  Irish: 'ga',
  Italian: 'it',
  Japanese: 'ja',
  Javanese: 'jw',
  Kannada: 'kn',
  Kazakh: 'kk',
  Khmer: 'km',
  Korean: 'ko',
  Kurdish_Kurmanji: 'ku',
  Kyrgyz: 'ky',
  Lao: 'lo',
  Latin: 'la',
  Latvian: 'lv',
  Lithuanian: 'lt',
  Luxembourgish: 'lb',
  Macedonian: 'mk',
  Malagasy: 'mg',
  Malay: 'ms',
  Malayalam: 'ml',
  Maltese: 'mt',
  Maori: 'mi',
  Marathi: 'mr',
  Mongolian: 'mn',
  Myanmar_Burmese: 'my',
  Nepali: 'ne',
  Norwegian: 'no',
  Pashto: 'ps',
  Persian: 'fa',
  Polish: 'pl',
  Portuguese: 'pt',
  Punjabi: 'pa',
  Romanian: 'ro',
  Russian: 'ru',
  Samoan: 'sm',
  Scots_Gaelic: 'gd',
  Serbian: 'sr',
  Sesotho: 'st',
  Shona: 'sn',
  Sindhi: 'sd',
  Sinhala: 'si',
  Slovak: 'sk',
  Slovenian: 'sl',
  Somali: 'so',
  Spanish: 'es',
  Sundanese: 'su',
  Swahili: 'sw',
  Swedish: 'sv',
  Tajik: 'tg',
  Tamil: 'ta',
  Telugu: 'te',
  Thai: 'th',
  Turkish: 'tr',
  Ukrainian: 'uk',
  Urdu: 'ur',
  Uzbek: 'uz',
  Vietnamese: 'vi',
  Welsh: 'cy',
  Xhosa: 'xh',
  Yiddish: 'yi',
  Yoruba: 'yo',
  Zulu: 'zu',
};

export const GoogleTranslate2Languages: Record<string, string> = {
  Automatic: 'auto',
  Afrikaans: 'af',
  Albanian: 'sq',
  Amharic: 'am',
  Arabic: 'ar',
  Armenian: 'hy',
  Azerbaijani: 'az',
  Basque: 'eu',
  Belarusian: 'be',
  Bengali: 'bn',
  Bosnian: 'bs',
  Bulgarian: 'bg',
  Catalan: 'ca',
  Cebuano: 'ceb',
  Chichewa: 'ny',
  Chinese_Simplified: 'zh-CN',
  Chinese_Traditional: 'zh-TW',
  Corsican: 'co',
  Croatian: 'hr',
  Czech: 'cs',
  Danish: 'da',
  Dutch: 'nl',
  English: 'en',
  Esperanto: 'eo',
  Estonian: 'et',
  Filipino: 'tl',
  Finnish: 'fi',
  French: 'fr',
  Frisian: 'fy',
  Galician: 'gl',
  Georgian: 'ka',
  German: 'de',
  Greek: 'el',
  Gujarati: 'gu',
  Haitian_Creole: 'ht',
  Hausa: 'ha',
  Hawaiian: 'haw',
  Hebrew: 'iw',
  Hindi: 'hi',
  Hmong: 'hmn',
  Hungarian: 'hu',
  Icelandic: 'is',
  Igbo: 'ig',
  Indonesian: 'id',
  Irish: 'ga',
  Italian: 'it',
  Japanese: 'ja',
  Javanese: 'jw',
  Kannada: 'kn',
  Kazakh: 'kk',
  Khmer: 'km',
  Korean: 'ko',
  Kurdish_Kurmanji: 'ku',
  Kyrgyz: 'ky',
  Lao: 'lo',
  Latin: 'la',
  Latvian: 'lv',
  Lithuanian: 'lt',
  Luxembourgish: 'lb',
  Macedonian: 'mk',
  Malagasy: 'mg',
  Malay: 'ms',
  Malayalam: 'ml',
  Maltese: 'mt',
  Maori: 'mi',
  Marathi: 'mr',
  Mongolian: 'mn',
  Myanmar_Burmese: 'my',
  Nepali: 'ne',
  Norwegian: 'no',
  Pashto: 'ps',
  Persian: 'fa',
  Polish: 'pl',
  Portuguese: 'pt',
  Punjabi: 'pa',
  Romanian: 'ro',
  Russian: 'ru',
  Samoan: 'sm',
  Scots_Gaelic: 'gd',
  Serbian: 'sr',
  Sesotho: 'st',
  Shona: 'sn',
  Sindhi: 'sd',
  Sinhala: 'si',
  Slovak: 'sk',
  Slovenian: 'sl',
  Somali: 'so',
  Spanish: 'es',
  Sundanese: 'su',
  Swahili: 'sw',
  Swedish: 'sv',
  Tajik: 'tg',
  Tamil: 'ta',
  Telugu: 'te',
  Thai: 'th',
  Turkish: 'tr',
  Ukrainian: 'uk',
  Urdu: 'ur',
  Uzbek: 'uz',
  Vietnamese: 'vi',
  Welsh: 'cy',
  Xhosa: 'xh',
  Yiddish: 'yi',
  Yoruba: 'yo',
  Zulu: 'zu',
};

export const LibreTranslateLanguages: Record<string, string> = {
  Automatic: 'auto',
  English: 'en',
  Arabic: 'ar',
  Azerbaijani: 'az',
  Chinese_Simplified: 'zh',
  Czech: 'cs',
  Danish: 'da',
  Dutch: 'nl',
  Esperanto: 'eo',
  Finnish: 'fi',
  French: 'fr',
  German: 'de',
  Greek: 'el',
  Hebrew: 'iw',
  Hindi: 'hi',
  Hungarian: 'hu',
  Indonesian: 'id',
  Irish: 'ga',
  Italian: 'it',
  Japanese: 'ja',
  Korean: 'ko',
  Persian: 'fa',
  Polish: 'pl',
  Portuguese: 'pt',
  Russian: 'ru',
  Slovak: 'sk',
  Spanish: 'es',
  Swedish: 'sv',
  Turkish: 'tr',
  Ukrainian: 'uk',
};

export const ArgosTranslateLanguages: Record<string, string> = {
  Automatic: 'auto',
  English: 'en',
  Arabic: 'ar',
  Chinese_Simplified: 'zh',
  French: 'fr',
  German: 'de',
  Hindi: 'hi',
  Indonesian: 'id',
  Irish: 'ga',
  Italian: 'it',
  Japanese: 'ja',
  Korean: 'ko',
  Polish: 'pl',
  Portuguese: 'pt',
  Russian: 'ru',
  Spanish: 'es',
  Turkish: 'tr',
  Vietnamese: 'vi',
};

export const BingTranslateLanguages: Record<string, string> = {
  Automatic: 'auto-detect',
  Afrikaans: 'af',
  Albanian: 'sq',
  Amharic: 'am',
  Arabic: 'ar',
  Armenian: 'hy',
  Assamese: 'as',
  Azerbaijani: 'az',
  Bangla: 'bn',
  Bashkir: 'ba',
  Basque: 'eu',
  Bosnian: 'bs',
  Bulgarian: 'bg',
  Cantonese_Traditional: 'yue',
  Catalan: 'ca',
  Chinese_Literary: 'lzh',
  Chinese_Simplified: 'zh-Hans',
  Chinese_Traditional: 'zh-Hant',
  Croatian: 'hr',
  Czech: 'cs',
  Danish: 'da',
  Dari: 'prs',
  Divehi: 'dv',
  Dutch: 'nl',
  English: 'en',
  Estonian: 'et',
  Faroese: 'fo',
  Fijian: 'fj',
  Filipino: 'fil',
  Finnish: 'fi',
  French: 'fr',
  French_Canada: 'fr-CA',
  Galician: 'gl',
  Georgian: 'ka',
  German: 'de',
  Greek: 'el',
  Gujarati: 'gu',
  Haitian_Creole: 'ht',
  Hebrew: 'he',
  Hindi: 'hi',
  Hmong: 'mww',
  Hungarian: 'hu',
  Icelandic: 'is',
  Indonesian: 'id',
  Inuinnaqtun: 'ikt',
  Inuktitut: 'iu',
  Inuktitut_Latin: 'iu-Latn',
  Irish: 'ga',
  Italian: 'it',
  Japanese: 'ja',
  Kannada: 'kn',
  Kazakh: 'kk',
  Khmer: 'km',
  Klingon_Latin: 'tlh-Latn',
  Korean: 'ko',
  Kurdish_Kurmanji: 'ku',
  Kurdish_Northern: 'kmr',
  Kyrgyz: 'ky',
  Lao: 'lo',
  Latvian: 'lv',
  Lithuanian: 'lt',
  Macedonian: 'mk',
  Malagasy: 'mg',
  Malay: 'ms',
  Malayalam: 'ml',
  Maltese: 'mt',
  Marathi: 'mr',
  Mongolian_Cyrillic: 'mn-Cyrl',
  Mongolian: 'mn-Mong',
  Myanmar_Burmese: 'my',
  Māori: 'mi',
  Nepali: 'ne',
  Norwegian: 'nb',
  Odia: 'or',
  Pashto: 'ps',
  Persian: 'fa',
  Polish: 'pl',
  Portuguese_Brazil: 'pt',
  Portuguese: 'pt-PT',
  Punjabi: 'pa',
  Querétaro_Otomi: 'otq',
  Romanian: 'ro',
  Russian: 'ru',
  Samoan: 'sm',
  Serbian_Cyrillic: 'sr-Cyrl',
  Serbian: 'sr-Latn',
  Slovak: 'sk',
  Slovenian: 'sl',
  Somali: 'so',
  Spanish: 'es',
  Swahili: 'sw',
  Swedish: 'sv',
  Tahitian: 'ty',
  Tamil: 'ta',
  Tatar: 'tt',
  Telugu: 'te',
  Thai: 'th',
  Tibetan: 'bo',
  Tigrinya: 'ti',
  Tongan: 'to',
  Turkish: 'tr',
  Turkmen: 'tk',
  Ukrainian: 'uk',
  Upper_Sorbian: 'hsb',
  Urdu: 'ur',
  Uyghur: 'ug',
  Uzbek: 'uz',
  Vietnamese: 'vi',
  Welsh: 'cy',
  Yucatec_Maya: 'yua',
  Zulu: 'zu',
};

export const DeepLTranslateLanguages: Record<string, string> = {
  Bulgarian: 'BG',
  Chinese_Simplified: 'ZH',
  Czech: 'CS',
  Danish: 'DA',
  Dutch: 'NL',
  English: 'EN',
  Estonian: 'ET',
  Finnish: 'FI',
  French: 'FR',
  German: 'DE',
  Greek: 'EL',
  Hungarian: 'HU',
  Indonesian: 'ID',
  Italian: 'IT',
  Japanese: 'JA',
  Korean: 'KO',
  Latvian: 'LV',
  Lithuanian: 'LT',
  Norwegian: 'NB',
  Polish: 'PL',
  Portuguese: 'PT',
  Romanian: 'RO',
  Russian: 'RU',
  Slovak: 'SK',
  Slovenian: 'SL',
  Spanish: 'ES',
  Swedish: 'SV',
  Turkish: 'TR',
  Ukrainian: 'UK',
};

export const GTPTranslateLanguages: Record<string, string> = {
  Automatic: 'auto',
  Afrikaans: 'af',
  Albanian: 'sq',
  Amharic: 'am',
  Arabic: 'ar',
  Armenian: 'hy',
  Azerbaijani: 'az',
  Basque: 'eu',
  Belarusian: 'be',
  Bengali: 'bn',
  Bosnian: 'bs',
  Bulgarian: 'bg',
  Catalan: 'ca',
  Cebuano: 'ceb',
  Chichewa: 'ny',
  Chinese_Simplified: 'zh-CN',
  Chinese_Traditional: 'zh-TW',
  Corsican: 'co',
  Croatian: 'hr',
  Czech: 'cs',
  Danish: 'da',
  Dutch: 'nl',
  English: 'en',
  Esperanto: 'eo',
  Estonian: 'et',
  Filipino: 'tl',
  Finnish: 'fi',
  French: 'fr',
  Frisian: 'fy',
  Galician: 'gl',
  Georgian: 'ka',
  German: 'de',
  Greek: 'el',
  Gujarati: 'gu',
  Haitian_Creole: 'ht',
  Hausa: 'ha',
  Hawaiian: 'haw',
  Hebrew: 'iw',
  Hindi: 'hi',
  Hmong: 'hmn',
  Hungarian: 'hu',
  Icelandic: 'is',
  Igbo: 'ig',
  Indonesian: 'id',
  Irish: 'ga',
  Italian: 'it',
  Japanese: 'ja',
  Javanese: 'jw',
  Kannada: 'kn',
  Kazakh: 'kk',
  Khmer: 'km',
  Korean: 'ko',
  Kurdish_Kurmanji: 'ku',
  Kyrgyz: 'ky',
  Lao: 'lo',
  Latin: 'la',
  Latvian: 'lv',
  Lithuanian: 'lt',
  Luxembourgish: 'lb',
  Macedonian: 'mk',
  Malagasy: 'mg',
  Malay: 'ms',
  Malayalam: 'ml',
  Maltese: 'mt',
  Maori: 'mi',
  Marathi: 'mr',
  Mongolian: 'mn',
  Myanmar_Burmese: 'my',
  Nepali: 'ne',
  Norwegian: 'no',
  Pashto: 'ps',
  Persian: 'fa',
  Polish: 'pl',
  Portuguese: 'pt',
  Punjabi: 'pa',
  Romanian: 'ro',
  Russian: 'ru',
  Samoan: 'sm',
  Scots_Gaelic: 'gd',
  Serbian: 'sr',
  Sesotho: 'st',
  Shona: 'sn',
  Sindhi: 'sd',
  Sinhala: 'si',
  Slovak: 'sk',
  Slovenian: 'sl',
  Somali: 'so',
  Spanish: 'es',
  Sundanese: 'su',
  Swahili: 'sw',
  Swedish: 'sv',
  Tajik: 'tg',
  Tamil: 'ta',
  Telugu: 'te',
  Thai: 'th',
  Turkish: 'tr',
  Ukrainian: 'uk',
  Urdu: 'ur',
  Uzbek: 'uz',
  Vietnamese: 'vi',
  Welsh: 'cy',
  Xhosa: 'xh',
  Yiddish: 'yi',
  Yoruba: 'yo',
  Zulu: 'zu',
};

export const LanguageMapping: Record<string, Array<string>> = {
  Automatic: [
    'google',
    'google2',
    'libre',
    'argos',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Afrikaans: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Albanian: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Amharic: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Arabic: [
    'google',
    'google2',
    'libre',
    'argos',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Assamese: ['bing'],
  Armenian: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Azerbaijani: [
    'google',
    'google2',
    'libre',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Bashkir: ['bing'],
  Basque: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Belarusian: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Bengali: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Bosnian: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Bulgarian: [
    'google',
    'google2',
    'bing',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Cantonese_Traditional: ['bing'],
  Catalan: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Cebuano: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Chichewa: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Chinese_Literary: ['bing'],
  Chinese_Simplified: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Chinese_Traditional: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Corsican: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Croatian: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Czech: [
    'google',
    'google2',
    'bing',
    'libre',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Danish: [
    'google',
    'google2',
    'bing',
    'libre',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Dari: ['bing'],
  Divehi: ['bing'],
  Dutch: [
    'google',
    'google2',
    'bing',
    'libre',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  English: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Esperanto: [
    'google',
    'google2',
    'libre',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Estonian: [
    'google',
    'google2',
    'bing',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Faroese: ['bing'],
  Fijian: ['bing'],
  Filipino: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Finnish: [
    'google',
    'google2',
    'bing',
    'libre',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  French: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  French_Canada: ['bing'],
  Frisian: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Galician: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Georgian: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  German: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Greek: [
    'google',
    'google2',
    'bing',
    'libre',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Gujarati: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Haitian_Creole: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Hausa: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Hawaiian: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Hebrew: [
    'google',
    'google2',
    'bing',
    'libre',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Hindi: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Hmong: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Hungarian: [
    'google',
    'google2',
    'bing',
    'libre',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Icelandic: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Igbo: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Indonesian: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Inuinnaqtun: ['bing'],
  Inuktitut: ['bing'],
  Inuktitut_Latin: ['bing'],
  Irish: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Italian: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Japanese: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Javanese: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Kannada: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Kazakh: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Khmer: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Klingon_Latin: ['bing'],
  Korean: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Kurdish_Kurmanji: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Kurdish_Northern: ['bing'],
  Kyrgyz: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Lao: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Latin: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Latvian: [
    'google',
    'google2',
    'bing',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Lithuanian: [
    'google',
    'google2',
    'bing',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Luxembourgish: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Macedonian: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Malagasy: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Malay: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Malayalam: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Maltese: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Maori: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Marathi: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Mongolian: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Mongolian_Cyrillic: ['bing'],
  Myanmar_Burmese: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Nepali: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Norwegian: [
    'google',
    'google2',
    'bing',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Odia: ['bing'],
  Pashto: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Persian: [
    'google',
    'google2',
    'bing',
    'libre',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Polish: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Portuguese: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Portuguese_Brazil: ['bing'],
  Punjabi: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Querétaro_Otomi: ['bing'],
  Romanian: [
    'google',
    'google2',
    'bing',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Russian: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Samoan: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Scots_Gaelic: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Serbian: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Serbian_Cyrillic: ['bing'],
  Sesotho: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Shona: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Sindhi: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Sinhala: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Slovak: [
    'google',
    'google2',
    'bing',
    'libre',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Slovenian: [
    'google',
    'google2',
    'bing',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Somali: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Spanish: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Sundanese: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Swahili: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Swedish: [
    'google',
    'google2',
    'bing',
    'libre',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Tahitian: ['bing'],
  Tajik: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Tamil: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Tatar: ['bing'],
  Telugu: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Thai: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Tibetan: ['bing'],
  Tigrinya: ['bing'],
  Tongan: ['bing'],
  Turkish: [
    'google',
    'google2',
    'bing',
    'libre',
    'argos',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Turkmen: ['bing'],
  Ukrainian: [
    'google',
    'google2',
    'bing',
    'libre',
    'deepl',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Upper_Sorbian: ['bing'],
  Urdu: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Uyghur: ['bing'],
  Uzbek: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Vietnamese: [
    'google',
    'google2',
    'bing',
    'argos',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Welsh: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Xhosa: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Yiddish: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Yoruba: [
    'google',
    'google2',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
  Yucatec_Maya: ['bing'],
  Zulu: [
    'google',
    'google2',
    'bing',
    'gpt-4o',
    'gpt-3.5-turbo',
    'gpt-4',
    'gpt-4o-mini',
  ],
};
