# SolarCalendar Components
![Embarcadero](https://img.shields.io/badge/Embarcadero-ED1F35.svg?style=for-the-badge&logo=Embarcadero&logoColor=white) ![Delphi](https://img.shields.io/badge/Delphi-B22222?style=for-the-badge&logo=delphi&logoColor=white
)

## What is SolarCalendar ?
![Delphi Supported Versions](https://img.shields.io/badge/Delphi_supported_versions-Delphi%207,%202007..2010,%20XE..XE10,%2010%20Berlin..11.*%20Alexandria_and_Delphi%2012%20Athens-red) ![GitHub License](https://img.shields.io/github/license/mohamadkh/SolarCalendar) ![GitHub Repo stars](https://img.shields.io/github/stars/mohamadkh/SolarCalendar) 
![GitHub Release](https://img.shields.io/github/v/release/mohamadkh/SolarCalendar) 


SolarCalendar is a collection of components for Delphi developers and specially for Persian language developers. The package has got set of components for showing and selecting Persian/Iranian/Solar/Shamsi/Jalali date in Persian/Shamsi and Christian(gregorian) interface and many more functions. I started to write a commercial calendar components for Delphi, then I noticed that my calendar component and its features got bigger and bigger. So I decided to share it with the Delphi developers community in hope it will be useful.


In **2008**, the source of this collection was published for the first time on SourceForge and Barnamaenevis.org sites.
<br>
<br>

## Features
- Contains components and classes for Borland Delphi 7, 2005, 2006, CodeGear Delphi 2007-2009, Embarcadero RAD Studio 2010, XE-XE10, Delphi 11.x, Delphi 12.x
- Switch between Persian and Christian(gregorian) interface and vice versa.
- Data-aware (DataField)
- Too many functions for working with Date(IncYear, IncMonth, IncDay, DaysBetween, GotoMonth, ConvertDate, ...)
- Use date calculation functions independently (TPublicUtils)
- Customizable Interface (Include various themes)
- The entered date is automatically checked (AutoCheck)
- Customization of exception messages
- Handle Change layout, Button click events
- Includes complete guide as a PDF file

<br>

### SolarCalendar in Persian/Jalali mode
![image](https://cloud.githubusercontent.com/assets/6840737/25553015/d8c7e128-2cbd-11e7-9f2d-0e4cb2894f42.png)

<br>

### SolarCalendar in Gregorian/Christian mode
![image](https://cloud.githubusercontent.com/assets/6840737/25553021/e9e8ca62-2cbd-11e7-9a8a-bcf65ff7afd4.png)

<br>

### SolarCalendar all themes
![image](https://cloud.githubusercontent.com/assets/6840737/25553022/ff26a106-2cbd-11e7-8744-dba590661fa9.png)

# Developed By
- Mohamad Khorsandi

### [TSolarCalendar].Create Better Applications

<br>

<p align="left">
کامپوننت تقویم شمسی(جلالی)/میلادی (دلفی Delphi)
</p>
