[//]: # (header-start)

<h1 align="center">
	<a href="https://blog.axway.com/mobile-apps/changes-to-application-development-services">
		Preparing for end of Axway
	</a>	
</h1>
<h2 align="center">
	👇 &nbsp; support for Amplify Cloud and Mobile   &nbsp; 👇
</h2>	

<a href="https://brenton.house/saying-goodbye-to-axway-amplify-titanium-31a44f3671de">
	<p align="center">
		<img src="https://cdn.secure-api.org/images/RIP-Axway-Amplify-Titanium.png" alt="RIP Axway Amplify Titanium (2010 - 2022)" width="80%" />
	</p>
</a>	
<p align="center">
	<a href="https://blog.axway.com/mobile-apps/changes-to-application-development-services">
			🪦 &nbsp; RIP Axway Amplify Titanium (2010 - 2022)
	</a>
</p>
<p align="center">
	<a href="https://blog.axway.com/mobile-apps/prepare-your-apps-for-appcelerator-end-of-support">
			🪦 &nbsp; RIP Axway Amplify Cloud Services (2012 - 2022)
	</a>
</p>
<p align="center">
	<a href="https://blog.axway.com/mobile-apps/prepare-your-apps-for-appcelerator-end-of-support">
			🪦 &nbsp; RIP Axway Amplify Crash Analytics (2015 - 2022)
	</a>
</p>

<hr>
<h4 align="center">
🛑 &nbsp;&nbsp; <a href="https://blog.axway.com/mobile-apps/prepare-your-apps-for-appcelerator-end-of-support">Axway support for Amplify products has ended</a> for most products related to mobile and cloud. 
</h4>

<h4 align="center">
A few of the open-source versions of Axway Amplify products will live on after <a href="">Axway Amplify End-of-Life</a> (EOL) announcements.  However, all closed-source projects and most open-source projects are now dead.  
	</h4>

<p>&nbsp;</p>

> 👉 &nbsp;&nbsp; A group of Axway employees, ex-Axway employees, and some developers from Titanium community have created a legal org and now officially decide all matters related to future of these products.  

<p>&nbsp;</p>
<hr>


## API FAQ:

* [API Best Practices](https://brenton.house)
* [What is API Security?](https://brenton.house/what-is-api-security-5ca8117d4911)
* [OWASP Top 10 List for API Security](https://www.youtube.com/watch?v=GLVHDj0Cpg4)
* [What is API Security?](https://brenton.house/what-is-api-security-5ca8117d4911)
* [Top API Trends for 2022](https://brenton.house/top-10-api-integration-trends-for-2022-49b05f2ef299)
* [What is a Frankenstein API?](https://brenton.house/what-is-a-frankenstein-api-4d6e59fca6)
* [What is a Zombie API?](https://brenton.house/what-is-a-zombie-api-6e5427c39b6a)
* [API Developer Experience](https://brenton.house/keys-to-winning-with-an-awesome-api-developer-experience-62dd2fa668f4)
* [API Cybersecurity 101](https://brenton.house/what-is-api-security-5ca8117d4911)
* [YouTube API Videos](https://youtube.com/brentonhouse)
* [YouTube API Shorts Videos](https://youtube.com/apishorts)

&nbsp;

[![Click to watch on Youtube](https://img.youtube.com/vi/GLVHDj0Cpg4/0.jpg)](https://www.youtube.com/watch?v=GLVHDj0Cpg4&list=PLsy9MwYlG1pew6sktCAIFD5tbrXy9HUQ7  "Click to watch on YouTube")


> &nbsp; [↑ Watch video on YouTube ↑](https://www.youtube.com/watch?v=GLVHDj0Cpg4&list=PLsy9MwYlG1pew6sktCAIFD5tbrXy9HUQ7)

&nbsp;



<p>&nbsp;</p>
<hr>

<p>&nbsp;</p>
<p>&nbsp;</p>

[//]: # (header-end)

# @titanium/essentials  <sup><sup><sub><a name="brenton-house" href="#brenton-house">🚀</a></sub></sup></sup> 

[![@titanium/essentials version](https://img.shields.io/npm/v/@titanium/essentials.png)](https://www.npmjs.com/package/@titanium/essentials)
[![@titanium/essentials downloads](https://img.shields.io/npm/dm/@titanium/essentials.svg)](https://www.npmjs.com/package/@titanium/essentials)
[![@titanium/essentials dependencies](https://img.shields.io/librariesio/release/npm/@titanium/essentials.svg)](https://www.npmjs.com/package/@titanium/essentials)



> Essential Toolkit for Titanium Turbo Native Mobile Apps

* [API FAQ:](#api-faq)
* [📓   &nbsp; Description](#----description)
* [🚀   &nbsp; Getting Started](#----getting-started)
* [✨  &nbsp; Features](#---features)
	* [Adds properties to the global `turbo` object](#adds-properties-to-the-global-turbo-object)
* [🎓  &nbsp;  Learn More](#----learn-more)
	* [📚  &nbsp;  Related projects](#----related-projects)
		* [🎟️  &nbsp; Modules for Titanium Mobile](#️---modules-for-titanium-mobile)
		* [🎟️  &nbsp; Modules for Node.js and Titanium Mobile](#️---modules-for-nodejs-and-titanium-mobile)
		* [🎟️  &nbsp; Modules for Node.js](#️---modules-for-nodejs)
* [📣  &nbsp; Feedback](#---feedback)
* [Follow Brenton House](#follow-brenton-house)
* [©️ &nbsp; Legal](#️--legal)


## 📓   &nbsp; Description

Essential Toolkit for Titanium Turbo Native Mobile Apps

## 🚀   &nbsp; Getting Started

1. Install `@titanium/essentials` in root of project

```bash
npm install @titanium/essentials
```

2. Initialize module in `alloy.js`

```JavaScript
require('@titanium/essentials');
```

## ✨  &nbsp; Features

### Adds properties to the global `turbo` object

> These properties are set on initialization

* [x] app_copyright
* [x] app_deploy_type
* [x] app_description
* [x] app_display_name
* [x] app_first_installed_version
* [x] app_guid
* [x] app_id
* [x] app_name
* [x] app_publisher
* [x] app_url
* [x] app_version
* [x] app_version_build
* [x] app_version_history
* [x] app_version_major
* [x] app_version_minor
* [x] app_version_previous
* [x] country_code
* [x] device_architecture
* [x] device_density
* [x] device_dpi
* [x] device_id
* [x] device_logical_density_factor
* [x] device_manufacturer
* [x] device_model
* [x] device_model_name
* [x] device_processor_count
* [x] device_total_memory
* [x] device_total_memory_formatted
* [x] install_id
* [x] ip_address
* [x] isAndroid
* [x] isFirstLaunchAfterUpdate
* [x] isFirstLaunchEver
* [x] isFirstLaunchForCurrentVersion
* [x] isIos
* [x] isIos10Plus
* [x] isIos11Plus
* [x] isIos12Plus
* [x] isIos13Plus
* [x] isIos14Plus
* [x] isIos7Plus
* [x] isIos8Plus
* [x] isIos9Plus
* [x] isIpad
* [x] isIphone
* [x] isVirtual
* [x] language_code
* [x] locale
* [x] mac_address
* [x] netmask
* [x] network_change_reason
* [x] network_type
* [x] network_type_name
* [x] online
* [x] os
* [x] os_name
* [x] os_name_full
* [x] os_type
* [x] os_version
* [x] os_version_build
* [x] os_version_major
* [x] os_version_minor
* [x] platform
* [x] runtime
* [x] session_id
* [x] titanium_sdk_version
* [x] username

> These properties are set on initialization and orientation change


* [x] device_height_actual
* [x] device_width
* [x] isLandscape
* [x] isPortrait
* [x] platform_height
* [x] platform_width


> These properties are calculated on-the-fly

* [x] device_available_memory
* [x] device_available_memory_formatted
* [x] battery_level
* [x] battery_level_formatted
* [x] uptime
* [x] uptime_formatted

> These functions are available

* [x] getClipboardText()
* [x] setClipboardText()


## 🎓  &nbsp;  Learn More

- [@titanium/essentials GitHub Repo](https://github.com/brentonhouse/titanium-essentials)
- [@titanium/essentials npm page](https://npmjs.com/packages/@titanium/essentials)

### 📚  &nbsp;  Related projects


#### 🎟️  &nbsp; Modules for Titanium Mobile

| project  	|  description 	|  npm	|
|---	|---  |---	|
| [@titanium/applesignin](https://www.npmjs.com/package/@titanium/applesignin)  	| Native modules that allows you to use the iOS 13+ Apple Sign In API with Axway Titanium native mobile apps.     	| [![@@titanium/applesignin](https://img.shields.io/npm/v/@titanium/applesignin.png)](https://www.npmjs.com/package/@titanium/applesignin)      |
| [@titanium/authentication](https://www.npmjs.com/package/@titanium/authentication)  	| Titanium native mobile authentication manager   	| [![@titanium/authentication](https://img.shields.io/npm/v/@titanium/authentication.png)](https://www.npmjs.com/package/@titanium/authentication)      |
| [@titanium/authentication-oauth](https://www.npmjs.com/package/@titanium/authentication-oauth)  	| Titanium native mobile OAuth plugin for authentication manager    	| [![@titanium/authentication-oauth](https://img.shields.io/npm/v/@titanium/authentication-oauth.png)](https://www.npmjs.com/package/@titanium/authentication-oauth)      |
| [@titanium/calendar-picker](https://www.npmjs.com/package/@titanium/calendar-picker)  	| urbo widget that allows you to pick dates from a calendar with Axway Titanium.      	| [![@titanium/calendar-picker](https://img.shields.io/npm/v/@titanium/calendar-picker.png)](https://www.npmjs.com/package/@titanium/calendar-picker)      |
| [@titanium/coremotion](https://www.npmjs.com/package/@titanium/coremotion)  	|  Native modules that allows you to use iOS CoreMotion framework with Axway Titanium native mobile apps.     	| [![@titanium/coremotion](https://img.shields.io/npm/v/@titanium/coremotion.png)](https://www.npmjs.com/package/@titanium/coremotion)      |
| [@titanium/essentials](https://www.npmjs.com/package/@titanium/essentials)  	| The <u>Essential Toolkit</u> for Titanium Turbo Native Mobile Apps       	| [![@titanium/essentials](https://img.shields.io/npm/v/@titanium/essentials.png)](https://www.npmjs.com/package/@titanium/essentials)      |
| [@titanium/icloud](https://www.npmjs.com/package/@titanium/icloud)  	|  Native module that allows you to use the Apple iCloud framework with Axway Titanium native mobile apps.   	| [![@titanium/icloud](https://img.shields.io/npm/v/@titanium/icloud.png)](https://www.npmjs.com/package/@titanium/icloud)      |
| [@titanium/identity](https://www.npmjs.com/package/@titanium/identity)  	|  Native modules to add Fingerprint/FaceId/keychain access to Titanium native mobile apps   	| [![@titanium/identity](https://img.shields.io/npm/v/@titanium/identity.png)](https://www.npmjs.com/package/@titanium/identity)      |
| [@titanium/facebook](https://www.npmjs.com/package/@titanium/facebook)  	|  Native modules that allows you to use Facebook SDK with Axway Titanium native mobile apps.    	| [![@titanium/facebook](https://img.shields.io/npm/v/@titanium/facebook.png)](https://www.npmjs.com/package/@titanium/facebook)      |
| [@titanium/googlesignin](https://www.npmjs.com/package/@titanium/googlesignin)  	| Native modules that allows you to use the Google Sign-in SDK with Axway Titanium native mobile apps.    	| [![@titanium/googlesignin](https://img.shields.io/npm/v/@titanium/googlesignin.png)](https://www.npmjs.com/package/@titanium/googlesignin)      |
| [@titanium/lottie](https://www.npmjs.com/package/@titanium/lottie)  	| Native modules that allows you to use Airbnb Lottie animations with Axway Titanium native mobile apps.      	| [![@titanium/lottie](https://img.shields.io/npm/v/@titanium/lottie.png)](https://www.npmjs.com/package/@titanium/lottie)      |
| [@titanium/observer](https://www.npmjs.com/package/@titanium/observer)  	| Repackaging of nx-js/observer-util for Titanium Native Mobile        	| [![@titanium/observer](https://img.shields.io/npm/v/@titanium/observer.png)](https://www.npmjs.com/package/@titanium/observer)      |
| [@titanium/please](https://www.npmjs.com/package/@titanium/please)  	|  Titanium native mobile library for politely requesting stuff from the internets   	| [![@titanium/please](https://img.shields.io/npm/v/@titanium/please.png)](https://www.npmjs.com/package/@titanium/please)      |
| [@titanium/polyfill](https://www.npmjs.com/package/@titanium/polyfill)  	|  Titanium native mobile polyfills necessary to use packages that depend on Node.js modules  	| [![@titanium/polyfill](https://img.shields.io/npm/v/@titanium/polyfill.png)](https://www.npmjs.com/package/@titanium/polyfill)      |
| [@titanium/turbo](https://www.npmjs.com/package/@titanium/turbo)  	|  🚀 Turbo is the awesome framework for turbo charging your Titanium cross-platform native mobile app development! | [![@titanium/turbo](https://img.shields.io/npm/v/@titanium/turbo.png)](https://www.npmjs.com/package/@titanium/turbo)      |
| [@titanium/updater](https://www.npmjs.com/package/@titanium/updater)  	|   Titanium native mobile widget to check for app updates  | [![@titanium/updater](https://img.shields.io/npm/v/@titanium/updater.png)](https://www.npmjs.com/package/@titanium/updater)      |
| [@titanium/webdialog](https://www.npmjs.com/package/@titanium/webdialog)  	|    Native modules that allows you to use native SFSafariViewController (iOS) and Chrome Pages (Android) with Axway Titanium native mobile apps. | [![@titanium/webdialog](https://img.shields.io/npm/v/@titanium/webdialog.png)](https://www.npmjs.com/package/@titanium/webdialog)      |



#### 🎟️  &nbsp; Modules for Node.js and Titanium Mobile

| project  	|  description 	|  npm	|
|---	|---  |---	|
| [@geek/cache](https://www.npmjs.com/package/@geek/cache)  	| Caching module for Node.js and Axway Titanium  	| [![@geek/cache](https://img.shields.io/npm/v/@geek/cache.png)](https://www.npmjs.com/package/@geek/cache)      |
| [@geek/jsonc](https://www.npmjs.com/package/@geek/cache)  	| JSONC and JSON utilities for JavaScript with Node.js and Axway Titanium.  	| [![@geek/jsonc](https://img.shields.io/npm/v/@geek/jsonc.png)](https://www.npmjs.com/package/@geek/jsonc)      |
|  [@geek/jwt](https://www.npmjs.com/package/@geek/jwt) 	| JWT parser for JavaScript Node.js and Titanium native mobile  |  [![@geek/jwt](https://img.shields.io/npm/v/@geek/jwt.png)](https://www.npmjs.com/package/@geek/jwt)     |
|  [@geek/logger](https://www.npmjs.com/package/@geek/logger) 	| Logging module for Node.js and Axway Titanium  |   [![@geek/logger](https://img.shields.io/npm/v/@geek/logger.png)](https://www.npmjs.com/package/@geek/logger)        |
| [@geek/mobile](https://www.npmjs.com/package/@geek/mobile)  	| Toolkit for creating, building, and managing mobile app projects.  	| [![@geek/mobile](https://img.shields.io/npm/v/@geek/mobile.png)](https://www.npmjs.com/package/@geek/mobile)    	|
|  [@geek/retry](https://www.npmjs.com/package/@geek/retry) 	| Retry JavaScript functions and promises in Node.js and Axway Titanium  |   [![@geek/retry](https://img.shields.io/npm/v/@geek/retry.png)](https://www.npmjs.com/package/@geek/retry)        |


#### 🎟️  &nbsp; Modules for Node.js


| project  	|  description 	|  npm	|
|---	|---  |---	|
| [@geek/google-sheets](https://www.npmjs.com/package/@geek/google-sheets)  	| Easy way to manage Google Sheets API from Node.js  	| [![@geek/google-sheets](https://img.shields.io/npm/v/@geek/google-sheets.png)](https://www.npmjs.com/package/@geek/google-sheets)      |



## 📣  &nbsp; Feedback

Have an idea or a comment?  [Join in the conversation here](https://github.com/brentonhouse/titanium-essentials/issues)! 


-----

## Follow Brenton House 

> Follow [`Brenton House`](https://brenton.house) for the latest on great modules and libraries!

[![Twitter Follow](https://img.shields.io/twitter/follow/brentonhouse?label=Follow%20%40brentonhouse%20on%20twitter&style=social)](https://twitter.com/brentonhouse)
[![LinkedIn Follow](https://img.shields.io/badge/LinkedIn-_Connect_with_%40brentonhouse_-blue?logo=linkedin&style=flat-square)](https://www.linkedin.com/in/brentonhouse/)
![Github Followers](https://img.shields.io/github/followers/brentonhouse?label=Follow%20%40brentonhouse%20on%20GitHub&style=social)

-----

## ©️ &nbsp; Legal

Code is licensed under MIT

Alloy is developed by Appcelerator and the community and is Copyright © 2012-present by Axway, Inc. All Rights Reserved.

Alloy is made available under the Apache Public License, version 2. See their license file for more information.

Titanium is Copyright (c) 2008-present by Axway, Inc. All Rights Reserved.

Titanium is licensed under the Apache Public License (Version 2). Please see the the Titanium license file for the full license.

Appcelerator is a registered trademark of Axway, Inc. Titanium is a registered trademark of Axway, Inc. Please see the LEGAL information about using trademarks, privacy policy, terms of usage and other legal information at http://www.appcelerator.com/legal.