BlurringAtlasForUGUI
===

ダイナミックフォントを含むアトラス画像でも効果的な, UGUI用のブラーエフェクト.

A blur effect for uGUI that is effective even for atlas images including dynamic fonts.

### NOTE: This project has been integrated into [UIEffect](https://github.com/mob-sakai/UIEffect), so we are NOT continuing development in this repository.

[![](https://img.shields.io/github/release/mob-sakai/BlurringAtlasForUGUI.svg?label=latest%20version)](https://github.com/mob-sakai/BlurringAtlasForUGUI/releases)
[![](https://img.shields.io/github/release-date/mob-sakai/BlurringAtlasForUGUI.svg)](https://github.com/mob-sakai/BlurringAtlasForUGUI/releases)
![](https://img.shields.io/badge/unity-5.5%2B-green.svg)
[![](https://img.shields.io/github/license/mob-sakai/BlurringAtlasForUGUI.svg)](https://github.com/mob-sakai/BlurringAtlasForUGUI/blob/master/LICENSE.txt)



<< [Description](#Description) | [WebGL Demo](#demo) | [Download](https://github.com/mob-sakai/BlurringAtlasForUGUI/releases) | [Usage](#usage) | [Development Note](#development-note) >>

### What's new? Please see [RELEASE NOTE ![](https://img.shields.io/github/release-date/mob-sakai/BlurringAtlasForUGUI.svg?label=last%20updated&style=for-the-badge)](https://github.com/mob-sakai/BlurringAtlasForUGUI/blob/develop/CHANGELOG.md)




<br><br><br><br>
## Description

![](https://user-images.githubusercontent.com/12690315/42547121-80134788-84fb-11e8-97a0-048bba9634ea.png)

このプラグインは, uGUI用のブラーエフェクトにおいて発生しうる一般的なアーティファクト（＝副産物, ノイズ）を軽減します.  
以下の2つのアーティファクトについて解決します.

**NOTE: アーティファクトの名称は適当です.**  

This plug-in reduces common artifacts in the blur effect for uGUI.  
This plug-in solve the following two artifacts.  

**NOTE: I do not know if the name of the artifact is an exact name;)**  


<br><br>
### 1. UV Conflict

![](https://user-images.githubusercontent.com/12690315/42547753-b07b42e2-84fe-11e8-89d9-385842c6d1b8.png)

ぼかし効果は, カーネルに基づきフラグメントシェーダで複数のテクセルを合成します.  
カーネルサイズが大きい, またはアトラスのパディングサイズが小さいなどの理由から, 隣接スプライトのUVを参照した場合, アーティファクトが発生します.

The blur effect combines multiple texels based on the kernel size, in the fragment shader.  
Artifacts will occur when referencing the UVs of adjacent sprites, for example because the kernel size is large or the padding size of the atlas is small.

<br>
#### Solution: UV Masking

![](https://user-images.githubusercontent.com/12690315/42552447-4799f96c-8517-11e8-89c3-32fda327ef41.png)

頂点毎に参照しうるUVをマスクします.  
UIの場合, スプライトや文字のUV範囲と一致します.  
マスクされていないUVを参照した場合（＝範囲外のUVを参照した場合）, そのテクセルは`(0,0,0,0)`の色を返すものと見なします.

For each vertex, mask UVs that vertices can reference.  
In the case of UI element, it will match the UV range of the sprite or the character.  
When referring to unmasked UV, the texel returns color `(0,0,0,0)`.

```
float4 mask;  // xy: minimum uv, zw: maximum uv.
float2 uv;
float4 color = tex2D(_MainTex, uv)
                * step(mask.x, uv.x)
                * step(mask.y, uv.y)
                * step(uv.x, mask.z)
                * step(uv.y, mask.w);
```


<br><br>
### 2. Mesh clipping

![](https://user-images.githubusercontent.com/12690315/42547838-0afab77a-84ff-11e8-8e29-9fa2cec2bb62.png)

フラグメントシェーダで描画できるピクセルは, ラスタライズによって生成されます.  
通常, UIシェーダは与えられたmeshより外側の領域を描画しません.  
カーネルサイズが大きい, またはスプライトのマージンが小さいとき, 「meshでクリップされたように見えるアーティファクト」が発生します.

Pixels that can be rendered with fragment shaders are generated by rasterization.  
In most cases, the UI shader does not draw areas outside the given mesh.  
When the kernel size is large or the margin of the sprite is small, "artifacts that looks like clipped by mesh" will occur.

<br>
#### Solution: Edge Expanding

![](https://user-images.githubusercontent.com/12690315/42552928-9477421a-8519-11e8-91fc-251961c23e49.png)

**外周にある頂点**をUVごと外側に膨張させ, 描画領域を拡大します.  
この解決方法は, 頂点数を増やしません. また, 「9-Sliced」や「Tiled」に対しても有効です.

Expand the drawing area by expanding the coordinates and UV of **the vertices on the outer side.**  
This solution does not increase the number of vertices. It is also available for "9-Slice" and "Tiled".


<br><br>
### Features

* Easy to use
* Controls amount of the blurring from inspector or script
* Supports RawImage, Image, Text element
* Supports 'small padding' atlas such as dynamic fonts
* Supports draw call batching




<br><br><br><br>
## Demo

[WebGL Demo](http://mob-sakai.github.io/BlurringAtlasForUGUI)




<br><br><br><br>
## Usage

1. Download BlurringAtlasForUGUI.unitypackage from [Releases](https://github.com/mob-sakai/BlurringAtlasForUGUI/releases).
1. Import the package into your Unity project. Select `Import Package > Custom Package` from the `Assets` menu.
1. In Unity5.6+, enable `TexCoord1` channel of canvas. See also [Development Note](##note-unity-56).
1. Add `UIBlurringAtlas` component to UI element (Image, RawImage, Text, etc...) from `Add Component` in inspector.
1. Enjoy!




##### Requirement

* Unity 5.5+ *(including Unity 2018.x)*
* No other SDK are required




<br><br><br><br>
## Development Note

### Note: Unity 5.6+

In Unity 5.6+, Canvas supports **Additional Shader Channels**.  
Please enable `TexCoord1` to use this plugin.  
![image](https://user-images.githubusercontent.com/12690315/28405830-f4f261e8-6d68-11e7-9faf-7e5442062f59.png)


### How to pack UV range to vertex

See [UIEffect](https://github.com/mob-sakai/UIEffect#how-to-control-effect-parameters-for-ugui-element-without-materialpropertyblock).

このプラグインでは, UV範囲`(uMin, vMin, uMax, vMax)`の各要素に12bit(4096ステップ)を使用し, 頂点のuv1に割り当てます.
（Unity 5.6+において, `TexCoord1`チャンネルを有効にすべき理由です.）

This plugin uses 12bit (4096 steps) for each element of the UV range `(uMin, vMin, uMax, vMax)` and assigns it to the vertex uv1.
(In Unity 5.6+, it is the reason to activate `TexCoord 1` channel.)

`uiVertex.uv1 = new Vector2( Packer.ToFloat(uMin, vMin), Packer.ToFloat(uMax, vMax) );`


### Application idea

この手法を応用すると, uvずらしを使った表現(グローエフェクトやソフトシャドウなど)がuGUI要素単体に対しても利用できます.  
後ほどグローエフェクトを公開予定です.

By applying this technique, effects using uv shift (such as glow effect or soft shadow) can be used for a single uGUI element.  
I will release the glow effect later.

(WIP)  
![](https://user-images.githubusercontent.com/12690315/41465393-da6ef2ae-70d8-11e8-9e1f-e8a5f7bf4643.gif)


### Future plans

* Code refactoring
* Merge to [UIEffect](https://github.com/mob-sakai/UIEffect)




<br><br><br><br>
## License

* MIT
* [Superpowers Asset Packs](http://sparklinlabs.itch.io/superpowers) 
[![](https://img.shields.io/github/license/sparklinlabs/superpowers-asset-packs.svg)](https://github.com/sparklinlabs/superpowers-asset-packs/blob/master/LICENSE.txt)



## Author

[mob-sakai](https://github.com/mob-sakai)



## See Also

* GitHub page : https://github.com/mob-sakai/BlurringAtlasForUGUI
* Releases : https://github.com/mob-sakai/BlurringAtlasForUGUI/releases
* Issue tracker : https://github.com/mob-sakai/BlurringAtlasForUGUI/issues
* Current project : https://github.com/mob-sakai/BlurringAtlasForUGUI/projects/1
* Change log : https://github.com/mob-sakai/BlurringAtlasForUGUI/blob/master/CHANGELOG.md
