![Dotfiles Header](https://raw.githubusercontent.com/mnabila/dotfiles-old/master/images/header.png)

## Introduction

Dotfiles are used to customize your system. The “dotfiles” name is derived from the configuration files in Unix-like systems that start with a dot (e.g. .bash_profile and .gitconfig). For normal users, this indicates these are not regular documents, and by default are hidden in directory listings. For power users, however, they are a core tool belt.</tspan>!

## Details

| Item                  | Value                                           |
| :-------------------- | :---------------------------------------------- |
| OS                    | Manjaro 18.0 & ArchLinux                        |
| WM                    | I3-gaps, Openbox                                |
| Shell                 | Zsh _([zimfw](https://github.com/zimfw/zimfw))_ |
| DM                    | Lightdm, SLIM                                   |
| Font                  | Iosevka, Iosevka Nerd Font                      |
| Compositor            | Picom(compton fork)                             |
| Notification          | Dunst                                           |
| Terminal              | URxvt, Termite, suckless terminal               |
| Launcher              | rofi, dmenu, jgmenu, j4-dmenu-desktop           |
| Bar                   | polybar                                         |
| Wallpaper             | feh                                             |
| Lock Screen           | i3lock, mantablockscreen, slimlock              |
| Logout / Shutdown     | script                                          |
| Volume Control        | pulseaudio-ctl, amixer                          |
| Brightness Controller | xbacklight                                      |
| Network Applet        | nm-applet, connman-gtk                          |
| Bluetooth Applet      | blueman-applet                                  |
| Text Editor           | neovim                                          |

## Table of Contents

| Item       | Value                                                                                                                                                   |
| :--------- | :------------------------------------------------------------------------------------------------------------------------------------------------------ |
| Conky      | [.config/conky](https://github.com/mnabila/dotfiles-old/tree/master/.config/conky)                                                                          |
| I3-wm      | [.config/i3](https://github.com/mnabila/dotfiles-old/tree/master/.config/i3)                                                                                |
| Jgmenu     | [.config/jgmenu](https://github.com/mnabila/dotfiles-old/tree/master/.config/jgmenu)                                                                        |
| Kvantum    | [.config/Kvantum](https://github.com/mnabila/dotfiles-old/tree/master/.config/Kvantum)                                                                      |
| Ncmpcpp    | [.ncmpcpp](https://github.com/mnabila/dotfiles-old/tree/master/.ncmpcpp)                                                                                    |
| Neovim     | [init.nvim](https://github.com/mnabila/nvimrc)                                                                                                          |
| Openbox    | [.config/openbox](https://github.com/mnabila/dotfiles-old/tree/master/.config/openbox)                                                                      |
| Polybar    | [.config/polybar](https://github.com/mnabila/dotfiles-old/tree/master/.config/polybar)                                                                      |
| Rofi       | [.config/rofi](https://github.com/mnabila/dotfiles-old/tree/master/.config/rofi)                                                                            |
| Rofi-tools | [.config/rofi-tools](https://github.com/mnabila/dotfiles-old/tree/master/.config/rofi-tools)                                                                |
| Screenshot | [preview](https://github.com/mnabila/dotfiles-old/tree/master/preview)                                                                                      |
| Scripts    | [./config/scripts](https://github.com/mnabila/dotfiles-old/blob/master/.config/scripts)                                                                     |
| Termite    | [.config/termite](https://github.com/mnabila/dotfiles-old/tree/master/.config/termite)                                                                      |
| Tint2      | [.config/tint2](https://github.com/mnabila/dotfiles-old/tree/master/.config/tint2)                                                                          |
| Tmux       | [.tmux.conf](https://github.com/mnabila/dotfiles-old/blob/master/.tmux.conf)                                                                                |
| URxvt      | [.xrdb/urxvt](https://github.com/mnabila/dotfiles-old/blob/master/.Xresources.d/urxvt)                                                                      |
| Vscode     | [vscode-settings](https://github.com/mnabila/dotfiles-old/blob/master/vscode-settings.json)                                                                 |
| Wallpaper  | [wallpaper](https://github.com/mnabila/dotfiles-old/tree/master/wallpaper)                                                                                  |
| Xresource  | [.Xresource](https://github.com/mnabila/dotfiles-old/blob/master/.Xresources) [.Xresource.d](https://github.com/nabil48/dotfiles-old/tree/master/.Xresources.d) |
| Xterm      | [.Xresources.d/xterm](https://github.com/mnabila/dotfiles-old/blob/master/.Xresources.d/xterm)                                                              |
| Zimfw      | [.zimrc](https://github.com/mnabila/dotfiles-old/blob/master/.zimrc)                                                                                        |
| Zsh        | [.zshrc](https://github.com/mnabila/dotfiles-old/blob/master/.zshrc)                                                                                        |

## ScreenShot

### i3-gaps

![i3-gaps and polybar preview](https://github.com/mnabila/dotfiles-old/blob/master/preview/i3gaps-and-polybar-preview.png?raw=true)
![i3-gaps preview](https://github.com/mnabila/dotfiles-old/blob/master/preview/i3gaps-preview.png?raw=true)

### Tmux & neovim

![tmux-nvim](https://github.com/mnabila/dotfiles-old/blob/master/preview/tmux-preview.png?raw=true)

### Zsh

![zshrc and zimrc](https://github.com/mnabila/dotfiles-old/blob/master/preview/zsh-preview.png?raw=true) 
