% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_gs_pois.R
\name{sim_gs_pois}
\alias{sim_gs_pois}
\title{Empirically determine the operating characteristics of a multi-stage
group-sequential multi-arm clinical trial for a Poisson distributed primary
outcome}
\usage{
sim_gs_pois(
  des = des_gs_pois(integer = TRUE),
  lambda,
  replicates = 1e+05,
  summary = FALSE
)
}
\arguments{
\item{des}{A \code{\link{list}} of class \code{"multiarm_des_gs_pois"}, as
returned by \code{\link{build_gs_pois}} or \code{\link{des_gs_pois}} (i.e., a
multi-stage group-sequential multi-arm clinical trial design for a Poisson
distributed outcome). \strong{Note:} The sample sizes in all arms must be
whole numbers. Defaults to \code{des_gs_pois(integer = TRUE)}.}

\item{lambda}{A \code{\link{matrix}} whose rows indicate values of
\ifelse{html}{\out{<b><i>&lambda;</i></b>}}{\eqn{\bold{\lambda}}} at which to
evaluate the operating characteristics. Defaults internally to the global
null, global alternative, and each of the least favourable configurations if
unspecified.}

\item{replicates}{A \code{\link{numeric}} indicating the number of replicate
simulations to use for each value of
\ifelse{html}{\out{<b><i>&tau;</i></b>}}{\eqn{\bold{\tau}}}. Defaults to
\code{1e5}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}} containing the following elements
\itemize{
\item A \code{\link{tibble}} in the slot \code{$sim} giving the estimated
operating characteristics.
\item Each of the input variables.
}
}
\description{
\code{sim_gs_pois()} determines the operating characteristics of a specified
multi-stage group-sequential multi-arm clinical trial design assuming the
primary outcome is Poisson distributed, for given values of the true
treatment effects, using simulation.
}
\examples{
\dontrun{
# The estimated operating characteristics for the default parameters
sim   <- sim_gs_pois()
}
}
\seealso{
\code{\link{build_gs_pois}}, \code{\link{des_gs_pois}},
\code{\link{opchar_gs_pois}}, \code{\link{plot.multiarm_des_gs_pois}}.
}
