% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_dtl_norm.R
\name{sim_dtl_norm}
\alias{sim_dtl_norm}
\title{Empirically determine the operating characteristics of a multi-stage
drop-the-losers multi-arm clinical trial for a normally distributed primary
outcome}
\usage{
sim_dtl_norm(
  des = des_dtl_norm(integer = TRUE),
  tau,
  replicates = 1e+05,
  summary = FALSE
)
}
\arguments{
\item{des}{A \code{\link{list}} of class \code{"multiarm_des_dtl_norm"}, as
returned by \code{\link{build_dtl_norm}} or \code{\link{des_dtl_norm}} (i.e.,
a multi-stage drop-the-losers multi-arm clinical trial design for a normally
distributed outcome). \strong{Note:} The sample sizes in all arms must be
whole numbers. Defaults to \code{des_dtl_norm(integer = TRUE)}.}

\item{tau}{A \code{\link{matrix}} whose rows indicate values of
\ifelse{html}{\out{<b><i>&tau;</i></b>}}{\eqn{\bold{\tau}}} at which to
evaluate the operating characteristics. Defaults internally to the global
null, global alternative, and each of the least favourable configurations if
unspecified.}

\item{replicates}{A \code{\link{numeric}} indicating the number of replicate
simulations to use for each value of
\ifelse{html}{\out{<b><i>&tau;</i></b>}}{\eqn{\bold{\tau}}}. Defaults to
\code{1e5}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}} containing the following elements
\itemize{
\item A \code{\link{tibble}} in the slot \code{$sim} giving the estimated
operating characteristics.
\item Each of the input variables.
}
}
\description{
\code{sim_dtl_norm()} determines the operating characteristics of a specified
multi-stage drop-the-losers multi-arm clinical trial design assuming the
primary outcome is normally distributed, for given values of the true
treatment effects, using simulation.
}
\examples{
\dontrun{
# The estimated operating characteristics for the default parameters
sim   <- sim_dtl_norm()
}
}
\seealso{
\code{\link{build_dtl_norm}}, \code{\link{des_dtl_norm}},
\code{\link{opchar_dtl_norm}}, \code{\link{plot.multiarm_des_dtl_norm}}.
}
