% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.multiarm_des_gs_pois.R
\name{plot.multiarm_des_gs_pois}
\alias{plot.multiarm_des_gs_pois}
\title{Plot operating characteristics of a multi-stage group-sequential multi-arm
clinical trial for a Poisson distributed primary outcome}
\usage{
\method{plot}{multiarm_des_gs_pois}(
  x = des_gs_pois(),
  delta_min = -x$delta1,
  delta_max = 2 * x$delta1,
  delta = x$delta1 - x$delta0,
  density = 100,
  output = FALSE,
  print_plots = TRUE,
  summary = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{\link{list}} of class \code{"multiarm_des_gs_pois"}, as
returned by \code{\link{build_gs_pois}} or \code{\link{des_gs_pois}} (i.e., a
multi-stage group-sequential multi-arm clinical trial design for a Poisson
distributed outcome). Defaults to \code{des_gs_pois()}.}

\item{delta_min}{A \code{\link{numeric}} specifying the chosen minimum value
for the treatment effects to include on the produced plots. Defaults to
\code{-x$delta1}.}

\item{delta_max}{A \code{\link{numeric}} specifying the chosen maximum
value for the treatment effects to include on the produced plots. Defaults to
\code{2*x$delta1}.}

\item{delta}{A \code{\link{numeric}} specifying the chosen treatment effect
shift to use in the 'shifted treatment effects plot'. Defaults to
\code{x$delta1 - x$delta0}.}

\item{density}{A \code{\link{numeric}} variable indicating the number of
treatment effect scenarios to consider for each power curve. Increasing
\code{density} increases the smoothness of the produced plots, at the cost of
increased run time. Defaults to \code{100}.}

\item{output}{A \code{\link{logical}} variable indicating whether the
available outputs from the function (see below) should be returned. Defaults
to \code{FALSE}.}

\item{print_plots}{A \code{\link{logical}} variable indicating whether to
print produced plots. Defaults to \code{TRUE}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}

\item{...}{Not currently used.}
}
\value{
If \code{output = T}, a list containing the following elements
\itemize{
\item A \code{\link{list}} in the slot \code{$plots} containing the produced
plots.
\item Each of the input variables.
}
}
\description{
\code{plot.multiarm_des_gs_pois()} produces power curve plots for a specified
multi-stage group-sequential multi-arm clinical trial design assuming the
primary outcome is Poisson distributed.
}
\examples{
\dontrun{
# The design for the default parameters
des        <- des_gs_pois()
plot(des)
}
}
\seealso{
\code{\link{build_gs_pois}}, \code{\link{des_gs_pois}},
\code{\link{gui}}, \code{\link{opchar_gs_pois}}, \code{\link{sim_gs_pois}}.
}
