% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.multiarm_des_dtl_bern.R
\name{plot.multiarm_des_dtl_bern}
\alias{plot.multiarm_des_dtl_bern}
\title{Plot operating characteristics of a multi-stage drop-the-losers multi-arm
clinical trial for a Bernoulli distributed primary outcome}
\usage{
\method{plot}{multiarm_des_dtl_bern}(
  x = des_dtl_bern(),
  delta_min = -x$pi0 + 1e-06,
  delta_max = 1 - x$pi0 - 1e-06,
  delta = x$delta1 - x$delta0,
  density = 100,
  output = FALSE,
  print_plots = TRUE,
  summary = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{\link{list}} of class \code{"multiarm_des_dtl_bern"}, as
returned by \code{\link{build_dtl_bern}} or \code{\link{des_dtl_bern}} (i.e.,
a multi-stage drop-the-losers multi-arm clinical trial design for a Bernoulli
distributed outcome). Defaults to \code{des_dtl_bern()}.}

\item{delta_min}{A \code{\link{numeric}} specifying the chosen minimum value
for the treatment effects to include on the produced plots. Defaults to
\code{-x$pi0 + 1e-6}.}

\item{delta_max}{A \code{\link{numeric}} specifying the chosen maximum
value for the treatment effects to include on the produced plots. Defaults to
\code{1 - x$pi0 - 1e-6}.}

\item{delta}{A \code{\link{numeric}} specifying the chosen treatment effect
shift to use in the 'shifted treatment effects plot'. Defaults to
\code{x$delta1 - x$delta0}.}

\item{density}{A \code{\link{numeric}} variable indicating the number of
treatment effect scenarios to consider for each power curve. Increasing
\code{density} increases the smoothness of the produced plots, at the cost of
increased run time. Defaults to \code{100}.}

\item{output}{A \code{\link{logical}} variable indicating whether the
available outputs from the function (see below) should be returned. Defaults
to \code{FALSE}.}

\item{print_plots}{A \code{\link{logical}} variable indicating whether to
print produced plots. Defaults to \code{TRUE}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}

\item{...}{Not currently used.}
}
\value{
If \code{output = T}, a list containing the following elements
\itemize{
\item A \code{\link{list}} in the slot \code{$plots} containing the produced
plots.
\item Each of the input variables.
}
}
\description{
\code{plot.multiarm_des_dtl_bern()} produces power curve plots for a
specified multi-stage drop-the-losers multi-arm clinical trial design
assuming the primary outcome is Bernoulli distributed.
}
\examples{
\dontrun{
# The design for the default parameters
des        <- des_dtl_bern()
plot(des)
}
}
\seealso{
\code{\link{build_dtl_bern}}, \code{\link{des_dtl_bern}},
\code{\link{gui}}, \code{\link{opchar_dtl_bern}}, \code{\link{sim_dtl_bern}}.
}
