% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opchar_ss_bern.R
\name{opchar_ss_bern}
\alias{opchar_ss_bern}
\title{Analytically determine the operating characteristics of a single-stage
multi-arm clinical trial for a Bernoulli distributed primary outcome}
\usage{
opchar_ss_bern(des = des_ss_bern(), pi, summary = FALSE)
}
\arguments{
\item{des}{A \code{\link{list}} of class \code{"multiarm_des_ss_bern"}, as
returned by \code{\link{des_ss_bern}} (i.e., a single-stage multi-arm
clinical trial design for a Poisson distributed outcome). Defaults to
\code{des_ss_bern()}.}

\item{pi}{A \code{\link{matrix}} whose rows indicate values of
\ifelse{html}{\out{<b><i>&pi;</i></b>}}{\eqn{\bold{\pi}}} at which to
evaluate the operating characteristics. Defaults internally to the global
null, global alternative, and each of the least favourable configurations,
for the specified design \code{des}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}} containing the following elements
\itemize{
\item A \code{\link{tibble}} in the slot \code{$opchar} giving the determined
operating characteristics.
\item Each of the input variables.
}
}
\description{
\code{opchar_ss_bern()} determines the operating characteristics of a
specified single-stage multi-arm clinical trial design assuming the primary
outcome variable is Bernoulli distributed, for given values of the true
treatment effects, using multivariate normal integration.
}
\examples{
# The operating characteristics for the default parameters
opchar        <- opchar_ss_bern()
# An A-optimal design
des_A         <- des_ss_bern(ratio = "A")
opchar_A      <- opchar_ss_bern(des_A)
# Using the root-K allocation rule, modifying the desired type of power and
# chosen multiple comparison correction, and specifying pi explicitly
des_root_K    <- des_ss_bern(ratio      = rep(1/sqrt(2), 2),
                             correction = "holm_bonferroni",
                             power      = "disjunctive")
opchar_root_K <- opchar_ss_bern(des_root_K, rbind(c(0.3, 0.3, 0.3),
                                                  c(0.3, 0.5, 0.5),
                                                  c(0.3, 0.5, 0.3),
                                                  c(0.3, 0.3, 0.5)))
}
\seealso{
\code{\link{build_ss_bern}}, \code{\link{des_ss_bern}},
\code{\link{plot.multiarm_des_ss_bern}}, \code{\link{sim_ss_bern}}.
}
