% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opchar_gs_norm.R
\name{opchar_gs_norm}
\alias{opchar_gs_norm}
\title{Analytically determine the operating characteristics of a multi-stage
group-sequential multi-arm clinical trial for a normally distributed primary
outcome}
\usage{
opchar_gs_norm(des = des_gs_norm(), tau, summary = FALSE)
}
\arguments{
\item{des}{A \code{\link{list}} of class \code{"multiarm_des_gs_norm"}, as
returned by \code{\link{build_gs_norm}} or \code{\link{des_gs_norm}} (i.e., a
multi-stage group-sequential multi-arm clinical trial design for a normally
distributed outcome). Defaults to \code{des_gs_norm()}.}

\item{tau}{A \code{\link{matrix}} whose rows indicate values of
\ifelse{html}{\out{<b><i>&tau;</i></b>}}{\eqn{\bold{\tau}}} at which to
evaluate the operating characteristics. Defaults internally to the global
null, global alternative, and each of the least favourable configurations,
for the specified design \code{des}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}} containing the following elements
\itemize{
\item A \code{\link{tibble}} in the slot \code{$opchar} giving the determined
operating characteristics.
\item A \code{\link{tibble}} in the slot \code{$pmf_N} giving the determined
probability mass functions of the random required sample size.
\item Each of the input variables.
}
}
\description{
\code{opchar_gs_norm()} determines the operating characteristics of a
specified multi-stage group-sequential multi-arm clinical trial design
assuming the primary outcome variable is normally distributed, for given
values of the true treatment effects, using multivariate normal integration.
}
\examples{
# The operating characteristics for the default parameters
opchar        <- opchar_gs_norm()
}
\seealso{
\code{\link{build_gs_norm}}, \code{\link{des_gs_norm}},
\code{\link{plot.multiarm_des_gs_norm}}, \code{\link{sim_gs_norm}}.
}
