% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opchar_dtl_pois.R
\name{opchar_dtl_pois}
\alias{opchar_dtl_pois}
\title{Analytically determine the operating characteristics of a multi-stage
drop-the-losers multi-arm clinical trial for a Poisson distributed primary
outcome}
\usage{
opchar_dtl_pois(des = des_dtl_pois(), lambda, summary = FALSE)
}
\arguments{
\item{des}{A \code{\link{list}} of class \code{"multiarm_des_dtl_pois"}, as
returned by \code{\link{build_dtl_pois}} or \code{\link{des_dtl_pois}} (i.e., a
multi-stage drop-the-losers multi-arm clinical trial design for a Poisson
distributed outcome). Defaults to \code{des_dtl_pois()}.}

\item{lambda}{A \code{\link{matrix}} whose rows indicate values of
\ifelse{html}{\out{<b><i>&lambda;</i></b>}}{\eqn{\bold{\lambda}}} at which to
evaluate the operating characteristics. Defaults internally to the global
null, global alternative, and each of the least favourable configurations,
for the specified design \code{des}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}} containing the following elements
\itemize{
\item A \code{\link{tibble}} in the slot \code{$opchar} giving the determined
operating characteristics.
\item A \code{\link{tibble}} in the slot \code{$pmf_N} giving the determined
probability mass functions of the random required sample size.
\item Each of the input variables.
}
}
\description{
\code{opchar_dtl_pois()} determines the operating characteristics of a
specified multi-stage drop-the-losers multi-arm clinical trial design
assuming the primary outcome variable is Poisson distributed, for given
values of the true treatment effects, using multivariate normal integration.
}
\examples{
# The operating characteristics for the default parameters
opchar        <- opchar_dtl_pois()
}
\seealso{
\code{\link{build_dtl_pois}}, \code{\link{des_dtl_pois}},
\code{\link{plot.multiarm_des_dtl_pois}}, \code{\link{sim_dtl_pois}}.
}
