% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opchar_dtl_bern.R
\name{opchar_dtl_bern}
\alias{opchar_dtl_bern}
\title{Analytically determine the operating characteristics of a multi-stage
drop-the-losers multi-arm clinical trial for a Bernoulli distributed primary
outcome}
\usage{
opchar_dtl_bern(des = des_dtl_bern(), pi, summary = FALSE)
}
\arguments{
\item{des}{A \code{\link{list}} of class \code{"multiarm_des_dtl_bern"}, as
returned by \code{\link{build_dtl_bern}} or \code{\link{des_dtl_bern}} (i.e., a
multi-stage drop-the-losers multi-arm clinical trial design for a Bernoulli
distributed outcome). Defaults to \code{des_dtl_bern()}.}

\item{pi}{A \code{\link{matrix}} whose rows indicate values of
\ifelse{html}{\out{<b><i>&pi;</i></b>}}{\eqn{\bold{\pi}}} at which to
evaluate the operating characteristics. Defaults internally to the global
null, global alternative, and each of the least favourable configurations,
for the specified design \code{des}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}} containing the following elements
\itemize{
\item A \code{\link{tibble}} in the slot \code{$opchar} giving the determined
operating characteristics.
\item A \code{\link{tibble}} in the slot \code{$pmf_N} giving the determined
probability mass functions of the random required sample size.
\item Each of the input variables.
}
}
\description{
\code{opchar_dtl_bern()} determines the operating characteristics of a
specified multi-stage drop-the-losers multi-arm clinical trial design
assuming the primary outcome variable is Bernoulli distributed, for given
values of the true treatment effects, using multivariate normal integration.
}
\examples{
# The operating characteristics for the default parameters
opchar        <- opchar_dtl_bern()
}
\seealso{
\code{\link{build_dtl_bern}}, \code{\link{des_dtl_bern}},
\code{\link{plot.multiarm_des_dtl_bern}}, \code{\link{sim_dtl_bern}}.
}
