% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/des_ss_norm.R
\name{des_ss_norm}
\alias{des_ss_norm}
\title{Design a single-stage multi-arm clinical trial for a normally distributed
primary outcome}
\usage{
des_ss_norm(
  K = 2,
  alpha = 0.025,
  beta = 0.1,
  delta1 = 0.5,
  delta0 = 0,
  sigma = rep(1, K + 1),
  ratio = rep(1, K),
  correction = "dunnett",
  power = "marginal",
  integer = FALSE,
  summary = FALSE
)
}
\arguments{
\item{K}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>K</i>}}{\eqn{K}}, the number of experimental treatment
arms. Defaults to \code{2}.}

\item{alpha}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&alpha;</i>}}{\eqn{\alpha}}, the significance level.
Defaults to \code{0.025}.}

\item{beta}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&beta;</i>}}{\eqn{\beta}}, used in the definition of
the desired power. Defaults to \code{0.1}.}

\item{delta1}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&delta;</i><sub>1</sub>}}{\eqn{\delta_1}}, the
'interesting' treatment effect. Defaults to \code{0.5}.}

\item{delta0}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&delta;</i><sub>0</sub>}}{\eqn{\delta_0}}, the
'uninteresting' treatment effect. Defaults to \code{0}.}

\item{sigma}{A \code{\link{numeric}} vector indicating the chosen value for
\ifelse{html}{\out{<b><i>&sigma;</i></b>}}{\eqn{\bold{\sigma}}}, the vector
of standard deviations of the responses in each arm. Defaults to
\code{rep(1, K + 1)}.}

\item{ratio}{Either a \code{\link{numeric}} vector or a
\code{\link{character}} string indicating the chosen value for
\ifelse{html}{\out{<b><i>r</i></b>}}{\eqn{\bold{r}}}, the vector of
allocation ratios to the experimental arms. Can be specified explicitly
as a \code{\link{numeric}} vector, or can be specified as \code{"A"},
\code{"D"}, or \code{"E"} to instruct \code{des_ss_norm()} to compute the
\emph{A}-, \emph{D}-, or \emph{E}-optimal value for
\ifelse{html}{\out{<b><i>r</i></b>}}{\eqn{\bold{r}}}. Defaults to
\code{rep(1, K)}.}

\item{correction}{A \code{\link{character}} string indicating the chosen
multiple comparison correction. Can be any of \code{"benjamini_hochberg"},
\code{"benjamini_yekutieli"}, \code{"bonferroni"}, \code{"dunnett"},
\code{"hochberg"}, \code{"holm_bonferroni"}, \code{"holm_sidak"},
\code{"none"}, \code{"sidak"}, and \code{"step_down_dunnett"}. Defaults to
\code{"dunnett"}.}

\item{power}{A \code{\link{character}} string indicating the chosen type of
power to design the trial for. Can be any of \code{"conjunctive"},
\code{"disjunctive"}, and \code{"marginal"}. Defaults to \code{"marginal"}.}

\item{integer}{A \code{\link{logical}} variable indicating whether the
computed values in \ifelse{html}{\out{<b><i>n</i></b>}}{\eqn{\bold{n}}}, the
vector of sample sizes required in each arm, should be forced to be whole
numbers. Defaults to \code{FALSE}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}}, with additional class
\code{"multiarm_des_ss_norm"}, containing the following elements:
\itemize{
\item A \code{\link{tibble}} in the slot \code{$opchar} summarising the
operating characteristics of the identified design.
\item A \code{\link{numeric}} in the slot \code{$N} specifying
\ifelse{html}{\out{<i>N</i>}}{\eqn{N}}, the trial's total required sample
size.
\item A \code{\link{numeric}} vector in the slot \code{$n} specifying
\ifelse{html}{\out{<b><i>n</i></b>}}{\eqn{\bold{n}}}, the vector of sample
sizes required in each arm.
\item A \code{\link{numeric}} in the slot \code{$gamma} specifying the
critical threshold for \emph{p}-values,
\ifelse{html}{\out{<i>&gamma;</i>}}{\eqn{\gamma}}, below which null
hypotheses would be rejected. Will be \code{\link{NA}} if \code{correction}
is not a single-step testing procedure.
\item A \code{\link{numeric}} vector in the slot \code{$gammaO} specifying
the critical thresholds for ordered \emph{p}-values,
\ifelse{html}{\out{<b><i>&gamma;</i></b>}}{\eqn{\bold{\gamma}}}, to use with
the chosen step-wise testing procedure. Will be \code{\link{NA}} if
\code{correction} is not a step-wise testing procedure.
\item A \code{\link{matrix}} in the slot \code{$CovZ} specifying the
covariance matrix,
\ifelse{html}{\out{Cov(<b><i>Z</i></b>)}}{\eqn{Cov(\bold{Z})}}, of the
standardised test statistics.
\item Each of the input variables.
}
}
\description{
\code{des_ss_norm()} determines single-stage multi-arm clinical trial designs
assuming the primary outcome variable is normally distributed. It supports a
variety of multiple comparison corrections, along with the determination of
\emph{A}-, \emph{D}-, and \emph{E}-optimal allocation ratios. In all
instances, \code{des_ss_norm()} computes the required sample size in each
arm, and returns information on key operating characteristics.
}
\examples{
# The design for the default parameters
des        <- des_ss_norm()
# An A-optimal design
des_A      <- des_ss_norm(ratio = "A")
# Using the root-K allocation rule, modifying the desired type of power, and
# choosing an alternative multiple comparison correction
des_root_K <- des_ss_norm(ratio      = rep(1/sqrt(2), 2),
                          correction = "holm_bonferroni",
                          power      = "disjunctive")
}
\seealso{
\code{\link{build_ss_norm}}, \code{\link{gui}},
\code{\link{opchar_ss_norm}}, \code{\link{plot.multiarm_des_ss_norm}},
\code{\link{sim_ss_norm}}.
}
