% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/des_gs_norm.R
\name{des_gs_norm}
\alias{des_gs_norm}
\title{Design a multi-stage group-sequential multi-arm clinical trial for a normally
distributed primary outcome}
\usage{
des_gs_norm(
  K = 2,
  J = 2,
  alpha = 0.025,
  beta = 0.1,
  delta1 = 0.5,
  delta0 = 0,
  sigma = 1,
  ratio = 1,
  power = "marginal",
  stopping = "simultaneous",
  type = "variable",
  fshape = "pocock",
  eshape = "pocock",
  ffix = -3,
  efix = 3,
  spacing = (1:J)/J,
  integer = FALSE,
  summary = FALSE
)
}
\arguments{
\item{K}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>K</i>}}{\eqn{K}}, the (initial) number of experimental
treatment arms. Defaults to \code{2}.}

\item{J}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>J</i>}}{\eqn{J}}, the (maximum) number of allowed
stages. Defaults to \code{2}.}

\item{alpha}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&alpha;</i>}}{\eqn{\alpha}}, the significance level
(family-wise error-rate). Defaults to \code{0.025}.}

\item{beta}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&beta;</i>}}{\eqn{\beta}}, used in the definition of
the desired power. Defaults to \code{0.1}.}

\item{delta1}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&delta;</i><sub>1</sub>}}{\eqn{\delta_1}}, the
'interesting' treatment effect. Defaults to \code{0.5}.}

\item{delta0}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&delta;</i><sub>0</sub>}}{\eqn{\delta_0}}, the
'uninteresting' treatment effect. Defaults to \code{0}.}

\item{sigma}{A \code{\link{numeric}} \code{\link{vector}} indicating the
chosen values for
\ifelse{html}{\out{<i>&sigma;</i><sub>0</sub>}}{\eqn{\sigma_0}} and
\ifelse{html}{\out{<i>&sigma;</i><sub>1</sub>}}{\eqn{\sigma_1}}, the standard
deviations of the responses in the control and experimental arms. Must be of
\code{\link{length}} 1 or 2. If of \code{\link{length}} 1, it is assumed that
\ifelse{html}{\out{<i>&sigma;</i><sub>0</sub>
=<i>&sigma;</i><sub>1</sub>}}{\eqn{\sigma_0=\sigma_1}}.
Defaults to \code{1}.}

\item{ratio}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>r</i>}}{\eqn{r}}, the stage-wise allocation ratio to
present experimental arms. Defaults to \code{1}.}

\item{power}{A \code{\link{character}} string indicating the chosen type of
power to design the trial for. Can be \code{"disjunctive"} or
\code{"marginal"}. Defaults to \code{"marginal"}.}

\item{stopping}{A \code{\link{character}} string indicating the chosen type
of stopping rule. Can be \code{"separate"} or \code{"simultaneous"}. Defaults
to \code{"simultaneous"}.}

\item{type}{A \code{\link{character}} string indicating the choice for the
stage-wise sample size. Can be \code{"variable"} or \code{"fixed"}. Defaults
to \code{"variable"}.}

\item{fshape}{A \code{\link{character}} string indicating the choice for the
futility (lower) stopping boundaries. Can be any of \code{"fixed"},
\code{"obf"}, \code{"pocock"}, and \code{"triangular"}. Defaults to
\code{"pocock"}.}

\item{eshape}{A \code{\link{character}} string indicating the choice for the
efficacy (upper) stopping boundaries. Can be any of \code{"fixed"},
\code{"obf"}, \code{"pocock"}, and \code{"triangular"}. Defaults to
\code{"pocock"}.}

\item{ffix}{A \code{\link{numeric}} indicating the chosen value for the fixed
interim futility bounds. Only used when \code{fshape = "fixed"}. Defaults to
\code{"-3"}.}

\item{efix}{A \code{\link{numeric}} indicating the chosen value for the fixed
interim efficacy bounds. Only used when \code{eshape = "fixed"}. Defaults to
\code{"3"}.}

\item{spacing}{A \code{\link{numeric}} \code{\link{vector}} indicating the
chosen spacing of the interim analyses in terms of the proportion of the
maximal possible sample size. It must contain strictly increasing values,
with final element equal to \code{1}. Defaults to
\code{(1:J)/J} (i.e., to equally spaced analyses).}

\item{integer}{A \code{\link{logical}} variable indicating whether the
computed possible sample sizes required in each arm in each stage should be
forced to be whole numbers. Defaults to \code{FALSE}. WARNING: If you set
\code{integer = TRUE} and \code{ratio != 1}, obscure results can occur due to
difficulties in identifying a suitable whole number sample size that meets
the allocation ratio requirement.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}}, with additional class
\code{"multiarm_des_gs_norm"}, containing the following elements:
\itemize{
\item A \code{\link{tibble}} in the slot \code{$opchar} summarising the
operating characteristics of the identified design.
\item A \code{\link{tibble}} in the slot \code{$pmf_N} summarising the
probability mass function of the random required sample size under key
scenarios.
\item A \code{\link{numeric}} \code{\link{vector}} in the slot \code{$e}
specifying \ifelse{html}{\out{<b><i>e</i></b>}}{\eqn{\bold{e}}}, the trial's
efficacy (upper) stopping boundaries.
\item A \code{\link{numeric}} \code{\link{vector}} in the slot \code{$f}
specifying \ifelse{html}{\out{<b><i>f</i></b>}}{\eqn{\bold{f}}}, the trial's
futility (lower) stopping boundaries.
\item A \code{\link{numeric}} in the slot \code{$maxN} specifying
\ifelse{html}{\out{max <i>N</i>}}{max \eqn{N}}, the trial's maximum required
sample size.
\item A \code{\link{numeric}} in the slot \code{$n_factor}, for internal use
in other functions.
\item A \code{\link{numeric}} in the slot \code{$n1} specifying
\ifelse{html}{\out{<i>n</i><sub>1</sub>}}{\eqn{n_1}}, the total sample size
required in stage one of the trial.
\item A \code{\link{numeric}} in the slot \code{$n10} specifying
\ifelse{html}{\out{<i>n</i><sub>10</sub>}}{\eqn{n_{10}}}, the sample size
required in the control arm in stage one of the trial.
\item Each of the input variables.
}
}
\description{
\code{des_gs_norm()} determines multi-stage group-sequential multi-arm
clinical trial designs assuming the primary outcome variable is normally
distributed. It computes required design components and returns information
on key operating characteristics.
}
\examples{
# The design for the default parameters
des <- des_gs_norm()
}
\seealso{
\code{\link{build_gs_norm}}, \code{\link{gui}},
\code{\link{opchar_gs_norm}}, \code{\link{plot.multiarm_des_gs_norm}},
\code{\link{sim_gs_norm}}.
}
