% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/des_dtl_norm.R
\name{des_dtl_norm}
\alias{des_dtl_norm}
\title{Design a multi-stage drop-the-losers multi-arm clinical trial for a normally
distributed primary outcome}
\usage{
des_dtl_norm(
  Kv = c(2, 1),
  alpha = 0.025,
  beta = 0.1,
  delta1 = 0.5,
  delta0 = 0,
  sigma = 1,
  ratio = 1,
  power = "marginal",
  type = "variable",
  spacing = (1:length(Kv))/length(Kv),
  integer = FALSE,
  summary = FALSE
)
}
\arguments{
\item{Kv}{A \code{\link{numeric}} \code{\link{vector}} of strictly decreasing
values, indicating the chosen value for
\ifelse{html}{\out{<b><i>K</i></b>}}{\eqn{\bold{K}}}, the number of
experimental treatment arms present in each stage. Defaults to
\code{c(2, 1)}.}

\item{alpha}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&alpha;</i>}}{\eqn{\alpha}}, the significance level
(family-wise error-rate). Defaults to \code{0.025}.}

\item{beta}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&beta;</i>}}{\eqn{\beta}}, used in the definition of
the desired power. Defaults to \code{0.1}.}

\item{delta1}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&delta;</i><sub>1</sub>}}{\eqn{\delta_1}}, the
'interesting' treatment effect. Defaults to \code{0.5}.}

\item{delta0}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&delta;</i><sub>0</sub>}}{\eqn{\delta_0}}, the
'uninteresting' treatment effect. Defaults to \code{0}.}

\item{sigma}{A \code{\link{numeric}} \code{\link{vector}} indicating the
chosen values for
\ifelse{html}{\out{<i>&sigma;</i><sub>0</sub>}}{\eqn{\sigma_0}} and
\ifelse{html}{\out{<i>&sigma;</i><sub>1</sub>}}{\eqn{\sigma_1}}, the standard
deviations of the responses in the control and experimental arms. Must be of
\code{\link{length}} 1 or 2. If of \code{\link{length}} 1, it is assumed that
\ifelse{html}{\out{<i>&sigma;</i><sub>0</sub>
=<i>&sigma;</i><sub>1</sub>}}{\eqn{\sigma_0=\sigma_1}}.
Defaults to \code{1}.}

\item{ratio}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>r</i>}}{\eqn{r}}, the stage-wise allocation ratio to
present experimental arms. Defaults to \code{1}.}

\item{power}{A \code{\link{character}} string indicating the chosen type of
power to design the trial for. Can be \code{"disjunctive"} or
\code{"marginal"}. Defaults to \code{"marginal"}.}

\item{type}{A \code{\link{character}} string indicating the choice for the
stage-wise sample size. Can be \code{"variable"} or \code{"fixed"}. Defaults
to \code{"variable"}.}

\item{spacing}{A \code{\link{numeric}} \code{\link{vector}} indicating the
chosen spacing of the interim analyses in terms of the proportion of the
maximal possible sample size. It must contain strictly increasing values,
with final element equal to \code{1}. Defaults to
\code{((1:length(Kv))/length(Kv)} (i.e., to equally spaced analyses).}

\item{integer}{A \code{\link{logical}} variable indicating whether the
computed possible sample sizes required in each arm in each stage should be
forced to be whole numbers. Defaults to \code{FALSE}. WARNING: If you set
\code{integer = TRUE} and \code{ratio != 1}, obscure results can occur due to
difficulties in identifying a suitable whole number sample size that meets
the allocation ratio requirement.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}}, with additional class
\code{"multiarm_des_dtl_norm"}, containing the following elements:
\itemize{
\item A \code{\link{tibble}} in the slot \code{$opchar} summarising the
operating characteristics of the identified design.
\item A \code{\link{numeric}} in the slot \code{$e} specifying
\ifelse{html}{\out{<i>e</i>}}{\eqn{e}}, the trial's critical rejection
boundary for the final analysis.
\item A \code{\link{numeric}} in the slot \code{$maxN} specifying
\ifelse{html}{\out{<i>N</i>}}{\eqn{N}}, the trial's total required sample
size.
\item A \code{\link{numeric}} in the slot \code{$n_factor}, for internal use
in other functions.
\item A \code{\link{numeric}} in the slot \code{$n1} specifying
\ifelse{html}{\out{<i>n</i><sub>1</sub>}}{\eqn{n_1}}, the total sample size
required in stage one of the trial.
\item A \code{\link{numeric}} in the slot \code{$n10} specifying
\ifelse{html}{\out{<i>n</i><sub>10</sub>}}{\eqn{n_{10}}}, the sample size
required in the control arm in stage one of the trial.
\item Each of the input variables.
}
}
\description{
\code{des_dtl_norm()} determines multi-stage drop-the-losers multi-arm
clinical trial designs assuming the primary outcome variable is normally
distributed. It computes required design components and returns information
on key operating characteristics.
}
\examples{
# The design for the default parameters
des <- des_dtl_norm()
}
\seealso{
\code{\link{build_dtl_norm}}, \code{\link{gui}},
\code{\link{opchar_dtl_norm}}, \code{\link{plot.multiarm_des_dtl_norm}},
\code{\link{sim_dtl_norm}}.
}
