% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_gs_bern.R
\name{build_gs_bern}
\alias{build_gs_bern}
\title{Build a multi-stage group-sequential multi-arm clinical trial for a Bernoulli
distributed primary outcome}
\usage{
build_gs_bern(
  n10 = 77,
  n1 = n10 * (1 + K * ratio),
  e = c(2.42, 2.42),
  f = c(-2.42, 2.42),
  K = 2,
  alpha = 0.025,
  beta = 0.1,
  pi0 = 0.3,
  delta1 = 0.2,
  delta0 = 0,
  ratio = 1,
  power = "marginal",
  stopping = "simultaneous",
  type = "variable",
  spacing = (1:length(e))/length(e),
  summary = FALSE
)
}
\arguments{
\item{n10}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>n</i><sub>10</sub>}}{\eqn{n_{10}}}, the sample size
required in the control arm in stage one of the trial. Defaults to \code{54}.}

\item{n1}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>n</i><sub>1</sub>}}{\eqn{n_1}}, the total sample size
required in stage one of the trial. Defaults to \code{n10\*(1 + K\*ratio)}.}

\item{e}{A \code{\link{numeric}} \code{\link{vector}} indicating the chosen
value for \ifelse{html}{\out{<b><i>e</i></b>}}{\eqn{\bold{e}}}, the efficacy
(upper) stopping boundaries. Defaults to \code{c(2.42, 2.42)}.}

\item{f}{A \code{\link{numeric}} \code{\link{vector}} indicating the chosen
value for \ifelse{html}{\out{<b><i>f</i></b>}}{\eqn{\bold{f}}}, the futility
(lower) stopping boundaries. Defaults to \code{c(-2.42, 2.42)}.}

\item{K}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>K</i>}}{\eqn{\bold{K}}}, the (initial) number of
experimental treatment arms. Defaults to \code{2}.}

\item{alpha}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&alpha;</i>}}{\eqn{\alpha}}, the significance level
(family-wise error-rate). Defaults to \code{0.025}.}

\item{beta}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&beta;</i>}}{\eqn{\beta}}, used in the definition of
the desired power. Defaults to \code{0.1}.}

\item{pi0}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&pi;</i><sub>0</sub>}}{\eqn{\pi_0}}, the
response rate in the control arm. Defaults to \code{0.3}.}

\item{delta1}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&delta;</i><sub>1</sub>}}{\eqn{\delta_1}}, the
'interesting' treatment effect. Defaults to \code{0.5}.}

\item{delta0}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&delta;</i><sub>0</sub>}}{\eqn{\delta_0}}, the
'uninteresting' treatment effect. Defaults to \code{0}.}

\item{ratio}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>r</i>}}{\eqn{r}}, the stage-wise allocation ratio to
present experimental arms. Defaults to \code{1}.}

\item{power}{A \code{\link{character}} string indicating the chosen type of
power to design the trial for. Can be \code{"disjunctive"} or
\code{"marginal"}. Defaults to \code{"marginal"}.}

\item{stopping}{A \code{\link{character}} string indicating the chosen type
of stopping rule. Can be \code{"separate"} or \code{"simultaneous"}. Defaults
to \code{"simultaneous"}.}

\item{type}{A \code{\link{character}} string indicating the choice for the
stage-wise sample size. Can be \code{"variable"} or \code{"fixed"}. Defaults
to \code{"variable"}.}

\item{spacing}{A \code{\link{numeric}} \code{\link{vector}} indicating the
chosen spacing of the interim analyses in terms of the proportion of the
maximal possible sample size. It must contain strictly increasing values,
with final element equal to \code{1}. Defaults to
\code{(1:length(e))/length(e)} (i.e., to equally spaced analyses).}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}}, with additional class
\code{"multiarm_des_gs_bern"}, containing the following elements:
\itemize{
\item A \code{\link{tibble}} in the slot \code{$opchar} summarising the
operating characteristics of the identified design.
\item A \code{\link{tibble}} in the slot \code{$pmf_N} summarising the
probability mass function of the random required sample size under key
scenarios.
\item A \code{\link{numeric}} in the slot \code{$maxN} specifying
\ifelse{html}{\out{max <i>N</i>}}{max \eqn{N}}, the trial's maximum required
sample size.
\item A \code{\link{numeric}} in the slot \code{$n_factor}, for internal use
in other functions.
\item Each of the input variables.
}
}
\description{
\code{build_gs_bern()} builds a multi-stage group-sequential multi-arm
clinical trial design object assuming the primary outcome variable is
Bernoulli distributed, like those returned by \code{\link{des_gs_bern}}.
}
\examples{
# The design for the default parameters
des <- build_gs_bern()
}
\seealso{
\code{\link{des_gs_bern}}, \code{\link{gui}},
\code{\link{opchar_gs_bern}}, \code{\link{plot.multiarm_des_gs_bern}},
\code{\link{sim_gs_bern}}.
}
