% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_dtl_bern.R
\name{build_dtl_bern}
\alias{build_dtl_bern}
\title{Build a multi-stage drop-the-losers multi-arm clinical trial for a Bernoulli
distributed primary outcome}
\usage{
build_dtl_bern(
  n1 = 210,
  n10 = 70,
  e = 2.17,
  Kv = c(2, 1),
  alpha = 0.025,
  beta = 0.1,
  pi0 = 0.3,
  delta1 = 0.2,
  delta0 = 0,
  ratio = 1,
  power = "marginal",
  type = "variable",
  summary = FALSE
)
}
\arguments{
\item{n1}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>n</i><sub>1</sub>}}{\eqn{n_1}}, the total sample size
required in stage one of the trial. Defaults to \code{147}.}

\item{n10}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>n</i><sub>10</sub>}}{\eqn{n_{10}}}, the sample size
required in the control arm in stage one of the trial. Defaults to \code{49}.}

\item{e}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>e</i>}}{\eqn{e}}, the critical rejection boundary for
the final analysis. Defaults to \code{2.17}.}

\item{Kv}{A \code{\link{numeric}} \code{\link{vector}} of strictly decreasing
values, indicating the chosen value for
\ifelse{html}{\out{<b><i>K</i></b>}}{\eqn{\bold{K}}}, the number of
experimental treatment arms present in each stage. Defaults to
\code{c(2, 1)}.}

\item{alpha}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&alpha;</i>}}{\eqn{\alpha}}, the significance level
(family-wise error-rate). Defaults to \code{0.025}.}

\item{beta}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&beta;</i>}}{\eqn{\beta}}, used in the definition of
the desired power. Defaults to \code{0.1}.}

\item{pi0}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&pi;</i><sub>0</sub>}}{\eqn{\pi_0}}, the
response rate in the control arm. Defaults to \code{0.3}.}

\item{delta1}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&delta;</i><sub>1</sub>}}{\eqn{\delta_1}}, the
'interesting' treatment effect. Defaults to \code{0.5}.}

\item{delta0}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>&delta;</i><sub>0</sub>}}{\eqn{\delta_0}}, the
'uninteresting' treatment effect. Defaults to \code{0}.}

\item{ratio}{A \code{\link{numeric}} indicating the chosen value for
\ifelse{html}{\out{<i>r</i>}}{\eqn{r}}, the stage-wise allocation ratio to
present experimental arms. Defaults to \code{1}.}

\item{power}{A \code{\link{character}} string indicating the chosen type of
power to design the trial for. Can be \code{"disjunctive"} or
\code{"marginal"}. Defaults to \code{"marginal"}.}

\item{type}{A \code{\link{character}} string indicating the choice for the
stage-wise sample size. Can be \code{"variable"} or \code{"fixed"}. Defaults
to \code{"variable"}.}

\item{summary}{A \code{\link{logical}} variable indicating whether a summary
of the function's progress should be printed to the console. Defaults to
\code{FALSE}.}
}
\value{
A \code{\link{list}}, with additional class
\code{"multiarm_des_dtl_bern"}, containing the following elements:
\itemize{
\item A \code{\link{tibble}} in the slot \code{$opchar} summarising the
operating characteristics of the identified design.
\item A \code{\link{numeric}} in the slot \code{$maxN} specifying
\ifelse{html}{\out{<i>N</i>}}{\eqn{N}}, the trial's total required sample
size.
\item A \code{\link{numeric}} in the slot \code{$n_factor}, for internal use
in other functions.
\item Each of the input variables.
}
}
\description{
\code{build_dtl_bern()} builds a multi-stage drop-the-losers multi-arm
clinical trial design object assuming the primary outcome variable is
Bernoulli distributed, like those returned by \code{\link{des_dtl_bern}}.
}
\examples{
# The design for the default parameters
des <- build_dtl_bern()
}
\seealso{
\code{\link{des_dtl_bern}}, \code{\link{gui}},
\code{\link{opchar_dtl_bern}}, \code{\link{plot.multiarm_des_dtl_bern}},
\code{\link{sim_dtl_bern}}.
}
