# 💎 Awesome Microservices .NET [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg)](https://makeapullrequest.com)

> A collection of awesome training series, articles, videos, books, courses, sample projects, and tools for Microservices in .NET

## Give a Star! ⭐️

If you liked this repo or if it helped you, please give a star ⭐️ for this repository. That will not only help strengthen our .NET community but also improve skills about the Microservices for .NET developers around the world 👍. Thank you very much.

## Contents
- [Training Series](#training-series)
- [Books](#books)
- [Free eBooks](#free-ebooks)
- [Courses](#courses)
- [Other Tutorials](#other-tutorials)
- [Sample Projects](#sample-projects)
- [Tools and Libraries](#tools-and-libraries)
- [Contribution](#contribution)
- [Licence](#license)

## Training Series

### Building Microservices On .NET Core 
January 2019-September 2019

1. [Building Microservices On .NET Core – Part 1 The Plan](https://altkomsoftware.com/blog/building-microservices-net-core-part-1-plan/)

2. [Building Microservices On .NET Core – Part 2 Shaping microservice internal architecture with CQRS and MediatR](https://altkomsoftware.com/blog/microservices-net-core-cqrs-mediatr/)

3. [Building Microservices On .NET Core – Part 3 Service Discovery with Eureka](https://altkomsoftware.com/blog/service-discovery-eureka/)

4. [Building Microservices On .NET Core – Part 4 Building API Gateways With Ocelot](https://altkomsoftware.com/blog/building-api-gateways-with-ocelot/)

5. [Building Microservices On .NET Core – Part 5 Marten An Ideal Repository For Your Domain Aggregates](https://altkomsoftware.com/blog/building-microservices-net-core-part-5-marten-ideal-repository-domain-aggregates/)

6. [Building Microservices On .NET Core – Part 6 Real time server client communication with SignalR and RabbitMQ](https://altkomsoftware.com/blog/building-microservices-6/)

7. [Building Microservices On .NET Core – Part 7 Transactional Outbox with RabbitMQ](https://altkomsoftware.com/blog/microservices-outbox-rabbitmq/)

**Repository :** https://github.com/asc-lab/dotnetcore-microservices-poc

### Building microservices through Event Driven Architecture 
January 2019-

1. [Building microservices through Event Driven Architecture part1 : application specific business rules](https://logcorner.com/building-microservices-through-event-driven-architecture-part1-application-specific-business-rules/)

2. [Building microservices through Event Driven Architecture part2 : domain objects and business rules](https://logcorner.com/building-microservices-through-event-driven-architecture-part2-domain-objects-and-business-rules/)

3. [Building microservices through Event Driven Architecture part3: Presenters, Views, and Controllers](https://logcorner.com/building-microservices-through-event-driven-architecture-part3-presenters-views-and-controllers/)

4. [Building microservices through Event Driven Architecture part4: repositories](https://logcorner.com/building-microservices-through-event-driven-architecture-part4-repositories/)

5. [Building microservices through Event Driven Architecture part5: dockerization (Web Api Core and SQL Server Linux)](https://logcorner.com/building-microservices-through-event-driven-architecture-part5-dockerization-web-api-core-and-sql-server-linux/)

6. [Building microservices through Event Driven Architecture part6: Implementing EventSourcing on Domain Model](https://logcorner.com/building-microservices-through-event-driven-architecture-part7-event-sourcing-core-domain/)

7. [Building microservices through Event Driven Architecture part7: Implementing EventSourcing on Repositories](https://logcorner.com/building-microservices-through-event-driven-architecture-part7-implementing-eventsourcing-on-repositories/)

8. [Building microservices through Event Driven Architecture part8: Implementing EventSourcing on Application](https://logcorner.com/building-microservices-through-event-driven-architecture-part8-implementing-eventsourcing-on-application/)

9. [Building microservices through Event Driven Architecture part09: Handling updates](https://logcorner.com/building-microservices-through-event-driven-architecture-part10-handling-updates-and-deletes/)

10. [Building microservices through Event Driven Architecture part10: Run Unit tests inside a docker container](https://logcorner.com/building-microservices-through-event-driven-architecture-part11-run-unit-tests-inside-a-docker-container/)

11. [Building microservices through Event Driven Architecture part11: Continuous Integration](https://logcorner.com/building-microservices-through-event-driven-architecture-part12-continuous-integration/)

12. [Building microservices through Event Driven Architecture part12 : Produce events to Apache KAFKA](https://logcorner.com/building-microservices-through-event-driven-architecture-part12-produce-events-to-apache-kafka/)

**Repository :** https://github.com/logcorner/LogCorner.EduSync.Speech.Command/  https://github.com/logcorner/LogCorner.EduSync.Speech.ServiceBus

### Building API Gateway Using Ocelot In ASP.NET Core
November 2017-August 2019

1. [Building API Gateway Using Ocelot In ASP.NET Core](https://www.c-sharpcorner.com/article/building-api-gateway-using-ocelot-in-asp-net-core/)

2. [Part Two - Building API Gateway Using Ocelot In ASP.NET Core - Authentication](https://www.c-sharpcorner.com/article/building-api-gateway-using-ocelot-in-asp-net-core-part-two/)

3. [Part Three -Building API Gateway Using Ocelot In ASP.NET Core - Logging](https://www.c-sharpcorner.com/article/building-api-gateway-using-ocelot-in-asp-net-core-part-three-logging2/)

4. [Part Four - Building API Gateway Using Ocelot In ASP.NET Core - Rate Limiting](https://www.c-sharpcorner.com/article/building-api-gateway-using-ocelot-in-asp-net-core-rate-limiting-part-four/)

5. [Building API Gateway Using Ocelot In ASP.NET Core - QoS (Quality of Service)](https://www.c-sharpcorner.com/article/building-api-gateway-using-ocelot-in-asp-net-core-qos/)

6. [Building API Gateway Using Ocelot In ASP.NET Core - Load Balancing](https://www.c-sharpcorner.com/article/building-api-gateway-using-ocelot-in-asp-net-core-load-balancing/)

7. [Building API Gateway Using Ocelot In ASP.NET Core - Service Discovery (Eureka)](https://www.c-sharpcorner.com/article/building-api-gateway-using-ocelot-in-asp-net-core-service-discoveryeureka/)

8. [Building API Gateway Using Ocelot In ASP.NET Core - Service Discovery (Consul)](https://www.c-sharpcorner.com/article/building-api-gateway-using-ocelot-in-asp-net-core-service-discovery-consul/)

9. [Building API Gateway Using Ocelot In ASP.NET Core - Configuration (Consul)](https://www.c-sharpcorner.com/article/building-api-gateway-using-ocelot-in-asp-net-core-configuration-consul/)

**Repository :** https://github.com/catcherwong-archive/APIGatewayDemo

### Distributed .NET Core (DShop)
December 2018-April 2019

1. [Distributed .NET Core (DShop) - Teaser](https://www.youtube.com/watch?v=6YYB8vv3pZg&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

2. [Distributed .NET Core (DShop) - Episode 1 [Intro, HTTP requests flow, Infrastructure with Docker]](https://www.youtube.com/watch?v=s4fd3PRlOcw&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

3. [Distributed .NET Core (DShop) - Episode 2 [CQRS - Write side, Discounts service, MongoDB repository]](https://www.youtube.com/watch?v=yqh0dN4oDTs&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

4. [Distributed .NET Core (DShop) - Episode 3 [Subscribing RabbitMQ messages, API gateway]](https://www.youtube.com/watch?v=L9UUUPedidg&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

5. [Distributed .NET Core (DShop) - Episode 4 [Asynchronous microservices integration via events]](https://www.youtube.com/watch?v=KiIetmswEos&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

6. [Distributed .NET Core (DShop) - Episode 5 [CQRS - Read side, Internal HTTP communication]](https://www.youtube.com/watch?v=o0fMHARUwq0&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

7. [Distributed .NET Core (DShop) - Episode 6 [Service discovery & Load balancing with Consul + Fabio]](https://www.youtube.com/watch?v=UWfn8Iml2Kc&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

8. [Distributed .NET Core (DShop) - Episode 7 [Handling asynchronous requests, SignalR, Polly]](https://www.youtube.com/watch?v=rKmL2Onh4hg&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

9. [Distributed .NET Core (DShop) - Episode 8 [Distributed transactions, 2PC, Event Choreography, Saga]](https://www.youtube.com/watch?v=KI223ULIFoA&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

10. [Distributed .NET Core (DShop) - Episode 9 [Vault secrets, Seq logging, Jaeger distributed tracing]](https://www.youtube.com/watch?v=8bDHf7yiNKM&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

11. [Distributed .NET Core (DShop) - Episode 10 [Metrics with AppMetrics, InfluxDB, Prometheus, Grafana]](https://www.youtube.com/watch?v=2OiE-h9sNM4&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

12. [Distributed .NET Core (DShop) - Episode 11 [Travis CI pipelines, custom MyGet feeds]](https://www.youtube.com/watch?v=sS9yB7m_OsQ&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

13. [Distributed .NET Core (DShop) - Episode 12 [Docker basics, Docker Hub, docker-compose]](https://www.youtube.com/watch?v=drD0vgKecAc&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

14. [Distributed .NET Core (DShop) - Episode 13 [Integration tests with xUnit, Web API, Mongo, RabbitMQ]](https://www.youtube.com/watch?v=fDe_Neayo9I&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

15. [Distributed .NET Core (DShop) - Episode 14 [Consumer-driven contract testing with Pact]](https://www.youtube.com/watch?v=qRCY5BTYQk0&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

16. [Distributed .NET Core (DShop) - Episode 15 [Orchestration with Portainer, Kubernetes and Rancher]](https://www.youtube.com/watch?v=YxvB6-6FSZE&list=PLqqD43D6Mqz38LoZEuo_hJAp2NxXskcut)

**Repository :** https://github.com/devmentors/DNC-DShop

### Microservices .NET
May 2020-August 2020

1. [Meet Pacco & Microservices .NET!](https://www.youtube.com/watch?v=5SLyrETnJoE&list=PLqqD43D6Mqz1LNS7bqFhAJNfmVfQ077hz)

2. [CQRS - reserving a resource](https://www.youtube.com/watch?v=Ne5XueXktfM&list=PLqqD43D6Mqz1LNS7bqFhAJNfmVfQ077hz)

3. [Inbox & Outbox pattern - transactional message processing](https://www.youtube.com/watch?v=ebyR5RPKciw&list=PLqqD43D6Mqz1LNS7bqFhAJNfmVfQ077hz)

4. [API Gateway with Ocelot and RabbitMQ](https://www.youtube.com/watch?v=TM3DpaWdLRM&list=PLqqD43D6Mqz1LNS7bqFhAJNfmVfQ077hz)

5. [Contract testing with Pact.io](https://www.youtube.com/watch?v=vhlH5NyNbjA&list=PLqqD43D6Mqz1LNS7bqFhAJNfmVfQ077hz)

6. [Distributed Tracing with Jaeger](https://www.youtube.com/watch?v=toXFRBtv4fg&list=PLqqD43D6Mqz1LNS7bqFhAJNfmVfQ077hz)

7. [Dynamic Credentials with Vault](https://www.youtube.com/watch?v=L3mDWAA-rzg&list=PLqqD43D6Mqz1LNS7bqFhAJNfmVfQ077hz)

8. [DevMentors Live #0 - "Microservices .NET" Q&A, future plans etc...](https://www.youtube.com/watch?v=tQu96sqWkz8&list=PLqqD43D6Mqz1LNS7bqFhAJNfmVfQ077hz)

9. [Sidecar pattern + custom reverse proxy + k8s](https://www.youtube.com/watch?v=1v8SXWXxGvM&list=PLqqD43D6Mqz1LNS7bqFhAJNfmVfQ077hz)

**Repository :** https://github.com/devmentors/Pacco

### .NET Conf: Focus on Microservices
August 2020

1. [Welcome to .NET Conf: Focus on Microservices](https://www.youtube.com/watch?v=ZEvoxXnsbbU&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

2. [Why You Should Care About Microservices](https://www.youtube.com/watch?v=7hY6fggwHqU&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

3. [Stay Sharp](https://www.youtube.com/watch?v=x_IGNq4snx8&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

4. [A Journey into .NET Microservices with Steeltoe](https://www.youtube.com/watch?v=3meYereHHtM&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

5. [Orleans at Microsoft](https://www.youtube.com/watch?v=KhgYlvGLv9c&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

6. [Adding a Little DAPR to Your .NET Microservices](https://www.youtube.com/watch?v=g-gOlkD9lKs&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

7. [Developing and Deploying Microservices with 'Tye'](https://www.youtube.com/watch?v=MMIUpYOQq5Y&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

8. [Beyond REST and RPC: Asynchronous Eventing and Messaging Patterns](https://www.youtube.com/watch?v=6zs-PhgfLU4&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

9. [The Intersection of Microservices, Domain-Driven Design and Entity Framework Core](https://www.youtube.com/watch?v=DG8Qe7TJiIE&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

10. [Build High-performance Microservices with gRPC and .NET](https://www.youtube.com/watch?v=HVq4TstHCEs&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

11. [DevOps, Waffles, and Superheroes - Oh My!](https://www.youtube.com/watch?v=5BkKjTxIokU&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

12. [API Communication in Microservices with Azure API Management and Azure Functions](https://www.youtube.com/watch?v=YLMsAMvY4KA&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

13. [Evolving .NET Framework Monoliths with .NET 5 and Kubernetes](https://www.youtube.com/watch?v=Wbjh4T-cdv8&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

14. [Migrating .NET Framework Web Apps to Azure](https://www.youtube.com/watch?v=UT_Fd-Pkiuw&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

15. [Building & Debugging Microservices faster using Kubernetes and Visual Studio](https://www.youtube.com/watch?v=98nIvg7ne7Q&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

16. [Workshop Module 1: Introducing Microservices](https://www.youtube.com/watch?v=jMDufMYAsmw&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

17. [Workshop Module 2: Modeling and Architecting Microservices](https://www.youtube.com/watch?v=u7MM21aIsqk&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

18. [Workshop Module 3: Microservice Communication](https://www.youtube.com/watch?v=iL3Kxd4Auys&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

19. [Workshop Module 4: Deploying Microservices to Kubernetes](https://www.youtube.com/watch?v=3G7NB4waGbk&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

20. [Workshop Module 5: Deploying Service Mesh to Kubernetes](https://www.youtube.com/watch?v=qwEfynnevEU&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

21. [Workshop Module 6: Distributed Data](https://www.youtube.com/watch?v=7kVmb747vfM&list=PLdo4fOcmZ0oUc2ShrReCS7KoBbPEONE0p)

**Repository :** https://github.com/dotnet-presentations/dotNETConf/tree/master/2020/FocusOnMicroservices

### Microservices with .NET Core and Docker
March 2020-June 2020

1. [Microservices with .NET Core and Docker Episode 1](https://www.youtube.com/watch?v=P5alkeFH8aU&list=PLuFW0YeVZv-kJyjRycyu-5R0COCbTXtIu)

2. [Microservices with .NET Core and Docker Episode 02](https://www.youtube.com/watch?v=Uwsgd7cIJxk&list=PLuFW0YeVZv-kJyjRycyu-5R0COCbTXtIu)

3. [Microservices with .NET Core and Docker Episode 03 - Serilog and Seq](https://www.youtube.com/watch?v=orPeI28AmaM&list=PLuFW0YeVZv-kJyjRycyu-5R0COCbTXtIu)

4. [Microservices with .NET Core and Docker Episode 04 - Bandwidth Tester with Serilog and Seq](https://www.youtube.com/watch?v=xwbzNI5ymAs&list=PLuFW0YeVZv-kJyjRycyu-5R0COCbTXtIu)

5. [Microservices with .NET Core and Docker Episode 05 - PostgreSQL Setup](https://www.youtube.com/watch?v=8QvVoFiYxIc&list=PLuFW0YeVZv-kJyjRycyu-5R0COCbTXtIu)

6. [Microservices with .Net Core and Docker Episode 06 - Corona Virus Dashboard Part 01](https://www.youtube.com/watch?v=yd8FycqRRAk&list=PLuFW0YeVZv-kJyjRycyu-5R0COCbTXtIu)

7. [Microservices with .Net Core and Docker Episode 07 - Corona Virus Dashboard Part 02](https://www.youtube.com/watch?v=nGmPHTnB8pk&list=PLuFW0YeVZv-kJyjRycyu-5R0COCbTXtIu)

8. [DockerMonitoring with Grafana and .NET Core](https://www.youtube.com/watch?v=udGjA6Pxtuo&list=PLuFW0YeVZv-kJyjRycyu-5R0COCbTXtIu)

**Repository :** https://github.com/DotNetMax/DockerMonitoringService

### .NET Microservices Architecture Guidance (Microsoft)

- [.NET Microservices: Architecture for Containerized .NET Applications](https://docs.microsoft.com/en-us/dotnet/architecture/microservices/)

- [Download eBook (PDF)](https://aka.ms/microservicesebook)

- [Microservice Architecture with ASP.NET Core (Video)](https://channel9.msdn.com/Shows/On-NET/Microservice-Architecture-with-ASPNET-Core)

- [Implement Microservices Patterns with .NET Core and Docker Containers (Video)](https://channel9.msdn.com/events/Ignite/Microsoft-Ignite-Orlando-2017/BRK3317)

**Repository :** https://github.com/dotnet-architecture/eShopOnContainers

### A Microservices Implementation Journey
January 2018-March 2018

1. [A Microservices implementation journey — Part 1](https://koukia.ca/a-microservices-implementation-journey-part-1-9f6471fe917)

2. [A Microservices implementation journey — Part 2](https://koukia.ca/a-microservices-implementation-journey-part-2-10c422a4d402)

3. [A Microservices implementation journey — Part 3](https://koukia.ca/a-microservices-implementation-journey-part-3-50f030ba6bb5)

4. [A Microservices implementation journey — Part 4](https://koukia.ca/a-microservices-implementation-journey-part-4-9c19a16385e9)

5. [A Microservices implementation journey — Part 5](https://koukia.ca/a-microservices-implementation-journey-part-5-d7d1b9d441e7)

6. [A Microservices implementation journey — Part 6](https://koukia.ca/a-microservices-implementation-journey-part-6-9b818e491336)

**Repository :** https://github.com/aramkoukia/microservices-prototype

### Microservices and Docker with .Net Core and Azure Service Fabric/Kubernetes
February 2018-September 2018

1. [Microservices and Docker with .Net Core and Azure Service Fabric - Part One](https://elvanydev.com/Microservices-part1/)

2. [Microservices and Docker with .Net Core and Azure Service Fabric - Part two](https://elvanydev.com/Microservices-part2/)

3. [Microservices and Docker with .Net Core and Azure Service Fabric - Part three](https://elvanydev.com/Microservices-part3/)

4. [Microservices and Docker with .Net Core and Azure Service Fabric - Part four](https://elvanydev.com/Microservices-part4/)

5. [Building resilient applications with Polly](https://elvanydev.com/resilience-with-polly/)

**Repository :** https://github.com/vany0114/microservices-dotnetcore-docker-sf-k8s

### Microservices with .NET Core Tutorials
September 2018-October 2018

1. [Understanding Microservices Architecture](https://www.dotnettricks.com/learn/microservices/architecture-example-advantages)

2. [Getting Started with Azure Service Fabric](https://www.dotnettricks.com/learn/microservices/azure-service-fabric)

3. [Building a Microservice with ASP.NET Core](https://www.dotnettricks.com/learn/microservices/building-micro-services-azure-service-fabric)

4. [Building an Azure Service Fabric Cluster](https://www.dotnettricks.com/learn/microservices/building-an-azure-service-fabric-cluster)

5. [Microservices Deployment Patterns](https://www.dotnettricks.com/learn/microservices/deployment-patterns)

### Building Microservices on .Net platforms
May 2020

1. [Microservices Architecture on .NET with applying CQRS, Clean Architecture and Event-Driven Communication](https://medium.com/aspnetrun/microservices-architecture-on-net-3b4865eea03f)

2. [Microservices Using ASP.NET Core, MongoDB and Docker Container](https://medium.com/aspnetrun/build-catalog-microservice-using-asp-net-core-mongodb-and-docker-container-88b8fd4d5040)

3. [Using Redis with ASP.NET Core, and Docker Container for Basket Microservices](https://medium.com/aspnetrun/using-redis-with-asp-net-core-and-docker-container-for-basket-microservices-715ff739186e)

4. [Building Ocelot API Gateway Microservices with ASP.NET Core and Docker Container](https://medium.com/aspnetrun/building-ocelot-api-gateway-microservices-with-asp-net-core-and-docker-container-13f96026e86c)

5. [Microservices Event Driven Architecture with RabbitMQ and Docker Container on .NET](https://medium.com/aspnetrun/microservices-event-driven-architecture-with-rabbitmq-and-docker-container-on-net-968d73052cbb)

6. [CQRS and Event Sourcing in Event Driven Architecture of Ordering Microservices](https://medium.com/aspnetrun/cqrs-and-event-sourcing-in-event-driven-architecture-of-ordering-microservices-fb67dc44da7a)

7. [AspnetRun Microservices Renewed !](https://mehmetozkaya.medium.com/aspnetrun-microservices-renewed-d08901b5e06f)

**Repository :** https://github.com/aspnetrun/run-aspnetcore-microservices

## Books

- [Building Microservices with .NET Core](https://www.amazon.com/Building-Microservices-NET-Core-Reactive-ebook/dp/B01MQ52RM3) <small>(by Gaurav Kumar Aroraa, Lalit Kale, and Kanwar Manish) June 14, 2017</small>

- [Microservices by examples using .NET Core](https://www.amazon.com/Microservices-examples-using-NET-Core/dp/9387284581) <small>(by Biswa Pujarini Mohapatra, Baishakhi Banerjee, and Gaurav Aroraa) April 16, 2019</small>

- [Building Microservices with ASP.NET Core](https://www.amazon.com/Building-Microservices-ASP-NET-Core-Cross-Platform-ebook/dp/B0758YB73N) <small>(by Kevin Hoffman) August 31, 2017</small>

- [Building Microservices with .NET Core 2.0](https://www.amazon.com/Building-Microservices-NET-Core-Transitioning-ebook-dp-B075VB9YL7/dp/B075VB9YL7) <small>(by Gaurav Aroraa) December 22, 2017</small>

- [Hands-On Microservices with C#](https://www.amazon.com/Hands-Microservices-real-world-enterprise-grade-microservice-ebook/dp/B07F6YDCWG) <small>(by Matt R. Cole) June 29, 2018</small>

- [Hands-On Microservices with C# 8 and .NET Core 3](https://www.amazon.com/Hands-Microservices-NET-Core-microservices/dp/1789617944) <small>(by Gaurav Aroraa and Ed Price) March 27, 2020</small>

- [Microservices in .NET Core](https://www.amazon.com/Microservices-NET-Core-examples-Nancy/dp/1617293377) <small>(by Christian Horsdal Gammelgaard) February 3, 2017</small>

## Free eBooks

- [.NET Microservices: Architecture for Containerized .NET Applications](https://docs.microsoft.com/en-us/dotnet/architecture/microservices/) - [Download PDF](https://aka.ms/microservicesebook)

- [Microservices in .NET Core (with examples in Nancy)](https://livebook.manning.com/book/microservices-in-net-core/about-this-book/) - [Manning Publications](https://www.manning.com/books/microservices-in-net-core) <!-- markdown-link-check-disable-line -->

- [Microservices Recipes (a free gitbook)](https://github.com/vaquarkhan/microservices-recipes-a-free-gitbook)

## Courses

- [.NET Core Microservices | Udemy](https://www.udemy.com/course/net-core-microservices/) - ([Packt](https://www.packtpub.com/product/net-core-microservices-video/9781788626415))

- [Microservices Architecture and Implementation on .NET 5 | Udemy](https://www.udemy.com/course/microservices-architecture-and-implementation-on-dotnet/)

- [Building Microservices using ASP.NET Core 5.0 and Docker | Udemy](https://www.udemy.com/course/microservices-using-aspnet-core-5-and-docker-rabbitmq-facedetection/)

- [Getting Started .NET Core Microservices RabbitMQ | Udemy](https://www.udemy.com/course/getting-started-net-core-microservices-rabbitmq/)

- [Build Microservices with .NET Core & Amazon Web Services | Udemy](https://www.udemy.com/course/build-microservices-with-aspnet-core-amazon-web-services/)

- [ASP.NET Core Microservices: Getting Started | Pluralsight](https://www.pluralsight.com/courses/getting-started-asp-dot-net-core-microservices)

- [Microservices Communication in ASP.NET Core | Pluralsight](https://www.pluralsight.com/courses/microservices-communication-asp-dot-net-core)

- [Versioning and Evolving Microservices in ASP.NET Core | Pluralsight](https://www.pluralsight.com/courses/versioning-evolving-microservices-asp-dot-net-core)

- [Securing Microservices in ASP.NET Core | Pluralsight](https://www.pluralsight.com/courses/securing-microservices-asp-dot-net-core)

- [Deploying ASP.NET Core Microservices Using Kubernetes and AKS | Pluralsight](https://www.pluralsight.com/courses/deploying-asp-dot-net-core-microservices-kubernetes-aks)

- [Strategies for Microservice Scalability and Availability in ASP.NET Core | Pluralsight](https://www.pluralsight.com/courses/strategies-microservice-scalability-availability-asp-dot-net-core)
- [Step-by-step tutorial for building microservices using .NET](https://www.youtube.com/watch?v=DgVjEo3OGBI&t=11544s)

	**Course content :** 
	 - Building two .NET Microservices using the REST API pattern
	 - Working with dedicated persistence layers for both services
	 - Deploying our services to Kubernetes cluster
	 - Employing the API Gateway pattern to route to our services
	 - Building Synchronous messaging between services (HTTP & gRPC)
	 - Building Asynchronous messaging between services using an Event Bus
	   (RabbitMQ)
## Other Tutorials

- [Microservices with ASP.NET Core 3.1](https://procodeguide.com/programming/microservices-asp-net-core/)
    - **Repository :** https://github.com/procodeguide/Microservices.Sample

- [Get Started Building Microservices with ASP.NET Core and Docker in Visual Studio Code](https://fullstackmark.com/post/12/get-started-building-microservices-with-asp.net-core-and-docker-in-visual-studio-code)
    - **Repository :** https://github.com/mmacneil/ASPNETCoreDockerMicroservices
    
- [Microservices with event sourcing using .NET Core](https://medium.com/@madslundt/microservices-with-event-sourcing-using-net-core-33e3074171f5)
    - **Repository :** https://github.com/madslundt/NetCoreMicroservicesSample
	
- [Microservice Architecture in ASP.NET Core with API Gateway](https://www.codewithmukesh.com/blog/microservice-architecture-in-aspnet-core/)
    - **Repository :** https://github.com/iammukeshm/Microservice.WebApi
	
- [RabbitMQ with ASP.NET Core – Microservice Communication with MassTransit](https://www.codewithmukesh.com/blog/rabbitmq-with-aspnet-core-microservice/)
    - **Repository :** https://github.com/iammukeshm/Microservices.Ticketing.WebApi

- [Programming a Microservice with .Net Core 3.1](https://www.programmingwithwolfgang.com/programming-microservices-net-core-3-1/)
    - **Repository :** https://github.com/WolfgangOfner/MicroserviceDemo

- [Securing Microservices with IdentityServer4, OAuth2 and OpenID Connect fronted by Ocelot API Gateway](https://medium.com/aspnetrun/securing-microservices-with-identityserver4-with-oauth2-and-openid-connect-fronted-by-ocelot-api-49ea44a0cf9e)
    - **Repository :** https://github.com/aspnetrun/run-aspnet-identityserver4

- [Using gRPC in Microservices for Building a high-performance Interservice Communication with .Net 5](https://medium.com/aspnetrun/using-grpc-in-microservices-for-building-a-high-performance-interservice-communication-with-net-5-11f3e5fa0e9d)
    - **Repository :** https://github.com/aspnetrun/run-aspnet-grpc
    
- **Our first Microservice with .NET Core 3.1**
    - [Our first Microservice with .NET Core 3.1 - First Part](https://medium.com/proscai-x/our-first-microservice-with-net-core-3-1-first-part-884fd46853ea)
    - [Containerizing your First NetCore MicroService with Docker and creating CI/CD Pipelines with Jenkins - Second Part](https://medium.com/proscai-x/containerizing-your-first-netcore-microservice-with-docker-and-creating-ci-cd-pipelines-with-c04ef62f9c17)
    - **Repository :** https://github.com/elsavies/NetCoreMicroservices

- [Microservice Series - From Zero to Hero](https://www.programmingwithwolfgang.com/microservice-series-from-zero-to-hero)

- [How To Develop Microservices Using .Net Core & Docker](https://www.3pillarglobal.com/insights/develop-microservices-net-core-docker)

- [Using Microservices in .Net Core and Docker container](https://medium.com/@didourebai/using-microservices-in-net-core-and-docker-container-c202785dd295)

- [Microservices Using ASP.NET Core](https://www.c-sharpcorner.com/article/microservice-using-asp-net-core/)

- [Microservices Using .Net Core 2.X With C# and Docker](https://dzone.com/articles/micro-services-using-net-core-2x-with-c-and-docker)

- [Serverless Event-Driven Architecture on Azure: A Worked Example - Part 1](https://dev.to/mariomeyrelles/serverless-event-driven-architecture-on-azure-a-worked-example-part-1-481e) and [Part2](https://dev.to/mariomeyrelles/serverless-event-driven-architecture-on-azure-a-worked-example-part-2-3im6)
	
- [Edwin van Wijk — Building microservices with .NET Core and Docker (Video)](https://www.youtube.com/watch?v=-AfZxdXa7yc)

- [Microservice architecture with ASP.NET Core (Video)](https://www.youtube.com/watch?v=2ooo-igyTrs)

- [Implement microservices patterns with .NET Core and Docker containers - BRK3317 (Video)](https://www.youtube.com/watch?v=1vK3TXXZ3zI)

- [Create .NET Core Microservice Using Best Practices (Video)](https://www.youtube.com/watch?v=MpQkwbq2SZ8)

- [APIs and Microservices in ASP.NET Core Today and Tomorrow - Glenn Condron (Video)](https://www.youtube.com/watch?v=dUdGcogYkss)

- [Microservices and more in .NET Core 3.0 (Video)](https://www.youtube.com/watch?v=cNdPbTB72bw)

- [Ocelot Api Gateway with ASP.NET Core 2.1 and VS Code (Video)](https://www.youtube.com/watch?v=kl-NeEAb1WQ)

- [Building Reactive Microservices with .NET Core - Kevin Hoffman, Capital One (Video)](https://www.youtube.com/watch?v=bGdar01KNzg)

- [Building .NET Microservices — Kevin Hoffmann (Video)](https://www.youtube.com/watch?v=-a8v_IRSveY)

- [Dan Wahlin on Microservices with Docker, Angular, and ASP.Net Core | Evening of Angular (Video)](https://www.youtube.com/watch?v=acykoYAgBsA)

- [Building Resilient Microservices with .NET Core and Steeltoe - Zach Brown & Matt Horan, Pivotal (Video)](https://www.youtube.com/watch?v=2HF6HFhGH60)

- [.NET Microservices with DAPR (Video)](https://www.youtube.com/watch?v=TeHVd3UlfY8)

- [Navigating microservices with .NET Core and Tye - Ryan Nowak (Video)](https://www.youtube.com/watch?v=dubHmScPNzQ)

- [Developing and Deploying Microservices with 'Tye' (Video)](https://www.youtube.com/watch?v=_s8UdhGOGmY)

- [On .NET Live - Intro to Microservice Patterns for .NET Developers (Video)](https://www.youtube.com/watch?v=zW4INO353Xg)

- [Splitting up a Monolith to (micro)Services by CodeOpinion (Video)](https://www.youtube.com/watch?v=Inscvakv5XI)

- [Building microservices with Tye (Video)](https://channel9.msdn.com/Shows/On-NET/Building-microservices-with-Tye)

## Sample Projects

- https://github.com/vietnam-devs/coolstore-microservices

- https://github.com/EdwinVW/pitstop

- https://github.com/chayxana/Restaurant-App

- https://github.com/netcorebcn/quiz

- https://github.com/twzhangyang/RestAirline

- https://github.com/thangchung/practical-dapr

- https://github.com/thangchung/shopping-cart-k8s

- https://github.com/thangchung/ShoppingCartDemo

- https://github.com/thangchung/magazine-website-akka

- https://github.com/thangchung/magazine-website

- https://github.com/alugili/ModernArchitectureShop

- https://github.com/MarcelMichau/fake-survey-generator

- https://github.com/kimcu-on-thenet/dapr-tye-simple-microservices

- https://github.com/dzimchuk/book-fast-docker

- https://github.com/dzimchuk/book-fast-service-fabric

- https://github.com/AlexeyKramarenko/.NET-Core-Microservices

- https://github.com/suadev/dotnet-istanbul-microservices-demo

- https://github.com/sandhaka/MyMicroservicesApplication

- https://github.com/ImranMA/MicroCouriers

- https://github.com/NHadi/HappySocialMedia

- https://github.com/xiajingren/NetCoreMicroserviceDemo

- https://github.com/HoussemDellai/MicroservicesOnContainers

- https://github.com/charlessolar/TodoMVC-DDD-CQRS-EventSourcing

- https://github.com/charlessolar/eShopOnContainersDDD

- https://github.com/Azure-Samples/Serverless-microservices-reference-architecture

- https://github.com/fcatae/Arda

- https://github.com/osstotalsoft/nbb

- https://github.com/AdrienTorris/aspnet-core-simple-microservices-sample

- https://github.com/MicroservicesBuildingBlocks/BuildingBlocks

- https://github.com/brucehu123/Study.Microservices

- https://github.com/hossambarakat/EspressoShop

- https://github.com/parameshg/northwind-mesh

- https://github.com/madslundt/NetCoreMicroservicesSample

- https://github.com/asc-lab/dotnetcore-microservices-poc

- https://github.com/devmentors/DNC-DShop

- https://github.com/logcorner/LogCorner.EduSync.Speech.Command/

- https://github.com/mmacneil/ASPNETCoreDockerMicroservices

- https://github.com/aramkoukia/microservices-prototype

- https://github.com/vany0114/microservices-dotnetcore-docker-sf-k8s

- https://github.com/vany0114/chaos-injection-using-simmy

- https://github.com/mspnp/microservices-reference-implementation

- https://github.com/SteeltoeOSS/Samples/tree/master/MusicStore

- https://github.com/mohamed-abdo/vehicle-tracking-microservices

- https://github.com/gfawcett22/EnterprisePlanner

- https://github.com/daxnet/we-text

- https://github.com/PacktPublishing/.NET-Core-Microservices

- https://github.com/PacktPublishing/Building-Microservices-with-DotNET-Core

- https://github.com/snatch-dev/Convey

- https://github.com/johnph/simple-transaction

- https://github.com/cloudnative-netcore/modernstore

- https://github.com/aacostamx/Microservice-using-ASP-NET-Core

## Tools and Libraries

### Messaging
- [MassTransit](https://github.com/MassTransit/MassTransit) - Distributed Application Framework for .NET
- [NServiceBus](https://github.com/Particular/NServiceBus) - The most popular service bus for .NET
- [Rebus](https://github.com/rebus-org/Rebus) - Simple and lean service bus implementation for .NET
- [Kafka](https://github.com/confluentinc/confluent-kafka-dotnet/) - Confluent's Apache Kafka .NET client
- [RabbitMQ](https://github.com/rabbitmq/rabbitmq-dotnet-client) - RabbitMQ .NET client for .NET Standard 2.0+ and .NET 4.6.1+
- [EasyNetQ](https://github.com/EasyNetQ/EasyNetQ) - An easy to use .NET API for RabbitMQ
- [ZeroMQ](https://github.com/zeromq/netmq) - A 100% native C# implementation of ZeroMQ for .NET
- [CAP](https://github.com/dotnetcore/CAP) - Distributed transaction solution in micro-service base on eventually consistency, also an eventbus with Outbox pattern
- [Brighter](https://github.com/BrighterCommand/Brighter) - Command Dispatcher, Processor, and Distributed Task Queue
- [Silverback](https://github.com/BEagle1984/silverback) - Silverback is a simple but feature-rich message bus for .NET (supports Kafka, RabbitMQ and MQTT).

### Api Gateway
- [Ocelot](https://github.com/ThreeMammals/Ocelot) - .NET core API Gateway
- [YARP](https://github.com/microsoft/reverse-proxy) - YARP (which stands for "YARP: A Reverse Proxy") is a toolkit for developing high-performance HTTP reverse proxy applications

### Service Discovery
- [Consul.NET](https://github.com/G-Research/consuldotnet) - Consul.NET is a .NET client library for the [HashiCorp Consul](https://github.com/hashicorp/consul) HTTP API

### Frameworks
- [Microdot](https://github.com/gigya/microdot) - Microdot is an open source .NET framework that answers a lot of the needs for easily creating microservices.
- [Foundatio](https://github.com/FoundatioFx/Foundatio) - Pluggable foundation blocks for building distributed apps.

### Other
- [Dapr](https://github.com/dapr/dotnet-sdk) - Dapr SDK for .NET ([Dapr](https://github.com/dapr/dapr) is a portable, event-driven, serverless runtime for building distributed applications)
- [Project Tye](https://github.com/dotnet/tye) - Tye is a tool that makes developing, testing, and deploying microservices and distributed applications easier
- [Health Checks](https://github.com/xabaril/AspNetCore.Diagnostics.HealthChecks) - Enterprise HealthChecks for ASP.NET Core Diagnostics Package



## Contribution

Contributions are always welcome! Feel free to open an [issue](https://github.com/mjebrahimi/Awesome-Microservices-NetCore/issues/new) or create a pull request.

## License

[![CC0](https://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Mohammad Javad Ebrahimi](https://github.com/mjebrahimi/) has waived all copyright and related or neighboring rights to this work.
