// This file was generated by hid_usagepages_json2cppheader.py
// ### Do not edit this file directly! ###
//
// The file HidUsageTables.json is the official HID Usage definition file
// from the standard downloaded from https://www.usb.org/hid
//
// HID Usage Tables
// The HID Usage Tables 1.5 document defines constants (Usages) that can be
// interpreted by an application to identify the purpose and meaning of a data
// field in a HID report. Usages are also used to define the meaning of groups
// of related data items. This is accomplished by the hierarchical assignment
// of Usage information to Collections.
// The HID Usage Tables 1.5 document also includes all Usage definitions as a
// JSON file as an attachment to the PDF. The PDF serves as the 'single' source
// of truth.

#pragma once

#include <QString>
#include <QVector>

namespace mixxx {

namespace hid {

struct Usage {
    uint16_t id;
    QString name;
};

struct UsagePage {
    uint16_t id;
    QString name;
    QVector<Usage> usages;
};

const QVector<UsagePage> kHidUsagePages = {
        {0x0091,
                QStringLiteral("Arcade"),
                {
                        {0x0001, QStringLiteral("General Purpose IO Card")},
                        {0x0002, QStringLiteral("Coin Door")},
                        {0x0003, QStringLiteral("Watchdog Timer")},
                        {0x0030,
                                QStringLiteral(
                                        "General Purpose Analog Input State")},
                        {0x0031,
                                QStringLiteral(
                                        "General Purpose Digital Input State")},
                        {0x0032,
                                QStringLiteral(
                                        "General Purpose Optical Input State")},
                        {0x0033,
                                QStringLiteral("General Purpose Digital Output "
                                               "State")},
                        {0x0034, QStringLiteral("Number of Coin Doors")},
                        {0x0035, QStringLiteral("Coin Drawer Drop Count")},
                        {0x0036, QStringLiteral("Coin Drawer Start")},
                        {0x0037, QStringLiteral("Coin Drawer Service")},
                        {0x0038, QStringLiteral("Coin Drawer Tilt")},
                        {0x0039, QStringLiteral("Coin Door Test")},
                        {0x0040, QStringLiteral("Coin Door Lockout")},
                        {0x0041, QStringLiteral("Watchdog Timeout")},
                        {0x0042, QStringLiteral("Watchdog Action")},
                        {0x0043, QStringLiteral("Watchdog Reboot")},
                        {0x0044, QStringLiteral("Watchdog Restart")},
                        {0x0045, QStringLiteral("Alarm Input")},
                        {0x0046, QStringLiteral("Coin Door Counter")},
                        {0x0047, QStringLiteral("I/O Direction Mapping")},
                        {0x0048, QStringLiteral("Set I/O Direction Mapping")},
                        {0x0049,
                                QStringLiteral("Extended Optical Input State")},
                        {0x004A, QStringLiteral("Pin Pad Input State")},
                        {0x004B, QStringLiteral("Pin Pad Status")},
                        {0x004C, QStringLiteral("Pin Pad Output")},
                        {0x004D, QStringLiteral("Pin Pad Command")},
                }},
        {0x0014,
                QStringLiteral("Auxiliary Display"),
                {
                        {0x0001, QStringLiteral("Alphanumeric Display")},
                        {0x0002, QStringLiteral("Auxiliary Display")},
                        {0x0020, QStringLiteral("Display Attributes Report")},
                        {0x0021, QStringLiteral("ASCII Character Set")},
                        {0x0022, QStringLiteral("Data Read Back")},
                        {0x0023, QStringLiteral("Font Read Back")},
                        {0x0024, QStringLiteral("Display Control Report")},
                        {0x0025, QStringLiteral("Clear Display")},
                        {0x0026, QStringLiteral("Display Enable")},
                        {0x0027, QStringLiteral("Screen Saver Delay")},
                        {0x0028, QStringLiteral("Screen Saver Enable")},
                        {0x0029, QStringLiteral("Vertical Scroll")},
                        {0x002A, QStringLiteral("Horizontal Scroll")},
                        {0x002B, QStringLiteral("Character Report")},
                        {0x002C, QStringLiteral("Display Data")},
                        {0x002D, QStringLiteral("Display Status")},
                        {0x002E, QStringLiteral("Stat Not Ready")},
                        {0x002F, QStringLiteral("Stat Ready")},
                        {0x0030,
                                QStringLiteral("Err Not a loadable character")},
                        {0x0031,
                                QStringLiteral("Err Font data cannot be read")},
                        {0x0032, QStringLiteral("Cursor Position Report")},
                        {0x0033, QStringLiteral("Row")},
                        {0x0034, QStringLiteral("Column")},
                        {0x0035, QStringLiteral("Rows")},
                        {0x0036, QStringLiteral("Columns")},
                        {0x0037, QStringLiteral("Cursor Pixel Positioning")},
                        {0x0038, QStringLiteral("Cursor Mode")},
                        {0x0039, QStringLiteral("Cursor Enable")},
                        {0x003A, QStringLiteral("Cursor Blink")},
                        {0x003B, QStringLiteral("Font Report")},
                        {0x003C, QStringLiteral("Font Data")},
                        {0x003D, QStringLiteral("Character Width")},
                        {0x003E, QStringLiteral("Character Height")},
                        {0x003F,
                                QStringLiteral("Character Spacing Horizontal")},
                        {0x0040, QStringLiteral("Character Spacing Vertical")},
                        {0x0041, QStringLiteral("Unicode Character Set")},
                        {0x0042, QStringLiteral("Font 7-Segment")},
                        {0x0043, QStringLiteral("7-Segment Direct Map")},
                        {0x0044, QStringLiteral("Font 14-Segment")},
                        {0x0045, QStringLiteral("14-Segment Direct Map")},
                        {0x0046, QStringLiteral("Display Brightness")},
                        {0x0047, QStringLiteral("Display Contrast")},
                        {0x0048, QStringLiteral("Character Attribute")},
                        {0x0049, QStringLiteral("Attribute Readback")},
                        {0x004A, QStringLiteral("Attribute Data")},
                        {0x004B, QStringLiteral("Char Attr Enhance")},
                        {0x004C, QStringLiteral("Char Attr Underline")},
                        {0x004D, QStringLiteral("Char Attr Blink")},
                        {0x0080, QStringLiteral("Bitmap Size X")},
                        {0x0081, QStringLiteral("Bitmap Size Y")},
                        {0x0082, QStringLiteral("Max Blit Size")},
                        {0x0083, QStringLiteral("Bit Depth Format")},
                        {0x0084, QStringLiteral("Display Orientation")},
                        {0x0085, QStringLiteral("Palette Report")},
                        {0x0086, QStringLiteral("Palette Data Size")},
                        {0x0087, QStringLiteral("Palette Data Offset")},
                        {0x0088, QStringLiteral("Palette Data")},
                        {0x008A, QStringLiteral("Blit Report")},
                        {0x008B, QStringLiteral("Blit Rectangle X1")},
                        {0x008C, QStringLiteral("Blit Rectangle Y1")},
                        {0x008D, QStringLiteral("Blit Rectangle X2")},
                        {0x008E, QStringLiteral("Blit Rectangle Y2")},
                        {0x008F, QStringLiteral("Blit Data")},
                        {0x0090, QStringLiteral("Soft Button")},
                        {0x0091, QStringLiteral("Soft Button ID")},
                        {0x0092, QStringLiteral("Soft Button Side")},
                        {0x0093, QStringLiteral("Soft Button Offset 1")},
                        {0x0094, QStringLiteral("Soft Button Offset 2")},
                        {0x0095, QStringLiteral("Soft Button Report")},
                        {0x00C2, QStringLiteral("Soft Keys")},
                        {0x00CC, QStringLiteral("Display Data Extensions")},
                        {0x00CF, QStringLiteral("Character Mapping")},
                        {0x00DD, QStringLiteral("Unicode Equivalent")},
                        {0x00DF, QStringLiteral("Character Page Mapping")},
                        {0x00FF, QStringLiteral("Request Report")},
                }},
        {0x008C,
                QStringLiteral("Barcode Scanner"),
                {
                        {0x0001, QStringLiteral("Barcode Badge Reader")},
                        {0x0002, QStringLiteral("Barcode Scanner")},
                        {0x0003, QStringLiteral("Dumb Bar Code Scanner")},
                        {0x0004, QStringLiteral("Cordless Scanner Base")},
                        {0x0005, QStringLiteral("Bar Code Scanner Cradle")},
                        {0x0010, QStringLiteral("Attribute Report")},
                        {0x0011, QStringLiteral("Settings Report")},
                        {0x0012, QStringLiteral("Scanned Data Report")},
                        {0x0013, QStringLiteral("Raw Scanned Data Report")},
                        {0x0014, QStringLiteral("Trigger Report")},
                        {0x0015, QStringLiteral("Status Report")},
                        {0x0016, QStringLiteral("UPC/EAN Control Report")},
                        {0x0017,
                                QStringLiteral("EAN 2/3 Label Control Report")},
                        {0x0018, QStringLiteral("Code 39 Control Report")},
                        {0x0019,
                                QStringLiteral(
                                        "Interleaved 2 of 5 Control Report")},
                        {0x001A,
                                QStringLiteral(
                                        "Standard 2 of 5 Control Report")},
                        {0x001B, QStringLiteral("MSI Plessey Control Report")},
                        {0x001C, QStringLiteral("Codabar Control Report")},
                        {0x001D, QStringLiteral("Code 128 Control Report")},
                        {0x001E, QStringLiteral("Misc 1D Control Report")},
                        {0x001F, QStringLiteral("2D Control Report")},
                        {0x0030, QStringLiteral("Aiming/Pointer Mode")},
                        {0x0031, QStringLiteral("Bar Code Present Sensor")},
                        {0x0032, QStringLiteral("Class 1A Laser")},
                        {0x0033, QStringLiteral("Class 2 Laser")},
                        {0x0034, QStringLiteral("Heater Present")},
                        {0x0035, QStringLiteral("Contact Scanner")},
                        {0x0036,
                                QStringLiteral("Electronic Article "
                                               "Surveillance Notification")},
                        {0x0037,
                                QStringLiteral("Constant Electronic Article "
                                               "Surveillance")},
                        {0x0038, QStringLiteral("Error Indication")},
                        {0x0039, QStringLiteral("Fixed Beeper")},
                        {0x003A, QStringLiteral("Good Decode Indication")},
                        {0x003B, QStringLiteral("Hands Free Scanning")},
                        {0x003C, QStringLiteral("Intrinsically Safe")},
                        {0x003D, QStringLiteral("Klasse Eins Laser")},
                        {0x003E, QStringLiteral("Long Range Scanner")},
                        {0x003F, QStringLiteral("Mirror Speed Control")},
                        {0x0040, QStringLiteral("Not On File Indication")},
                        {0x0041, QStringLiteral("Programmable Beeper")},
                        {0x0042, QStringLiteral("Triggerless")},
                        {0x0043, QStringLiteral("Wand")},
                        {0x0044, QStringLiteral("Water Resistant")},
                        {0x0045, QStringLiteral("Multi-Range Scanner")},
                        {0x0046, QStringLiteral("Proximity Sensor")},
                        {0x004D, QStringLiteral("Fragment Decoding")},
                        {0x004E, QStringLiteral("Scanner Read Confidence")},
                        {0x004F, QStringLiteral("Data Prefix")},
                        {0x0050, QStringLiteral("Prefix AIMI")},
                        {0x0051, QStringLiteral("Prefix None")},
                        {0x0052, QStringLiteral("Prefix Proprietary")},
                        {0x0055, QStringLiteral("Active Time")},
                        {0x0056, QStringLiteral("Aiming Laser Pattern")},
                        {0x0057, QStringLiteral("Bar Code Present")},
                        {0x0058, QStringLiteral("Beeper State")},
                        {0x0059, QStringLiteral("Laser On Time")},
                        {0x005A, QStringLiteral("Laser State")},
                        {0x005B, QStringLiteral("Lockout Time")},
                        {0x005C, QStringLiteral("Motor State")},
                        {0x005D, QStringLiteral("Motor Timeout")},
                        {0x005E, QStringLiteral("Power On Reset Scanner")},
                        {0x005F, QStringLiteral("Prevent Read of Barcodes")},
                        {0x0060, QStringLiteral("Initiate Barcode Read")},
                        {0x0061, QStringLiteral("Trigger State")},
                        {0x0062, QStringLiteral("Trigger Mode")},
                        {0x0063,
                                QStringLiteral(
                                        "Trigger Mode Blinking Laser On")},
                        {0x0064,
                                QStringLiteral(
                                        "Trigger Mode Continuous Laser On")},
                        {0x0065,
                                QStringLiteral(
                                        "Trigger Mode Laser on while Pulled")},
                        {0x0066,
                                QStringLiteral("Trigger Mode Laser stays on "
                                               "after release")},
                        {0x006D, QStringLiteral("Commit Parameters to NVM")},
                        {0x006E, QStringLiteral("Parameter Scanning")},
                        {0x006F, QStringLiteral("Parameters Changed")},
                        {0x0070,
                                QStringLiteral("Set parameter default values")},
                        {0x0075, QStringLiteral("Scanner In Cradle")},
                        {0x0076, QStringLiteral("Scanner In Range")},
                        {0x007A, QStringLiteral("Aim Duration")},
                        {0x007B, QStringLiteral("Good Read Lamp Duration")},
                        {0x007C, QStringLiteral("Good Read Lamp Intensity")},
                        {0x007D, QStringLiteral("Good Read LED")},
                        {0x007E, QStringLiteral("Good Read Tone Frequency")},
                        {0x007F, QStringLiteral("Good Read Tone Length")},
                        {0x0080, QStringLiteral("Good Read Tone Volume")},
                        {0x0082, QStringLiteral("No Read Message")},
                        {0x0083, QStringLiteral("Not on File Volume")},
                        {0x0084, QStringLiteral("Powerup Beep")},
                        {0x0085, QStringLiteral("Sound Error Beep")},
                        {0x0086, QStringLiteral("Sound Good Read Beep")},
                        {0x0087, QStringLiteral("Sound Not On File Beep")},
                        {0x0088, QStringLiteral("Good Read When to Write")},
                        {0x0089, QStringLiteral("GRWTI After Decode")},
                        {0x008A,
                                QStringLiteral(
                                        "GRWTI Beep/Lamp after transmit")},
                        {0x008B,
                                QStringLiteral(
                                        "GRWTI No Beep/Lamp use at all")},
                        {0x0091, QStringLiteral("Bookland EAN")},
                        {0x0092, QStringLiteral("Convert EAN 8 to 13 Type")},
                        {0x0093, QStringLiteral("Convert UPC A to EAN-13")},
                        {0x0094, QStringLiteral("Convert UPC-E to A")},
                        {0x0095, QStringLiteral("EAN-13")},
                        {0x0096, QStringLiteral("EAN-8")},
                        {0x0097, QStringLiteral("EAN-99 128 Mandatory")},
                        {0x0098, QStringLiteral("EAN-99 P5/128 Optional")},
                        {0x0099, QStringLiteral("Enable EAN Two Label")},
                        {0x009A, QStringLiteral("UPC/EAN")},
                        {0x009B, QStringLiteral("UPC/EAN Coupon Code")},
                        {0x009C, QStringLiteral("UPC/EAN Periodicals")},
                        {0x009D, QStringLiteral("UPC-A")},
                        {0x009E, QStringLiteral("UPC-A with 128 Mandatory")},
                        {0x009F, QStringLiteral("UPC-A with 128 Optional")},
                        {0x00A0, QStringLiteral("UPC-A with P5 Optional")},
                        {0x00A1, QStringLiteral("UPC-E")},
                        {0x00A2, QStringLiteral("UPC-E1")},
                        {0x00A9, QStringLiteral("Periodical")},
                        {0x00AA,
                                QStringLiteral(
                                        "Periodical Auto-Discriminate +2")},
                        {0x00AB,
                                QStringLiteral(
                                        "Periodical Only Decode with +2")},
                        {0x00AC, QStringLiteral("Periodical Ignore +2")},
                        {0x00AD,
                                QStringLiteral(
                                        "Periodical Auto-Discriminate +5")},
                        {0x00AE,
                                QStringLiteral(
                                        "Periodical Only Decode with +5")},
                        {0x00AF, QStringLiteral("Periodical Ignore +5")},
                        {0x00B0, QStringLiteral("Check")},
                        {0x00B1, QStringLiteral("Check Disable Price")},
                        {0x00B2, QStringLiteral("Check Enable 4 digit Price")},
                        {0x00B3, QStringLiteral("Check Enable 5 digit Price")},
                        {0x00B4,
                                QStringLiteral(
                                        "Check Enable European 4 digit Price")},
                        {0x00B5,
                                QStringLiteral(
                                        "Check Enable European 5 digit Price")},
                        {0x00B7, QStringLiteral("EAN Two Label")},
                        {0x00B8, QStringLiteral("EAN Three Label")},
                        {0x00B9, QStringLiteral("EAN 8 Flag Digit 1")},
                        {0x00BA, QStringLiteral("EAN 8 Flag Digit 2")},
                        {0x00BB, QStringLiteral("EAN 8 Flag Digit 3")},
                        {0x00BC, QStringLiteral("EAN 13 Flag Digit 1")},
                        {0x00BD, QStringLiteral("EAN 13 Flag Digit 2")},
                        {0x00BE, QStringLiteral("EAN 13 Flag Digit 3")},
                        {0x00BF,
                                QStringLiteral("Add EAN 2/3 Label Definition")},
                        {0x00C0,
                                QStringLiteral(
                                        "Clear all EAN 2/3 Label Definitions")},
                        {0x00C3, QStringLiteral("Codabar")},
                        {0x00C4, QStringLiteral("Code 128")},
                        {0x00C7, QStringLiteral("Code 39")},
                        {0x00C8, QStringLiteral("Code 93")},
                        {0x00C9, QStringLiteral("Full ASCII Conversion")},
                        {0x00CA, QStringLiteral("Interleaved 2 of 5")},
                        {0x00CB, QStringLiteral("Italian Pharmacy Code")},
                        {0x00CC, QStringLiteral("MSI/Plessey")},
                        {0x00CD, QStringLiteral("Standard 2 of 5 IATA")},
                        {0x00CE, QStringLiteral("Standard 2 of 5")},
                        {0x00D3, QStringLiteral("Transmit Start/Stop")},
                        {0x00D4, QStringLiteral("Tri-Optic")},
                        {0x00D5, QStringLiteral("UCC/EAN-128")},
                        {0x00D6, QStringLiteral("Check Digit")},
                        {0x00D7, QStringLiteral("Check Digit Disable")},
                        {0x00D8,
                                QStringLiteral("Check Digit Enable Interleaved "
                                               "2 of 5 OPCC")},
                        {0x00D9,
                                QStringLiteral("Check Digit Enable Interleaved "
                                               "2 of 5 USS")},
                        {0x00DA,
                                QStringLiteral("Check Digit Enable Standard 2 "
                                               "of 5 OPCC")},
                        {0x00DB,
                                QStringLiteral("Check Digit Enable Standard 2 "
                                               "of 5 USS")},
                        {0x00DC,
                                QStringLiteral(
                                        "Check Digit Enable One MSI Plessey")},
                        {0x00DD,
                                QStringLiteral(
                                        "Check Digit Enable Two MSI Plessey")},
                        {0x00DE, QStringLiteral("Check Digit Codabar Enable")},
                        {0x00DF, QStringLiteral("Check Digit Code 39 Enable")},
                        {0x00F0, QStringLiteral("Transmit Check Digit")},
                        {0x00F1,
                                QStringLiteral("Disable Check Digit Transmit")},
                        {0x00F2, QStringLiteral("Enable Check Digit Transmit")},
                        {0x00FB, QStringLiteral("Symbology Identifier 1")},
                        {0x00FC, QStringLiteral("Symbology Identifier 2")},
                        {0x00FD, QStringLiteral("Symbology Identifier 3")},
                        {0x00FE, QStringLiteral("Decoded Data")},
                        {0x00FF, QStringLiteral("Decode Data Continued")},
                        {0x0100, QStringLiteral("Bar Space Data")},
                        {0x0101, QStringLiteral("Scanner Data Accuracy")},
                        {0x0102, QStringLiteral("Raw Data Polarity")},
                        {0x0103, QStringLiteral("Polarity Inverted Bar Code")},
                        {0x0104, QStringLiteral("Polarity Normal Bar Code")},
                        {0x0106, QStringLiteral("Minimum Length to Decode")},
                        {0x0107, QStringLiteral("Maximum Length to Decode")},
                        {0x0108, QStringLiteral("Discrete Length to Decode 1")},
                        {0x0109, QStringLiteral("Discrete Length to Decode 2")},
                        {0x010A, QStringLiteral("Data Length Method")},
                        {0x010B, QStringLiteral("DL Method Read any")},
                        {0x010C, QStringLiteral("DL Method Check in Range")},
                        {0x010D,
                                QStringLiteral("DL Method Check for Discrete")},
                        {0x0110, QStringLiteral("Aztec Code")},
                        {0x0111, QStringLiteral("BC412")},
                        {0x0112, QStringLiteral("Channel Code")},
                        {0x0113, QStringLiteral("Code 16")},
                        {0x0114, QStringLiteral("Code 32")},
                        {0x0115, QStringLiteral("Code 49")},
                        {0x0116, QStringLiteral("Code One")},
                        {0x0117, QStringLiteral("Colorcode")},
                        {0x0118, QStringLiteral("Data Matrix")},
                        {0x0119, QStringLiteral("MaxiCode")},
                        {0x011A, QStringLiteral("MicroPDF")},
                        {0x011B, QStringLiteral("PDF-417")},
                        {0x011C, QStringLiteral("PosiCode")},
                        {0x011D, QStringLiteral("QR Code")},
                        {0x011E, QStringLiteral("SuperCode")},
                        {0x011F, QStringLiteral("UltraCode")},
                        {0x0120, QStringLiteral("USD-5 (Slug Code)")},
                        {0x0121, QStringLiteral("VeriCode")},
                }},
        {0x0085,
                QStringLiteral("Battery System"),
                {
                        {0x0001, QStringLiteral("Smart Battery Battery Mode")},
                        {0x0002,
                                QStringLiteral("Smart Battery Battery Status")},
                        {0x0003, QStringLiteral("Smart Battery Alarm Warning")},
                        {0x0004, QStringLiteral("Smart Battery Charger Mode")},
                        {0x0005,
                                QStringLiteral("Smart Battery Charger Status")},
                        {0x0006,
                                QStringLiteral(
                                        "Smart Battery Charger Spec Info")},
                        {0x0007,
                                QStringLiteral("Smart Battery Selector State")},
                        {0x0008,
                                QStringLiteral(
                                        "Smart Battery Selector Presets")},
                        {0x0009, QStringLiteral("Smart Battery Selector Info")},
                        {0x0010, QStringLiteral("Optional Mfg Function 1")},
                        {0x0011, QStringLiteral("Optional Mfg Function 2")},
                        {0x0012, QStringLiteral("Optional Mfg Function 3")},
                        {0x0013, QStringLiteral("Optional Mfg Function 4")},
                        {0x0014, QStringLiteral("Optional Mfg Function 5")},
                        {0x0015, QStringLiteral("Connection To SM Bus")},
                        {0x0016, QStringLiteral("Output Connection")},
                        {0x0017, QStringLiteral("Charger Connection")},
                        {0x0018, QStringLiteral("Battery Insertion")},
                        {0x0019, QStringLiteral("Use Next")},
                        {0x001A, QStringLiteral("OK To Use")},
                        {0x001B, QStringLiteral("Battery Supported")},
                        {0x001C, QStringLiteral("Selector Revision")},
                        {0x001D, QStringLiteral("Charging Indicator")},
                        {0x0028, QStringLiteral("Manufacturer Access")},
                        {0x0029, QStringLiteral("Remaining Capacity Limit")},
                        {0x002A, QStringLiteral("Remaining Time Limit")},
                        {0x002B, QStringLiteral("At Rate")},
                        {0x002C, QStringLiteral("Capacity Mode")},
                        {0x002D, QStringLiteral("Broadcast To Charger")},
                        {0x002E, QStringLiteral("Primary Battery")},
                        {0x002F, QStringLiteral("Charge Controller")},
                        {0x0040, QStringLiteral("Terminate Charge")},
                        {0x0041, QStringLiteral("Terminate Discharge")},
                        {0x0042,
                                QStringLiteral(
                                        "Below Remaining Capacity Limit")},
                        {0x0043,
                                QStringLiteral("Remaining Time Limit Expired")},
                        {0x0044, QStringLiteral("Charging")},
                        {0x0045, QStringLiteral("Discharging")},
                        {0x0046, QStringLiteral("Fully Charged")},
                        {0x0047, QStringLiteral("Fully Discharged")},
                        {0x0048, QStringLiteral("Conditioning Flag")},
                        {0x0049, QStringLiteral("At Rate OK")},
                        {0x004A, QStringLiteral("Smart Battery Error Code")},
                        {0x004B, QStringLiteral("Need Replacement")},
                        {0x0060, QStringLiteral("At Rate Time To Full")},
                        {0x0061, QStringLiteral("At Rate Time To Empty")},
                        {0x0062, QStringLiteral("Average Current")},
                        {0x0063, QStringLiteral("Max Error")},
                        {0x0064, QStringLiteral("Relative State Of Charge")},
                        {0x0065, QStringLiteral("Absolute State Of Charge")},
                        {0x0066, QStringLiteral("Remaining Capacity")},
                        {0x0067, QStringLiteral("Full Charge Capacity")},
                        {0x0068, QStringLiteral("Run Time To Empty")},
                        {0x0069, QStringLiteral("Average Time To Empty")},
                        {0x006A, QStringLiteral("Average Time To Full")},
                        {0x006B, QStringLiteral("Cycle Count")},
                        {0x0080, QStringLiteral("Battery Pack Model Level")},
                        {0x0081, QStringLiteral("Internal Charge Controller")},
                        {0x0082, QStringLiteral("Primary Battery Support")},
                        {0x0083, QStringLiteral("Design Capacity")},
                        {0x0084, QStringLiteral("Specification Info")},
                        {0x0085, QStringLiteral("Manufacture Date")},
                        {0x0086, QStringLiteral("Serial Number")},
                        {0x0087, QStringLiteral("iManufacturer Name")},
                        {0x0088, QStringLiteral("iDevice Name")},
                        {0x0089, QStringLiteral("iDevice Chemistry")},
                        {0x008A, QStringLiteral("Manufacturer Data")},
                        {0x008B, QStringLiteral("Rechargeable")},
                        {0x008C, QStringLiteral("Warning Capacity Limit")},
                        {0x008D, QStringLiteral("Capacity Granularity 1")},
                        {0x008E, QStringLiteral("Capacity Granularity 2")},
                        {0x008F, QStringLiteral("iOEM Information")},
                        {0x00C0, QStringLiteral("Inhibit Charge")},
                        {0x00C1, QStringLiteral("Enable Polling")},
                        {0x00C2, QStringLiteral("Reset To Zero")},
                        {0x00D0, QStringLiteral("AC Present")},
                        {0x00D1, QStringLiteral("Battery Present")},
                        {0x00D2, QStringLiteral("Power Fail")},
                        {0x00D3, QStringLiteral("Alarm Inhibited")},
                        {0x00D4, QStringLiteral("Thermistor Under Range")},
                        {0x00D5, QStringLiteral("Thermistor Hot")},
                        {0x00D6, QStringLiteral("Thermistor Cold")},
                        {0x00D7, QStringLiteral("Thermistor Over Range")},
                        {0x00D8, QStringLiteral("Voltage Out Of Range")},
                        {0x00D9, QStringLiteral("Current Out Of Range")},
                        {0x00DA, QStringLiteral("Current Not Regulated")},
                        {0x00DB, QStringLiteral("Voltage Not Regulated")},
                        {0x00DC, QStringLiteral("Master Mode")},
                        {0x00F0, QStringLiteral("Charger Selector Support")},
                        {0x00F1, QStringLiteral("Charger Spec")},
                        {0x00F2, QStringLiteral("Level 2")},
                        {0x00F3, QStringLiteral("Level 3")},
                }},
        {0x0041,
                QStringLiteral("Braille Display"),
                {
                        {0x0001, QStringLiteral("Braille Display")},
                        {0x0002, QStringLiteral("Braille Row")},
                        {0x0003, QStringLiteral("8 Dot Braille Cell")},
                        {0x0004, QStringLiteral("6 Dot Braille Cell")},
                        {0x0005, QStringLiteral("Number of Braille Cells")},
                        {0x0006, QStringLiteral("Screen Reader Control")},
                        {0x0007, QStringLiteral("Screen Reader Identifier")},
                        {0x00FA, QStringLiteral("Router Set 1")},
                        {0x00FB, QStringLiteral("Router Set 2")},
                        {0x00FC, QStringLiteral("Router Set 3")},
                        {0x0100, QStringLiteral("Router Key")},
                        {0x0101, QStringLiteral("Row Router Key")},
                        {0x0200, QStringLiteral("Braille Buttons")},
                        {0x0201, QStringLiteral("Braille Keyboard Dot 1")},
                        {0x0202, QStringLiteral("Braille Keyboard Dot 2")},
                        {0x0203, QStringLiteral("Braille Keyboard Dot 3")},
                        {0x0204, QStringLiteral("Braille Keyboard Dot 4")},
                        {0x0205, QStringLiteral("Braille Keyboard Dot 5")},
                        {0x0206, QStringLiteral("Braille Keyboard Dot 6")},
                        {0x0207, QStringLiteral("Braille Keyboard Dot 7")},
                        {0x0208, QStringLiteral("Braille Keyboard Dot 8")},
                        {0x0209, QStringLiteral("Braille Keyboard Space")},
                        {0x020A, QStringLiteral("Braille Keyboard Left Space")},
                        {0x020B,
                                QStringLiteral("Braille Keyboard Right Space")},
                        {0x020C, QStringLiteral("Braille Face Controls")},
                        {0x020D, QStringLiteral("Braille Left Controls")},
                        {0x020E, QStringLiteral("Braille Right Controls")},
                        {0x020F, QStringLiteral("Braille Top Controls")},
                        {0x0210, QStringLiteral("Braille Joystick Center")},
                        {0x0211, QStringLiteral("Braille Joystick Up")},
                        {0x0212, QStringLiteral("Braille Joystick Down")},
                        {0x0213, QStringLiteral("Braille Joystick Left")},
                        {0x0214, QStringLiteral("Braille Joystick Right")},
                        {0x0215, QStringLiteral("Braille D-Pad Center")},
                        {0x0216, QStringLiteral("Braille D-Pad Up")},
                        {0x0217, QStringLiteral("Braille D-Pad Down")},
                        {0x0218, QStringLiteral("Braille D-Pad Left")},
                        {0x0219, QStringLiteral("Braille D-Pad Right")},
                        {0x021A, QStringLiteral("Braille Pan Left")},
                        {0x021B, QStringLiteral("Braille Pan Right")},
                        {0x021C, QStringLiteral("Braille Rocker Up")},
                        {0x021D, QStringLiteral("Braille Rocker Down")},
                        {0x021E, QStringLiteral("Braille Rocker Press")},
                }},
        {0x0009, QStringLiteral("Button"), {}},
        {0x0090,
                QStringLiteral("Camera Control"),
                {
                        {0x0020, QStringLiteral("Camera Auto-focus")},
                        {0x0021, QStringLiteral("Camera Shutter")},
                }},
        {0x000C,
                QStringLiteral("Consumer"),
                {
                        {0x0001, QStringLiteral("Consumer Control")},
                        {0x0002, QStringLiteral("Numeric Key Pad")},
                        {0x0003, QStringLiteral("Programmable Buttons")},
                        {0x0004, QStringLiteral("Microphone")},
                        {0x0005, QStringLiteral("Headphone")},
                        {0x0006, QStringLiteral("Graphic Equalizer")},
                        {0x0020, QStringLiteral("+10")},
                        {0x0021, QStringLiteral("+100")},
                        {0x0022, QStringLiteral("AM/PM")},
                        {0x0030, QStringLiteral("Power")},
                        {0x0031, QStringLiteral("Reset")},
                        {0x0032, QStringLiteral("Sleep")},
                        {0x0033, QStringLiteral("Sleep After")},
                        {0x0034, QStringLiteral("Sleep Mode")},
                        {0x0035, QStringLiteral("Illumination")},
                        {0x0036, QStringLiteral("Function Buttons")},
                        {0x0040, QStringLiteral("Menu")},
                        {0x0041, QStringLiteral("Menu Pick")},
                        {0x0042, QStringLiteral("Menu Up")},
                        {0x0043, QStringLiteral("Menu Down")},
                        {0x0044, QStringLiteral("Menu Left")},
                        {0x0045, QStringLiteral("Menu Right")},
                        {0x0046, QStringLiteral("Menu Escape")},
                        {0x0047, QStringLiteral("Menu Value Increase")},
                        {0x0048, QStringLiteral("Menu Value Decrease")},
                        {0x0060, QStringLiteral("Data On Screen")},
                        {0x0061, QStringLiteral("Closed Caption")},
                        {0x0062, QStringLiteral("Closed Caption Select")},
                        {0x0063, QStringLiteral("VCR/TV")},
                        {0x0064, QStringLiteral("Broadcast Mode")},
                        {0x0065, QStringLiteral("Snapshot")},
                        {0x0066, QStringLiteral("Still")},
                        {0x0067, QStringLiteral("Picture-in-Picture Toggle")},
                        {0x0068, QStringLiteral("Picture-in-Picture Swap")},
                        {0x0069, QStringLiteral("Red Menu Button")},
                        {0x006A, QStringLiteral("Green Menu Button")},
                        {0x006B, QStringLiteral("Blue Menu Button")},
                        {0x006C, QStringLiteral("Yellow Menu Button")},
                        {0x006D, QStringLiteral("Aspect")},
                        {0x006E, QStringLiteral("3D Mode Select")},
                        {0x006F,
                                QStringLiteral("Display Brightness Increment")},
                        {0x0070,
                                QStringLiteral("Display Brightness Decrement")},
                        {0x0071, QStringLiteral("Display Brightness")},
                        {0x0072, QStringLiteral("Display Backlight Toggle")},
                        {0x0073,
                                QStringLiteral(
                                        "Display Set Brightness to Minimum")},
                        {0x0074,
                                QStringLiteral(
                                        "Display Set Brightness to Maximum")},
                        {0x0075, QStringLiteral("Display Set Auto Brightness")},
                        {0x0076, QStringLiteral("Camera Access Enabled")},
                        {0x0077, QStringLiteral("Camera Access Disabled")},
                        {0x0078, QStringLiteral("Camera Access Toggle")},
                        {0x0079,
                                QStringLiteral(
                                        "Keyboard Brightness Increment")},
                        {0x007A,
                                QStringLiteral(
                                        "Keyboard Brightness Decrement")},
                        {0x007B,
                                QStringLiteral("Keyboard Backlight Set Level")},
                        {0x007C, QStringLiteral("Keyboard Backlight OOC")},
                        {0x007D,
                                QStringLiteral(
                                        "Keyboard Backlight Set Minimum")},
                        {0x007E,
                                QStringLiteral(
                                        "Keyboard Backlight Set Maximum")},
                        {0x007F, QStringLiteral("Keyboard Backlight Auto")},
                        {0x0080, QStringLiteral("Selection")},
                        {0x0081, QStringLiteral("Assign Selection")},
                        {0x0082, QStringLiteral("Mode Step")},
                        {0x0083, QStringLiteral("Recall Last")},
                        {0x0084, QStringLiteral("Enter Channel")},
                        {0x0085, QStringLiteral("Order Movie")},
                        {0x0086, QStringLiteral("Channel")},
                        {0x0087, QStringLiteral("Media Selection")},
                        {0x0088, QStringLiteral("Media Select Computer")},
                        {0x0089, QStringLiteral("Media Select TV")},
                        {0x008A, QStringLiteral("Media Select WWW")},
                        {0x008B, QStringLiteral("Media Select DVD")},
                        {0x008C, QStringLiteral("Media Select Telephone")},
                        {0x008D, QStringLiteral("Media Select Program Guide")},
                        {0x008E, QStringLiteral("Media Select Video Phone")},
                        {0x008F, QStringLiteral("Media Select Games")},
                        {0x0090, QStringLiteral("Media Select Messages")},
                        {0x0091, QStringLiteral("Media Select CD")},
                        {0x0092, QStringLiteral("Media Select VCR")},
                        {0x0093, QStringLiteral("Media Select Tuner")},
                        {0x0094, QStringLiteral("Quit")},
                        {0x0095, QStringLiteral("Help")},
                        {0x0096, QStringLiteral("Media Select Tape")},
                        {0x0097, QStringLiteral("Media Select Cable")},
                        {0x0098, QStringLiteral("Media Select Satellite")},
                        {0x0099, QStringLiteral("Media Select Security")},
                        {0x009A, QStringLiteral("Media Select Home")},
                        {0x009B, QStringLiteral("Media Select Call")},
                        {0x009C, QStringLiteral("Channel Increment")},
                        {0x009D, QStringLiteral("Channel Decrement")},
                        {0x009E, QStringLiteral("Media Select SAP")},
                        {0x00A0, QStringLiteral("VCR Plus")},
                        {0x00A1, QStringLiteral("Once")},
                        {0x00A2, QStringLiteral("Daily")},
                        {0x00A3, QStringLiteral("Weekly")},
                        {0x00A4, QStringLiteral("Monthly")},
                        {0x00B0, QStringLiteral("Play")},
                        {0x00B1, QStringLiteral("Pause")},
                        {0x00B2, QStringLiteral("Record")},
                        {0x00B3, QStringLiteral("Fast Forward")},
                        {0x00B4, QStringLiteral("Rewind")},
                        {0x00B5, QStringLiteral("Scan Next Track")},
                        {0x00B6, QStringLiteral("Scan Previous Track")},
                        {0x00B7, QStringLiteral("Stop")},
                        {0x00B8, QStringLiteral("Eject")},
                        {0x00B9, QStringLiteral("Random Play")},
                        {0x00BA, QStringLiteral("Select Disc")},
                        {0x00BB, QStringLiteral("Enter Disc")},
                        {0x00BC, QStringLiteral("Repeat")},
                        {0x00BD, QStringLiteral("Tracking")},
                        {0x00BE, QStringLiteral("Track Normal")},
                        {0x00BF, QStringLiteral("Slow Tracking")},
                        {0x00C0, QStringLiteral("Frame Forward")},
                        {0x00C1, QStringLiteral("Frame Back")},
                        {0x00C2, QStringLiteral("Mark")},
                        {0x00C3, QStringLiteral("Clear Mark")},
                        {0x00C4, QStringLiteral("Repeat From Mark")},
                        {0x00C5, QStringLiteral("Return To Mark")},
                        {0x00C6, QStringLiteral("Search Mark Forward")},
                        {0x00C7, QStringLiteral("Search Mark Backwards")},
                        {0x00C8, QStringLiteral("Counter Reset")},
                        {0x00C9, QStringLiteral("Show Counter")},
                        {0x00CA, QStringLiteral("Tracking Increment")},
                        {0x00CB, QStringLiteral("Tracking Decrement")},
                        {0x00CC, QStringLiteral("Stop/Eject")},
                        {0x00CD, QStringLiteral("Play/Pause")},
                        {0x00CE, QStringLiteral("Play/Skip")},
                        {0x00CF, QStringLiteral("Voice Command")},
                        {0x00D0, QStringLiteral("Invoke Capture Interface")},
                        {0x00D1,
                                QStringLiteral("Start or Stop Game Recording")},
                        {0x00D2, QStringLiteral("Historical Game Capture")},
                        {0x00D3, QStringLiteral("Capture Game Screenshot")},
                        {0x00D4,
                                QStringLiteral(
                                        "Show or Hide Recording Indicator")},
                        {0x00D5,
                                QStringLiteral(
                                        "Start or Stop Microphone Capture")},
                        {0x00D6,
                                QStringLiteral("Start or Stop Camera Capture")},
                        {0x00D7,
                                QStringLiteral("Start or Stop Game Broadcast")},
                        {0x00D8,
                                QStringLiteral("Start or Stop Voice Dictation "
                                               "Session")},
                        {0x00D9, QStringLiteral("Invoke/Dismiss Emoji Picker")},
                        {0x00E0, QStringLiteral("Volume")},
                        {0x00E1, QStringLiteral("Balance")},
                        {0x00E2, QStringLiteral("Mute")},
                        {0x00E3, QStringLiteral("Bass")},
                        {0x00E4, QStringLiteral("Treble")},
                        {0x00E5, QStringLiteral("Bass Boost")},
                        {0x00E6, QStringLiteral("Surround Mode")},
                        {0x00E7, QStringLiteral("Loudness")},
                        {0x00E8, QStringLiteral("MPX")},
                        {0x00E9, QStringLiteral("Volume Increment")},
                        {0x00EA, QStringLiteral("Volume Decrement")},
                        {0x00F0, QStringLiteral("Speed Select")},
                        {0x00F1, QStringLiteral("Playback Speed")},
                        {0x00F2, QStringLiteral("Standard Play")},
                        {0x00F3, QStringLiteral("Long Play")},
                        {0x00F4, QStringLiteral("Extended Play")},
                        {0x00F5, QStringLiteral("Slow")},
                        {0x0100, QStringLiteral("Fan Enable")},
                        {0x0101, QStringLiteral("Fan Speed")},
                        {0x0102, QStringLiteral("Light Enable")},
                        {0x0103, QStringLiteral("Light Illumination Level")},
                        {0x0104, QStringLiteral("Climate Control Enable")},
                        {0x0105, QStringLiteral("Room Temperature")},
                        {0x0106, QStringLiteral("Security Enable")},
                        {0x0107, QStringLiteral("Fire Alarm")},
                        {0x0108, QStringLiteral("Police Alarm")},
                        {0x0109, QStringLiteral("Proximity")},
                        {0x010A, QStringLiteral("Motion")},
                        {0x010B, QStringLiteral("Duress Alarm")},
                        {0x010C, QStringLiteral("Holdup Alarm")},
                        {0x010D, QStringLiteral("Medical Alarm")},
                        {0x0150, QStringLiteral("Balance Right")},
                        {0x0151, QStringLiteral("Balance Left")},
                        {0x0152, QStringLiteral("Bass Increment")},
                        {0x0153, QStringLiteral("Bass Decrement")},
                        {0x0154, QStringLiteral("Treble Increment")},
                        {0x0155, QStringLiteral("Treble Decrement")},
                        {0x0160, QStringLiteral("Speaker System")},
                        {0x0161, QStringLiteral("Channel Left")},
                        {0x0162, QStringLiteral("Channel Right")},
                        {0x0163, QStringLiteral("Channel Center")},
                        {0x0164, QStringLiteral("Channel Front")},
                        {0x0165, QStringLiteral("Channel Center Front")},
                        {0x0166, QStringLiteral("Channel Side")},
                        {0x0167, QStringLiteral("Channel Surround")},
                        {0x0168,
                                QStringLiteral(
                                        "Channel Low Frequency Enhancement")},
                        {0x0169, QStringLiteral("Channel Top")},
                        {0x016A, QStringLiteral("Channel Unknown")},
                        {0x0170, QStringLiteral("Sub-channel")},
                        {0x0171, QStringLiteral("Sub-channel Increment")},
                        {0x0172, QStringLiteral("Sub-channel Decrement")},
                        {0x0173, QStringLiteral("Alternate Audio Increment")},
                        {0x0174, QStringLiteral("Alternate Audio Decrement")},
                        {0x0180, QStringLiteral("Application Launch Buttons")},
                        {0x0181,
                                QStringLiteral(
                                        "AL Launch Button Configuration Tool")},
                        {0x0182,
                                QStringLiteral("AL Programmable Button "
                                               "Configuration")},
                        {0x0183,
                                QStringLiteral(
                                        "AL Consumer Control Configuration")},
                        {0x0184, QStringLiteral("AL Word Processor")},
                        {0x0185, QStringLiteral("AL Text Editor")},
                        {0x0186, QStringLiteral("AL Spreadsheet")},
                        {0x0187, QStringLiteral("AL Graphics Editor")},
                        {0x0188, QStringLiteral("AL Presentation App")},
                        {0x0189, QStringLiteral("AL Database App")},
                        {0x018A, QStringLiteral("AL Email Reader")},
                        {0x018B, QStringLiteral("AL Newsreader")},
                        {0x018C, QStringLiteral("AL Voicemail")},
                        {0x018D, QStringLiteral("AL Contacts/Address Book")},
                        {0x018E, QStringLiteral("AL Calendar/Schedule")},
                        {0x018F, QStringLiteral("AL Task/Project Manager")},
                        {0x0190, QStringLiteral("AL Log/Journal/Timecard")},
                        {0x0191, QStringLiteral("AL Checkbook/Finance")},
                        {0x0192, QStringLiteral("AL Calculator")},
                        {0x0193, QStringLiteral("AL A/V Capture/Playback")},
                        {0x0194, QStringLiteral("AL Local Machine Browser")},
                        {0x0195, QStringLiteral("AL LAN/WAN Browser")},
                        {0x0196, QStringLiteral("AL Internet Browser")},
                        {0x0197,
                                QStringLiteral(
                                        "AL Remote Networking/ISP Connect")},
                        {0x0198, QStringLiteral("AL Network Conference")},
                        {0x0199, QStringLiteral("AL Network Chat")},
                        {0x019A, QStringLiteral("AL Telephony/Dialer")},
                        {0x019B, QStringLiteral("AL Logon")},
                        {0x019C, QStringLiteral("AL Logoff")},
                        {0x019D, QStringLiteral("AL Logon/Logoff")},
                        {0x019E,
                                QStringLiteral("AL Terminal Lock/Screensaver")},
                        {0x019F, QStringLiteral("AL Control Panel")},
                        {0x01A0,
                                QStringLiteral(
                                        "AL Command Line Processor/Run")},
                        {0x01A1, QStringLiteral("AL Process/Task Manager")},
                        {0x01A2, QStringLiteral("AL Select Task/Application")},
                        {0x01A3, QStringLiteral("AL Next Task/Application")},
                        {0x01A4,
                                QStringLiteral("AL Previous Task/Application")},
                        {0x01A5,
                                QStringLiteral(
                                        "AL Preemptive Halt Task/Application")},
                        {0x01A6, QStringLiteral("AL Integrated Help Center")},
                        {0x01A7, QStringLiteral("AL Documents")},
                        {0x01A8, QStringLiteral("AL Thesaurus")},
                        {0x01A9, QStringLiteral("AL Dictionary")},
                        {0x01AA, QStringLiteral("AL Desktop")},
                        {0x01AB, QStringLiteral("AL Spell Check")},
                        {0x01AC, QStringLiteral("AL Grammar Check")},
                        {0x01AD, QStringLiteral("AL Wireless Status")},
                        {0x01AE, QStringLiteral("AL Keyboard Layout")},
                        {0x01AF, QStringLiteral("AL Virus Protection")},
                        {0x01B0, QStringLiteral("AL Encryption")},
                        {0x01B1, QStringLiteral("AL Screen Saver")},
                        {0x01B2, QStringLiteral("AL Alarms")},
                        {0x01B3, QStringLiteral("AL Clock")},
                        {0x01B4, QStringLiteral("AL File Browser")},
                        {0x01B5, QStringLiteral("AL Power Status")},
                        {0x01B6, QStringLiteral("AL Image Browser")},
                        {0x01B7, QStringLiteral("AL Audio Browser")},
                        {0x01B8, QStringLiteral("AL Movie Browser")},
                        {0x01B9, QStringLiteral("AL Digital Rights Manager")},
                        {0x01BA, QStringLiteral("AL Digital Wallet")},
                        {0x01BC, QStringLiteral("AL Instant Messaging")},
                        {0x01BD,
                                QStringLiteral("AL OEM Features/ Tips/Tutorial "
                                               "Browser")},
                        {0x01BE, QStringLiteral("AL OEM Help")},
                        {0x01BF, QStringLiteral("AL Online Community")},
                        {0x01C0,
                                QStringLiteral(
                                        "AL Entertainment Content Browser")},
                        {0x01C1, QStringLiteral("AL Online Shopping Browser")},
                        {0x01C2,
                                QStringLiteral(
                                        "AL SmartCard Information/Help")},
                        {0x01C3,
                                QStringLiteral(
                                        "AL Market Monitor/Finance Browser")},
                        {0x01C4,
                                QStringLiteral("AL Customized Corporate News "
                                               "Browser")},
                        {0x01C5, QStringLiteral("AL Online Activity Browser")},
                        {0x01C6, QStringLiteral("AL Research/Search Browser")},
                        {0x01C7, QStringLiteral("AL Audio Player")},
                        {0x01C8, QStringLiteral("AL Message Status")},
                        {0x01C9, QStringLiteral("AL Contact Sync")},
                        {0x01CA, QStringLiteral("AL Navigation")},
                        {0x01CB,
                                QStringLiteral("AL Context\u2010aware Desktop "
                                               "Assistant")},
                        {0x0200,
                                QStringLiteral(
                                        "Generic GUI Application Controls")},
                        {0x0201, QStringLiteral("AC New")},
                        {0x0202, QStringLiteral("AC Open")},
                        {0x0203, QStringLiteral("AC Close")},
                        {0x0204, QStringLiteral("AC Exit")},
                        {0x0205, QStringLiteral("AC Maximize")},
                        {0x0206, QStringLiteral("AC Minimize")},
                        {0x0207, QStringLiteral("AC Save")},
                        {0x0208, QStringLiteral("AC Print")},
                        {0x0209, QStringLiteral("AC Properties")},
                        {0x021A, QStringLiteral("AC Undo")},
                        {0x021B, QStringLiteral("AC Copy")},
                        {0x021C, QStringLiteral("AC Cut")},
                        {0x021D, QStringLiteral("AC Paste")},
                        {0x021E, QStringLiteral("AC Select All")},
                        {0x021F, QStringLiteral("AC Find")},
                        {0x0220, QStringLiteral("AC Find and Replace")},
                        {0x0221, QStringLiteral("AC Search")},
                        {0x0222, QStringLiteral("AC Go To")},
                        {0x0223, QStringLiteral("AC Home")},
                        {0x0224, QStringLiteral("AC Back")},
                        {0x0225, QStringLiteral("AC Forward")},
                        {0x0226, QStringLiteral("AC Stop")},
                        {0x0227, QStringLiteral("AC Refresh")},
                        {0x0228, QStringLiteral("AC Previous Link")},
                        {0x0229, QStringLiteral("AC Next Link")},
                        {0x022A, QStringLiteral("AC Bookmarks")},
                        {0x022B, QStringLiteral("AC History")},
                        {0x022C, QStringLiteral("AC Subscriptions")},
                        {0x022D, QStringLiteral("AC Zoom In")},
                        {0x022E, QStringLiteral("AC Zoom Out")},
                        {0x022F, QStringLiteral("AC Zoom")},
                        {0x0230, QStringLiteral("AC Full Screen View")},
                        {0x0231, QStringLiteral("AC Normal View")},
                        {0x0232, QStringLiteral("AC View Toggle")},
                        {0x0233, QStringLiteral("AC Scroll Up")},
                        {0x0234, QStringLiteral("AC Scroll Down")},
                        {0x0235, QStringLiteral("AC Scroll")},
                        {0x0236, QStringLiteral("AC Pan Left")},
                        {0x0237, QStringLiteral("AC Pan Right")},
                        {0x0238, QStringLiteral("AC Pan")},
                        {0x0239, QStringLiteral("AC New Window")},
                        {0x023A, QStringLiteral("AC Tile Horizontally")},
                        {0x023B, QStringLiteral("AC Tile Vertically")},
                        {0x023C, QStringLiteral("AC Format")},
                        {0x023D, QStringLiteral("AC Edit")},
                        {0x023E, QStringLiteral("AC Bold")},
                        {0x023F, QStringLiteral("AC Italics")},
                        {0x0240, QStringLiteral("AC Underline")},
                        {0x0241, QStringLiteral("AC Strikethrough")},
                        {0x0242, QStringLiteral("AC Subscript")},
                        {0x0243, QStringLiteral("AC Superscript")},
                        {0x0244, QStringLiteral("AC All Caps")},
                        {0x0245, QStringLiteral("AC Rotate")},
                        {0x0246, QStringLiteral("AC Resize")},
                        {0x0247, QStringLiteral("AC Flip Horizontal")},
                        {0x0248, QStringLiteral("AC Flip Vertical")},
                        {0x0249, QStringLiteral("AC Mirror Horizontal")},
                        {0x024A, QStringLiteral("AC Mirror Vertical")},
                        {0x024B, QStringLiteral("AC Font Select")},
                        {0x024C, QStringLiteral("AC Font Color")},
                        {0x024D, QStringLiteral("AC Font Size")},
                        {0x024E, QStringLiteral("AC Justify Left")},
                        {0x024F, QStringLiteral("AC Justify Center H")},
                        {0x0250, QStringLiteral("AC Justify Right")},
                        {0x0251, QStringLiteral("AC Justify Block H")},
                        {0x0252, QStringLiteral("AC Justify Top")},
                        {0x0253, QStringLiteral("AC Justify Center V")},
                        {0x0254, QStringLiteral("AC Justify Bottom")},
                        {0x0255, QStringLiteral("AC Justify Block V")},
                        {0x0256, QStringLiteral("AC Indent Decrease")},
                        {0x0257, QStringLiteral("AC Indent Increase")},
                        {0x0258, QStringLiteral("AC Numbered List")},
                        {0x0259, QStringLiteral("AC Restart Numbering")},
                        {0x025A, QStringLiteral("AC Bulleted List")},
                        {0x025B, QStringLiteral("AC Promote")},
                        {0x025C, QStringLiteral("AC Demote")},
                        {0x025D, QStringLiteral("AC Yes")},
                        {0x025E, QStringLiteral("AC No")},
                        {0x025F, QStringLiteral("AC Cancel")},
                        {0x0260, QStringLiteral("AC Catalog")},
                        {0x0261, QStringLiteral("AC Buy/Checkout")},
                        {0x0262, QStringLiteral("AC Add to Cart")},
                        {0x0263, QStringLiteral("AC Expand")},
                        {0x0264, QStringLiteral("AC Expand All")},
                        {0x0265, QStringLiteral("AC Collapse")},
                        {0x0266, QStringLiteral("AC Collapse All")},
                        {0x0267, QStringLiteral("AC Print Preview")},
                        {0x0268, QStringLiteral("AC Paste Special")},
                        {0x0269, QStringLiteral("AC Insert Mode")},
                        {0x026A, QStringLiteral("AC Delete")},
                        {0x026B, QStringLiteral("AC Lock")},
                        {0x026C, QStringLiteral("AC Unlock")},
                        {0x026D, QStringLiteral("AC Protect")},
                        {0x026E, QStringLiteral("AC Unprotect")},
                        {0x026F, QStringLiteral("AC Attach Comment")},
                        {0x0270, QStringLiteral("AC Delete Comment")},
                        {0x0271, QStringLiteral("AC View Comment")},
                        {0x0272, QStringLiteral("AC Select Word")},
                        {0x0273, QStringLiteral("AC Select Sentence")},
                        {0x0274, QStringLiteral("AC Select Paragraph")},
                        {0x0275, QStringLiteral("AC Select Column")},
                        {0x0276, QStringLiteral("AC Select Row")},
                        {0x0277, QStringLiteral("AC Select Table")},
                        {0x0278, QStringLiteral("AC Select Object")},
                        {0x0279, QStringLiteral("AC Redo/Repeat")},
                        {0x027A, QStringLiteral("AC Sort")},
                        {0x027B, QStringLiteral("AC Sort Ascending")},
                        {0x027C, QStringLiteral("AC Sort Descending")},
                        {0x027D, QStringLiteral("AC Filter")},
                        {0x027E, QStringLiteral("AC Set Clock")},
                        {0x027F, QStringLiteral("AC View Clock")},
                        {0x0280, QStringLiteral("AC Select Time Zone")},
                        {0x0281, QStringLiteral("AC Edit Time Zones")},
                        {0x0282, QStringLiteral("AC Set Alarm")},
                        {0x0283, QStringLiteral("AC Clear Alarm")},
                        {0x0284, QStringLiteral("AC Snooze Alarm")},
                        {0x0285, QStringLiteral("AC Reset Alarm")},
                        {0x0286, QStringLiteral("AC Synchronize")},
                        {0x0287, QStringLiteral("AC Send/Receive")},
                        {0x0288, QStringLiteral("AC Send To")},
                        {0x0289, QStringLiteral("AC Reply")},
                        {0x028A, QStringLiteral("AC Reply All")},
                        {0x028B, QStringLiteral("AC Forward Msg")},
                        {0x028C, QStringLiteral("AC Send")},
                        {0x028D, QStringLiteral("AC Attach File")},
                        {0x028E, QStringLiteral("AC Upload")},
                        {0x028F,
                                QStringLiteral("AC Download (Save Target As)")},
                        {0x0290, QStringLiteral("AC Set Borders")},
                        {0x0291, QStringLiteral("AC Insert Row")},
                        {0x0292, QStringLiteral("AC Insert Column")},
                        {0x0293, QStringLiteral("AC Insert File")},
                        {0x0294, QStringLiteral("AC Insert Picture")},
                        {0x0295, QStringLiteral("AC Insert Object")},
                        {0x0296, QStringLiteral("AC Insert Symbol")},
                        {0x0297, QStringLiteral("AC Save and Close")},
                        {0x0298, QStringLiteral("AC Rename")},
                        {0x0299, QStringLiteral("AC Merge")},
                        {0x029A, QStringLiteral("AC Split")},
                        {0x029B, QStringLiteral("AC Distribute Horizontally")},
                        {0x029C, QStringLiteral("AC Distribute Vertically")},
                        {0x029D,
                                QStringLiteral(
                                        "AC Next Keyboard Layout Select")},
                        {0x029E, QStringLiteral("AC Navigation Guidance")},
                        {0x029F, QStringLiteral("AC Desktop Show All Windows")},
                        {0x02A0, QStringLiteral("AC Soft Key Left")},
                        {0x02A1, QStringLiteral("AC Soft Key Right")},
                        {0x02A2,
                                QStringLiteral(
                                        "AC Desktop Show All Applications")},
                        {0x02B0, QStringLiteral("AC Idle Keep Alive")},
                        {0x02C0,
                                QStringLiteral("Extended Keyboard Attributes "
                                               "Collection")},
                        {0x02C1, QStringLiteral("Keyboard Form Factor")},
                        {0x02C2, QStringLiteral("Keyboard Key Type")},
                        {0x02C3, QStringLiteral("Keyboard Physical Layout")},
                        {0x02C4,
                                QStringLiteral("Vendor\u2010Specific Keyboard "
                                               "Physical Layout")},
                        {0x02C5,
                                QStringLiteral(
                                        "Keyboard IETF Language Tag Index")},
                        {0x02C6,
                                QStringLiteral("Implemented Keyboard Input "
                                               "Assist Controls")},
                        {0x02C7,
                                QStringLiteral(
                                        "Keyboard Input Assist Previous")},
                        {0x02C8, QStringLiteral("Keyboard Input Assist Next")},
                        {0x02C9,
                                QStringLiteral("Keyboard Input Assist Previous "
                                               "Group")},
                        {0x02CA,
                                QStringLiteral(
                                        "Keyboard Input Assist Next Group")},
                        {0x02CB,
                                QStringLiteral("Keyboard Input Assist Accept")},
                        {0x02CC,
                                QStringLiteral("Keyboard Input Assist Cancel")},
                        {0x02D0, QStringLiteral("Privacy Screen Toggle")},
                        {0x02D1,
                                QStringLiteral(
                                        "Privacy Screen Level Decrement")},
                        {0x02D2,
                                QStringLiteral(
                                        "Privacy Screen Level Increment")},
                        {0x02D3,
                                QStringLiteral("Privacy Screen Level Minimum")},
                        {0x02D4,
                                QStringLiteral("Privacy Screen Level Maximum")},
                        {0x0500, QStringLiteral("Contact Edited")},
                        {0x0501, QStringLiteral("Contact Added")},
                        {0x0502, QStringLiteral("Contact Record Active")},
                        {0x0503, QStringLiteral("Contact Index")},
                        {0x0504, QStringLiteral("Contact Nickname")},
                        {0x0505, QStringLiteral("Contact First Name")},
                        {0x0506, QStringLiteral("Contact Last Name")},
                        {0x0507, QStringLiteral("Contact Full Name")},
                        {0x0508,
                                QStringLiteral(
                                        "Contact Phone Number Personal")},
                        {0x0509,
                                QStringLiteral(
                                        "Contact Phone Number Business")},
                        {0x050A, QStringLiteral("Contact Phone Number Mobile")},
                        {0x050B, QStringLiteral("Contact Phone Number Pager")},
                        {0x050C, QStringLiteral("Contact Phone Number Fax")},
                        {0x050D, QStringLiteral("Contact Phone Number Other")},
                        {0x050E, QStringLiteral("Contact Email Personal")},
                        {0x050F, QStringLiteral("Contact Email Business")},
                        {0x0510, QStringLiteral("Contact Email Other")},
                        {0x0511, QStringLiteral("Contact Email Main")},
                        {0x0512, QStringLiteral("Contact Speed Dial Number")},
                        {0x0513, QStringLiteral("Contact Status Flag")},
                        {0x0514, QStringLiteral("Contact Misc.")},
                }},
        {0x000D,
                QStringLiteral("Digitizers"),
                {
                        {0x0001, QStringLiteral("Digitizer")},
                        {0x0002, QStringLiteral("Pen")},
                        {0x0003, QStringLiteral("Light Pen")},
                        {0x0004, QStringLiteral("Touch Screen")},
                        {0x0005, QStringLiteral("Touch Pad")},
                        {0x0006, QStringLiteral("Whiteboard")},
                        {0x0007,
                                QStringLiteral("Coordinate Measuring Machine")},
                        {0x0008, QStringLiteral("3D Digitizer")},
                        {0x0009, QStringLiteral("Stereo Plotter")},
                        {0x000A, QStringLiteral("Articulated Arm")},
                        {0x000B, QStringLiteral("Armature")},
                        {0x000C, QStringLiteral("Multiple Point Digitizer")},
                        {0x000D, QStringLiteral("Free Space Wand")},
                        {0x000E, QStringLiteral("Device Configuration")},
                        {0x000F,
                                QStringLiteral(
                                        "Capacitive Heat Map Digitizer")},
                        {0x0020, QStringLiteral("Stylus")},
                        {0x0021, QStringLiteral("Puck")},
                        {0x0022, QStringLiteral("Finger")},
                        {0x0023, QStringLiteral("Device settings")},
                        {0x0024, QStringLiteral("Character Gesture")},
                        {0x0030, QStringLiteral("Tip Pressure")},
                        {0x0031, QStringLiteral("Barrel Pressure")},
                        {0x0032, QStringLiteral("In Range")},
                        {0x0033, QStringLiteral("Touch")},
                        {0x0034, QStringLiteral("Untouch")},
                        {0x0035, QStringLiteral("Tap")},
                        {0x0036, QStringLiteral("Quality")},
                        {0x0037, QStringLiteral("Data Valid")},
                        {0x0038, QStringLiteral("Transducer Index")},
                        {0x0039, QStringLiteral("Tablet Function Keys")},
                        {0x003A, QStringLiteral("Program Change Keys")},
                        {0x003B, QStringLiteral("Battery Strength")},
                        {0x003C, QStringLiteral("Invert")},
                        {0x003D, QStringLiteral("X Tilt")},
                        {0x003E, QStringLiteral("Y Tilt")},
                        {0x003F, QStringLiteral("Azimuth")},
                        {0x0040, QStringLiteral("Altitude")},
                        {0x0041, QStringLiteral("Twist")},
                        {0x0042, QStringLiteral("Tip Switch")},
                        {0x0043, QStringLiteral("Secondary Tip Switch")},
                        {0x0044, QStringLiteral("Barrel Switch")},
                        {0x0045, QStringLiteral("Eraser")},
                        {0x0046, QStringLiteral("Tablet Pick")},
                        {0x0047, QStringLiteral("Touch Valid")},
                        {0x0048, QStringLiteral("Width")},
                        {0x0049, QStringLiteral("Height")},
                        {0x0051, QStringLiteral("Contact Identifier")},
                        {0x0052, QStringLiteral("Device Mode")},
                        {0x0053, QStringLiteral("Device Identifier")},
                        {0x0054, QStringLiteral("Contact Count")},
                        {0x0055, QStringLiteral("Contact Count Maximum")},
                        {0x0056, QStringLiteral("Scan Time")},
                        {0x0057, QStringLiteral("Surface Switch")},
                        {0x0058, QStringLiteral("Button Switch")},
                        {0x0059, QStringLiteral("Pad Type")},
                        {0x005A, QStringLiteral("Secondary Barrel Switch")},
                        {0x005B, QStringLiteral("Transducer Serial Number")},
                        {0x005C, QStringLiteral("Preferred Color")},
                        {0x005D, QStringLiteral("Preferred Color is Locked")},
                        {0x005E, QStringLiteral("Preferred Line Width")},
                        {0x005F,
                                QStringLiteral(
                                        "Preferred Line Width is Locked")},
                        {0x0060, QStringLiteral("Latency Mode")},
                        {0x0061, QStringLiteral("Gesture Character Quality")},
                        {0x0062,
                                QStringLiteral(
                                        "Character Gesture Data Length")},
                        {0x0063, QStringLiteral("Character Gesture Data")},
                        {0x0064, QStringLiteral("Gesture Character Encoding")},
                        {0x0065,
                                QStringLiteral(
                                        "UTF8 Character Gesture Encoding")},
                        {0x0066,
                                QStringLiteral("UTF16 Little Endian Character "
                                               "Gesture Encoding")},
                        {0x0067,
                                QStringLiteral("UTF16 Big Endian Character "
                                               "Gesture Encoding")},
                        {0x0068,
                                QStringLiteral("UTF32 Little Endian Character "
                                               "Gesture Encoding")},
                        {0x0069,
                                QStringLiteral("UTF32 Big Endian Character "
                                               "Gesture Encoding")},
                        {0x006A,
                                QStringLiteral("Capacitive Heat Map Protocol "
                                               "Vendor ID")},
                        {0x006B,
                                QStringLiteral("Capacitive Heat Map Protocol "
                                               "Version")},
                        {0x006C,
                                QStringLiteral(
                                        "Capacitive Heat Map Frame Data")},
                        {0x006D, QStringLiteral("Gesture Character Enable")},
                        {0x006E,
                                QStringLiteral(
                                        "Transducer Serial Number Part 2")},
                        {0x006F, QStringLiteral("No Preferred Color")},
                        {0x0070, QStringLiteral("Preferred Line Style")},
                        {0x0071,
                                QStringLiteral(
                                        "Preferred Line Style is Locked")},
                        {0x0072, QStringLiteral("Ink")},
                        {0x0073, QStringLiteral("Pencil")},
                        {0x0074, QStringLiteral("Highlighter")},
                        {0x0075, QStringLiteral("Chisel Marker")},
                        {0x0076, QStringLiteral("Brush")},
                        {0x0077, QStringLiteral("No Preference")},
                        {0x0080, QStringLiteral("Digitizer Diagnostic")},
                        {0x0081, QStringLiteral("Digitizer Error")},
                        {0x0082, QStringLiteral("Err Normal Status")},
                        {0x0083, QStringLiteral("Err Transducers Exceeded")},
                        {0x0084,
                                QStringLiteral(
                                        "Err Full Trans Features Unavailable")},
                        {0x0085, QStringLiteral("Err Charge Low")},
                        {0x0090, QStringLiteral("Transducer Software Info")},
                        {0x0091, QStringLiteral("Transducer Vendor Id")},
                        {0x0092, QStringLiteral("Transducer Product Id")},
                        {0x0093, QStringLiteral("Device Supported Protocols")},
                        {0x0094,
                                QStringLiteral(
                                        "Transducer Supported Protocols")},
                        {0x0095, QStringLiteral("No Protocol")},
                        {0x0096, QStringLiteral("Wacom AES Protocol")},
                        {0x0097, QStringLiteral("USI Protocol")},
                        {0x0098, QStringLiteral("Microsoft Pen Protocol")},
                        {0x00A0, QStringLiteral("Supported Report Rates")},
                        {0x00A1, QStringLiteral("Report Rate")},
                        {0x00A2, QStringLiteral("Transducer Connected")},
                        {0x00A3, QStringLiteral("Switch Disabled")},
                        {0x00A4, QStringLiteral("Switch Unimplemented")},
                        {0x00A5, QStringLiteral("Transducer Switches")},
                        {0x00A6, QStringLiteral("Transducer Index Selector")},
                        {0x00B0, QStringLiteral("Button Press Threshold")},
                }},
        {0x0012,
                QStringLiteral("Eye and Head Trackers"),
                {
                        {0x0001, QStringLiteral("Eye Tracker")},
                        {0x0002, QStringLiteral("Head Tracker")},
                        {0x0010, QStringLiteral("Tracking Data")},
                        {0x0011, QStringLiteral("Capabilities")},
                        {0x0012, QStringLiteral("Configuration")},
                        {0x0013, QStringLiteral("Status")},
                        {0x0014, QStringLiteral("Control")},
                        {0x0020, QStringLiteral("Sensor Timestamp")},
                        {0x0021, QStringLiteral("Position X")},
                        {0x0022, QStringLiteral("Position Y")},
                        {0x0023, QStringLiteral("Position Z")},
                        {0x0024, QStringLiteral("Gaze Point")},
                        {0x0025, QStringLiteral("Left Eye Position")},
                        {0x0026, QStringLiteral("Right Eye Position")},
                        {0x0027, QStringLiteral("Head Position")},
                        {0x0028, QStringLiteral("Head Direction Point")},
                        {0x0029, QStringLiteral("Rotation about X axis")},
                        {0x002A, QStringLiteral("Rotation about Y axis")},
                        {0x002B, QStringLiteral("Rotation about Z axis")},
                        {0x0100, QStringLiteral("Tracker Quality")},
                        {0x0101, QStringLiteral("Minimum Tracking Distance")},
                        {0x0102, QStringLiteral("Optimum Tracking Distance")},
                        {0x0103, QStringLiteral("Maximum Tracking Distance")},
                        {0x0104, QStringLiteral("Maximum Screen Plane Width")},
                        {0x0105, QStringLiteral("Maximum Screen Plane Height")},
                        {0x0200, QStringLiteral("Display Manufacturer ID")},
                        {0x0201, QStringLiteral("Display Product ID")},
                        {0x0202, QStringLiteral("Display Serial Number")},
                        {0x0203, QStringLiteral("Display Manufacturer Date")},
                        {0x0204, QStringLiteral("Calibrated Screen Width")},
                        {0x0205, QStringLiteral("Calibrated Screen Height")},
                        {0x0300, QStringLiteral("Sampling Frequency")},
                        {0x0301, QStringLiteral("Configuration Status")},
                        {0x0400, QStringLiteral("Device Mode Request")},
                }},
        {0xF1D0,
                QStringLiteral("FIDO Alliance"),
                {
                        {0x0001, QStringLiteral("U2F Authenticator Device")},
                        {0x0020, QStringLiteral("Input Report Data")},
                        {0x0021, QStringLiteral("Output Report Data")},
                }},
        {0x0005,
                QStringLiteral("Game Controls"),
                {
                        {0x0001, QStringLiteral("3D Game Controller")},
                        {0x0002, QStringLiteral("Pinball Device")},
                        {0x0003, QStringLiteral("Gun Device")},
                        {0x0020, QStringLiteral("Point of View")},
                        {0x0021, QStringLiteral("Turn Right/Left")},
                        {0x0022, QStringLiteral("Pitch Forward/Backward")},
                        {0x0023, QStringLiteral("Roll Right/Left")},
                        {0x0024, QStringLiteral("Move Right/Left")},
                        {0x0025, QStringLiteral("Move Forward/Backward")},
                        {0x0026, QStringLiteral("Move Up/Down")},
                        {0x0027, QStringLiteral("Lean Right/Left")},
                        {0x0028, QStringLiteral("Lean Forward/Backward")},
                        {0x0029, QStringLiteral("Height of POV")},
                        {0x002A, QStringLiteral("Flipper")},
                        {0x002B, QStringLiteral("Secondary Flipper")},
                        {0x002C, QStringLiteral("Bump")},
                        {0x002D, QStringLiteral("New Game")},
                        {0x002E, QStringLiteral("Shoot Ball")},
                        {0x002F, QStringLiteral("Player")},
                        {0x0030, QStringLiteral("Gun Bolt")},
                        {0x0031, QStringLiteral("Gun Clip")},
                        {0x0032, QStringLiteral("Gun Selector")},
                        {0x0033, QStringLiteral("Gun Single Shot")},
                        {0x0034, QStringLiteral("Gun Burst")},
                        {0x0035, QStringLiteral("Gun Automatic")},
                        {0x0036, QStringLiteral("Gun Safety")},
                        {0x0037, QStringLiteral("Gamepad Fire/Jump")},
                        {0x0039, QStringLiteral("Gamepad Trigger")},
                        {0x003A, QStringLiteral("Form-fitting Gamepad")},
                }},
        {0x0001,
                QStringLiteral("Generic Desktop"),
                {
                        {0x0001, QStringLiteral("Pointer")},
                        {0x0002, QStringLiteral("Mouse")},
                        {0x0004, QStringLiteral("Joystick")},
                        {0x0005, QStringLiteral("Gamepad")},
                        {0x0006, QStringLiteral("Keyboard")},
                        {0x0007, QStringLiteral("Keypad")},
                        {0x0008, QStringLiteral("Multi-axis Controller")},
                        {0x0009, QStringLiteral("Tablet PC System Controls")},
                        {0x000A, QStringLiteral("Water Cooling Device")},
                        {0x000B, QStringLiteral("Computer Chassis Device")},
                        {0x000C, QStringLiteral("Wireless Radio Controls")},
                        {0x000D, QStringLiteral("Portable Device Control")},
                        {0x000E,
                                QStringLiteral("System Multi-Axis Controller")},
                        {0x000F, QStringLiteral("Spatial Controller")},
                        {0x0010, QStringLiteral("Assistive Control")},
                        {0x0011, QStringLiteral("Device Dock")},
                        {0x0012, QStringLiteral("Dockable Device")},
                        {0x0013,
                                QStringLiteral(
                                        "Call State Management Control")},
                        {0x0030, QStringLiteral("X")},
                        {0x0031, QStringLiteral("Y")},
                        {0x0032, QStringLiteral("Z")},
                        {0x0033, QStringLiteral("Rx")},
                        {0x0034, QStringLiteral("Ry")},
                        {0x0035, QStringLiteral("Rz")},
                        {0x0036, QStringLiteral("Slider")},
                        {0x0037, QStringLiteral("Dial")},
                        {0x0038, QStringLiteral("Wheel")},
                        {0x0039, QStringLiteral("Hat Switch")},
                        {0x003A, QStringLiteral("Counted Buffer")},
                        {0x003B, QStringLiteral("Byte Count")},
                        {0x003C, QStringLiteral("Motion Wakeup")},
                        {0x003D, QStringLiteral("Start")},
                        {0x003E, QStringLiteral("Select")},
                        {0x0040, QStringLiteral("Vx")},
                        {0x0041, QStringLiteral("Vy")},
                        {0x0042, QStringLiteral("Vz")},
                        {0x0043, QStringLiteral("Vbrx")},
                        {0x0044, QStringLiteral("Vbry")},
                        {0x0045, QStringLiteral("Vbrz")},
                        {0x0046, QStringLiteral("Vno")},
                        {0x0047, QStringLiteral("Feature Notification")},
                        {0x0048, QStringLiteral("Resolution Multiplier")},
                        {0x0049, QStringLiteral("Qx")},
                        {0x004A, QStringLiteral("Qy")},
                        {0x004B, QStringLiteral("Qz")},
                        {0x004C, QStringLiteral("Qw")},
                        {0x0080, QStringLiteral("System Control")},
                        {0x0081, QStringLiteral("System Power Down")},
                        {0x0082, QStringLiteral("System Sleep")},
                        {0x0083, QStringLiteral("System Wake Up")},
                        {0x0084, QStringLiteral("System Context Menu")},
                        {0x0085, QStringLiteral("System Main Menu")},
                        {0x0086, QStringLiteral("System App Menu")},
                        {0x0087, QStringLiteral("System Menu Help")},
                        {0x0088, QStringLiteral("System Menu Exit")},
                        {0x0089, QStringLiteral("System Menu Select")},
                        {0x008A, QStringLiteral("System Menu Right")},
                        {0x008B, QStringLiteral("System Menu Left")},
                        {0x008C, QStringLiteral("System Menu Up")},
                        {0x008D, QStringLiteral("System Menu Down")},
                        {0x008E, QStringLiteral("System Cold Restart")},
                        {0x008F, QStringLiteral("System Warm Restart")},
                        {0x0090, QStringLiteral("D-pad Up")},
                        {0x0091, QStringLiteral("D-pad Down")},
                        {0x0092, QStringLiteral("D-pad Right")},
                        {0x0093, QStringLiteral("D-pad Left")},
                        {0x0094, QStringLiteral("Index Trigger")},
                        {0x0095, QStringLiteral("Palm Trigger")},
                        {0x0096, QStringLiteral("Thumbstick")},
                        {0x0097, QStringLiteral("System Function Shift")},
                        {0x0098, QStringLiteral("System Function Shift Lock")},
                        {0x0099,
                                QStringLiteral("System Function Shift Lock "
                                               "Indicator")},
                        {0x009A, QStringLiteral("System Dismiss Notification")},
                        {0x009B, QStringLiteral("System Do Not Disturb")},
                        {0x00A0, QStringLiteral("System Dock")},
                        {0x00A1, QStringLiteral("System Undock")},
                        {0x00A2, QStringLiteral("System Setup")},
                        {0x00A3, QStringLiteral("System Break")},
                        {0x00A4, QStringLiteral("System Debugger Break")},
                        {0x00A5, QStringLiteral("Application Break")},
                        {0x00A6, QStringLiteral("Application Debugger Break")},
                        {0x00A7, QStringLiteral("System Speaker Mute")},
                        {0x00A8, QStringLiteral("System Hibernate")},
                        {0x00A9, QStringLiteral("System Microphone Mute")},
                        {0x00B0, QStringLiteral("System Display Invert")},
                        {0x00B1, QStringLiteral("System Display Internal")},
                        {0x00B2, QStringLiteral("System Display External")},
                        {0x00B3, QStringLiteral("System Display Both")},
                        {0x00B4, QStringLiteral("System Display Dual")},
                        {0x00B5,
                                QStringLiteral(
                                        "System Display Toggle Int/Ext Mode")},
                        {0x00B6,
                                QStringLiteral("System Display Swap "
                                               "Primary/Secondary")},
                        {0x00B7,
                                QStringLiteral(
                                        "System Display Toggle LCD Autoscale")},
                        {0x00C0, QStringLiteral("Sensor Zone")},
                        {0x00C1, QStringLiteral("RPM")},
                        {0x00C2, QStringLiteral("Coolant Level")},
                        {0x00C3, QStringLiteral("Coolant Critical Level")},
                        {0x00C4, QStringLiteral("Coolant Pump")},
                        {0x00C5, QStringLiteral("Chassis Enclosure")},
                        {0x00C6, QStringLiteral("Wireless Radio Button")},
                        {0x00C7, QStringLiteral("Wireless Radio LED")},
                        {0x00C8,
                                QStringLiteral("Wireless Radio Slider Switch")},
                        {0x00C9,
                                QStringLiteral(
                                        "System Display Rotation Lock Button")},
                        {0x00CA,
                                QStringLiteral("System Display Rotation Lock "
                                               "Slider Switch")},
                        {0x00CB, QStringLiteral("Control Enable")},
                        {0x00D0, QStringLiteral("Dockable Device Unique ID")},
                        {0x00D1, QStringLiteral("Dockable Device Vendor ID")},
                        {0x00D2,
                                QStringLiteral(
                                        "Dockable Device Primary Usage Page")},
                        {0x00D3,
                                QStringLiteral(
                                        "Dockable Device Primary Usage ID")},
                        {0x00D4,
                                QStringLiteral(
                                        "Dockable Device Docking State")},
                        {0x00D5,
                                QStringLiteral(
                                        "Dockable Device Display Occlusion")},
                        {0x00D6, QStringLiteral("Dockable Device Object Type")},
                        {0x00E0, QStringLiteral("Call Active LED")},
                        {0x00E1, QStringLiteral("Call Mute Toggle")},
                        {0x00E2, QStringLiteral("Call Mute LED")},
                }},
        {0x0006,
                QStringLiteral("Generic Device Controls"),
                {
                        {0x0001, QStringLiteral("Background/Nonuser Controls")},
                        {0x0020, QStringLiteral("Battery Strength")},
                        {0x0021, QStringLiteral("Wireless Channel")},
                        {0x0022, QStringLiteral("Wireless ID")},
                        {0x0023, QStringLiteral("Discover Wireless Control")},
                        {0x0024,
                                QStringLiteral(
                                        "Security Code Character Entered")},
                        {0x0025,
                                QStringLiteral(
                                        "Security Code Character Erased")},
                        {0x0026, QStringLiteral("Security Code Cleared")},
                        {0x0027, QStringLiteral("Sequence ID")},
                        {0x0028, QStringLiteral("Sequence ID Reset")},
                        {0x0029, QStringLiteral("RF Signal Strength")},
                        {0x002A, QStringLiteral("Software Version")},
                        {0x002B, QStringLiteral("Protocol Version")},
                        {0x002C, QStringLiteral("Hardware Version")},
                        {0x002D, QStringLiteral("Major")},
                        {0x002E, QStringLiteral("Minor")},
                        {0x002F, QStringLiteral("Revision")},
                        {0x0030, QStringLiteral("Handedness")},
                        {0x0031, QStringLiteral("Either Hand")},
                        {0x0032, QStringLiteral("Left Hand")},
                        {0x0033, QStringLiteral("Right Hand")},
                        {0x0034, QStringLiteral("Both Hands")},
                        {0x0040, QStringLiteral("Grip Pose Offset")},
                        {0x0041, QStringLiteral("Pointer Pose Offset")},
                }},
        {0x000E,
                QStringLiteral("Haptics"),
                {
                        {0x0001, QStringLiteral("Simple Haptic Controller")},
                        {0x0010, QStringLiteral("Waveform List")},
                        {0x0011, QStringLiteral("Duration List")},
                        {0x0020, QStringLiteral("Auto Trigger")},
                        {0x0021, QStringLiteral("Manual Trigger")},
                        {0x0022,
                                QStringLiteral(
                                        "Auto Trigger Associated Control")},
                        {0x0023, QStringLiteral("Intensity")},
                        {0x0024, QStringLiteral("Repeat Count")},
                        {0x0025, QStringLiteral("Retrigger Period")},
                        {0x0026, QStringLiteral("Waveform Vendor Page")},
                        {0x0027, QStringLiteral("Waveform Vendor ID")},
                        {0x0028, QStringLiteral("Waveform Cutoff Time")},
                        {0x1001, QStringLiteral("Waveform None")},
                        {0x1002, QStringLiteral("Waveform Stop")},
                        {0x1003, QStringLiteral("Waveform Click")},
                        {0x1004, QStringLiteral("Waveform Buzz Continuous")},
                        {0x1005, QStringLiteral("Waveform Rumble Continuous")},
                        {0x1006, QStringLiteral("Waveform Press")},
                        {0x1007, QStringLiteral("Waveform Release")},
                        {0x1008, QStringLiteral("Waveform Hover")},
                        {0x1009, QStringLiteral("Waveform Success")},
                        {0x100A, QStringLiteral("Waveform Error")},
                        {0x100B, QStringLiteral("Waveform Ink Continuous")},
                        {0x100C, QStringLiteral("Waveform Pencil Continuous")},
                        {0x100D, QStringLiteral("Waveform Marker Continuous")},
                        {0x100E,
                                QStringLiteral(
                                        "Waveform Chisel Marker Continuous")},
                        {0x100F, QStringLiteral("Waveform Brush Continuous")},
                        {0x1010, QStringLiteral("Waveform Eraser Continuous")},
                        {0x1011, QStringLiteral("Waveform Sparkle Continuous")},
                }},
        {0x0007,
                QStringLiteral("Keyboard/Keypad"),
                {
                        {0x0001, QStringLiteral("ErrorRollOver")},
                        {0x0002, QStringLiteral("POSTFail")},
                        {0x0003, QStringLiteral("ErrorUndefined")},
                        {0x0004, QStringLiteral("Keyboard A")},
                        {0x0005, QStringLiteral("Keyboard B")},
                        {0x0006, QStringLiteral("Keyboard C")},
                        {0x0007, QStringLiteral("Keyboard D")},
                        {0x0008, QStringLiteral("Keyboard E")},
                        {0x0009, QStringLiteral("Keyboard F")},
                        {0x000A, QStringLiteral("Keyboard G")},
                        {0x000B, QStringLiteral("Keyboard H")},
                        {0x000C, QStringLiteral("Keyboard I")},
                        {0x000D, QStringLiteral("Keyboard J")},
                        {0x000E, QStringLiteral("Keyboard K")},
                        {0x000F, QStringLiteral("Keyboard L")},
                        {0x0010, QStringLiteral("Keyboard M")},
                        {0x0011, QStringLiteral("Keyboard N")},
                        {0x0012, QStringLiteral("Keyboard O")},
                        {0x0013, QStringLiteral("Keyboard P")},
                        {0x0014, QStringLiteral("Keyboard Q")},
                        {0x0015, QStringLiteral("Keyboard R")},
                        {0x0016, QStringLiteral("Keyboard S")},
                        {0x0017, QStringLiteral("Keyboard T")},
                        {0x0018, QStringLiteral("Keyboard U")},
                        {0x0019, QStringLiteral("Keyboard V")},
                        {0x001A, QStringLiteral("Keyboard W")},
                        {0x001B, QStringLiteral("Keyboard X")},
                        {0x001C, QStringLiteral("Keyboard Y")},
                        {0x001D, QStringLiteral("Keyboard Z")},
                        {0x001E, QStringLiteral("Keyboard 1 and Bang")},
                        {0x001F, QStringLiteral("Keyboard 2 and At")},
                        {0x0020, QStringLiteral("Keyboard 3 and Hash")},
                        {0x0021, QStringLiteral("Keyboard 4 and Dollar")},
                        {0x0022, QStringLiteral("Keyboard 5 and Percent")},
                        {0x0023, QStringLiteral("Keyboard 6 and Caret")},
                        {0x0024, QStringLiteral("Keyboard 7 and Ampersand")},
                        {0x0025, QStringLiteral("Keyboard 8 and Star")},
                        {0x0026, QStringLiteral("Keyboard 9 and Left Bracket")},
                        {0x0027,
                                QStringLiteral("Keyboard 0 and Right Bracket")},
                        {0x0028, QStringLiteral("Keyboard Return Enter")},
                        {0x0029, QStringLiteral("Keyboard Escape")},
                        {0x002A, QStringLiteral("Keyboard Delete")},
                        {0x002B, QStringLiteral("Keyboard Tab")},
                        {0x002C, QStringLiteral("Keyboard Spacebar")},
                        {0x002D,
                                QStringLiteral("Keyboard Dash and Underscore")},
                        {0x002E, QStringLiteral("Keyboard Equals and Plus")},
                        {0x002F, QStringLiteral("Keyboard Left Brace")},
                        {0x0030, QStringLiteral("Keyboard Right Brace")},
                        {0x0031, QStringLiteral("Keyboard Backslash and Pipe")},
                        {0x0032,
                                QStringLiteral(
                                        "Keyboard Non-US Hash and Tilde")},
                        {0x0033,
                                QStringLiteral("Keyboard SemiColon and Colon")},
                        {0x0034,
                                QStringLiteral(
                                        "Keyboard Left Apos and Double")},
                        {0x0035,
                                QStringLiteral(
                                        "Keyboard Grave Accent and Tilde")},
                        {0x0036, QStringLiteral("Keyboard Comma and LessThan")},
                        {0x0037,
                                QStringLiteral(
                                        "Keyboard Period and GreaterThan")},
                        {0x0038,
                                QStringLiteral("Keyboard ForwardSlash and "
                                               "QuestionMark")},
                        {0x0039, QStringLiteral("Keyboard Caps Lock")},
                        {0x003A, QStringLiteral("Keyboard F1")},
                        {0x003B, QStringLiteral("Keyboard F2")},
                        {0x003C, QStringLiteral("Keyboard F3")},
                        {0x003D, QStringLiteral("Keyboard F4")},
                        {0x003E, QStringLiteral("Keyboard F5")},
                        {0x003F, QStringLiteral("Keyboard F6")},
                        {0x0040, QStringLiteral("Keyboard F7")},
                        {0x0041, QStringLiteral("Keyboard F8")},
                        {0x0042, QStringLiteral("Keyboard F9")},
                        {0x0043, QStringLiteral("Keyboard F10")},
                        {0x0044, QStringLiteral("Keyboard F11")},
                        {0x0045, QStringLiteral("Keyboard F12")},
                        {0x0046, QStringLiteral("Keyboard PrintScreen")},
                        {0x0047, QStringLiteral("Keyboard Scroll Lock")},
                        {0x0048, QStringLiteral("Keyboard Pause")},
                        {0x0049, QStringLiteral("Keyboard Insert")},
                        {0x004A, QStringLiteral("Keyboard Home")},
                        {0x004B, QStringLiteral("Keyboard PageUp")},
                        {0x004C, QStringLiteral("Keyboard Delete Forward")},
                        {0x004D, QStringLiteral("Keyboard End")},
                        {0x004E, QStringLiteral("Keyboard PageDown")},
                        {0x004F, QStringLiteral("Keyboard RightArrow")},
                        {0x0050, QStringLiteral("Keyboard LeftArrow")},
                        {0x0051, QStringLiteral("Keyboard DownArrow")},
                        {0x0052, QStringLiteral("Keyboard UpArrow")},
                        {0x0053, QStringLiteral("Keypad Num Lock and Clear")},
                        {0x0054, QStringLiteral("Keypad ForwardSlash")},
                        {0x0055, QStringLiteral("Keypad Star")},
                        {0x0056, QStringLiteral("Keypad Dash")},
                        {0x0057, QStringLiteral("Keypad Plus")},
                        {0x0058, QStringLiteral("Keypad ENTER")},
                        {0x0059, QStringLiteral("Keypad 1 and End")},
                        {0x005A, QStringLiteral("Keypad 2 and Down Arrow")},
                        {0x005B, QStringLiteral("Keypad 3 and PageDn")},
                        {0x005C, QStringLiteral("Keypad 4 and Left Arrow")},
                        {0x005D, QStringLiteral("Keypad 5")},
                        {0x005E, QStringLiteral("Keypad 6 and Right Arrow")},
                        {0x005F, QStringLiteral("Keypad 7 and Home")},
                        {0x0060, QStringLiteral("Keypad 8 and Up Arrow")},
                        {0x0061, QStringLiteral("Keypad 9 and PageUp")},
                        {0x0062, QStringLiteral("Keypad 0 and Insert")},
                        {0x0063, QStringLiteral("Keypad Period and Delete")},
                        {0x0064,
                                QStringLiteral(
                                        "Keyboard Non-US Backslash and Pipe")},
                        {0x0065, QStringLiteral("Keyboard Application")},
                        {0x0066, QStringLiteral("Keyboard Power")},
                        {0x0067, QStringLiteral("Keypad Equals")},
                        {0x0068, QStringLiteral("Keyboard F13")},
                        {0x0069, QStringLiteral("Keyboard F14")},
                        {0x006A, QStringLiteral("Keyboard F15")},
                        {0x006B, QStringLiteral("Keyboard F16")},
                        {0x006C, QStringLiteral("Keyboard F17")},
                        {0x006D, QStringLiteral("Keyboard F18")},
                        {0x006E, QStringLiteral("Keyboard F19")},
                        {0x006F, QStringLiteral("Keyboard F20")},
                        {0x0070, QStringLiteral("Keyboard F21")},
                        {0x0071, QStringLiteral("Keyboard F22")},
                        {0x0072, QStringLiteral("Keyboard F23")},
                        {0x0073, QStringLiteral("Keyboard F24")},
                        {0x0074, QStringLiteral("Keyboard Execute")},
                        {0x0075, QStringLiteral("Keyboard Help")},
                        {0x0076, QStringLiteral("Keyboard Menu")},
                        {0x0077, QStringLiteral("Keyboard Select")},
                        {0x0078, QStringLiteral("Keyboard Stop")},
                        {0x0079, QStringLiteral("Keyboard Again")},
                        {0x007A, QStringLiteral("Keyboard Undo")},
                        {0x007B, QStringLiteral("Keyboard Cut")},
                        {0x007C, QStringLiteral("Keyboard Copy")},
                        {0x007D, QStringLiteral("Keyboard Paste")},
                        {0x007E, QStringLiteral("Keyboard Find")},
                        {0x007F, QStringLiteral("Keyboard Mute")},
                        {0x0080, QStringLiteral("Keyboard Volume Up")},
                        {0x0081, QStringLiteral("Keyboard Volume Down")},
                        {0x0082, QStringLiteral("Keyboard Locking Caps Lock")},
                        {0x0083, QStringLiteral("Keyboard Locking Num Lock")},
                        {0x0084,
                                QStringLiteral("Keyboard Locking Scroll Lock")},
                        {0x0085, QStringLiteral("Keypad Comma")},
                        {0x0086, QStringLiteral("Keypad Equal Sign")},
                        {0x0087, QStringLiteral("Keyboard International1")},
                        {0x0088, QStringLiteral("Keyboard International2")},
                        {0x0089, QStringLiteral("Keyboard International3")},
                        {0x008A, QStringLiteral("Keyboard International4")},
                        {0x008B, QStringLiteral("Keyboard International5")},
                        {0x008C, QStringLiteral("Keyboard International6")},
                        {0x008D, QStringLiteral("Keyboard International7")},
                        {0x008E, QStringLiteral("Keyboard International8")},
                        {0x008F, QStringLiteral("Keyboard International9")},
                        {0x0090, QStringLiteral("Keyboard LANG1")},
                        {0x0091, QStringLiteral("Keyboard LANG2")},
                        {0x0092, QStringLiteral("Keyboard LANG3")},
                        {0x0093, QStringLiteral("Keyboard LANG4")},
                        {0x0094, QStringLiteral("Keyboard LANG5")},
                        {0x0095, QStringLiteral("Keyboard LANG6")},
                        {0x0096, QStringLiteral("Keyboard LANG7")},
                        {0x0097, QStringLiteral("Keyboard LANG8")},
                        {0x0098, QStringLiteral("Keyboard LANG9")},
                        {0x0099, QStringLiteral("Keyboard Alternate Erase")},
                        {0x009A, QStringLiteral("Keyboard SysReq Attention")},
                        {0x009B, QStringLiteral("Keyboard Cancel")},
                        {0x009C, QStringLiteral("Keyboard Clear")},
                        {0x009D, QStringLiteral("Keyboard Prior")},
                        {0x009E, QStringLiteral("Keyboard Return")},
                        {0x009F, QStringLiteral("Keyboard Separator")},
                        {0x00A0, QStringLiteral("Keyboard Out")},
                        {0x00A1, QStringLiteral("Keyboard Oper")},
                        {0x00A2, QStringLiteral("Keyboard Clear Again")},
                        {0x00A3, QStringLiteral("Keyboard CrSel Props")},
                        {0x00A4, QStringLiteral("Keyboard ExSel")},
                        {0x00B0, QStringLiteral("Keypad Double 0")},
                        {0x00B1, QStringLiteral("Keypad Triple 0")},
                        {0x00B2, QStringLiteral("Thousands Separator")},
                        {0x00B3, QStringLiteral("Decimal Separator")},
                        {0x00B4, QStringLiteral("Currency Unit")},
                        {0x00B5, QStringLiteral("Currency Sub-unit")},
                        {0x00B6, QStringLiteral("Keypad Left Bracket")},
                        {0x00B7, QStringLiteral("Keypad Right Bracket")},
                        {0x00B8, QStringLiteral("Keypad Left Brace")},
                        {0x00B9, QStringLiteral("Keypad Right Brace")},
                        {0x00BA, QStringLiteral("Keypad Tab")},
                        {0x00BB, QStringLiteral("Keypad Backspace")},
                        {0x00BC, QStringLiteral("Keypad A")},
                        {0x00BD, QStringLiteral("Keypad B")},
                        {0x00BE, QStringLiteral("Keypad C")},
                        {0x00BF, QStringLiteral("Keypad D")},
                        {0x00C0, QStringLiteral("Keypad E")},
                        {0x00C1, QStringLiteral("Keypad F")},
                        {0x00C2, QStringLiteral("Keypad XOR")},
                        {0x00C3, QStringLiteral("Keypad Caret")},
                        {0x00C4, QStringLiteral("Keypad Percentage")},
                        {0x00C5, QStringLiteral("Keypad Less")},
                        {0x00C6, QStringLiteral("Keypad Greater")},
                        {0x00C7, QStringLiteral("Keypad Ampersand")},
                        {0x00C8, QStringLiteral("Keypad Double Ampersand")},
                        {0x00C9, QStringLiteral("Keypad Bar")},
                        {0x00CA, QStringLiteral("Keypad Double Bar")},
                        {0x00CB, QStringLiteral("Keypad Colon")},
                        {0x00CC, QStringLiteral("Keypad Hash")},
                        {0x00CD, QStringLiteral("Keypad Space")},
                        {0x00CE, QStringLiteral("Keypad At")},
                        {0x00CF, QStringLiteral("Keypad Bang")},
                        {0x00D0, QStringLiteral("Keypad Memory Store")},
                        {0x00D1, QStringLiteral("Keypad Memory Recall")},
                        {0x00D2, QStringLiteral("Keypad Memory Clear")},
                        {0x00D3, QStringLiteral("Keypad Memory Add")},
                        {0x00D4, QStringLiteral("Keypad Memory Subtract")},
                        {0x00D5, QStringLiteral("Keypad Memory Multiply")},
                        {0x00D6, QStringLiteral("Keypad Memory Divide")},
                        {0x00D7, QStringLiteral("Keypad Plus Minus")},
                        {0x00D8, QStringLiteral("Keypad Clear")},
                        {0x00D9, QStringLiteral("Keypad Clear Entry")},
                        {0x00DA, QStringLiteral("Keypad Binary")},
                        {0x00DB, QStringLiteral("Keypad Octal")},
                        {0x00DC, QStringLiteral("Keypad Decimal")},
                        {0x00DD, QStringLiteral("Keypad Hexadecimal")},
                        {0x00E0, QStringLiteral("Keyboard LeftControl")},
                        {0x00E1, QStringLiteral("Keyboard LeftShift")},
                        {0x00E2, QStringLiteral("Keyboard LeftAlt")},
                        {0x00E3, QStringLiteral("Keyboard Left GUI")},
                        {0x00E4, QStringLiteral("Keyboard RightControl")},
                        {0x00E5, QStringLiteral("Keyboard RightShift")},
                        {0x00E6, QStringLiteral("Keyboard RightAlt")},
                        {0x00E7, QStringLiteral("Keyboard Right GUI")},
                }},
        {0x0008,
                QStringLiteral("LED"),
                {
                        {0x0001, QStringLiteral("Num Lock")},
                        {0x0002, QStringLiteral("Caps Lock")},
                        {0x0003, QStringLiteral("Scroll Lock")},
                        {0x0004, QStringLiteral("Compose")},
                        {0x0005, QStringLiteral("Kana")},
                        {0x0006, QStringLiteral("Power")},
                        {0x0007, QStringLiteral("Shift")},
                        {0x0008, QStringLiteral("Do Not Disturb")},
                        {0x0009, QStringLiteral("Mute")},
                        {0x000A, QStringLiteral("Tone Enable")},
                        {0x000B, QStringLiteral("High Cut Filter")},
                        {0x000C, QStringLiteral("Low Cut Filter")},
                        {0x000D, QStringLiteral("Equalizer Enable")},
                        {0x000E, QStringLiteral("Sound Field On")},
                        {0x000F, QStringLiteral("Surround On")},
                        {0x0010, QStringLiteral("Repeat")},
                        {0x0011, QStringLiteral("Stereo")},
                        {0x0012, QStringLiteral("Sampling Rate Detect")},
                        {0x0013, QStringLiteral("Spinning")},
                        {0x0014, QStringLiteral("CAV")},
                        {0x0015, QStringLiteral("CLV")},
                        {0x0016, QStringLiteral("Recording Format Detect")},
                        {0x0017, QStringLiteral("Off-Hook")},
                        {0x0018, QStringLiteral("Ring")},
                        {0x0019, QStringLiteral("Message Waiting")},
                        {0x001A, QStringLiteral("Data Mode")},
                        {0x001B, QStringLiteral("Battery Operation")},
                        {0x001C, QStringLiteral("Battery OK")},
                        {0x001D, QStringLiteral("Battery Low")},
                        {0x001E, QStringLiteral("Speaker")},
                        {0x001F, QStringLiteral("Headset")},
                        {0x0020, QStringLiteral("Hold")},
                        {0x0021, QStringLiteral("Microphone")},
                        {0x0022, QStringLiteral("Coverage")},
                        {0x0023, QStringLiteral("Night Mode")},
                        {0x0024, QStringLiteral("Send Calls")},
                        {0x0025, QStringLiteral("Call Pickup")},
                        {0x0026, QStringLiteral("Conference")},
                        {0x0027, QStringLiteral("Stand-by")},
                        {0x0028, QStringLiteral("Camera On")},
                        {0x0029, QStringLiteral("Camera Off")},
                        {0x002A, QStringLiteral("On-Line")},
                        {0x002B, QStringLiteral("Off-Line")},
                        {0x002C, QStringLiteral("Busy")},
                        {0x002D, QStringLiteral("Ready")},
                        {0x002E, QStringLiteral("Paper-Out")},
                        {0x002F, QStringLiteral("Paper-Jam")},
                        {0x0030, QStringLiteral("Remote")},
                        {0x0031, QStringLiteral("Forward")},
                        {0x0032, QStringLiteral("Reverse")},
                        {0x0033, QStringLiteral("Stop")},
                        {0x0034, QStringLiteral("Rewind")},
                        {0x0035, QStringLiteral("Fast Forward")},
                        {0x0036, QStringLiteral("Play")},
                        {0x0037, QStringLiteral("Pause")},
                        {0x0038, QStringLiteral("Record")},
                        {0x0039, QStringLiteral("Error")},
                        {0x003A, QStringLiteral("Usage Selected Indicator")},
                        {0x003B, QStringLiteral("Usage In Use Indicator")},
                        {0x003C, QStringLiteral("Usage Multi Mode Indicator")},
                        {0x003D, QStringLiteral("Indicator On")},
                        {0x003E, QStringLiteral("Indicator Flash")},
                        {0x003F, QStringLiteral("Indicator Slow Blink")},
                        {0x0040, QStringLiteral("Indicator Fast Blink")},
                        {0x0041, QStringLiteral("Indicator Off")},
                        {0x0042, QStringLiteral("Flash On Time")},
                        {0x0043, QStringLiteral("Slow Blink On Time")},
                        {0x0044, QStringLiteral("Slow Blink Off Time")},
                        {0x0045, QStringLiteral("Fast Blink On Time")},
                        {0x0046, QStringLiteral("Fast Blink Off Time")},
                        {0x0047, QStringLiteral("Usage Indicator Color")},
                        {0x0048, QStringLiteral("Indicator Red")},
                        {0x0049, QStringLiteral("Indicator Green")},
                        {0x004A, QStringLiteral("Indicator Amber")},
                        {0x004B, QStringLiteral("Generic Indicator")},
                        {0x004C, QStringLiteral("System Suspend")},
                        {0x004D, QStringLiteral("External Power Connected")},
                        {0x004E, QStringLiteral("Indicator Blue")},
                        {0x004F, QStringLiteral("Indicator Orange")},
                        {0x0050, QStringLiteral("Good Status")},
                        {0x0051, QStringLiteral("Warning Status")},
                        {0x0052, QStringLiteral("RGB LED")},
                        {0x0053, QStringLiteral("Red LED Channel")},
                        {0x0054, QStringLiteral("Blue LED Channel")},
                        {0x0055, QStringLiteral("Green LED Channel")},
                        {0x0056, QStringLiteral("LED Intensity")},
                        {0x0057, QStringLiteral("System Microphone Mute")},
                        {0x0060, QStringLiteral("Player Indicator")},
                        {0x0061, QStringLiteral("Player 1")},
                        {0x0062, QStringLiteral("Player 2")},
                        {0x0063, QStringLiteral("Player 3")},
                        {0x0064, QStringLiteral("Player 4")},
                        {0x0065, QStringLiteral("Player 5")},
                        {0x0066, QStringLiteral("Player 6")},
                        {0x0067, QStringLiteral("Player 7")},
                        {0x0068, QStringLiteral("Player 8")},
                }},
        {0x0059,
                QStringLiteral("Lighting And Illumination"),
                {
                        {0x0001, QStringLiteral("LampArray")},
                        {0x0002, QStringLiteral("LampArrayAttributesReport")},
                        {0x0003, QStringLiteral("LampCount")},
                        {0x0004,
                                QStringLiteral(
                                        "BoundingBoxWidthInMicrometers")},
                        {0x0005,
                                QStringLiteral(
                                        "BoundingBoxHeightInMicrometers")},
                        {0x0006,
                                QStringLiteral(
                                        "BoundingBoxDepthInMicrometers")},
                        {0x0007, QStringLiteral("LampArrayKind")},
                        {0x0008,
                                QStringLiteral(
                                        "MinUpdateIntervalInMicroseconds")},
                        {0x0020, QStringLiteral("LampAttributesRequestReport")},
                        {0x0021, QStringLiteral("LampId")},
                        {0x0022,
                                QStringLiteral("LampAttributesResponseReport")},
                        {0x0023, QStringLiteral("PositionXInMicrometers")},
                        {0x0024, QStringLiteral("PositionYInMicrometers")},
                        {0x0025, QStringLiteral("PositionZInMicrometers")},
                        {0x0026, QStringLiteral("LampPurposes")},
                        {0x0027, QStringLiteral("UpdateLatencyInMicroseconds")},
                        {0x0028, QStringLiteral("RedLevelCount")},
                        {0x0029, QStringLiteral("GreenLevelCount")},
                        {0x002A, QStringLiteral("BlueLevelCount")},
                        {0x002B, QStringLiteral("IntensityLevelCount")},
                        {0x002C, QStringLiteral("IsProgrammable")},
                        {0x002D, QStringLiteral("InputBinding")},
                        {0x0050, QStringLiteral("LampMultiUpdateReport")},
                        {0x0051, QStringLiteral("RedUpdateChannel")},
                        {0x0052, QStringLiteral("GreenUpdateChannel")},
                        {0x0053, QStringLiteral("BlueUpdateChannel")},
                        {0x0054, QStringLiteral("IntensityUpdateChannel")},
                        {0x0055, QStringLiteral("LampUpdateFlags")},
                        {0x0060, QStringLiteral("LampRangeUpdateReport")},
                        {0x0061, QStringLiteral("LampIdStart")},
                        {0x0062, QStringLiteral("LampIdEnd")},
                        {0x0070, QStringLiteral("LampArrayControlReport")},
                        {0x0071, QStringLiteral("AutonomousMode")},
                }},
        {0x008E,
                QStringLiteral("Magnetic Stripe Reader"),
                {
                        {0x0001, QStringLiteral("MSR Device Read-Only")},
                        {0x0011, QStringLiteral("Track 1 Length")},
                        {0x0012, QStringLiteral("Track 2 Length")},
                        {0x0013, QStringLiteral("Track 3 Length")},
                        {0x0014, QStringLiteral("Track JIS Length")},
                        {0x0020, QStringLiteral("Track Data")},
                        {0x0021, QStringLiteral("Track 1 Data")},
                        {0x0022, QStringLiteral("Track 2 Data")},
                        {0x0023, QStringLiteral("Track 3 Data")},
                        {0x0024, QStringLiteral("Track JIS Data")},
                }},
        {0x0040,
                QStringLiteral("Medical Instrument"),
                {
                        {0x0001, QStringLiteral("Medical Ultrasound")},
                        {0x0020, QStringLiteral("VCR/Acquisition")},
                        {0x0021, QStringLiteral("Freeze/Thaw")},
                        {0x0022, QStringLiteral("Clip Store")},
                        {0x0023, QStringLiteral("Update")},
                        {0x0024, QStringLiteral("Next")},
                        {0x0025, QStringLiteral("Save")},
                        {0x0026, QStringLiteral("Print")},
                        {0x0027, QStringLiteral("Microphone Enable")},
                        {0x0040, QStringLiteral("Cine")},
                        {0x0041, QStringLiteral("Transmit Power")},
                        {0x0042, QStringLiteral("Volume")},
                        {0x0043, QStringLiteral("Focus")},
                        {0x0044, QStringLiteral("Depth")},
                        {0x0060, QStringLiteral("Soft Step - Primary")},
                        {0x0061, QStringLiteral("Soft Step - Secondary")},
                        {0x0070, QStringLiteral("Depth Gain Compensation")},
                        {0x0080, QStringLiteral("Zoom Select")},
                        {0x0081, QStringLiteral("Zoom Adjust")},
                        {0x0082,
                                QStringLiteral("Spectral Doppler Mode Select")},
                        {0x0083, QStringLiteral("Spectral Doppler Adjust")},
                        {0x0084, QStringLiteral("Color Doppler Mode Select")},
                        {0x0085, QStringLiteral("Color Doppler Adjust")},
                        {0x0086, QStringLiteral("Motion Mode Select")},
                        {0x0087, QStringLiteral("Motion Mode Adjust")},
                        {0x0088, QStringLiteral("2-D Mode Select")},
                        {0x0089, QStringLiteral("2-D Mode Adjust")},
                        {0x00A0, QStringLiteral("Soft Control Select")},
                        {0x00A1, QStringLiteral("Soft Control Adjust")},
                }},
        {0x0080,
                QStringLiteral("Monitor"),
                {
                        {0x0001, QStringLiteral("Monitor Control")},
                        {0x0002, QStringLiteral("EDID Information")},
                        {0x0003, QStringLiteral("VDIF Information")},
                        {0x0004, QStringLiteral("VESA Version")},
                }},
        {0x0081, QStringLiteral("Monitor Enumerated"), {}},
        {0x000A, QStringLiteral("Ordinal"), {}},
        {0x000F,
                QStringLiteral("Physical Input Device"),
                {
                        {0x0001, QStringLiteral("Physical Input Device")},
                        {0x0020, QStringLiteral("Normal")},
                        {0x0021, QStringLiteral("Set Effect Report")},
                        {0x0022,
                                QStringLiteral("Effect Parameter Block Index")},
                        {0x0023, QStringLiteral("Parameter Block Offset")},
                        {0x0024, QStringLiteral("ROM Flag")},
                        {0x0025, QStringLiteral("Effect Type")},
                        {0x0026, QStringLiteral("ET Constant-Force")},
                        {0x0027, QStringLiteral("ET Ramp")},
                        {0x0028, QStringLiteral("ET Custom-Force")},
                        {0x0030, QStringLiteral("ET Square")},
                        {0x0031, QStringLiteral("ET Sine")},
                        {0x0032, QStringLiteral("ET Triangle")},
                        {0x0033, QStringLiteral("ET Sawtooth Up")},
                        {0x0034, QStringLiteral("ET Sawtooth Down")},
                        {0x0040, QStringLiteral("ET Spring")},
                        {0x0041, QStringLiteral("ET Damper")},
                        {0x0042, QStringLiteral("ET Inertia")},
                        {0x0043, QStringLiteral("ET Friction")},
                        {0x0050, QStringLiteral("Duration")},
                        {0x0051, QStringLiteral("Sample Period")},
                        {0x0052, QStringLiteral("Gain")},
                        {0x0053, QStringLiteral("Trigger Button")},
                        {0x0054, QStringLiteral("Trigger Repeat Interval")},
                        {0x0055, QStringLiteral("Axes Enable")},
                        {0x0056, QStringLiteral("Direction Enable")},
                        {0x0057, QStringLiteral("Direction")},
                        {0x0058, QStringLiteral("Type Specific Block Offset")},
                        {0x0059, QStringLiteral("Block Type")},
                        {0x005A, QStringLiteral("Set Envelope Report")},
                        {0x005B, QStringLiteral("Attack Level")},
                        {0x005C, QStringLiteral("Attack Time")},
                        {0x005D, QStringLiteral("Fade Level")},
                        {0x005E, QStringLiteral("Fade Time")},
                        {0x005F, QStringLiteral("Set Condition Report")},
                        {0x0060, QStringLiteral("Center-Point Offset")},
                        {0x0061, QStringLiteral("Positive Coefficient")},
                        {0x0062, QStringLiteral("Negative Coefficient")},
                        {0x0063, QStringLiteral("Positive Saturation")},
                        {0x0064, QStringLiteral("Negative Saturation")},
                        {0x0065, QStringLiteral("Dead Band")},
                        {0x0066, QStringLiteral("Download Force Sample")},
                        {0x0067, QStringLiteral("Isoch Custom-Force Enable")},
                        {0x0068, QStringLiteral("Custom-Force Data Report")},
                        {0x0069, QStringLiteral("Custom-Force Data")},
                        {0x006A,
                                QStringLiteral(
                                        "Custom-Force Vendor Defined Data")},
                        {0x006B, QStringLiteral("Set Custom-Force Report")},
                        {0x006C, QStringLiteral("Custom-Force Data Offset")},
                        {0x006D, QStringLiteral("Sample Count")},
                        {0x006E, QStringLiteral("Set Periodic Report")},
                        {0x006F, QStringLiteral("Offset")},
                        {0x0070, QStringLiteral("Magnitude")},
                        {0x0071, QStringLiteral("Phase")},
                        {0x0072, QStringLiteral("Period")},
                        {0x0073, QStringLiteral("Set Constant-Force Report")},
                        {0x0074, QStringLiteral("Set Ramp-Force Report")},
                        {0x0075, QStringLiteral("Ramp Start")},
                        {0x0076, QStringLiteral("Ramp End")},
                        {0x0077, QStringLiteral("Effect Operation Report")},
                        {0x0078, QStringLiteral("Effect Operation")},
                        {0x0079, QStringLiteral("Op Effect Start")},
                        {0x007A, QStringLiteral("Op Effect Start Solo")},
                        {0x007B, QStringLiteral("Op Effect Stop")},
                        {0x007C, QStringLiteral("Loop Count")},
                        {0x007D, QStringLiteral("Device Gain Report")},
                        {0x007E, QStringLiteral("Device Gain")},
                        {0x007F,
                                QStringLiteral("Parameter Block Pools Report")},
                        {0x0080, QStringLiteral("RAM Pool Size")},
                        {0x0081, QStringLiteral("ROM Pool Size")},
                        {0x0082, QStringLiteral("ROM Effect Block Count")},
                        {0x0083, QStringLiteral("Simultaneous Effects Max")},
                        {0x0084, QStringLiteral("Pool Alignment")},
                        {0x0085, QStringLiteral("Parameter Block Move Report")},
                        {0x0086, QStringLiteral("Move Source")},
                        {0x0087, QStringLiteral("Move Destination")},
                        {0x0088, QStringLiteral("Move Length")},
                        {0x0089,
                                QStringLiteral(
                                        "Effect Parameter Block Load Report")},
                        {0x008B,
                                QStringLiteral(
                                        "Effect Parameter Block Load Status")},
                        {0x008C, QStringLiteral("Block Load Success")},
                        {0x008D, QStringLiteral("Block Load Full")},
                        {0x008E, QStringLiteral("Block Load Error")},
                        {0x008F, QStringLiteral("Block Handle")},
                        {0x0090,
                                QStringLiteral(
                                        "Effect Parameter Block Free Report")},
                        {0x0091, QStringLiteral("Type Specific Block Handle")},
                        {0x0092, QStringLiteral("PID State Report")},
                        {0x0094, QStringLiteral("Effect Playing")},
                        {0x0095, QStringLiteral("PID Device Control Report")},
                        {0x0096, QStringLiteral("PID Device Control")},
                        {0x0097, QStringLiteral("DC Enable Actuators")},
                        {0x0098, QStringLiteral("DC Disable Actuators")},
                        {0x0099, QStringLiteral("DC Stop All Effects")},
                        {0x009A, QStringLiteral("DC Reset")},
                        {0x009B, QStringLiteral("DC Pause")},
                        {0x009C, QStringLiteral("DC Continue")},
                        {0x009F, QStringLiteral("Device Paused")},
                        {0x00A0, QStringLiteral("Actuators Enabled")},
                        {0x00A4, QStringLiteral("Safety Switch")},
                        {0x00A5, QStringLiteral("Actuator Override Switch")},
                        {0x00A6, QStringLiteral("Actuator Power")},
                        {0x00A7, QStringLiteral("Start Delay")},
                        {0x00A8, QStringLiteral("Parameter Block Size")},
                        {0x00A9, QStringLiteral("Device-Managed Pool")},
                        {0x00AA, QStringLiteral("Shared Parameter Blocks")},
                        {0x00AB,
                                QStringLiteral("Create New Effect Parameter "
                                               "Block Report")},
                        {0x00AC, QStringLiteral("RAM Pool Available")},
                }},
        {0x0084,
                QStringLiteral("Power"),
                {
                        {0x0001, QStringLiteral("iName")},
                        {0x0002, QStringLiteral("Present Status")},
                        {0x0003, QStringLiteral("Changed Status")},
                        {0x0004, QStringLiteral("UPS")},
                        {0x0005, QStringLiteral("Power Supply")},
                        {0x0010, QStringLiteral("Battery System")},
                        {0x0011, QStringLiteral("Battery System Id")},
                        {0x0012, QStringLiteral("Battery")},
                        {0x0013, QStringLiteral("Battery Id")},
                        {0x0014, QStringLiteral("Charger")},
                        {0x0015, QStringLiteral("Charger Id")},
                        {0x0016, QStringLiteral("Power Converter")},
                        {0x0017, QStringLiteral("Power Converter Id")},
                        {0x0018, QStringLiteral("Outlet System")},
                        {0x0019, QStringLiteral("Outlet System Id")},
                        {0x001A, QStringLiteral("Input")},
                        {0x001B, QStringLiteral("Input Id")},
                        {0x001C, QStringLiteral("Output")},
                        {0x001D, QStringLiteral("Output Id")},
                        {0x001E, QStringLiteral("Flow")},
                        {0x001F, QStringLiteral("Flow Id")},
                        {0x0020, QStringLiteral("Outlet")},
                        {0x0021, QStringLiteral("Outlet Id")},
                        {0x0022, QStringLiteral("Gang")},
                        {0x0023, QStringLiteral("Gang Id")},
                        {0x0024, QStringLiteral("Power Summary")},
                        {0x0025, QStringLiteral("Power Summary Id")},
                        {0x0030, QStringLiteral("Voltage")},
                        {0x0031, QStringLiteral("Current")},
                        {0x0032, QStringLiteral("Frequency")},
                        {0x0033, QStringLiteral("Apparent Power")},
                        {0x0034, QStringLiteral("Active Power")},
                        {0x0035, QStringLiteral("Percent Load")},
                        {0x0036, QStringLiteral("Temperature")},
                        {0x0037, QStringLiteral("Humidity")},
                        {0x0038, QStringLiteral("Bad Count")},
                        {0x0040, QStringLiteral("Config Voltage")},
                        {0x0041, QStringLiteral("Config Current")},
                        {0x0042, QStringLiteral("Config Frequency")},
                        {0x0043, QStringLiteral("Config Apparent Power")},
                        {0x0044, QStringLiteral("Config Active Power")},
                        {0x0045, QStringLiteral("Config Percent Load")},
                        {0x0046, QStringLiteral("Config Temperature")},
                        {0x0047, QStringLiteral("Config Humidity")},
                        {0x0050, QStringLiteral("Switch On Control")},
                        {0x0051, QStringLiteral("Switch Off Control")},
                        {0x0052, QStringLiteral("Toggle Control")},
                        {0x0053, QStringLiteral("Low Voltage Transfer")},
                        {0x0054, QStringLiteral("High Voltage Transfer")},
                        {0x0055, QStringLiteral("Delay Before Reboot")},
                        {0x0056, QStringLiteral("Delay Before Startup")},
                        {0x0057, QStringLiteral("Delay Before Shutdown")},
                        {0x0058, QStringLiteral("Test")},
                        {0x0059, QStringLiteral("Module Reset")},
                        {0x005A, QStringLiteral("Audible Alarm Control")},
                        {0x0060, QStringLiteral("Present")},
                        {0x0061, QStringLiteral("Good")},
                        {0x0062, QStringLiteral("Internal Failure")},
                        {0x0063, QStringLiteral("Voltag Out Of Range")},
                        {0x0064, QStringLiteral("Frequency Out Of Range")},
                        {0x0065, QStringLiteral("Overload")},
                        {0x0066, QStringLiteral("Over Charged")},
                        {0x0067, QStringLiteral("Over Temperature")},
                        {0x0068, QStringLiteral("Shutdown Requested")},
                        {0x0069, QStringLiteral("Shutdown Imminent")},
                        {0x006B, QStringLiteral("Switch On/Off")},
                        {0x006C, QStringLiteral("Switchable")},
                        {0x006D, QStringLiteral("Used")},
                        {0x006E, QStringLiteral("Boost")},
                        {0x006F, QStringLiteral("Buck")},
                        {0x0070, QStringLiteral("Initialized")},
                        {0x0071, QStringLiteral("Tested")},
                        {0x0072, QStringLiteral("Awaiting Power")},
                        {0x0073, QStringLiteral("Communication Lost")},
                        {0x00FD, QStringLiteral("iManufacturer")},
                        {0x00FE, QStringLiteral("iProduct")},
                        {0x00FF, QStringLiteral("iSerialNumber")},
                }},
        {0x008D,
                QStringLiteral("Scales"),
                {
                        {0x0001, QStringLiteral("Scales")},
                        {0x0020, QStringLiteral("Scale Device")},
                        {0x0021, QStringLiteral("Scale Class")},
                        {0x0022, QStringLiteral("Scale Class I Metric")},
                        {0x0023, QStringLiteral("Scale Class II Metric")},
                        {0x0024, QStringLiteral("Scale Class III Metric")},
                        {0x0025, QStringLiteral("Scale Class IIIL Metric")},
                        {0x0026, QStringLiteral("Scale Class IV Metric")},
                        {0x0027, QStringLiteral("Scale Class III English")},
                        {0x0028, QStringLiteral("Scale Class IIIL English")},
                        {0x0029, QStringLiteral("Scale Class IV English")},
                        {0x002A, QStringLiteral("Scale Class Generic")},
                        {0x0030, QStringLiteral("Scale Attribute Report")},
                        {0x0031, QStringLiteral("Scale Control Report")},
                        {0x0032, QStringLiteral("Scale Data Report")},
                        {0x0033, QStringLiteral("Scale Status Report")},
                        {0x0034, QStringLiteral("Scale Weight Limit Report")},
                        {0x0035, QStringLiteral("Scale Statistics Report")},
                        {0x0040, QStringLiteral("Data Weight")},
                        {0x0041, QStringLiteral("Data Scaling")},
                        {0x0050, QStringLiteral("Weight Unit")},
                        {0x0051, QStringLiteral("Weight Unit Milligram")},
                        {0x0052, QStringLiteral("Weight Unit Gram")},
                        {0x0053, QStringLiteral("Weight Unit Kilogram")},
                        {0x0054, QStringLiteral("Weight Unit Carats")},
                        {0x0055, QStringLiteral("Weight Unit Taels")},
                        {0x0056, QStringLiteral("Weight Unit Grains")},
                        {0x0057, QStringLiteral("Weight Unit Pennyweights")},
                        {0x0058, QStringLiteral("Weight Unit Metric Ton")},
                        {0x0059, QStringLiteral("Weight Unit Avoir Ton")},
                        {0x005A, QStringLiteral("Weight Unit Troy Ounce")},
                        {0x005B, QStringLiteral("Weight Unit Ounce")},
                        {0x005C, QStringLiteral("Weight Unit Pound")},
                        {0x0060, QStringLiteral("Calibration Count")},
                        {0x0061, QStringLiteral("Re-Zero Count")},
                        {0x0070, QStringLiteral("Scale Status")},
                        {0x0071, QStringLiteral("Scale Status Fault")},
                        {0x0072,
                                QStringLiteral("Scale Status Stable at Center "
                                               "of Zero")},
                        {0x0073, QStringLiteral("Scale Status In Motion")},
                        {0x0074, QStringLiteral("Scale Status Weight Stable")},
                        {0x0075, QStringLiteral("Scale Status Under Zero")},
                        {0x0076,
                                QStringLiteral(
                                        "Scale Status Over Weight Limit")},
                        {0x0077,
                                QStringLiteral(
                                        "Scale Status Requires Calibration")},
                        {0x0078,
                                QStringLiteral(
                                        "Scale Status Requires Rezeroing")},
                        {0x0080, QStringLiteral("Zero Scale")},
                        {0x0081, QStringLiteral("Enforced Zero Return")},
                }},
        {0x0020,
                QStringLiteral("Sensors"),
                {
                        {0x0001, QStringLiteral("Sensor")},
                        {0x0010, QStringLiteral("Biometric")},
                        {0x0011, QStringLiteral("Biometric: Human Presence")},
                        {0x0012, QStringLiteral("Biometric: Human Proximity")},
                        {0x0013, QStringLiteral("Biometric: Human Touch")},
                        {0x0014, QStringLiteral("Biometric: Blood Pressure")},
                        {0x0015, QStringLiteral("Biometric: Body Temperature")},
                        {0x0016, QStringLiteral("Biometric: Heart Rate")},
                        {0x0017,
                                QStringLiteral(
                                        "Biometric: Heart Rate Variability")},
                        {0x0018,
                                QStringLiteral("Biometric: Peripheral Oxygen "
                                               "Saturation")},
                        {0x0019, QStringLiteral("Biometric: Respiratory Rate")},
                        {0x0020, QStringLiteral("Electrical")},
                        {0x0021, QStringLiteral("Electrical: Capacitance")},
                        {0x0022, QStringLiteral("Electrical: Current")},
                        {0x0023, QStringLiteral("Electrical: Power")},
                        {0x0024, QStringLiteral("Electrical: Inductance")},
                        {0x0025, QStringLiteral("Electrical: Resistance")},
                        {0x0026, QStringLiteral("Electrical: Voltage")},
                        {0x0027, QStringLiteral("Electrical: Potentiometer")},
                        {0x0028, QStringLiteral("Electrical: Frequency")},
                        {0x0029, QStringLiteral("Electrical: Period")},
                        {0x0030, QStringLiteral("Environmental")},
                        {0x0031,
                                QStringLiteral(
                                        "Environmental: Atmospheric Pressure")},
                        {0x0032, QStringLiteral("Environmental: Humidity")},
                        {0x0033, QStringLiteral("Environmental: Temperature")},
                        {0x0034,
                                QStringLiteral(
                                        "Environmental: Wind Direction")},
                        {0x0035, QStringLiteral("Environmental: Wind Speed")},
                        {0x0036, QStringLiteral("Environmental: Air Quality")},
                        {0x0037, QStringLiteral("Environmental: Heat Index")},
                        {0x0038,
                                QStringLiteral(
                                        "Environmental: Surface Temperature")},
                        {0x0039,
                                QStringLiteral("Environmental: Volatile "
                                               "Organic Compounds")},
                        {0x003A,
                                QStringLiteral(
                                        "Environmental: Object Presence")},
                        {0x003B,
                                QStringLiteral(
                                        "Environmental: Object Proximity")},
                        {0x0040, QStringLiteral("Light")},
                        {0x0041, QStringLiteral("Light: Ambient Light")},
                        {0x0042, QStringLiteral("Light: Consumer Infrared")},
                        {0x0043, QStringLiteral("Light: Infrared Light")},
                        {0x0044, QStringLiteral("Light: Visible Light")},
                        {0x0045, QStringLiteral("Light: Ultraviolet Light")},
                        {0x0050, QStringLiteral("Location")},
                        {0x0051, QStringLiteral("Location: Broadcast")},
                        {0x0052, QStringLiteral("Location: Dead Reckoning")},
                        {0x0053,
                                QStringLiteral("Location: GPS (Global "
                                               "Positioning System)")},
                        {0x0054, QStringLiteral("Location: Lookup")},
                        {0x0055, QStringLiteral("Location: Other")},
                        {0x0056, QStringLiteral("Location: Static")},
                        {0x0057, QStringLiteral("Location: Triangulation")},
                        {0x0060, QStringLiteral("Mechanical")},
                        {0x0061, QStringLiteral("Mechanical: Boolean Switch")},
                        {0x0062,
                                QStringLiteral(
                                        "Mechanical: Boolean Switch Array")},
                        {0x0063,
                                QStringLiteral(
                                        "Mechanical: Multivalue Switch")},
                        {0x0064, QStringLiteral("Mechanical: Force")},
                        {0x0065, QStringLiteral("Mechanical: Pressure")},
                        {0x0066, QStringLiteral("Mechanical: Strain")},
                        {0x0067, QStringLiteral("Mechanical: Weight")},
                        {0x0068, QStringLiteral("Mechanical: Haptic Vibrator")},
                        {0x0069,
                                QStringLiteral(
                                        "Mechanical: Hall Effect Switch")},
                        {0x0070, QStringLiteral("Motion")},
                        {0x0071, QStringLiteral("Motion: Accelerometer 1D")},
                        {0x0072, QStringLiteral("Motion: Accelerometer 2D")},
                        {0x0073, QStringLiteral("Motion: Accelerometer 3D")},
                        {0x0074, QStringLiteral("Motion: Gyrometer 1D")},
                        {0x0075, QStringLiteral("Motion: Gyrometer 2D")},
                        {0x0076, QStringLiteral("Motion: Gyrometer 3D")},
                        {0x0077, QStringLiteral("Motion: Motion Detector")},
                        {0x0078, QStringLiteral("Motion: Speedometer")},
                        {0x0079, QStringLiteral("Motion: Accelerometer")},
                        {0x007A, QStringLiteral("Motion: Gyrometer")},
                        {0x007B, QStringLiteral("Motion: Gravity Vector")},
                        {0x007C,
                                QStringLiteral("Motion: Linear Accelerometer")},
                        {0x0080, QStringLiteral("Orientation")},
                        {0x0081, QStringLiteral("Orientation: Compass 1D")},
                        {0x0082, QStringLiteral("Orientation: Compass 2D")},
                        {0x0083, QStringLiteral("Orientation: Compass 3D")},
                        {0x0084,
                                QStringLiteral("Orientation: Inclinometer 1D")},
                        {0x0085,
                                QStringLiteral("Orientation: Inclinometer 2D")},
                        {0x0086,
                                QStringLiteral("Orientation: Inclinometer 3D")},
                        {0x0087, QStringLiteral("Orientation: Distance 1D")},
                        {0x0088, QStringLiteral("Orientation: Distance 2D")},
                        {0x0089, QStringLiteral("Orientation: Distance 3D")},
                        {0x008A,
                                QStringLiteral(
                                        "Orientation: Device Orientation")},
                        {0x008B, QStringLiteral("Orientation: Compass")},
                        {0x008C, QStringLiteral("Orientation: Inclinometer")},
                        {0x008D, QStringLiteral("Orientation: Distance")},
                        {0x008E,
                                QStringLiteral(
                                        "Orientation: Relative Orientation")},
                        {0x008F,
                                QStringLiteral(
                                        "Orientation: Simple Orientation")},
                        {0x0090, QStringLiteral("Scanner")},
                        {0x0091, QStringLiteral("Scanner: Barcode")},
                        {0x0092, QStringLiteral("Scanner: RFID")},
                        {0x0093, QStringLiteral("Scanner: NFC")},
                        {0x00A0, QStringLiteral("Time")},
                        {0x00A1, QStringLiteral("Time: Alarm Timer")},
                        {0x00A2, QStringLiteral("Time: Real Time Clock")},
                        {0x00B0, QStringLiteral("Personal Activity")},
                        {0x00B1,
                                QStringLiteral("Personal Activity: Activity "
                                               "Detection")},
                        {0x00B2,
                                QStringLiteral(
                                        "Personal Activity: Device Position")},
                        {0x00B3,
                                QStringLiteral(
                                        "Personal Activity: Floor Tracker")},
                        {0x00B4,
                                QStringLiteral("Personal Activity: Pedometer")},
                        {0x00B5,
                                QStringLiteral(
                                        "Personal Activity: Step Detection")},
                        {0x00C0, QStringLiteral("Orientation Extended")},
                        {0x00C1,
                                QStringLiteral("Orientation Extended: "
                                               "Geomagnetic Orientation")},
                        {0x00C2,
                                QStringLiteral(
                                        "Orientation Extended: Magnetometer")},
                        {0x00D0, QStringLiteral("Gesture")},
                        {0x00D1,
                                QStringLiteral(
                                        "Gesture: Chassis Flip Gesture")},
                        {0x00D2, QStringLiteral("Gesture: Hinge Fold Gesture")},
                        {0x00E0, QStringLiteral("Other")},
                        {0x00E1, QStringLiteral("Other: Custom")},
                        {0x00E2, QStringLiteral("Other: Generic")},
                        {0x00E3, QStringLiteral("Other: Generic Enumerator")},
                        {0x00E4, QStringLiteral("Other: Hinge Angle")},
                        {0x00F0, QStringLiteral("Vendor Reserved 1")},
                        {0x00F1, QStringLiteral("Vendor Reserved 2")},
                        {0x00F2, QStringLiteral("Vendor Reserved 3")},
                        {0x00F3, QStringLiteral("Vendor Reserved 4")},
                        {0x00F4, QStringLiteral("Vendor Reserved 5")},
                        {0x00F5, QStringLiteral("Vendor Reserved 6")},
                        {0x00F6, QStringLiteral("Vendor Reserved 7")},
                        {0x00F7, QStringLiteral("Vendor Reserved 8")},
                        {0x00F8, QStringLiteral("Vendor Reserved 9")},
                        {0x00F9, QStringLiteral("Vendor Reserved 10")},
                        {0x00FA, QStringLiteral("Vendor Reserved 11")},
                        {0x00FB, QStringLiteral("Vendor Reserved 12")},
                        {0x00FC, QStringLiteral("Vendor Reserved 13")},
                        {0x00FD, QStringLiteral("Vendor Reserved 14")},
                        {0x00FE, QStringLiteral("Vendor Reserved 15")},
                        {0x00FF, QStringLiteral("Vendor Reserved 16")},
                        {0x0200, QStringLiteral("Event")},
                        {0x0201, QStringLiteral("Event: Sensor State")},
                        {0x0202, QStringLiteral("Event: Sensor Event")},
                        {0x0300, QStringLiteral("Property")},
                        {0x0301, QStringLiteral("Property: Friendly Name")},
                        {0x0302,
                                QStringLiteral(
                                        "Property: Persistent Unique ID")},
                        {0x0303, QStringLiteral("Property: Sensor Status")},
                        {0x0304,
                                QStringLiteral(
                                        "Property: Minimum Report Interval")},
                        {0x0305,
                                QStringLiteral(
                                        "Property: Sensor Manufacturer")},
                        {0x0306, QStringLiteral("Property: Sensor Model")},
                        {0x0307,
                                QStringLiteral(
                                        "Property: Sensor Serial Number")},
                        {0x0308,
                                QStringLiteral("Property: Sensor Description")},
                        {0x0309,
                                QStringLiteral(
                                        "Property: Sensor Connection Type")},
                        {0x030A,
                                QStringLiteral("Property: Sensor Device Path")},
                        {0x030B, QStringLiteral("Property: Hardware Revision")},
                        {0x030C, QStringLiteral("Property: Firmware Version")},
                        {0x030D, QStringLiteral("Property: Release Date")},
                        {0x030E, QStringLiteral("Property: Report Interval")},
                        {0x030F,
                                QStringLiteral("Property: Change Sensitivity "
                                               "Absolute")},
                        {0x0310,
                                QStringLiteral("Property: Change Sensitivity "
                                               "Percent of Range")},
                        {0x0311,
                                QStringLiteral("Property: Change Sensitivity "
                                               "Percent Relative")},
                        {0x0312, QStringLiteral("Property: Accuracy")},
                        {0x0313, QStringLiteral("Property: Resolution")},
                        {0x0314, QStringLiteral("Property: Maximum")},
                        {0x0315, QStringLiteral("Property: Minimum")},
                        {0x0316, QStringLiteral("Property: Reporting State")},
                        {0x0317, QStringLiteral("Property: Sampling Rate")},
                        {0x0318, QStringLiteral("Property: Response Curve")},
                        {0x0319, QStringLiteral("Property: Power State")},
                        {0x031A,
                                QStringLiteral(
                                        "Property: Maximum FIFO Events")},
                        {0x031B, QStringLiteral("Property: Report Latency")},
                        {0x031C, QStringLiteral("Property: Flush FIFO Events")},
                        {0x031D,
                                QStringLiteral(
                                        "Property: Maximum Power Consumption")},
                        {0x031E, QStringLiteral("Property: Is Primary")},
                        {0x031F,
                                QStringLiteral("Property: Human Presence "
                                               "Detection Type")},
                        {0x0400, QStringLiteral("Data Field: Location")},
                        {0x0402,
                                QStringLiteral("Data Field: Altitude Antenna "
                                               "Sea Level")},
                        {0x0403,
                                QStringLiteral("Data Field: Differential "
                                               "Reference Station ID")},
                        {0x0404,
                                QStringLiteral("Data Field: Altitude Ellipsoid "
                                               "Error")},
                        {0x0405,
                                QStringLiteral(
                                        "Data Field: Altitude Ellipsoid")},
                        {0x0406,
                                QStringLiteral("Data Field: Altitude Sea Level "
                                               "Error")},
                        {0x0407,
                                QStringLiteral(
                                        "Data Field: Altitude Sea Level")},
                        {0x0408,
                                QStringLiteral("Data Field: Differential GPS "
                                               "Data Age")},
                        {0x0409, QStringLiteral("Data Field: Error Radius")},
                        {0x040A, QStringLiteral("Data Field: Fix Quality")},
                        {0x040B, QStringLiteral("Data Field: Fix Type")},
                        {0x040C,
                                QStringLiteral(
                                        "Data Field: Geoidal Separation")},
                        {0x040D,
                                QStringLiteral(
                                        "Data Field: GPS Operation Mode")},
                        {0x040E,
                                QStringLiteral(
                                        "Data Field: GPS Selection Mode")},
                        {0x040F, QStringLiteral("Data Field: GPS Status")},
                        {0x0410,
                                QStringLiteral("Data Field: Position Dilution "
                                               "of Precision")},
                        {0x0411,
                                QStringLiteral("Data Field: Horizontal "
                                               "Dilution of Precision")},
                        {0x0412,
                                QStringLiteral("Data Field: Vertical Dilution "
                                               "of Precision")},
                        {0x0413, QStringLiteral("Data Field: Latitude")},
                        {0x0414, QStringLiteral("Data Field: Longitude")},
                        {0x0415, QStringLiteral("Data Field: True Heading")},
                        {0x0416,
                                QStringLiteral("Data Field: Magnetic Heading")},
                        {0x0417,
                                QStringLiteral(
                                        "Data Field: Magnetic Variation")},
                        {0x0418, QStringLiteral("Data Field: Speed")},
                        {0x0419,
                                QStringLiteral(
                                        "Data Field: Satellites in View")},
                        {0x041A,
                                QStringLiteral("Data Field: Satellites in View "
                                               "Azimuth")},
                        {0x041B,
                                QStringLiteral("Data Field: Satellites in View "
                                               "Elevation")},
                        {0x041C,
                                QStringLiteral(
                                        "Data Field: Satellites in View IDs")},
                        {0x041D,
                                QStringLiteral(
                                        "Data Field: Satellites in View PRNs")},
                        {0x041E,
                                QStringLiteral("Data Field: Satellites in View "
                                               "S/N Ratios")},
                        {0x041F,
                                QStringLiteral(
                                        "Data Field: Satellites Used Count")},
                        {0x0420,
                                QStringLiteral(
                                        "Data Field: Satellites Used PRNs")},
                        {0x0421, QStringLiteral("Data Field: NMEA Sentence")},
                        {0x0422, QStringLiteral("Data Field: Address Line 1")},
                        {0x0423, QStringLiteral("Data Field: Address Line 2")},
                        {0x0424, QStringLiteral("Data Field: City")},
                        {0x0425,
                                QStringLiteral(
                                        "Data Field: State or Province")},
                        {0x0426,
                                QStringLiteral(
                                        "Data Field: Country or Region")},
                        {0x0427, QStringLiteral("Data Field: Postal Code")},
                        {0x042A, QStringLiteral("Property: Location")},
                        {0x042B,
                                QStringLiteral(
                                        "Property: Location Desired Accuracy")},
                        {0x0430, QStringLiteral("Data Field: Environmental")},
                        {0x0431,
                                QStringLiteral(
                                        "Data Field: Atmospheric Pressure")},
                        {0x0433,
                                QStringLiteral(
                                        "Data Field: Relative Humidity")},
                        {0x0434, QStringLiteral("Data Field: Temperature")},
                        {0x0435, QStringLiteral("Data Field: Wind Direction")},
                        {0x0436, QStringLiteral("Data Field: Wind Speed")},
                        {0x0437,
                                QStringLiteral(
                                        "Data Field: Air Quality Index")},
                        {0x0438, QStringLiteral("Data Field: Equivalent CO2")},
                        {0x0439,
                                QStringLiteral("Data Field: Volatile Organic "
                                               "Compound Concentration")},
                        {0x043A, QStringLiteral("Data Field: Object Presence")},
                        {0x043B,
                                QStringLiteral(
                                        "Data Field: Object Proximity Range")},
                        {0x043C,
                                QStringLiteral("Data Field: Object Proximity "
                                               "Out of Range")},
                        {0x0440, QStringLiteral("Property: Environmental")},
                        {0x0441,
                                QStringLiteral("Property: Reference Pressure")},
                        {0x0450, QStringLiteral("Data Field: Motion")},
                        {0x0451, QStringLiteral("Data Field: Motion State")},
                        {0x0452, QStringLiteral("Data Field: Acceleration")},
                        {0x0453,
                                QStringLiteral(
                                        "Data Field: Acceleration Axis X")},
                        {0x0454,
                                QStringLiteral(
                                        "Data Field: Acceleration Axis Y")},
                        {0x0455,
                                QStringLiteral(
                                        "Data Field: Acceleration Axis Z")},
                        {0x0456,
                                QStringLiteral("Data Field: Angular Velocity")},
                        {0x0457,
                                QStringLiteral("Data Field: Angular Velocity "
                                               "about X Axis")},
                        {0x0458,
                                QStringLiteral("Data Field: Angular Velocity "
                                               "about Y Axis")},
                        {0x0459,
                                QStringLiteral("Data Field: Angular Velocity "
                                               "about Z Axis")},
                        {0x045A,
                                QStringLiteral("Data Field: Angular Position")},
                        {0x045B,
                                QStringLiteral("Data Field: Angular Position "
                                               "about X Axis")},
                        {0x045C,
                                QStringLiteral("Data Field: Angular Position "
                                               "about Y Axis")},
                        {0x045D,
                                QStringLiteral("Data Field: Angular Position "
                                               "about Z Axis")},
                        {0x045E, QStringLiteral("Data Field: Motion Speed")},
                        {0x045F,
                                QStringLiteral("Data Field: Motion Intensity")},
                        {0x0470, QStringLiteral("Data Field: Orientation")},
                        {0x0471, QStringLiteral("Data Field: Heading")},
                        {0x0472, QStringLiteral("Data Field: Heading X Axis")},
                        {0x0473, QStringLiteral("Data Field: Heading Y Axis")},
                        {0x0474, QStringLiteral("Data Field: Heading Z Axis")},
                        {0x0475,
                                QStringLiteral("Data Field: Heading "
                                               "Compensated Magnetic North")},
                        {0x0476,
                                QStringLiteral("Data Field: Heading "
                                               "Compensated True North")},
                        {0x0477,
                                QStringLiteral(
                                        "Data Field: Heading Magnetic North")},
                        {0x0478,
                                QStringLiteral(
                                        "Data Field: Heading True North")},
                        {0x0479, QStringLiteral("Data Field: Distance")},
                        {0x047A, QStringLiteral("Data Field: Distance X Axis")},
                        {0x047B, QStringLiteral("Data Field: Distance Y Axis")},
                        {0x047C, QStringLiteral("Data Field: Distance Z Axis")},
                        {0x047D,
                                QStringLiteral(
                                        "Data Field: Distance Out-of-Range")},
                        {0x047E, QStringLiteral("Data Field: Tilt")},
                        {0x047F, QStringLiteral("Data Field: Tilt X Axis")},
                        {0x0480, QStringLiteral("Data Field: Tilt Y Axis")},
                        {0x0481, QStringLiteral("Data Field: Tilt Z Axis")},
                        {0x0482, QStringLiteral("Data Field: Rotation Matrix")},
                        {0x0483, QStringLiteral("Data Field: Quaternion")},
                        {0x0484, QStringLiteral("Data Field: Magnetic Flux")},
                        {0x0485,
                                QStringLiteral(
                                        "Data Field: Magnetic Flux X Axis")},
                        {0x0486,
                                QStringLiteral(
                                        "Data Field: Magnetic Flux Y Axis")},
                        {0x0487,
                                QStringLiteral(
                                        "Data Field: Magnetic Flux Z Axis")},
                        {0x0488,
                                QStringLiteral(
                                        "Data Field: Magnetometer Accuracy")},
                        {0x0489,
                                QStringLiteral("Data Field: Simple Orientation "
                                               "Direction")},
                        {0x0490, QStringLiteral("Data Field: Mechanical")},
                        {0x0491,
                                QStringLiteral(
                                        "Data Field: Boolean Switch State")},
                        {0x0492,
                                QStringLiteral("Data Field: Boolean Switch "
                                               "Array States")},
                        {0x0493,
                                QStringLiteral(
                                        "Data Field: Multivalue Switch Value")},
                        {0x0494, QStringLiteral("Data Field: Force")},
                        {0x0495,
                                QStringLiteral(
                                        "Data Field: Absolute Pressure")},
                        {0x0496, QStringLiteral("Data Field: Gauge Pressure")},
                        {0x0497, QStringLiteral("Data Field: Strain")},
                        {0x0498, QStringLiteral("Data Field: Weight")},
                        {0x04A0, QStringLiteral("Property: Mechanical")},
                        {0x04A1, QStringLiteral("Property: Vibration State")},
                        {0x04A2,
                                QStringLiteral(
                                        "Property: Forward Vibration Speed")},
                        {0x04A3,
                                QStringLiteral(
                                        "Property: Backward Vibration Speed")},
                        {0x04B0, QStringLiteral("Data Field: Biometric")},
                        {0x04B1, QStringLiteral("Data Field: Human Presence")},
                        {0x04B2,
                                QStringLiteral(
                                        "Data Field: Human Proximity Range")},
                        {0x04B3,
                                QStringLiteral("Data Field: Human Proximity "
                                               "Out of Range")},
                        {0x04B4,
                                QStringLiteral(
                                        "Data Field: Human Touch State")},
                        {0x04B5, QStringLiteral("Data Field: Blood Pressure")},
                        {0x04B6,
                                QStringLiteral("Data Field: Blood Pressure "
                                               "Diastolic")},
                        {0x04B7,
                                QStringLiteral(
                                        "Data Field: Blood Pressure Systolic")},
                        {0x04B8, QStringLiteral("Data Field: Heart Rate")},
                        {0x04B9,
                                QStringLiteral(
                                        "Data Field: Resting Heart Rate")},
                        {0x04BA,
                                QStringLiteral(
                                        "Data Field: Heartbeat Interval")},
                        {0x04BB,
                                QStringLiteral("Data Field: Respiratory Rate")},
                        {0x04BC, QStringLiteral("Data Field: SpO2")},
                        {0x04BD,
                                QStringLiteral("Data Field: Human Attention "
                                               "Detected")},
                        {0x04BE,
                                QStringLiteral(
                                        "Data Field: Human Head Azimuth")},
                        {0x04BF,
                                QStringLiteral(
                                        "Data Field: Human Head Altitude")},
                        {0x04C0, QStringLiteral("Data Field: Human Head Roll")},
                        {0x04C1,
                                QStringLiteral("Data Field: Human Head Pitch")},
                        {0x04C2, QStringLiteral("Data Field: Human Head Yaw")},
                        {0x04C3,
                                QStringLiteral(
                                        "Data Field: Human Correlation Id")},
                        {0x04D0, QStringLiteral("Data Field: Light")},
                        {0x04D1, QStringLiteral("Data Field: Illuminance")},
                        {0x04D2,
                                QStringLiteral(
                                        "Data Field: Color Temperature")},
                        {0x04D3, QStringLiteral("Data Field: Chromaticity")},
                        {0x04D4, QStringLiteral("Data Field: Chromaticity X")},
                        {0x04D5, QStringLiteral("Data Field: Chromaticity Y")},
                        {0x04D6,
                                QStringLiteral("Data Field: Consumer IR "
                                               "Sentence Receive")},
                        {0x04D7, QStringLiteral("Data Field: Infrared Light")},
                        {0x04D8, QStringLiteral("Data Field: Red Light")},
                        {0x04D9, QStringLiteral("Data Field: Green Light")},
                        {0x04DA, QStringLiteral("Data Field: Blue Light")},
                        {0x04DB,
                                QStringLiteral(
                                        "Data Field: Ultraviolet A Light")},
                        {0x04DC,
                                QStringLiteral(
                                        "Data Field: Ultraviolet B Light")},
                        {0x04DD,
                                QStringLiteral(
                                        "Data Field: Ultraviolet Index")},
                        {0x04DE,
                                QStringLiteral(
                                        "Data Field: Near Infrared Light")},
                        {0x04DF, QStringLiteral("Property: Light")},
                        {0x04E0,
                                QStringLiteral(
                                        "Property: Consumer IR Sentence Send")},
                        {0x04E2,
                                QStringLiteral(
                                        "Property: Auto Brightness Preferred")},
                        {0x04E3,
                                QStringLiteral(
                                        "Property: Auto Color Preferred")},
                        {0x04F0, QStringLiteral("Data Field: Scanner")},
                        {0x04F1, QStringLiteral("Data Field: RFID Tag 40 Bit")},
                        {0x04F2,
                                QStringLiteral(
                                        "Data Field: NFC Sentence Receive")},
                        {0x04F8, QStringLiteral("Property: Scanner")},
                        {0x04F9, QStringLiteral("Property: NFC Sentence Send")},
                        {0x0500, QStringLiteral("Data Field: Electrical")},
                        {0x0501, QStringLiteral("Data Field: Capacitance")},
                        {0x0502, QStringLiteral("Data Field: Current")},
                        {0x0503,
                                QStringLiteral("Data Field: Electrical Power")},
                        {0x0504, QStringLiteral("Data Field: Inductance")},
                        {0x0505, QStringLiteral("Data Field: Resistance")},
                        {0x0506, QStringLiteral("Data Field: Voltage")},
                        {0x0507, QStringLiteral("Data Field: Frequency")},
                        {0x0508, QStringLiteral("Data Field: Period")},
                        {0x0509,
                                QStringLiteral("Data Field: Percent of Range")},
                        {0x0520, QStringLiteral("Data Field: Time")},
                        {0x0521, QStringLiteral("Data Field: Year")},
                        {0x0522, QStringLiteral("Data Field: Month")},
                        {0x0523, QStringLiteral("Data Field: Day")},
                        {0x0524, QStringLiteral("Data Field: Day of Week")},
                        {0x0525, QStringLiteral("Data Field: Hour")},
                        {0x0526, QStringLiteral("Data Field: Minute")},
                        {0x0527, QStringLiteral("Data Field: Second")},
                        {0x0528, QStringLiteral("Data Field: Millisecond")},
                        {0x0529, QStringLiteral("Data Field: Timestamp")},
                        {0x052A,
                                QStringLiteral(
                                        "Data Field: Julian Day of Year")},
                        {0x052B,
                                QStringLiteral(
                                        "Data Field: Time Since System Boot")},
                        {0x0530, QStringLiteral("Property: Time")},
                        {0x0531,
                                QStringLiteral(
                                        "Property: Time Zone Offset from UTC")},
                        {0x0532, QStringLiteral("Property: Time Zone Name")},
                        {0x0533,
                                QStringLiteral("Property: Daylight Savings "
                                               "Time Observed")},
                        {0x0534,
                                QStringLiteral(
                                        "Property: Time Trim Adjustment")},
                        {0x0535, QStringLiteral("Property: Arm Alarm")},
                        {0x0540, QStringLiteral("Data Field: Custom")},
                        {0x0541, QStringLiteral("Data Field: Custom Usage")},
                        {0x0542,
                                QStringLiteral(
                                        "Data Field: Custom Boolean Array")},
                        {0x0543, QStringLiteral("Data Field: Custom Value")},
                        {0x0544, QStringLiteral("Data Field: Custom Value 1")},
                        {0x0545, QStringLiteral("Data Field: Custom Value 2")},
                        {0x0546, QStringLiteral("Data Field: Custom Value 3")},
                        {0x0547, QStringLiteral("Data Field: Custom Value 4")},
                        {0x0548, QStringLiteral("Data Field: Custom Value 5")},
                        {0x0549, QStringLiteral("Data Field: Custom Value 6")},
                        {0x054A, QStringLiteral("Data Field: Custom Value 7")},
                        {0x054B, QStringLiteral("Data Field: Custom Value 8")},
                        {0x054C, QStringLiteral("Data Field: Custom Value 9")},
                        {0x054D, QStringLiteral("Data Field: Custom Value 10")},
                        {0x054E, QStringLiteral("Data Field: Custom Value 11")},
                        {0x054F, QStringLiteral("Data Field: Custom Value 12")},
                        {0x0550, QStringLiteral("Data Field: Custom Value 13")},
                        {0x0551, QStringLiteral("Data Field: Custom Value 14")},
                        {0x0552, QStringLiteral("Data Field: Custom Value 15")},
                        {0x0553, QStringLiteral("Data Field: Custom Value 16")},
                        {0x0554, QStringLiteral("Data Field: Custom Value 17")},
                        {0x0555, QStringLiteral("Data Field: Custom Value 18")},
                        {0x0556, QStringLiteral("Data Field: Custom Value 19")},
                        {0x0557, QStringLiteral("Data Field: Custom Value 20")},
                        {0x0558, QStringLiteral("Data Field: Custom Value 21")},
                        {0x0559, QStringLiteral("Data Field: Custom Value 22")},
                        {0x055A, QStringLiteral("Data Field: Custom Value 23")},
                        {0x055B, QStringLiteral("Data Field: Custom Value 24")},
                        {0x055C, QStringLiteral("Data Field: Custom Value 25")},
                        {0x055D, QStringLiteral("Data Field: Custom Value 26")},
                        {0x055E, QStringLiteral("Data Field: Custom Value 27")},
                        {0x055F, QStringLiteral("Data Field: Custom Value 28")},
                        {0x0560, QStringLiteral("Data Field: Generic")},
                        {0x0561,
                                QStringLiteral("Data Field: Generic GUID or "
                                               "PROPERTYKEY")},
                        {0x0562,
                                QStringLiteral(
                                        "Data Field: Generic Category GUID")},
                        {0x0563,
                                QStringLiteral(
                                        "Data Field: Generic Type GUID")},
                        {0x0564,
                                QStringLiteral("Data Field: Generic Event "
                                               "PROPERTYKEY")},
                        {0x0565,
                                QStringLiteral("Data Field: Generic Property "
                                               "PROPERTYKEY")},
                        {0x0566,
                                QStringLiteral("Data Field: Generic Data Field "
                                               "PROPERTYKEY")},
                        {0x0567, QStringLiteral("Data Field: Generic Event")},
                        {0x0568,
                                QStringLiteral("Data Field: Generic Property")},
                        {0x0569,
                                QStringLiteral(
                                        "Data Field: Generic Data Field")},
                        {0x056A,
                                QStringLiteral("Data Field: Enumerator Table "
                                               "Row Index")},
                        {0x056B,
                                QStringLiteral("Data Field: Enumerator Table "
                                               "Row Count")},
                        {0x056C,
                                QStringLiteral("Data Field: Generic GUID or "
                                               "PROPERTYKEY kind")},
                        {0x056D, QStringLiteral("Data Field: Generic GUID")},
                        {0x056E,
                                QStringLiteral(
                                        "Data Field: Generic PROPERTYKEY")},
                        {0x056F,
                                QStringLiteral("Data Field: Generic Top Level "
                                               "Collection ID")},
                        {0x0570,
                                QStringLiteral(
                                        "Data Field: Generic Report ID")},
                        {0x0571,
                                QStringLiteral("Data Field: Generic Report "
                                               "Item Position Index")},
                        {0x0572,
                                QStringLiteral("Data Field: Generic Firmware "
                                               "VARTYPE")},
                        {0x0573,
                                QStringLiteral(
                                        "Data Field: Generic Unit of Measure")},
                        {0x0574,
                                QStringLiteral(
                                        "Data Field: Generic Unit Exponent")},
                        {0x0575,
                                QStringLiteral(
                                        "Data Field: Generic Report Size")},
                        {0x0576,
                                QStringLiteral(
                                        "Data Field: Generic Report Count")},
                        {0x0580, QStringLiteral("Property: Generic")},
                        {0x0581,
                                QStringLiteral("Property: Enumerator Table Row "
                                               "Index")},
                        {0x0582,
                                QStringLiteral("Property: Enumerator Table Row "
                                               "Count")},
                        {0x0590,
                                QStringLiteral(
                                        "Data Field: Personal Activity")},
                        {0x0591, QStringLiteral("Data Field: Activity Type")},
                        {0x0592, QStringLiteral("Data Field: Activity State")},
                        {0x0593, QStringLiteral("Data Field: Device Position")},
                        {0x0594, QStringLiteral("Data Field: Step Count")},
                        {0x0595,
                                QStringLiteral("Data Field: Step Count Reset")},
                        {0x0596, QStringLiteral("Data Field: Step Duration")},
                        {0x0597, QStringLiteral("Data Field: Step Type")},
                        {0x05A0,
                                QStringLiteral("Property: Minimum Activity "
                                               "Detection Interval")},
                        {0x05A1,
                                QStringLiteral(
                                        "Property: Supported Activity Types")},
                        {0x05A2,
                                QStringLiteral(
                                        "Property: Subscribed Activity Types")},
                        {0x05A3,
                                QStringLiteral(
                                        "Property: Supported Step Types")},
                        {0x05A4,
                                QStringLiteral(
                                        "Property: Subscribed Step Types")},
                        {0x05A5, QStringLiteral("Property: Floor Height")},
                        {0x05B0, QStringLiteral("Data Field: Custom Type ID")},
                        {0x05C0, QStringLiteral("Property: Custom")},
                        {0x05C1, QStringLiteral("Property: Custom Value 1")},
                        {0x05C2, QStringLiteral("Property: Custom Value 2")},
                        {0x05C3, QStringLiteral("Property: Custom Value 3")},
                        {0x05C4, QStringLiteral("Property: Custom Value 4")},
                        {0x05C5, QStringLiteral("Property: Custom Value 5")},
                        {0x05C6, QStringLiteral("Property: Custom Value 6")},
                        {0x05C7, QStringLiteral("Property: Custom Value 7")},
                        {0x05C8, QStringLiteral("Property: Custom Value 8")},
                        {0x05C9, QStringLiteral("Property: Custom Value 9")},
                        {0x05CA, QStringLiteral("Property: Custom Value 10")},
                        {0x05CB, QStringLiteral("Property: Custom Value 11")},
                        {0x05CC, QStringLiteral("Property: Custom Value 12")},
                        {0x05CD, QStringLiteral("Property: Custom Value 13")},
                        {0x05CE, QStringLiteral("Property: Custom Value 14")},
                        {0x05CF, QStringLiteral("Property: Custom Value 15")},
                        {0x05D0, QStringLiteral("Property: Custom Value 16")},
                        {0x05E0, QStringLiteral("Data Field: Hinge")},
                        {0x05E1, QStringLiteral("Data Field: Hinge Angle")},
                        {0x05F0, QStringLiteral("Data Field: Gesture Sensor")},
                        {0x05F1, QStringLiteral("Data Field: Gesture State")},
                        {0x05F2,
                                QStringLiteral("Data Field: Hinge Fold Initial "
                                               "Angle")},
                        {0x05F3,
                                QStringLiteral(
                                        "Data Field: Hinge Fold Final Angle")},
                        {0x05F4,
                                QStringLiteral("Data Field: Hinge Fold "
                                               "Contributing Panel")},
                        {0x05F5, QStringLiteral("Data Field: Hinge Fold Type")},
                        {0x0800, QStringLiteral("Sensor State: Undefined")},
                        {0x0801, QStringLiteral("Sensor State: Ready")},
                        {0x0802, QStringLiteral("Sensor State: Not Available")},
                        {0x0803, QStringLiteral("Sensor State: No Data")},
                        {0x0804, QStringLiteral("Sensor State: Initializing")},
                        {0x0805, QStringLiteral("Sensor State: Access Denied")},
                        {0x0806, QStringLiteral("Sensor State: Error")},
                        {0x0810, QStringLiteral("Sensor Event: Unknown")},
                        {0x0811, QStringLiteral("Sensor Event: State Changed")},
                        {0x0812,
                                QStringLiteral(
                                        "Sensor Event: Property Changed")},
                        {0x0813, QStringLiteral("Sensor Event: Data Updated")},
                        {0x0814, QStringLiteral("Sensor Event: Poll Response")},
                        {0x0815,
                                QStringLiteral(
                                        "Sensor Event: Change Sensitivity")},
                        {0x0816,
                                QStringLiteral(
                                        "Sensor Event: Range Maximum Reached")},
                        {0x0817,
                                QStringLiteral(
                                        "Sensor Event: Range Minimum Reached")},
                        {0x0818,
                                QStringLiteral("Sensor Event: High Threshold "
                                               "Cross Upward")},
                        {0x0819,
                                QStringLiteral("Sensor Event: High Threshold "
                                               "Cross Downward")},
                        {0x081A,
                                QStringLiteral("Sensor Event: Low Threshold "
                                               "Cross Upward")},
                        {0x081B,
                                QStringLiteral("Sensor Event: Low Threshold "
                                               "Cross Downward")},
                        {0x081C,
                                QStringLiteral("Sensor Event: Zero Threshold "
                                               "Cross Upward")},
                        {0x081D,
                                QStringLiteral("Sensor Event: Zero Threshold "
                                               "Cross Downward")},
                        {0x081E,
                                QStringLiteral(
                                        "Sensor Event: Period Exceeded")},
                        {0x081F,
                                QStringLiteral(
                                        "Sensor Event: Frequency Exceeded")},
                        {0x0820,
                                QStringLiteral(
                                        "Sensor Event: Complex Trigger")},
                        {0x0830,
                                QStringLiteral(
                                        "Connection Type: PC Integrated")},
                        {0x0831,
                                QStringLiteral("Connection Type: PC Attached")},
                        {0x0832,
                                QStringLiteral("Connection Type: PC External")},
                        {0x0840,
                                QStringLiteral(
                                        "Reporting State: Report No Events")},
                        {0x0841,
                                QStringLiteral(
                                        "Reporting State: Report All Events")},
                        {0x0842,
                                QStringLiteral("Reporting State: Report "
                                               "Threshold Events")},
                        {0x0843,
                                QStringLiteral(
                                        "Reporting State: Wake On No Events")},
                        {0x0844,
                                QStringLiteral(
                                        "Reporting State: Wake On All Events")},
                        {0x0845,
                                QStringLiteral("Reporting State: Wake On "
                                               "Threshold Events")},
                        {0x0846, QStringLiteral("Reporting State: Anytime")},
                        {0x0850, QStringLiteral("Power State: Undefined")},
                        {0x0851, QStringLiteral("Power State: D0 Full Power")},
                        {0x0852, QStringLiteral("Power State: D1 Low Power")},
                        {0x0853,
                                QStringLiteral("Power State: D2 Standby Power "
                                               "with Wakeup")},
                        {0x0854,
                                QStringLiteral(
                                        "Power State: D3 Sleep with Wakeup")},
                        {0x0855, QStringLiteral("Power State: D4 Power Off")},
                        {0x0860, QStringLiteral("Accuracy: Default")},
                        {0x0861, QStringLiteral("Accuracy: High")},
                        {0x0862, QStringLiteral("Accuracy: Medium")},
                        {0x0863, QStringLiteral("Accuracy: Low")},
                        {0x0870, QStringLiteral("Fix Quality: No Fix")},
                        {0x0871, QStringLiteral("Fix Quality: GPS")},
                        {0x0872, QStringLiteral("Fix Quality: DGPS")},
                        {0x0880, QStringLiteral("Fix Type: No Fix")},
                        {0x0881,
                                QStringLiteral(
                                        "Fix Type: GPS SPS Mode, Fix Valid")},
                        {0x0882,
                                QStringLiteral(
                                        "Fix Type: DGPS SPS Mode, Fix Valid")},
                        {0x0883,
                                QStringLiteral(
                                        "Fix Type: GPS PPS Mode, Fix Valid")},
                        {0x0884,
                                QStringLiteral(
                                        "Fix Type: Real Time Kinematic")},
                        {0x0885, QStringLiteral("Fix Type: Float RTK")},
                        {0x0886,
                                QStringLiteral(
                                        "Fix Type: Estimated (dead reckoned)")},
                        {0x0887, QStringLiteral("Fix Type: Manual Input Mode")},
                        {0x0888, QStringLiteral("Fix Type: Simulator Mode")},
                        {0x0890, QStringLiteral("GPS Operation Mode: Manual")},
                        {0x0891,
                                QStringLiteral(
                                        "GPS Operation Mode: Automatic")},
                        {0x08A0,
                                QStringLiteral(
                                        "GPS Selection Mode: Autonomous")},
                        {0x08A1, QStringLiteral("GPS Selection Mode: DGPS")},
                        {0x08A2,
                                QStringLiteral("GPS Selection Mode: Estimated "
                                               "(dead reckoned)")},
                        {0x08A3,
                                QStringLiteral(
                                        "GPS Selection Mode: Manual Input")},
                        {0x08A4,
                                QStringLiteral(
                                        "GPS Selection Mode: Simulator")},
                        {0x08A5,
                                QStringLiteral(
                                        "GPS Selection Mode: Data Not Valid")},
                        {0x08B0, QStringLiteral("GPS Status Data: Valid")},
                        {0x08B1, QStringLiteral("GPS Status Data: Not Valid")},
                        {0x08C0, QStringLiteral("Day of Week: Sunday")},
                        {0x08C1, QStringLiteral("Day of Week: Monday")},
                        {0x08C2, QStringLiteral("Day of Week: Tuesday")},
                        {0x08C3, QStringLiteral("Day of Week: Wednesday")},
                        {0x08C4, QStringLiteral("Day of Week: Thursday")},
                        {0x08C5, QStringLiteral("Day of Week: Friday")},
                        {0x08C6, QStringLiteral("Day of Week: Saturday")},
                        {0x08D0, QStringLiteral("Kind: Category")},
                        {0x08D1, QStringLiteral("Kind: Type")},
                        {0x08D2, QStringLiteral("Kind: Event")},
                        {0x08D3, QStringLiteral("Kind: Property")},
                        {0x08D4, QStringLiteral("Kind: Data Field")},
                        {0x08E0, QStringLiteral("Magnetometer Accuracy: Low")},
                        {0x08E1,
                                QStringLiteral(
                                        "Magnetometer Accuracy: Medium")},
                        {0x08E2, QStringLiteral("Magnetometer Accuracy: High")},
                        {0x08F0,
                                QStringLiteral("Simple Orientation Direction: "
                                               "Not Rotated")},
                        {0x08F1,
                                QStringLiteral("Simple Orientation Direction: "
                                               "Rotated 90 Degrees CCW")},
                        {0x08F2,
                                QStringLiteral("Simple Orientation Direction: "
                                               "Rotated 180 Degrees CCW")},
                        {0x08F3,
                                QStringLiteral("Simple Orientation Direction: "
                                               "Rotated 270 Degrees CCW")},
                        {0x08F4,
                                QStringLiteral("Simple Orientation Direction: "
                                               "Face Up")},
                        {0x08F5,
                                QStringLiteral("Simple Orientation Direction: "
                                               "Face Down")},
                        {0x0900, QStringLiteral("VT\\_NULL")},
                        {0x0901, QStringLiteral("VT\\_BOOL")},
                        {0x0902, QStringLiteral("VT\\_UI1")},
                        {0x0903, QStringLiteral("VT\\_I1")},
                        {0x0904, QStringLiteral("VT\\_UI2")},
                        {0x0905, QStringLiteral("VT\\_I2")},
                        {0x0906, QStringLiteral("VT\\_UI4")},
                        {0x0907, QStringLiteral("VT\\_I4")},
                        {0x0908, QStringLiteral("VT\\_UI8")},
                        {0x0909, QStringLiteral("VT\\_I8")},
                        {0x090A, QStringLiteral("VT\\_R4")},
                        {0x090B, QStringLiteral("VT\\_R8")},
                        {0x090C, QStringLiteral("VT\\_WSTR")},
                        {0x090D, QStringLiteral("VT\\_STR")},
                        {0x090E, QStringLiteral("VT\\_CLSID")},
                        {0x090F, QStringLiteral("VT\\_VECTOR VT\\_UI1")},
                        {0x0910, QStringLiteral("VT\\_F16E0")},
                        {0x0911, QStringLiteral("VT\\_F16E1")},
                        {0x0912, QStringLiteral("VT\\_F16E2")},
                        {0x0913, QStringLiteral("VT\\_F16E3")},
                        {0x0914, QStringLiteral("VT\\_F16E4")},
                        {0x0915, QStringLiteral("VT\\_F16E5")},
                        {0x0916, QStringLiteral("VT\\_F16E6")},
                        {0x0917, QStringLiteral("VT\\_F16E7")},
                        {0x0918, QStringLiteral("VT\\_F16E8")},
                        {0x0919, QStringLiteral("VT\\_F16E9")},
                        {0x091A, QStringLiteral("VT\\_F16EA")},
                        {0x091B, QStringLiteral("VT\\_F16EB")},
                        {0x091C, QStringLiteral("VT\\_F16EC")},
                        {0x091D, QStringLiteral("VT\\_F16ED")},
                        {0x091E, QStringLiteral("VT\\_F16EE")},
                        {0x091F, QStringLiteral("VT\\_F16EF")},
                        {0x0920, QStringLiteral("VT\\_F32E0")},
                        {0x0921, QStringLiteral("VT\\_F32E1")},
                        {0x0922, QStringLiteral("VT\\_F32E2")},
                        {0x0923, QStringLiteral("VT\\_F32E3")},
                        {0x0924, QStringLiteral("VT\\_F32E4")},
                        {0x0925, QStringLiteral("VT\\_F32E5")},
                        {0x0926, QStringLiteral("VT\\_F32E6")},
                        {0x0927, QStringLiteral("VT\\_F32E7")},
                        {0x0928, QStringLiteral("VT\\_F32E8")},
                        {0x0929, QStringLiteral("VT\\_F32E9")},
                        {0x092A, QStringLiteral("VT\\_F32EA")},
                        {0x092B, QStringLiteral("VT\\_F32EB")},
                        {0x092C, QStringLiteral("VT\\_F32EC")},
                        {0x092D, QStringLiteral("VT\\_F32ED")},
                        {0x092E, QStringLiteral("VT\\_F32EE")},
                        {0x092F, QStringLiteral("VT\\_F32EF")},
                        {0x0930, QStringLiteral("Activity Type: Unknown")},
                        {0x0931, QStringLiteral("Activity Type: Stationary")},
                        {0x0932, QStringLiteral("Activity Type: Fidgeting")},
                        {0x0933, QStringLiteral("Activity Type: Walking")},
                        {0x0934, QStringLiteral("Activity Type: Running")},
                        {0x0935, QStringLiteral("Activity Type: In Vehicle")},
                        {0x0936, QStringLiteral("Activity Type: Biking")},
                        {0x0937, QStringLiteral("Activity Type: Idle")},
                        {0x0940, QStringLiteral("Unit: Not Specified")},
                        {0x0941, QStringLiteral("Unit: Lux")},
                        {0x0942, QStringLiteral("Unit: Degrees Kelvin")},
                        {0x0943, QStringLiteral("Unit: Degrees Celsius")},
                        {0x0944, QStringLiteral("Unit: Pascal")},
                        {0x0945, QStringLiteral("Unit: Newton")},
                        {0x0946, QStringLiteral("Unit: Meters/Second")},
                        {0x0947, QStringLiteral("Unit: Kilogram")},
                        {0x0948, QStringLiteral("Unit: Meter")},
                        {0x0949, QStringLiteral("Unit: Meters/Second/Second")},
                        {0x094A, QStringLiteral("Unit: Farad")},
                        {0x094B, QStringLiteral("Unit: Ampere")},
                        {0x094C, QStringLiteral("Unit: Watt")},
                        {0x094D, QStringLiteral("Unit: Henry")},
                        {0x094E, QStringLiteral("Unit: Ohm")},
                        {0x094F, QStringLiteral("Unit: Volt")},
                        {0x0950, QStringLiteral("Unit: Hertz")},
                        {0x0951, QStringLiteral("Unit: Bar")},
                        {0x0952,
                                QStringLiteral("Unit: Degrees Anti-clockwise")},
                        {0x0953, QStringLiteral("Unit: Degrees Clockwise")},
                        {0x0954, QStringLiteral("Unit: Degrees")},
                        {0x0955, QStringLiteral("Unit: Degrees/Second")},
                        {0x0956, QStringLiteral("Unit: Degrees/Second/Second")},
                        {0x0957, QStringLiteral("Unit: Knot")},
                        {0x0958, QStringLiteral("Unit: Percent")},
                        {0x0959, QStringLiteral("Unit: Second")},
                        {0x095A, QStringLiteral("Unit: Millisecond")},
                        {0x095B, QStringLiteral("Unit: G")},
                        {0x095C, QStringLiteral("Unit: Bytes")},
                        {0x095D, QStringLiteral("Unit: Milligauss")},
                        {0x095E, QStringLiteral("Unit: Bits")},
                        {0x0960,
                                QStringLiteral(
                                        "Activity State: No State Change")},
                        {0x0961,
                                QStringLiteral(
                                        "Activity State: Start Activity")},
                        {0x0962,
                                QStringLiteral("Activity State: End Activity")},
                        {0x0970, QStringLiteral("Exponent 0")},
                        {0x0971, QStringLiteral("Exponent 1")},
                        {0x0972, QStringLiteral("Exponent 2")},
                        {0x0973, QStringLiteral("Exponent 3")},
                        {0x0974, QStringLiteral("Exponent 4")},
                        {0x0975, QStringLiteral("Exponent 5")},
                        {0x0976, QStringLiteral("Exponent 6")},
                        {0x0977, QStringLiteral("Exponent 7")},
                        {0x0978, QStringLiteral("Exponent 8")},
                        {0x0979, QStringLiteral("Exponent 9")},
                        {0x097A, QStringLiteral("Exponent A")},
                        {0x097B, QStringLiteral("Exponent B")},
                        {0x097C, QStringLiteral("Exponent C")},
                        {0x097D, QStringLiteral("Exponent D")},
                        {0x097E, QStringLiteral("Exponent E")},
                        {0x097F, QStringLiteral("Exponent F")},
                        {0x0980, QStringLiteral("Device Position: Unknown")},
                        {0x0981, QStringLiteral("Device Position: Unchanged")},
                        {0x0982, QStringLiteral("Device Position: On Desk")},
                        {0x0983, QStringLiteral("Device Position: In Hand")},
                        {0x0984,
                                QStringLiteral(
                                        "Device Position: Moving in Bag")},
                        {0x0985,
                                QStringLiteral(
                                        "Device Position: Stationary in Bag")},
                        {0x0990, QStringLiteral("Step Type: Unknown")},
                        {0x0991, QStringLiteral("Step Type: Walking")},
                        {0x0992, QStringLiteral("Step Type: Running")},
                        {0x09A0, QStringLiteral("Gesture State: Unknown")},
                        {0x09A1, QStringLiteral("Gesture State: Started")},
                        {0x09A2, QStringLiteral("Gesture State: Completed")},
                        {0x09A3, QStringLiteral("Gesture State: Cancelled")},
                        {0x09B0,
                                QStringLiteral("Hinge Fold Contributing Panel: "
                                               "Unknown")},
                        {0x09B1,
                                QStringLiteral("Hinge Fold Contributing Panel: "
                                               "Panel 1")},
                        {0x09B2,
                                QStringLiteral("Hinge Fold Contributing Panel: "
                                               "Panel 2")},
                        {0x09B3,
                                QStringLiteral(
                                        "Hinge Fold Contributing Panel: Both")},
                        {0x09B4, QStringLiteral("Hinge Fold Type: Unknown")},
                        {0x09B5, QStringLiteral("Hinge Fold Type: Increasing")},
                        {0x09B6, QStringLiteral("Hinge Fold Type: Decreasing")},
                        {0x09C0,
                                QStringLiteral("Human Presence Detection Type: "
                                               "Vendor-Defined Non-Biometric")},
                        {0x09C1,
                                QStringLiteral("Human Presence Detection Type: "
                                               "Vendor-Defined Biometric")},
                        {0x09C2,
                                QStringLiteral("Human Presence Detection Type: "
                                               "Facial Biometric")},
                        {0x09C3,
                                QStringLiteral("Human Presence Detection Type: "
                                               "Audio Biometric")},
                        {0x1000,
                                QStringLiteral("Modifier: Change Sensitivity "
                                               "Absolute")},
                        {0x2000, QStringLiteral("Modifier: Maximum")},
                        {0x3000, QStringLiteral("Modifier: Minimum")},
                        {0x4000, QStringLiteral("Modifier: Accuracy")},
                        {0x5000, QStringLiteral("Modifier: Resolution")},
                        {0x6000, QStringLiteral("Modifier: Threshold High")},
                        {0x7000, QStringLiteral("Modifier: Threshold Low")},
                        {0x8000,
                                QStringLiteral("Modifier: Calibration Offset")},
                        {0x9000,
                                QStringLiteral(
                                        "Modifier: Calibration Multiplier")},
                        {0xA000, QStringLiteral("Modifier: Report Interval")},
                        {0xB000, QStringLiteral("Modifier: Frequency Max")},
                        {0xC000, QStringLiteral("Modifier: Period Max")},
                        {0xD000,
                                QStringLiteral("Modifier: Change Sensitivity "
                                               "Percent of Range")},
                        {0xE000,
                                QStringLiteral("Modifier: Change Sensitivity "
                                               "Percent Relative")},
                        {0xF000, QStringLiteral("Modifier: Vendor Reserved")},
                }},
        {0x0002,
                QStringLiteral("Simulation Controls"),
                {
                        {0x0001, QStringLiteral("Flight Simulation Device")},
                        {0x0002,
                                QStringLiteral("Automobile Simulation Device")},
                        {0x0003, QStringLiteral("Tank Simulation Device")},
                        {0x0004, QStringLiteral("Spaceship Simulation Device")},
                        {0x0005, QStringLiteral("Submarine Simulation Device")},
                        {0x0006, QStringLiteral("Sailing Simulation Device")},
                        {0x0007,
                                QStringLiteral("Motorcycle Simulation Device")},
                        {0x0008, QStringLiteral("Sports Simulation Device")},
                        {0x0009, QStringLiteral("Airplane Simulation Device")},
                        {0x000A,
                                QStringLiteral("Helicopter Simulation Device")},
                        {0x000B,
                                QStringLiteral(
                                        "Magic Carpet Simulation Device")},
                        {0x000C, QStringLiteral("Bicycle Simulation Device")},
                        {0x0020, QStringLiteral("Flight Control Stick")},
                        {0x0021, QStringLiteral("Flight Stick")},
                        {0x0022, QStringLiteral("Cyclic Control")},
                        {0x0023, QStringLiteral("Cyclic Trim")},
                        {0x0024, QStringLiteral("Flight Yoke")},
                        {0x0025, QStringLiteral("Track Control")},
                        {0x00B0, QStringLiteral("Aileron")},
                        {0x00B1, QStringLiteral("Aileron Trim")},
                        {0x00B2, QStringLiteral("Anti-Torque Control")},
                        {0x00B3, QStringLiteral("Autopilot Enable")},
                        {0x00B4, QStringLiteral("Chaff Release")},
                        {0x00B5, QStringLiteral("Collective Control")},
                        {0x00B6, QStringLiteral("Dive Brake")},
                        {0x00B7, QStringLiteral("Electronic Countermeasures")},
                        {0x00B8, QStringLiteral("Elevator")},
                        {0x00B9, QStringLiteral("Elevator Trim")},
                        {0x00BA, QStringLiteral("Rudder")},
                        {0x00BB, QStringLiteral("Throttle")},
                        {0x00BC, QStringLiteral("Flight Communications")},
                        {0x00BD, QStringLiteral("Flare Release")},
                        {0x00BE, QStringLiteral("Landing Gear")},
                        {0x00BF, QStringLiteral("Toe Brake")},
                        {0x00C0, QStringLiteral("Trigger")},
                        {0x00C1, QStringLiteral("Weapons Arm")},
                        {0x00C2, QStringLiteral("Weapons Select")},
                        {0x00C3, QStringLiteral("Wing Flaps")},
                        {0x00C4, QStringLiteral("Accelerator")},
                        {0x00C5, QStringLiteral("Brake")},
                        {0x00C6, QStringLiteral("Clutch")},
                        {0x00C7, QStringLiteral("Shifter")},
                        {0x00C8, QStringLiteral("Steering")},
                        {0x00C9, QStringLiteral("Turret Direction")},
                        {0x00CA, QStringLiteral("Barrel Elevation")},
                        {0x00CB, QStringLiteral("Dive Plane")},
                        {0x00CC, QStringLiteral("Ballast")},
                        {0x00CD, QStringLiteral("Bicycle Crank")},
                        {0x00CE, QStringLiteral("Handle Bars")},
                        {0x00CF, QStringLiteral("Front Brake")},
                        {0x00D0, QStringLiteral("Rear Brake")},
                }},
        {0x0011,
                QStringLiteral("SoC"),
                {
                        {0x0001, QStringLiteral("SocControl")},
                        {0x0002, QStringLiteral("FirmwareTransfer")},
                        {0x0003, QStringLiteral("FirmwareFileId")},
                        {0x0004, QStringLiteral("FileOffsetInBytes")},
                        {0x0005, QStringLiteral("FileTransferSizeMaxInBytes")},
                        {0x0006, QStringLiteral("FilePayload")},
                        {0x0007, QStringLiteral("FilePayloadSizeInBytes")},
                        {0x0008,
                                QStringLiteral("FilePayloadContainsLastBytes")},
                        {0x0009, QStringLiteral("FileTransferStop")},
                        {0x000A, QStringLiteral("FileTransferTillEnd")},
                }},
        {0x0004,
                QStringLiteral("Sport Controls"),
                {
                        {0x0001, QStringLiteral("Baseball Bat")},
                        {0x0002, QStringLiteral("Golf Club")},
                        {0x0003, QStringLiteral("Rowing Machine")},
                        {0x0004, QStringLiteral("Treadmill")},
                        {0x0030, QStringLiteral("Oar")},
                        {0x0031, QStringLiteral("Slope")},
                        {0x0032, QStringLiteral("Rate")},
                        {0x0033, QStringLiteral("Stick Speed")},
                        {0x0034, QStringLiteral("Stick Face Angle")},
                        {0x0035, QStringLiteral("Stick Heel/Toe")},
                        {0x0036, QStringLiteral("Stick Follow Through")},
                        {0x0037, QStringLiteral("Stick Tempo")},
                        {0x0038, QStringLiteral("Stick Type")},
                        {0x0039, QStringLiteral("Stick Height")},
                        {0x0050, QStringLiteral("Putter")},
                        {0x0051, QStringLiteral("1 Iron")},
                        {0x0052, QStringLiteral("2 Iron")},
                        {0x0053, QStringLiteral("3 Iron")},
                        {0x0054, QStringLiteral("4 Iron")},
                        {0x0055, QStringLiteral("5 Iron")},
                        {0x0056, QStringLiteral("6 Iron")},
                        {0x0057, QStringLiteral("7 Iron")},
                        {0x0058, QStringLiteral("8 Iron")},
                        {0x0059, QStringLiteral("9 Iron")},
                        {0x005A, QStringLiteral("10 Iron")},
                        {0x005B, QStringLiteral("11 Iron")},
                        {0x005C, QStringLiteral("Sand Wedge")},
                        {0x005D, QStringLiteral("Loft Wedge")},
                        {0x005E, QStringLiteral("Power Wedge")},
                        {0x005F, QStringLiteral("1 Wood")},
                        {0x0060, QStringLiteral("3 Wood")},
                        {0x0061, QStringLiteral("5 Wood")},
                        {0x0062, QStringLiteral("7 Wood")},
                        {0x0063, QStringLiteral("9 Wood")},
                }},
        {0x000B,
                QStringLiteral("Telephony Device"),
                {
                        {0x0001, QStringLiteral("Phone")},
                        {0x0002, QStringLiteral("Answering Machine")},
                        {0x0003, QStringLiteral("Message Controls")},
                        {0x0004, QStringLiteral("Handset")},
                        {0x0005, QStringLiteral("Headset")},
                        {0x0006, QStringLiteral("Telephony Key Pad")},
                        {0x0007, QStringLiteral("Programmable Button")},
                        {0x0020, QStringLiteral("Hook Switch")},
                        {0x0021, QStringLiteral("Flash")},
                        {0x0022, QStringLiteral("Feature")},
                        {0x0023, QStringLiteral("Hold")},
                        {0x0024, QStringLiteral("Redial")},
                        {0x0025, QStringLiteral("Transfer")},
                        {0x0026, QStringLiteral("Drop")},
                        {0x0027, QStringLiteral("Park")},
                        {0x0028, QStringLiteral("Forward Calls")},
                        {0x0029, QStringLiteral("Alternate Function")},
                        {0x002A, QStringLiteral("Line")},
                        {0x002B, QStringLiteral("Speaker Phone")},
                        {0x002C, QStringLiteral("Conference")},
                        {0x002D, QStringLiteral("Ring Enable")},
                        {0x002E, QStringLiteral("Ring Select")},
                        {0x002F, QStringLiteral("Phone Mute")},
                        {0x0030, QStringLiteral("Caller ID")},
                        {0x0031, QStringLiteral("Send")},
                        {0x0050, QStringLiteral("Speed Dial")},
                        {0x0051, QStringLiteral("Store Number")},
                        {0x0052, QStringLiteral("Recall Number")},
                        {0x0053, QStringLiteral("Phone Directory")},
                        {0x0070, QStringLiteral("Voice Mail")},
                        {0x0071, QStringLiteral("Screen Calls")},
                        {0x0072, QStringLiteral("Do Not Disturb")},
                        {0x0073, QStringLiteral("Message")},
                        {0x0074, QStringLiteral("Answer On/Off")},
                        {0x0090, QStringLiteral("Inside Dial Tone")},
                        {0x0091, QStringLiteral("Outside Dial Tone")},
                        {0x0092, QStringLiteral("Inside Ring Tone")},
                        {0x0093, QStringLiteral("Outside Ring Tone")},
                        {0x0094, QStringLiteral("Priority Ring Tone")},
                        {0x0095, QStringLiteral("Inside Ringback")},
                        {0x0096, QStringLiteral("Priority Ringback")},
                        {0x0097, QStringLiteral("Line Busy Tone")},
                        {0x0098, QStringLiteral("Reorder Tone")},
                        {0x0099, QStringLiteral("Call Waiting Tone")},
                        {0x009A, QStringLiteral("Confirmation Tone 1")},
                        {0x009B, QStringLiteral("Confirmation Tone 2")},
                        {0x009C, QStringLiteral("Tones Off")},
                        {0x009D, QStringLiteral("Outside Ringback")},
                        {0x009E, QStringLiteral("Ringer")},
                        {0x00B0, QStringLiteral("Phone Key 0")},
                        {0x00B1, QStringLiteral("Phone Key 1")},
                        {0x00B2, QStringLiteral("Phone Key 2")},
                        {0x00B3, QStringLiteral("Phone Key 3")},
                        {0x00B4, QStringLiteral("Phone Key 4")},
                        {0x00B5, QStringLiteral("Phone Key 5")},
                        {0x00B6, QStringLiteral("Phone Key 6")},
                        {0x00B7, QStringLiteral("Phone Key 7")},
                        {0x00B8, QStringLiteral("Phone Key 8")},
                        {0x00B9, QStringLiteral("Phone Key 9")},
                        {0x00BA, QStringLiteral("Phone Key Star")},
                        {0x00BB, QStringLiteral("Phone Key Pound")},
                        {0x00BC, QStringLiteral("Phone Key A")},
                        {0x00BD, QStringLiteral("Phone Key B")},
                        {0x00BE, QStringLiteral("Phone Key C")},
                        {0x00BF, QStringLiteral("Phone Key D")},
                        {0x00C0, QStringLiteral("Phone Call History Key")},
                        {0x00C1, QStringLiteral("Phone Caller ID Key")},
                        {0x00C2, QStringLiteral("Phone Settings Key")},
                        {0x00F0, QStringLiteral("Host Control")},
                        {0x00F1, QStringLiteral("Host Available")},
                        {0x00F2, QStringLiteral("Host Call Active")},
                        {0x00F3, QStringLiteral("Activate Handset Audio")},
                        {0x00F4, QStringLiteral("Ring Type")},
                        {0x00F5, QStringLiteral("Re-dialable Phone Number")},
                        {0x00F8, QStringLiteral("Stop Ring Tone")},
                        {0x00F9, QStringLiteral("PSTN Ring Tone")},
                        {0x00FA, QStringLiteral("Host Ring Tone")},
                        {0x00FB, QStringLiteral("Alert Sound Error")},
                        {0x00FC, QStringLiteral("Alert Sound Confirm")},
                        {0x00FD, QStringLiteral("Alert Sound Notification")},
                        {0x00FE, QStringLiteral("Silent Ring")},
                        {0x0108, QStringLiteral("Email Message Waiting")},
                        {0x0109, QStringLiteral("Voicemail Message Waiting")},
                        {0x010A, QStringLiteral("Host Hold")},
                        {0x0110, QStringLiteral("Incoming Call History Count")},
                        {0x0111, QStringLiteral("Outgoing Call History Count")},
                        {0x0112, QStringLiteral("Incoming Call History")},
                        {0x0113, QStringLiteral("Outgoing Call History")},
                        {0x0114, QStringLiteral("Phone Locale")},
                        {0x0140, QStringLiteral("Phone Time Second")},
                        {0x0141, QStringLiteral("Phone Time Minute")},
                        {0x0142, QStringLiteral("Phone Time Hour")},
                        {0x0143, QStringLiteral("Phone Date Day")},
                        {0x0144, QStringLiteral("Phone Date Month")},
                        {0x0145, QStringLiteral("Phone Date Year")},
                        {0x0146, QStringLiteral("Handset Nickname")},
                        {0x0147, QStringLiteral("Address Book ID")},
                        {0x014A, QStringLiteral("Call Duration")},
                        {0x014B, QStringLiteral("Dual Mode Phone")},
                }},
        {0x0082,
                QStringLiteral("VESA Virtual Controls"),
                {
                        {0x0001, QStringLiteral("Degauss")},
                        {0x0010, QStringLiteral("Brightness")},
                        {0x0012, QStringLiteral("Contrast")},
                        {0x0016, QStringLiteral("Red Video Gain")},
                        {0x0018, QStringLiteral("Green Video Gain")},
                        {0x001A, QStringLiteral("Blue Video Gain")},
                        {0x001C, QStringLiteral("Focus")},
                        {0x0020, QStringLiteral("Horizontal Position")},
                        {0x0022, QStringLiteral("Horizontal Size")},
                        {0x0024, QStringLiteral("Horizontal Pincushion")},
                        {0x0026,
                                QStringLiteral(
                                        "Horizontal Pincushion Balance")},
                        {0x0028, QStringLiteral("Horizontal Misconvergence")},
                        {0x002A, QStringLiteral("Horizontal Linearity")},
                        {0x002C,
                                QStringLiteral("Horizontal Linearity Balance")},
                        {0x0030, QStringLiteral("Vertical Position")},
                        {0x0032, QStringLiteral("Vertical Size")},
                        {0x0034, QStringLiteral("Vertical Pincushion")},
                        {0x0036, QStringLiteral("Vertical Pincushion Balance")},
                        {0x0038, QStringLiteral("Vertical Misconvergence")},
                        {0x003A, QStringLiteral("Vertical Linearity")},
                        {0x003C, QStringLiteral("Vertical Linearity Balance")},
                        {0x0040,
                                QStringLiteral("Parallelogram Distortion (Key "
                                               "Balance)")},
                        {0x0042,
                                QStringLiteral("Trapezoidal Distortion (Key)")},
                        {0x0044, QStringLiteral("Tilt (Rotation)")},
                        {0x0046,
                                QStringLiteral(
                                        "Top Corner Distortion Control")},
                        {0x0048,
                                QStringLiteral(
                                        "Top Corner Distortion Balance")},
                        {0x004A,
                                QStringLiteral(
                                        "Bottom Corner Distortion Control")},
                        {0x004C,
                                QStringLiteral(
                                        "Bottom Corner Distortion Balance")},
                        {0x0056, QStringLiteral("Horizontal Moir\u00e9")},
                        {0x0058, QStringLiteral("Vertical Moir\u00e9")},
                        {0x005E, QStringLiteral("Input Level Select")},
                        {0x0060, QStringLiteral("Input Source Select")},
                        {0x006C, QStringLiteral("Red Video Black Level")},
                        {0x006E, QStringLiteral("Green Video Black Level")},
                        {0x0070, QStringLiteral("Blue Video Black Level")},
                        {0x00A2, QStringLiteral("Auto Size Center")},
                        {0x00A4,
                                QStringLiteral(
                                        "Polarity Horizontal Synchronization")},
                        {0x00A6,
                                QStringLiteral(
                                        "Polarity Vertical Synchronization")},
                        {0x00A8, QStringLiteral("Synchronization Type")},
                        {0x00AA, QStringLiteral("Screen Orientation")},
                        {0x00AC, QStringLiteral("Horizontal Frequency")},
                        {0x00AE, QStringLiteral("Vertical Frequency")},
                        {0x00B0, QStringLiteral("Settings")},
                        {0x00CA, QStringLiteral("On Screen Display")},
                        {0x00D4, QStringLiteral("Stereo Mode")},
                }},
        {0x0003,
                QStringLiteral("VR Controls"),
                {
                        {0x0001, QStringLiteral("Belt")},
                        {0x0002, QStringLiteral("Body Suit")},
                        {0x0003, QStringLiteral("Flexor")},
                        {0x0004, QStringLiteral("Glove")},
                        {0x0005, QStringLiteral("Head Tracker")},
                        {0x0006, QStringLiteral("Head Mounted Display")},
                        {0x0007, QStringLiteral("Hand Tracker")},
                        {0x0008, QStringLiteral("Oculometer")},
                        {0x0009, QStringLiteral("Vest")},
                        {0x000A, QStringLiteral("Animatronic Device")},
                        {0x0020, QStringLiteral("Stereo Enable")},
                        {0x0021, QStringLiteral("Display Enable")},
                }},
};

} // namespace hid

} // namespace mixxx
