"""empty message

Revision ID: c1ea65e2b492
Revises: e1bf78a597a2
Create Date: 2020-12-09 18:34:13.345064

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'c1ea65e2b492'
down_revision = 'e1bf78a597a2'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('edit_request_change')
    op.drop_table('edit_request')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('edit_request',
    sa.Column('id', sa.INTEGER(), server_default=sa.text("nextval('edit_request_id_seq'::regclass)"), autoincrement=True, nullable=False),
    sa.Column('package_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('author_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('title', sa.VARCHAR(length=100), autoincrement=False, nullable=False),
    sa.Column('desc', sa.VARCHAR(length=1000), autoincrement=False, nullable=True),
    sa.Column('status', sa.INTEGER(), autoincrement=False, nullable=False),
    sa.ForeignKeyConstraint(['author_id'], ['user.id'], name='edit_request_author_id_fkey'),
    sa.ForeignKeyConstraint(['package_id'], ['package.id'], name='edit_request_package_id_fkey'),
    sa.PrimaryKeyConstraint('id', name='edit_request_pkey'),
    postgresql_ignore_search_path=False
    )
    op.create_table('edit_request_change',
    sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
    sa.Column('request_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('key', postgresql.ENUM('name', 'title', 'shortDesc', 'desc', 'type', 'license', 'tags', 'repo', 'website', 'issueTracker', 'forums', 'harddeps', 'softdeps', name='packagepropertykey'), autoincrement=False, nullable=False),
    sa.Column('oldValue', sa.TEXT(), autoincrement=False, nullable=True),
    sa.Column('newValue', sa.TEXT(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['request_id'], ['edit_request.id'], name='edit_request_change_request_id_fkey'),
    sa.PrimaryKeyConstraint('id', name='edit_request_change_pkey')
    )
    # ### end Alembic commands ###
