"""empty message

Revision ID: b3c7ff6655af
Revises: dff4b87e4a76
Create Date: 2020-09-16 14:35:43.805422

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy import text
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'b3c7ff6655af'
down_revision = 'dff4b87e4a76'
branch_labels = None
depends_on = None


def upgrade():
	status = postgresql.ENUM('WIP', 'CHANGES_NEEDED', 'READY_FOR_REVIEW', 'APPROVED', 'DELETED', name='packagestate')
	status.create(op.get_bind())

	op.add_column('package', sa.Column('state', sa.Enum('WIP', 'CHANGES_NEEDED', 'READY_FOR_REVIEW', 'APPROVED', 'DELETED', name='packagestate'), nullable=True))
	op.execute(text("UPDATE package SET state='APPROVED' WHERE approved=true"))
	op.execute(text("UPDATE package SET state='DELETED' WHERE soft_deleted=true"))
	op.drop_column('package', 'approved')
	op.drop_column('package', 'soft_deleted')
	# ### end Alembic commands ###


def downgrade():
	# ### commands auto generated by Alembic - please adjust! ###
	op.add_column('package', sa.Column('soft_deleted', sa.BOOLEAN(), server_default=sa.text('false'), autoincrement=False, nullable=False))
	op.add_column('package', sa.Column('approved', sa.BOOLEAN(), autoincrement=False, nullable=False))
	op.drop_column('package', 'state')
	# ### end Alembic commands ###
