"""empty message

Revision ID: 6a0aee983614
Revises: 7828535fe339
Create Date: 2024-02-25 15:26:18.708794

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '6a0aee983614'
down_revision = '7828535fe339'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('language',
    sa.Column('id', sa.String(length=10), nullable=False),
    sa.Column('title', sa.String(length=100), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('title')
    )

    op.create_table('package_translation',
    sa.Column('package_id', sa.Integer(), nullable=False),
    sa.Column('language_id', sa.String(length=10), nullable=False),
    sa.Column('title', sa.Unicode(length=100), nullable=True),
    sa.Column('short_desc', sa.Unicode(length=200), nullable=True),
    sa.Column('desc', sa.UnicodeText(), nullable=True),
    sa.ForeignKeyConstraint(['language_id'], ['language.id'], ),
    sa.ForeignKeyConstraint(['package_id'], ['package.id'], ),
    sa.PrimaryKeyConstraint('package_id', 'language_id')
    )

    with op.batch_alter_table('package', schema=None) as batch_op:
        batch_op.add_column(sa.Column('translation_url', sa.String(length=200), nullable=True))


def downgrade():
    with op.batch_alter_table('package', schema=None) as batch_op:
        batch_op.drop_column('translation_url')

    op.drop_table('package_translation')
    op.drop_table('language')
