title: About ContentDB
description: Information about ContentDB's development, history, and more
toc: False

## Development

ContentDB was created by [rubenwardy](https://rubenwardy.com/) in 2018, he was lucky enough to have the time available
as it was submitted as university coursework. To learn about the history and development of ContentDB,
[see the blog post](https://blog.rubenwardy.com/2022/03/24/contentdb/).

ContentDB is open source software, licensed under AGPLv3.0.

<a href="https://github.com/minetest/contentdb/" class="btn btn-primary me-1">Source code</a>
<a href="https://github.com/minetest/contentdb/issues/" class="btn btn-secondary me-1">Issue tracker</a>
<a href="{{ admin_contact_url }}" class="btn btn-secondary me-1">Contact admin</a>
{% if monitoring_url -%}
<a href="{{ monitoring_url }}" class="btn btn-secondary">Stats / monitoring</a>
{%- endif %}

## Why was ContentDB created?

Before ContentDB, users had to manually install mods and games by unzipping their files into a directory. This is
poor user experience, especially for first-time users.

ContentDB isn't just about supporting the in-game content downloader; it's common for technical users to find
and review packages using the ContentDB website, but install using Git rather than the in-game installer.
**ContentDB's purpose is to be a well-formatted source of information about mods, games,
and texture packs for Luanti**.

## How do I learn how to make mods and games for Luanti?

You should read
[the official Luanti Modding Book](https://rubenwardy.com/minetest_modding_book/)
for a guide to making mods and games using Luanti.


<h2 id="donate">How can I support / donate to ContentDB?</h2>

You can donate to rubenwardy to cover ContentDB's costs and support future development.

For more information about the cost of ContentDB and what rubenwardy does, see his donation page:

<a href="https://rubenwardy.com/donate/" class="btn btn-primary me-1">Donate</a>
<a href="/donate/" class="btn btn-secondary">Support Creators</a>

## Sponsorships

Luanti and ContentDB are sponsored by <a href="https://sentry.io/" rel="nofollow">sentry.io</a>.
This provides us with improved error logging and performance insights.
