from mindflow.core.commands.git.diff import parse_git_diff


def test_diff_parser():
    diff = open("mindflow/unit_tests/dummy_diff.txt", "r").read()
    diffs, excluded_files = parse_git_diff(diff)

    assert excluded_files == ["b/mindflow/test.ipynb"]

    print(list(diffs.keys()))
    print(excluded_files)
    # print(diffs)

    expected = {
        "b/mindflow/core/git/diff.py": 'diff --git a/mindflow/core/git/diff.py b/mindflow/core/git/diff.py\nindex 4931684..e8e414b 100644\n--- a/mindflow/core/git/diff.py\n+++ b/mindflow/core/git/diff.py\n@@ -13,6 +13,8 @@ from mindflow.settings import Settings\n from mindflow.utils.prompt_builders import build_context_prompt\n from mindflow.utils.prompts import GIT_DIFF_PROMPT_PREFIX\n \n+from mindflow.utils.diff_parser import parse_git_diff, IGNORE_FILE_EXTENSIONS\n+\n \n def run_diff(args: Tuple[str]) -> str:\n     """\n@@ -25,12 +27,17 @@ def run_diff(args: Tuple[str]) -> str:\n \n     # Execute the git diff command and retrieve the output as a string\n     diff_result = subprocess.check_output(command).decode("utf-8")\n-\n     if diff_result.strip() == "":\n         return "No staged changes."\n \n+    \n+    diff_dict, excluded_filenames = parse_git_diff(diff_result)\n+\n+    if len(diff_dict) <= 0:\n+        return "No staged changes."\n+\n     batched_parsed_diff_result = batch_git_diffs(\n-        parse_git_diff(diff_result), token_limit=completion_model.hard_token_limit\n+        diff_dict, token_limit=completion_model.hard_token_limit\n     )\n \n     response: str = ""\n@@ -58,37 +65,22 @@ def run_diff(args: Tuple[str]) -> str:\n             for future in concurrent.futures.as_completed(futures):\n                 response += future.result()\n \n+    if len(excluded_filenames) > 0:\n+        response += f"\\n\\nNOTE: The following files were excluded from the diff: {\', \'.join(excluded_filenames)}"\n+\n     return response\n \n \n import re\n \n \n-def parse_git_diff(diff_output: str) -> List[Tuple[str, str]]:\n-    file_diffs: List[Dict[str, List[str]]] = []\n-    current_diff: Optional[Dict[str, List[str]]] = None\n-    for line in diff_output.split("\\n"):\n-        if line.startswith("diff --git"):\n-            if current_diff is not None:\n-                file_diffs.append(current_diff)\n-            current_diff = {"file_name": None, "content": []}  # type: ignore\n-            match = re.match(r"^diff --git a/(.+?) b/.+?$", line)\n-            if match:\n-                current_diff["file_name"] = match.group(1)  # type: ignore\n-        if current_diff is not None:\n-            current_diff["content"].append(line)\n-    if current_diff is not None:\n-        file_diffs.append(current_diff)\n-    return [(diff["file_name"], "\\n".join(diff["content"])) for diff in file_diffs]  # type: ignore\n-\n-\n def batch_git_diffs(\n-    file_diffs: List[Tuple[str, str]], token_limit: int\n+    file_diffs: List[Dict[str, str]], token_limit: int\n ) -> List[List[Tuple[str, str]]]:\n     batches = []\n     current_batch: List = []\n     current_batch_size = 0\n-    for file_name, diff_content in file_diffs:\n+    for file_name, diff_content in file_diffs.items():\n         if len(diff_content) > token_limit:\n             chunks = [\n                 diff_content[i : i + token_limit]\n',
        "b/mindflow/unit_tests/dummy_diff.txt": 'diff --git a/mindflow/unit_tests/dummy_diff.txt b/mindflow/unit_tests/dummy_diff.txt\nindex e3afdd6..e69de29 100644\n--- a/mindflow/unit_tests/dummy_diff.txt\n+++ b/mindflow/unit_tests/dummy_diff.txt\n@@ -1,94 +0,0 @@\n-diff --git a/diff.txt b/diff.txt\n-index de79139..e69de29 100644\n---- a/diff.txt\n-+++ b/diff.txt\n-@@ -1,38 +0,0 @@\n--diff --git a/mindflow/utils/diff_parser.py b/mindflow/utils/diff_parser.py\n--new file mode 100644\n--index 0000000..33a588f\n----- /dev/null\n--+++ b/mindflow/utils/diff_parser.py\n--@@ -0,0 +1,31 @@\n--+\n--+\n--+\n--+def parse_git_diff_file(diff_file):\n--+    diffs = {}\n--+    current_file = None\n--+    current_diff = []\n--+\n--+    with open(diff_file, "r") as f:\n--+        for line in f:\n--+            if line.startswith("diff --git"):\n--+                # Starting a new file\n--+                if current_file:\n--+                    # Add the previous diff to the dictionary\n--+                    diffs[current_file] = "".join(current_diff)\n--+                current_file = line.split()[-1]\n--+                current_diff = [line]\n--+            else:\n--+                current_diff.append(line)\n--+\n--+        # Add the last diff to the dictionary\n--+        if current_file:\n--+            diffs[current_file] = "".join(current_diff)\n--+\n--+    return diffs\n--+\n--+\n--+diffs = parse_git_diff_file("diff.txt")\n--+for filename, diff in diffs.items():\n--+    print(f"Diff for {filename}:")\n--+    print(diff)\n--\\ No newline at end of file\n-diff --git a/mindflow/utils/diff_parser.py b/mindflow/utils/diff_parser.py\n-index 33a588f..bfb9b92 100644\n---- a/mindflow/utils/diff_parser.py\n-+++ b/mindflow/utils/diff_parser.py\n-@@ -1,4 +1,8 @@\n- \n-+import os\n-+\n-+# NOTE: make sure to have a the "." in the file extension (if applicable)\n-+IGNORE_FILE_EXTENSIONS = [".pyc", ".ipynb", ".ipynb_checkpoints"]\n- \n- \n- def parse_git_diff_file(diff_file):\n-@@ -13,10 +17,21 @@ def parse_git_diff_file(diff_file):\n-                 if current_file:\n-                     # Add the previous diff to the dictionary\n-                     diffs[current_file] = "".join(current_diff)\n-+\n-                 current_file = line.split()[-1]\n-+                current_ext = os.path.splitext(current_file)[1]\n-+\n-+                if current_ext in IGNORE_FILE_EXTENSIONS:\n-+                    # Ignore this file\n-+                    current_file = None\n-+                    current_diff = []\n-+                    continue\n-+\n-                 current_diff = [line]\n-             else:\n--                current_diff.append(line)\n-+                # skip lines if we are ignoring this file (TODO - this is a bit hacky)\n-+                if current_file:\n-+                    current_diff.append(line)\n- \n-         # Add the last diff to the dictionary\n-         if current_file:\n-@@ -25,7 +40,9 @@ def parse_git_diff_file(diff_file):\n-     return diffs\n- \n- \n-+\n- diffs = parse_git_diff_file("diff.txt")\n--for filename, diff in diffs.items():\n--    print(f"Diff for {filename}:")\n--    print(diff)\n-\\ No newline at end of file\n-+# for filename, diff in diffs.items():\n-+#     print(f"Diff for {filename}:")\n-+#     print(diff)\n-+print(list(diffs.keys()))\n-\\ No newline at end of file\n',
        "b/mindflow/unit_tests/test_utils.py": 'diff --git a/mindflow/unit_tests/test_utils.py b/mindflow/unit_tests/test_utils.py\nindex cacf274..4f1b9fc 100644\n--- a/mindflow/unit_tests/test_utils.py\n+++ b/mindflow/unit_tests/test_utils.py\n@@ -1,8 +1,14 @@\n-from mindflow.utils.diff_parser import parse_git_diff_file\n+from mindflow.utils.diff_parser import parse_git_diff\n \n \n def test_diff_parser():\n-    diffs = parse_git_diff_file("mindflow/unit_tests/dummy_diff.txt")\n+\n+    diff = open("mindflow/unit_tests/dummy_diff.txt", "r").read()\n+    diffs, excluded_files = parse_git_diff(diff)\n+\n+    assert excluded_files == "b/"\n+\n+    print(list(diffs.keys()))\n \n     expected = {\n         "b/diff.txt": \'diff --git a/diff.txt b/diff.txt\\nindex de79139..e69de29 100644\\n--- a/diff.txt\\n+++ b/diff.txt\\n@@ -1,38 +0,0 @@\\n-diff --git a/mindflow/utils/diff_parser.py b/mindflow/utils/diff_parser.py\\n-new file mode 100644\\n-index 0000000..33a588f\\n---- /dev/null\\n-+++ b/mindflow/utils/diff_parser.py\\n-@@ -0,0 +1,31 @@\\n-+\\n-+\\n-+\\n-+def parse_git_diff_file(diff_file):\\n-+    diffs = {}\\n-+    current_file = None\\n-+    current_diff = []\\n-+\\n-+    with open(diff_file, "r") as f:\\n-+        for line in f:\\n-+            if line.startswith("diff --git"):\\n-+                # Starting a new file\\n-+                if current_file:\\n-+                    # Add the previous diff to the dictionary\\n-+                    diffs[current_file] = "".join(current_diff)\\n-+                current_file = line.split()[-1]\\n-+                current_diff = [line]\\n-+            else:\\n-+                current_diff.append(line)\\n-+\\n-+        # Add the last diff to the dictionary\\n-+        if current_file:\\n-+            diffs[current_file] = "".join(current_diff)\\n-+\\n-+    return diffs\\n-+\\n-+\\n-+diffs = parse_git_diff_file("diff.txt")\\n-+for filename, diff in diffs.items():\\n-+    print(f"Diff for {filename}:")\\n-+    print(diff)\\n-\\\\ No newline at end of file\\n\',\n',
        "b/mindflow/utils/diff_parser.py": 'diff --git a/mindflow/utils/diff_parser.py b/mindflow/utils/diff_parser.py\nindex c9d0d27..1d7b094 100644\n--- a/mindflow/utils/diff_parser.py\n+++ b/mindflow/utils/diff_parser.py\n@@ -4,36 +4,59 @@ import os\n IGNORE_FILE_EXTENSIONS = [".pyc", ".ipynb", ".ipynb_checkpoints"]\n \n \n-def parse_git_diff_file(diff_file):\n+def parse_git_diff(diff_str: str):\n     diffs = {}\n     current_file = None\n     current_diff = []\n \n-    with open(diff_file, "r") as f:\n-        for line in f:\n-            if line.startswith("diff --git"):\n-                # Starting a new file\n-                if current_file:\n-                    # Add the previous diff to the dictionary\n-                    diffs[current_file] = "".join(current_diff)\n-\n-                current_file = line.split()[-1]\n-                current_ext = os.path.splitext(current_file)[1]\n-\n-                if current_ext in IGNORE_FILE_EXTENSIONS:\n-                    # Ignore this file\n-                    current_file = None\n-                    current_diff = []\n-                    continue\n-\n-                current_diff = [line]\n-            else:\n-                # skip lines if we are ignoring this file (TODO - this is a bit hacky)\n-                if current_file:\n-                    current_diff.append(line)\n-\n-        # Add the last diff to the dictionary\n-        if current_file:\n-            diffs[current_file] = "".join(current_diff)\n-\n-    return diffs\n+    excluded_files = []\n+\n+    for line in diff_str.splitlines(keepends=True):\n+        if line.startswith("diff --git"):\n+            # Starting a new file\n+            if current_file:\n+                # Add the previous diff to the dictionary\n+                diffs[current_file] = "".join(current_diff)\n+\n+            current_file = line.split()[-1]\n+            current_ext = os.path.splitext(current_file)[1]\n+\n+            if current_ext in IGNORE_FILE_EXTENSIONS:\n+                excluded_files.append(current_file)\n+\n+                # Ignore this file\n+                current_file = None\n+                current_diff = []\n+                continue\n+\n+            current_diff = [line]\n+        else:\n+            # skip lines if we are ignoring this file (TODO - this is a bit hacky)\n+            if current_file:\n+                current_diff.append(line)\n+\n+    # Add the last diff to the dictionary\n+    if current_file:\n+        diffs[current_file] = "".join(current_diff)\n+\n+    return diffs, excluded_files\n+\n+\n+# Old implementation:\n+# def parse_git_diff(diff_output: str) -> List[Tuple[str, str]]:\n+#     file_diffs: List[Dict[str, List[str]]] = []\n+#     current_diff: Optional[Dict[str, List[str]]] = None\n+#     for line in diff_output.split("\\n"):\n+#         if line.startswith("diff --git"):\n+#             if current_diff is not None:\n+#                 file_diffs.append(current_diff)\n+#             current_diff = {"file_name": None, "content": []}  # type: ignore\n+#             match = re.match(r"^diff --git a/(.+?) b/.+?$", line)\n+#             if match:\n+#                 current_diff["file_name"] = match.group(1)  # type: ignore\n+#         if current_diff is not None:\n+#             current_diff["content"].append(line)\n+#     if current_diff is not None:\n+#         file_diffs.append(current_diff)\n+#     return [(diff["file_name"], "\\n".join(diff["content"])) for diff in file_diffs]  # type: ignore\n+\n',
    }

    assert diffs == expected
