import { ReactElement } from 'react';
import { MetricType } from '../../consts/Milvus';
import { DataTypeStringEnum } from '../collections/Types';

export enum INDEX_TYPES_ENUM {
  IVF_FLAT = 'IVF_FLAT',
  IVF_PQ = 'IVF_PQ',
  IVF_SQ8 = 'IVF_SQ8',
  IVF_SQ8_HYBRID = 'IVF_SQ8_HYBRID',
  FLAT = 'FLAT',
  HNSW = 'HNSW',
  ANNOY = 'ANNOY',
  RNSG = 'RNSG',
  BIN_IVF_FLAT = 'BIN_IVF_FLAT',
  BIN_FLAT = 'BIN_FLAT',
}

export interface Field {
  data_type: DataTypeStringEnum;
  fieldID: string;
  type_params: { key: string; value: string }[];
  is_primary_key: true;
  name: string;
  description: string;
}

export interface FieldData {
  _fieldId: string;
  _isPrimaryKey: boolean;
  _isAutoId: boolean;
  _fieldName: string;
  _fieldNameElement?: ReactElement;
  _fieldType: DataTypeStringEnum;
  _dimension: string;
  _desc: string;
}

export interface FieldView extends FieldData, IndexView {
  _createIndexDisabled?: boolean;
}

export interface Index {
  params: { key: string; value: string }[];
}

export interface IndexView {
  _fieldName: string;
  _indexType: string;
  _indexTypeElement?: ReactElement;
  _indexParameterPairs: { key: string; value: string }[];
  _indexParamElement?: ReactElement;
  _metricType?: MetricType | string;
}

export type IndexType =
  | INDEX_TYPES_ENUM.FLAT
  | INDEX_TYPES_ENUM.IVF_FLAT
  // | 'IVF_SQ8'
  // | 'IVF_SQ8_HYBRID'
  | INDEX_TYPES_ENUM.IVF_PQ
  // | 'RNSG'
  | INDEX_TYPES_ENUM.HNSW
  | INDEX_TYPES_ENUM.ANNOY
  | INDEX_TYPES_ENUM.BIN_IVF_FLAT
  | INDEX_TYPES_ENUM.BIN_FLAT;

export interface IndexManageParam {
  collection_name: string;
  field_name: string;
}

export interface IndexCreateParam extends IndexManageParam {
  extra_params: IndexExtraParam;
}

export interface IndexExtraParam {
  index_type: string;
  metric_type: string;
  params: string;
}

export interface SizingInfoParam {
  info: {
    memory: string;
    disk: string;
  } | null;
}
