## Mihdan: Disable Aggressive Updates

![Mihdan: Disable Aggressive Updates](screenshot.jpg)

WordPress плагин для ускорения админки WordPress путём отключения агрессивных проверок обновлений

Это на мой взгляд обязательная фитча для всех сайтов на WordPress, как принято говорить - маст хэв. Почему? Потому что проверка обновлений должна идти фоном и никак иначе, за очень редким исключением! Но давайте разберемся что к чему...

## Причина тормозов в админке

Думаю каждый, кто более-менее связан с WordPress замечал периодические тормоза при заходе на любую страницу админки: в консоль админки, на страницу плагинов или тем (здесь особенно!). Эти тормоза встречаются периодически: то медленно, то быстро... Происходит так из-за проверок WordPress о новых версиях: ядра, плагинов, тем и переводов...

Дело в том, что для проверки новых версий при генерации страницы PHP отправляет HTTP запрос, а точнее 3 запроса: ядро, темы, плагины... Если есть платные плагины, то на каждый плагин обычно еще один свой запрос... При HTTP запросе в PHP генерация страницы зависает пока каждый запрос не получит результат, а на каждый запрос уходит в среднем 0,5 - 1 секунд. Вот и получается, что страница виснет на 3-4 секунды.

Частота этих проверок на разных страницах админки такая:

- На странице `Консоль > Обновления` - раз в минуту.
- На странице `Плагины или Внешний вид > Темы` - раз в час.
- На любой странице в админке - раз в 12 часов (два раза в день).

Кроме того, эти проверки срабатывают во время события `'admin_init'`, а значит при AJAX запросах. Несмотря на то что это происходит раз в пол дня, все же неприятно когда кто-то будет ловить AJAX запрос с задержкой в 3 секунды... Кроме того, такое поведение для AJAX запросов работает и во фронтэнде, а это уже прям совсем не хорошо...

## Copyright

Оригинальная идея принадлежит [WordPress как на ладони](https://wp-kama.ru/id_8514/uskoryaem-adminku-wordpress-otklyuchaem-proverki-obnovlenij.html).
