% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replext_funcs.R
\name{lr_pow}
\alias{lr_pow}
\title{Calculate Power for Linear Regression Simulations}
\usage{
lr_pow(df_list, constr = 0, standardize = TRUE, alpha = 0.05)
}
\arguments{
\item{df_list}{A list of data frames, each representing a dataset for regression
analysis. Each data frame should contain the response variable 'y' and the
predictor variables 'x1', 'x2', ..., 'xp'.}

\item{constr}{The number of inequality constraints imposed on the regression
coefficients. It must be a non-negative integer less than or equal to the number
of predictors (p). A value of 0 implies no constraints or equality constraints.}

\item{standardize}{A logical value indicating whether the predictor variables
should be standardized before fitting the model. Default is TRUE.}

\item{alpha}{The significance level used in hypothesis testing, default is 0.05.}
}
\value{
A numeric value representing the calculated power, defined as the
proportion of datasets meeting the hypothesis test criteria as defined by
the constraints and significance level.
}
\description{
This function computes the power of hypothesis tests in a linear regression
setting, considering constraints on the regression coefficients. It processes a
list of data frames, each representing a different dataset, and calculates the
power based on specified constraints.
}
\details{
The function validates the 'constr' parameter, optionally standardizes
the predictor variables, constructs the necessary constraints, and calculates
power by fitting a linear model to each dataset. It uses the 'iht' function
from the 'restriktor' package to apply the constraints and evaluate the
hypothesis tests.
}
\examples{
generate_datasets_reg(S = 4, n = 30, p = 3, f2 = 0.20, rho = 0.5) |> lr_pow()

}
\references{
Vanbrabant, Leonard; Van De Schoot, Rens; Rosseel, Yves (2015). Constrained
statistical inference: sample-size tables for ANOVA and regression. Frontiers
in Psychology, 5. DOI:10.3389/fpsyg.2014.01565.
URL: https://www.frontiersin.org/articles/10.3389/fpsyg.2014.01565
}
