# Examples

This folder contains examples and tests for different features.

How to run examples:

```bash
npm i -g editly

git clone https://github.com/mifi/editly.git

cd editly/examples

git clone https://github.com/mifi/editly-assets.git assets

editly --fast commonFeatures.json5
```

## Image slideshow with Ken Burns zoom

![](https://github.com/mifi/gifs/raw/master/kenburns.gif)

[kenBurns.json5](https://github.com/mifi/editly/blob/master/examples/kenBurns.json5)

## News title

![](https://github.com/mifi/gifs/raw/master/newsTitle.gif)

[newsTitle.json5](https://github.com/mifi/editly/blob/master/examples/newsTitle.json5)

## Resize modes

![](https://github.com/mifi/gifs/raw/master/resizeHorizontal.gif)

[resizeHorizontal.json5](https://github.com/mifi/editly/blob/master/examples/resizeHorizontal.json5)

## Speed up / slow down with cutting

![](https://github.com/mifi/gifs/raw/master/speedTest.gif)

[speedTest.json5](https://github.com/mifi/editly/blob/master/examples/speedTest.json5)

## Title and subtitle

![](https://github.com/mifi/gifs/raw/master/subtitle.gif)

[subtitle.json5](https://github.com/mifi/editly/blob/master/examples/subtitle.json5)

## Video overlays with alpha channel

[alpha.json5](https://github.com/mifi/editly/blob/master/examples/alpha.json5)

## Image overlays with alpha channel

![](https://github.com/mifi/gifs/raw/master/imageOverlay.gif)

[imageOverlay.json5](https://github.com/mifi/editly/blob/master/examples/imageOverlay.json5)

## Partial overlays (B-roll)

[visibleFromUntil.json5](https://github.com/mifi/editly/blob/master/examples/visibleFromUntil.json5)

## Audio layers

- [audio1.json5](https://github.com/mifi/editly/blob/master/examples/audio1.json5)
- [audio2.json5](https://github.com/mifi/editly/blob/master/examples/audio2.json5)


## Custom HTML5 canvas Javascript

![](https://github.com/mifi/gifs/raw/master/customCanvas.gif)

[customCanvas.js](https://github.com/mifi/editly/blob/master/examples/customCanvas.js)

```bash
node customCanvas.js
```

## Custom Fabric.js

![](https://github.com/mifi/gifs/raw/master/customFabric.gif)

[customFabric.js](https://github.com/mifi/editly/blob/master/examples/customFabric.js)

```bash
node customFabric.js
```

## `fabricImagePostProcessing`

https://user-images.githubusercontent.com/907138/214545896-ab420beb-bd50-4974-9bad-9657e4f0c849.mp4

[fabricImagePostProcessing.js](fabricImagePostProcessing.js)

## LosslessCut tutorial

[This video](https://www.youtube.com/watch?v=pYHMxXy05Jg) was created with [losslesscut.json5](https://github.com/mifi/editly/blob/master/examples/losslesscut.json5)