# Contributing Guidelines

There are many different ways to contribute to this repo, including reporting issues, filing feature request, providing feedback and sending out pull requests.

## Issues and Feature Requests

Issues are submitted through [Issues](https://github.com/microsoft/testbase/issues) section.

Feature requests and feedback are submitted through [Discussions](https://github.com/microsoft/testbase/discussions) section.

## Pull Requests

### Update existing code

* Make sure
    * the updated source code can still be built successfully.
    * the new or updated test cases can pass.
    * the new or updated scripts can run successfully.
* Update any documentation that is impacted by your changes.

### Upload a new sample package

* Provide the sample application that is used in the sample package in two ways.
    * Include a readme file in the PR to specify how to get the app.
    * Include the source code of the sample app in the PR.
* Make sure
    * the new source code can be built successfully.
    * the new test cases can pass.
    * the new scripts can run successfully.
* Update any documentation that is impacted by your changes.

## Contributor License Agreement
Most contributions require you to agree to a
Contributor License Agreement (CLA) declaring that you have the right to, and actually do, grant us
the rights to use your contribution. For details, visit https://cla.opensource.microsoft.com.

When you submit a pull request, a CLA bot will automatically determine whether you need to provide
a CLA and decorate the PR appropriately (e.g., status check, comment). Simply follow the instructions
provided by the bot. You will only need to do this once across all repos using our CLA.

## Code of Conduct
This project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).

Resources:

- [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/)
- [Microsoft Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/)
- Contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with questions or concerns
