/*
 * Author: Landon Fuller <landonf@plausiblelabs.com>
 *
 * Copyright (c) 2008-2009 Plausible Labs Cooperative, Inc.
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#import "PLCrashReportSignalInfo.h"


/**
 * Provides access to the signal name and signal code.
 */
@implementation PLCrashReportSignalInfo {

    /** Signal name */
    __strong NSString *_name;
    
    /** Signal code */
    __strong NSString *_code;

    /** Fauling instruction or address */
    uint64_t _address;
}

/**
 * Initialize with the given signal name and reason.
 */
- (id) initWithSignalName: (NSString *) name code: (NSString *) code address: (uint64_t) address {
    if ((self = [super init]) == nil)
        return nil;
    
    _name = name;
    _code = code;
    _address = address;
    
    return self;
}

@synthesize name = _name;
@synthesize code = _code;
@synthesize address = _address;

@end
