# Fluent UI for iOS

##### The iOS UI framework for building experiences for Microsoft 365.

FluentUI for iOS is a native framework that provides the Microsoft UI experience for the iOS platform. It contains information about colors and typography, as well as custom controls and customizations for platform controls, all from the official Fluent design language used in Microsoft 365 products.

## Contents

- [Colors and typography](#colors-and-typography)
- [Controls](#controls)
- [Install and use FluentUI](#install-and-use-fluentui)
- [Demo app](#demo-app)
- [Targets](#targets)

## Colors and Typography

FluentUI for iOS provides [colors](Core/FluentTheme+Tokens.swift) and [typography](Core/FluentTheme+Tokens.swift) core to experiences within the Fluent Design language.

## Controls

FluentUI for iOS includes an expanding set of controls written in Swift and supporting Objective-C. These controls implement the Fluent Design language and provide consistency across Microsoft experiences.

Some of the controls available include:
- ActivityIndicator
- Avatar
- AvatarGroup
- BadgeView
- Button
- BottomCommandingController
- BottomSheetController
- Card
- CardNudge
- Color
- DateTimePicker
- DrawerController
- HUD
- IndeterminateProgressBar
- Label
- NavigationController
- NotificationView
- PeoplePicker
- PersonaButtonCarousel
- PersonaListView
- PillButtonBar
- PopupMenuController
- SearchBar
- SegmentedControl
- Separator
- ShimmerView
- SideTabBar
- TabBarView
- TableViewCell
- TableViewCellFileAccessoryView
- TableViewCellShimmer
- Tooltip

A full list of currently supported controls can be found here: [Components](Components).

## Demo app

Included in this repository is a demo of currently implemented controls. A full list of implemented controls available in the demo can be found here: [Demos](/Demos/FluentUIDemo_iOS/FluentUI.Demo/Demos).

To build and deploy the demo follow these steps:
- Download or clone the [FluentUI for iOS](https://github.com/microsoft/fluentui-apple) repository.
- Open `Demos/FluentUIDemo_iOS/FluentUI.Demo.xcodeproj` in Xcode.
- In the Xcode scheme menu choose `Demo.development` and choose a device to deploy to.
- Once deployed you can choose a control to demo from the list of controls on the selected device.

## Targets
Fluent UI for iOS builds both a framework target and a static library target. If you are adding, removing, or renaming files, please ensure that all files compile for both the framework and static library targets.
