# Button
## Overview
A `Button` triggers a single action or event.
Use `Button`s for important actions like submitting a response, committing a change, or moving to the next step.

### Styles
| | Style |
|---|---|
| Primary filled | ![Button-Primary-Filled.png](.attachments/Button-Primary-Filled.png) |
| Primary outline | ![Button-Primary-Outline.png](.attachments/Button-Primary-Outline.png) |
| Danger filled | ![Button-Danger-Filled.png](.attachments/Button-Danger-Filled.png) |
| Danger outline | ![Button-Danger-Outline.png](.attachments/Button-Danger-Outline.png) |
| Secondary outline | ![Button-Secondary-Outline.png](.attachments/Button-Secondary-Outline.png) |
| Tertiary outline | ![Button-Tertiary-Outline.png](.attachments/Button-Tertiary-Outline.png) |
| Borderless | ![Button-Borderless.png](.attachments/Button-Borderless.png) |

## Usage
### UIKit
The `Button` can be initialized with a `ButtonStyle` parameter as follows:
```Swift
let button = Button(style: style)
```
### SwiftUI
There is currently no SwiftUI implementation of the `Button`

## Implementation
### Control Name
`Button` in Swift, `MSFButton` in Objective-C

### Source Code
 - [Button.swift](https://github.com/microsoft/fluentui-apple/blob/main/Sources/FluentUI_iOS/Components/Button/Button.swift)
 - [ButtonTokenSet.swift](https://github.com/microsoft/fluentui-apple/blob/main/Sources/FluentUI_iOS/Components/Button/ButtonTokenSet.swift)
### Sample Code
 - [ButtonDemoController.swift](https://github.com/microsoft/fluentui-apple/blob/main/Demos/FluentUIDemo_iOS/FluentUI.Demo/Demos/ButtonDemoController.swift)

