//
//  Copyright (c) Microsoft Corporation. All rights reserved.
//  Licensed under the MIT License.
//

import AppKit
import FluentUI

class TestLinkViewController: NSViewController {
	let disabledLink: Link = {
		let disabledLinkTitle = "Disabled link with hover effects"
		let disabledLink = Link(title: disabledLinkTitle)
		disabledLink.toolTip = disabledLinkTitle

		return disabledLink
	}()

	override func loadView() {
		let url = URL(string: "https://github.com/microsoft/fluentui-apple")

		let linkWithNoUnderlineTitle = "FluentUI on GitHub"
		let linkWithNoUnderline = Link(title: linkWithNoUnderlineTitle, url: url)
		linkWithNoUnderline.toolTip = linkWithNoUnderlineTitle

		let linkWithHoverTitle = "FluentUI on GitHub (link with hover effects)"
		let linkWithHover = Link(title: linkWithHoverTitle, url: url)
		linkWithHover.toolTip = linkWithHoverTitle
		linkWithHover.showsUnderlineWhileMouseInside = true

		let linkWithHoverAndNoURLTitle = "Link with hover effects and no URL"
		let linkWithHoverAndNoURL = Link(title: linkWithHoverAndNoURLTitle)
		linkWithHoverAndNoURL.toolTip = linkWithHoverAndNoURLTitle
		linkWithHoverAndNoURL.showsUnderlineWhileMouseInside = true

		let linkWithOverridenTargetActionTitle = "Link with overridden Target/Action"
		let linkWithOverridenTargetAction = Link(title: linkWithOverridenTargetActionTitle)
		linkWithOverridenTargetAction.toolTip = linkWithOverridenTargetActionTitle
		linkWithOverridenTargetAction.showsUnderlineWhileMouseInside = true
		linkWithOverridenTargetAction.target = self
		linkWithOverridenTargetAction.action = #selector(displayAlert)

		let customLinkTitle = "FluentUI on GitHub (Link with custom font, color and image)"
		let customLink = Link(title: customLinkTitle, url: url)
		customLink.toolTip = customLinkTitle
		customLink.font = NSFont.systemFont(ofSize: 12.0, weight: NSFont.Weight.semibold)
		customLink.contentTintColor = .textColor
		customLink.image = NSImage(named: NSImage.goRightTemplateName)!
		customLink.image?.accessibilityDescription = customLinkTitle
		customLink.imagePosition = .imageTrailing

		disabledLink.showsUnderlineWhileMouseInside = true
		disabledLink.isEnabled = false
		disabledLink.target = self
		disabledLink.action = #selector(toggleLink)

		let toggleDisabledLinkTitle = "Toggle disabled link"
		let toggleDisabledLink = Link(title: toggleDisabledLinkTitle)
		toggleDisabledLink.toolTip = toggleDisabledLinkTitle
		toggleDisabledLink.showsUnderlineWhileMouseInside = true
		toggleDisabledLink.target = self
		toggleDisabledLink.action = #selector(toggleLink)

		let containerView = NSStackView(views: [
			linkWithNoUnderline,
			linkWithHover,
			linkWithHoverAndNoURL,
			linkWithOverridenTargetAction,
			customLink,
			disabledLink,
			toggleDisabledLink
		])
		containerView.edgeInsets = NSEdgeInsets(top: 100, left: 100, bottom: 100, right: 100)
		containerView.orientation = .vertical
		containerView.distribution = .gravityAreas
		view = containerView
	}

	@objc private func toggleLink() {
		disabledLink.isEnabled = !disabledLink.isEnabled
	}

	@objc private func displayAlert() {
		let alert = NSAlert()
		alert.messageText = "Alert"
		alert.informativeText = "This is an alert generated by a Link with an overridden Target/Action"
		alert.runModal()
	}
}
