## Contributing

Post bug reports, feature requests, and questions in [Issues](https://github.com/microsoft/fluentui-apple/issues).

This project welcomes contributions and suggestions.  Most contributions require you to agree to a
Contributor License Agreement (CLA) declaring that you have the right to, and actually do, grant us
the rights to use your contribution. For details, visit https://cla.opensource.microsoft.com.

When you submit a pull request, a CLA bot will automatically determine whether you need to provide
a CLA and decorate the PR appropriately (e.g., status check, comment). Simply follow the instructions
provided by the bot. You will only need to do this once across all repos using our CLA.

This project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).
For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/) or
contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.

### Prerequisite
#### Xcode
Make sure your local [Xcode version](https://github.com/microsoft/fluentui-apple#requirements) is the same as the supported version of the repo. 

#### Swift Lint
This project uses [SwiftLint](https://github.com/realm/SwiftLint) to automatically lint our Swift code for common errors. Please install it when developing in this repo by following the [SwiftLint Installation Instructions](https://realm.github.io/SwiftLint/).

### Developing in the repo

Fluent UI Apple requires all [pull requests](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/about-pull-requests) to come from forks of the repository. Please see [Fork a Repo - GitHub Help](https://help.github.com/en/github/getting-started-with-github/fork-a-repo) for more details on how to set up a fork of Microsoft/fluentui-apple, keep it up-to-date, and submit pull requests back to this repository.

Fluent UI Apple doesn't have any external code dependencies, so developing in the repository is as easy as launching the appropriate Xcode project or workspace and building and running a test/demo app.

For more detailed instructions on how to run the demo app in specific platform, please see [the iOS readme file](Sources/FluentUI_iOS/CONTRIBUTING.md) and the [the macOS readme file](Sources/FluentUI_macOS/CONTRIBUTING.md).

## Checklist before creating a pull request
Fill out all the information in your [PR description](https://github.com/microsoft/fluentui-apple/blob/main/.github/PULL_REQUEST_TEMPLATE.md#pull-request-checklist)

Once your pull request has been approved by @microsoft/fluentui-native team, if you have the write access you can squash-merge your changes or @microsoft/fluentui-native team member will merge it for you.
