# Contributing

## Repository layout

Files in `public/` are copied as-is to the final build output. Any files that should be packaged with the application can be put there.

Files in `src/` are processed and transpiled.

## Source code organization

Inside `src/`, there are:

* `components`: Reusable UI components
* `datastore`: Datastore for data shared among multiple components. Uses [redux](https://redux.js.org/)
* `fonts`: Autogenerated fonts; see [src/fonts/README.md](src/fonts/README.md)
* `native`: Code interfacing with native (non-web) features
* `schema`: Schemas used for input validation and autocomplete
* `view`: UI views
* `App.{css,tsx}`: Root React component
* `electronMain.js`: Electron entry point
* `index.{css,tsx}`: Index component (will be loaded with the page)
* `registerServiceWorker.js`: Service worker that caches content offline so resources can be accessed on a browser without internet connection
