﻿using System;
using System.Collections.Generic;
using System.Drawing;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using OpenQA.Selenium.Appium.Interactions;
using OpenQA.Selenium.Appium.Windows;
using OpenQA.Selenium;
using OpenQA.Selenium.Remote;

// Define an alias to OpenQA.Selenium.Appium.Interactions.PointerInputDevice to hide
// inherited OpenQA.Selenium.Interactions.PointerInputDevice that causes ambiguity.
// In the future, all functions of OpenQA.Selenium.Appium.Interactions should be moved
// up to OpenQA.Selenium.Interactions and this alias can simply be removed.
using PointerInputDevice = OpenQA.Selenium.Appium.Interactions.PointerInputDevice;

namespace SamplesTest
{
    public class SqueezenetSession
    {
        // This string key is present in RegisteredUserModeAppID under AppX/vs.appxrecipe
        // TODO: this string value has to be retrieved from local test machine
        // More information on https://github.com/Microsoft/WinAppDriver
        private const string SqueezenetAppId = "9B904DD1-22BF-4715-A2D3-B0F44457074A_7td7jx2gva3r8!App";
        protected static WindowsDriver<WindowsElement> session;

        public static void Setup(TestContext context)
        {
            if (session == null)
            {
                session = TestHelper.GetSession(SqueezenetAppId, "SqueezeNetObjectDetectionCS");
                // Set implicit timeout to 1.5 seconds to make element search to retry every 500 ms for at most three times
                session.Manage().Timeouts().ImplicitWait = TimeSpan.FromSeconds(1.5);
            }
        }

        public static void TearDown()
        {
            if (session != null)
            {
                session.Quit();
                session = null;
            }
        }
    }

    [TestClass]
    public class SqueezenetTest : SqueezenetSession
    {
        private static WindowsElement loadModelButton;
        private static WindowsElement pickImageButton;
        private static WindowsElement resetButton;
        private static WindowsElement statusBlock;

        [ClassInitialize]
        public static void ClassInitialize(TestContext context)
        {
            Setup(context);
            loadModelButton = session.FindElementByName("Load model");
            pickImageButton = session.FindElementByName("Pick image");
            resetButton = session.FindElementByName("Reset");
            statusBlock = session.FindElementByAccessibilityId("StatusBlock");
        }

        [ClassCleanup()]
        public static void ClassCleanup()
        {
            TearDown();
        }

        [TestMethod]
        public void TestTabbyCat()
        {
            string tabbyCatPath = System.AppDomain.CurrentDomain.BaseDirectory + "\\kitten_224.png";
            TestImageFile(tabbyCatPath, "\"tabby, tabby cat\" with confidence of 0.93");
        }

        [TestMethod]
        public void TestFish()
        {
            string fishPath = System.AppDomain.CurrentDomain.BaseDirectory + "\\fish.png";
            TestImageFile(fishPath, "\"tench, Tinca tinca\" with confidence of 0.738");
        }

        public void TestImageFile(string filePath, string expectedResult)
        {
            resetButton.Click();
            System.Threading.Thread.Sleep(100);
            loadModelButton.Click();
            // wait for model to load
            System.Threading.Thread.Sleep(2000);
            pickImageButton.Click();
            // wait for file picker window to pop up
            System.Threading.Thread.Sleep(3000);
            session.Keyboard.SendKeys(filePath);
            session.Keyboard.SendKeys(Keys.Enter);
            System.Threading.Thread.Sleep(1000);
            string result = statusBlock.Text;
            Assert.IsTrue(result.Contains(expectedResult));
        }
    }
}
