# Windows ML Samples Gallery: Adapter Selection
Select different adapters based on your power and performance needs.

The sample showcases how to use Windows ML with different adapters that have tradeoffs between power and performance.

<img src="Docs/AdapterSelectionScreenshot.png" width="650"/>

- [Getting Started](#getting-started)
- [Feedback](#feedback)
- [External Links](#external-links)

## Getting Started
- Check out the [source](https://github.com/microsoft/Windows-Machine-Learning/blob/master/Samples/WinMLSamplesGallery/WinMLSamplesGallery/Samples/AdapterSelection/AdapterSelection.xaml.cs).
- Learn how to [get a list of adapters using DXCore](https://github.com/microsoft/Windows-Machine-Learning/blob/master/Samples/WinMLSamplesGallery/WinMLSamplesGalleryNative/AdapterList.cpp#L12) to your session.
- Learn how to [create learning model devices from adapters](https://github.com/microsoft/Windows-Machine-Learning/blob/master/Samples/WinMLSamplesGallery/WinMLSamplesGalleryNative/AdapterList.cpp#L46).

## Feedback
Please file an issue [here](https://github.com/microsoft/Windows-Machine-Learning/issues/new) if you encounter any issues with the Windows ML Samples Gallery or wish to request a new sample.

## External Links
- [Windows ML Library (WinML)](https://docs.microsoft.com/en-us/windows/ai/windows-ml/)
- [DirectML](https://github.com/microsoft/directml)
- [ONNX Model Zoo](https://github.com/onnx/models)
- [Windows UI Library (WinUI)](https://docs.microsoft.com/en-us/windows/apps/winui/) 
