# Base SSL Algorithms

In addtion to fully-supervised method (as a baseline), USB supports the following popular 16 algorithms:

1. [PiModel](https://arxiv.org/abs/1507.02672): is a simple SSL algorithm that forces the output probability of perturbed versions of unlabeled data be the same which uses Mean Squared Error (MSE) for optimization.
2. [Pseudo-Label](https://citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.664.3543): turns the output probability of unlabeled data into the 'one-hot' hard one and makes the same unlabeled data to learn the pseudo 'one-hot' label. Pseudo Labeling uses CE for optimization.
3. [MeanTeacher](https://arxiv.org/abs/1703.01780): takes the exponential moving average (EMA) of the neural model as the teacher model. With Mean Teacher, the neural model forces itself to output a similar probability to the EMA teacher. Though the later SSL algorithms will not always choose the EMA model as the teacher, they often use the EMA model for validation/test cause it decreases the risk of neural models falling into the local optima.
4. [VAT](https://arxiv.org/abs/1704.03976): enhances the robustness of the conditional predicted label distribution around each unlabeled data against an adversarial perturbation. In other words, VAT forces the neural model to give similar predictions on unlabeled data even facing a strong adversarial perturbation.
5. [MixMatch](https://proceedings.neurips.cc/paper/2019/file/1cd138d0499a68f4bb72bee04bbec2d7-Paper.pdf): first introduces Mixup into SSL by taking the input as the mixture of labeled and unlabeled data and the output as the mixture of labels and model predictions on unlabeled data. Note that MixMatch also utilizes MSE as the unsupervised loss.
6. [ReMixMatch](https://arxiv.org/abs/1911.09785): can be seen as the upgraded version of MixMatch. ReMixMatch improves MixMatch by (1) proposing stronger augmentation (i.e., Control Theory Augmentation (CTAugment) for unlabeled data; (2) using Augmentation Anchoring to force the model to output similar predictions to weakly augmented unlabeled data when fed strongly augmented data; (3) utilizing Distribution Alignment to encourage the marginal distribution of predictions on unlabeled data to be similar to the marginal distribution of labeled data.
7. [UDA](https://arxiv.org/abs/1904.12848): also introduces strong augmentation (i.e., RandAugment) for unlabeled data. The core idea of UDA is similar to Augmentation Anchoring, which forces the predictions of neural models on the strongly-augmented unlabeled data to be close to those of weakly-augmented unlabeled data. Instead of turning predictions into hard 'one-hot' pseudo-labels, UDA sharpens the prediction on unlabeled data. Thresholding technique is used to mask out unconfident unlabeled samples that is considered noise here.
8. [FixMatch](https://arxiv.org/abs/2001.07685): is the upgraded version of Pseudo Labeling. FixMatch turns the predictions on weakly-augmented unlabeled data into hard 'one-hot' pseudo-labels and then further uses them as the learning signal of strongly-augmented unlabeled data. FixMatch finds that using a high threshold (e.g., 0.95) to filter noisy unlabeled predictions and take the rest as the pseudo-label can achieve very good performance.
9. [Dash](https://arxiv.org/abs/2109.00650): improves the FixMatch by using a gradually increased threshold instead of a fixed threshold, which allows more unlabeled data to participate in the training at the early stage. Moreover, Dash theoretically establishes the convergence rate from the view of non-convex optimization.
10. [CoMatch](https://arxiv.org/abs/2011.11183): firstly introduces contrastive learning into SSL. Except for consistency regularizing on the class probabilities, it is also exploited on graph-based feature representations, which imposes smooth constraints on pseudo-labels generated.
11. [CRMatch](https://arxiv.org/abs/2112.05825): proposed an improved consistency regularization framework which impose consistency and equivariance on the classification probability and the feature level.
12. [FlexMatch](https://arxiv.org/abs/2110.08263): firstly introduces the class-specific thresholds into SSL by considering the different learning difficulties of different classes. Specifically, the hard-to-learn classes should have a low threshold to speed up convergence while the easy-to-learn classes should have a high threshold to avoid confirmation bias.
13. [AdaMatch](https://arxiv.org/abs/2106.04732): is proposed mainly for domain adaption, but can also adapted to SSL. It is characterized by Relative Threshold and Distribution Alignment, where the relative threshold is adaptively estimated from EMA of the confidence on labeled data.
14. [SimMatch](https://arxiv.org/abs/2203.06915): extends [CoMatch](https://arxiv.org/abs/2011.11183) by considering semantic-level and instance-level consistency regularization. Similar similarity relationship of different augmented versions on the same data with respect to other instances is encouraged during training. In addition, a memory buffer consisting of predictions on labeled data is adopted to connect the two-level regularization.
15. [Freematch](https://arxiv.org/abs/2205.07246): 
16. [SoftMatch](https://openreview.net/forum?id=ymt1zQXBDiF&referrer=%5BAuthor%20Console%5D(%2Fgroup%3Fid%3DICLR.cc%2F2023%2FConference%2FAuthors%23your-submissions)):
17. [DeFixMatch] (https://arxiv.org/abs/2203.07512)