# Getting started

The MixedReality-WebRTC project is comprised of several entities:

- A **C library** to integrate into a native C/C++ application
- A **C# library** to integrate into a C# application
- A **Unity library** to help integrate into an existing Unity application

Not all libraries are required for all use cases, but each library builds upon the previous one. This means that for use in a C++ application only the C library needs to be installed. But the Unity library requires installing also the C# and C libraries.

In this chapter we discuss:

- [**Download**](download.md) : Downloading precompiled binary packages of MixedReality-WebRTC.
- [**Installation**](installation.md) : How to install the various libraries for use in your poject.
- [**Building from sources**](building.md) : Building the MixedReality-WebRTC from sources.
- [**Hello, C# world! (Desktop)**](cs/helloworld-cs-core3.md) : Your first C# .NET Core 3.0 application based on the C# library.
- [**Hello, C# world! (UWP)**](cs/helloworld-cs-uwp.md) : Your first C# UWP application based on the C# library.
- [**Hello, Unity world!**](unity/helloworld-unity.md) : Your first Unity application based on the Unity library.

Users migrating from a previous version of the libraries can consult the [**Migration Guide**](migration-guide.md).
