# Microsoft Support for Azure Kinect DK Sensor SDK

Every Microsoft product has a lifecycle, including Azure Kinect Sensor SDK. The lifecycle begins when a product is released and ends when it's no longer supported. Knowing key dates in this lifecycle helps you make informed decisions about when to upgrade or make other changes to your software. This product is governed by the [Microsoft Modern Lifecycle](https://support.microsoft.com/help/30881/modern-lifecycle-policy).

This document describes the support lifecycle for: Azure Kinect Sensor SDK.

## Azure Kinect DK Sensor SDK - End of Support / Retirement
Microsoft announced [End of Production of Azure Kinect DK](https://techcommunity.microsoft.com/t5/mixed-reality-blog/microsoft-s-azure-kinect-developer-kit-technology-transfers-to/ba-p/3899122) on Aug 17th 2023. 
End of Support / Retirement Date for Azure Kinect DK Sensor SDK is Aug 16th 2024.


## Release Types

Microsoft produces **Long Term Support (LTS)** and **Current** releases, which are defined as:

* **LTS** releases are designed for long-term support. They included features and components that have been stabilized, requiring few updates over a longer support release lifetime. These releases are a good choice for hosting applications that you do not intend to update.
* **Current** releases include new features that may undergo future change based on feedback. These releases are a good choice for applications in active development, giving you access to the latest features and improvements. You need to upgrade to later Sensor SDK releases more often to stay in support.

Both types of releases receive critical fixes throughout their lifecycle, for security, reliability, or to add support for new operating system versions. You must stay up-to-date with the latest patches to qualify for support.

## Release Support Policies

Azure Kinect Sensor SDK releases are supported according to the following policies.

### Long Term Support (LTS) releases

LTS releases are supported for three years after the initial release.

### Current releases

Current releases are supported for three months after a subsequent Current or LTS release.

### Maintenance releases

Maintenance releases are in the last stage of the lifecycle . During Maintenance, a release will receive security updates. The length of Maintenance time is 3 months for Current and 1 year for LTS.

### End of support

End of support refers to the date when Microsoft no longer provides fixes, updates, or online technical assistance. As this date nears, make sure you have the latest available update\* installed. Without Microsoft support, you will no longer receive security updates that can help protect your machine from harmful viruses, spyware, and other malicious software that can steal your personal information.

\* Updates are cumulative, with each update built upon all of the updates that preceded it. A device needs to install the latest update to remain supported. Updates may include new features, fixes (security and/or non-security), or a combination of both. Not all features in an update will work on all devices. Update availability may vary, for example by country, region, network connectivity, or hardware capabilities (including, for example, free disk space).
