# Azure Kinect Transformation Example

## Introduction

The Azure Kinect Transformation Example shows the transformations between a color image, a depth image, and a point cloud.
It has two modes: the **capture** mode and the **playback** mode.

The Azure Kinect Transformation Example demonstrates the use of the Azure Kinect transformation functions
`k4a_transformation_color_image_to_depth_camera()`, `k4a_transformation_depth_image_to_color_camera()` and 
`k4a_transformation_depth_image_to_point_cloud()`.

### Capture Mode

The **capture** mode in the example uses the device to record one capture (depth map + color image) and writes two color
point cloud files (`color_to_depth.ply` and `depth_to_color.ply`) to the directory specified by the user. The directory
provided by the user needs to exist. The color point cloud files can be viewed using [Meshlab](http://www.meshlab.net/).

The first point cloud file (`color_to_depth.ply`) is generated by warping the color image into the geometry of the depth
camera using `k4a_transformation_color_image_to_depth_camera()`. The resulting transformed color image provides a 
corresponding BGRA color reading for every pixel of the depth map.

The second point cloud file (`depth_to_color.ply`) is generated by warping the depth map into the geometry of the color
camera using `k4a_transformation_depth_image_to_color_camera()`. The resulting transformed depth map provides a 
corresponding depth reading for every pixel of the color image.

### Playback Mode

The **playback** mode extracts a single frame in a recording into a point cloud. The recording should be captured using
`K4ARecorder` and should contain at least a color channel and a depth channel, along with calibration information.
The point cloud is generated by warping the depth map into the geometry of the color camera and is stored in the `.ply`
format. Note that the color channel needs to be in MJPEG format.

## Usage Info

```
transformation_example capture <output_directory> [device_id]
transformation_example playback <filename.mkv> [timestamp (ms)] [output_file]
```

### Examples:

```
transformation_example capture c:\temp\
transformation_example capture output 1

transformation_example playback output.mkv
transformation_example playback output.mkv 2000
transformation_example playback output.mkv 2000 c:\data\out.ply
```
