/****************************************************************************
 * libs/libnx/nxfonts/nxfonts_bitmaps.c
 *
 *   Copyright (C) 2008-2009, 2011 Gregory Nutt. All rights reserved.
 *   Author: Gregory Nutt <gnutt@nuttx.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name NuttX nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT}
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING}
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

#include <stdint.h>
#include <nuttx/nx/nxfonts.h>

#include "nxfonts.h"

/* Pick the fontset */

#if NXFONTS_FONTID == 1
#  include "nxfonts_sans23x27.h"
#elif NXFONTS_FONTID == 2
#  include "nxfonts_sans22x29.h"
#elif NXFONTS_FONTID == 3
#  include "nxfonts_sans28x37.h"
#elif NXFONTS_FONTID == 4
#  include "nxfonts_sans39x48.h"
#elif NXFONTS_FONTID == 5
#  include "nxfonts_sans22x29b.h"
#elif NXFONTS_FONTID == 6
#  include "nxfonts_sans28x37b.h"
#elif NXFONTS_FONTID == 7
#  include "nxfonts_sans40x49b.h"
#elif NXFONTS_FONTID == 8
#  include "nxfonts_serif22x29.h"
#elif NXFONTS_FONTID == 9
#  include "nxfonts_serif29x37.h"
#elif NXFONTS_FONTID == 10
#  include "nxfonts_serif38x48.h"
#elif NXFONTS_FONTID == 11
#  include "nxfonts_serif22x28b.h"
#elif NXFONTS_FONTID == 12
#  include "nxfonts_serif27x38b.h"
#elif NXFONTS_FONTID == 13
#  include "nxfonts_serif38x49b.h"
#elif NXFONTS_FONTID == 14
#  include "nxfonts_sans17x22.h"
#elif NXFONTS_FONTID == 15
#  include "nxfonts_sans20x26.h"
#elif NXFONTS_FONTID == 16
#  include "nxfonts_sans17x23b.h"
#elif NXFONTS_FONTID == 17
#  include "nxfonts_sans20x27b.h"
#elif NXFONTS_FONTID == 18
#  include "nxfonts_mono5x8.h"
#elif NXFONTS_FONTID == 19
#  include "nxfonts_pixel-unicode.h"
#elif NXFONTS_FONTID == 20
#  include "nxfonts_pixel-lcd-machine.h"
#elif NXFONTS_FONTID == 21
#  include "nxfonts_x11-misc-fixed-4x6.h"
#elif NXFONTS_FONTID == 22
#  include "nxfonts_x11-misc-fixed-5x7.h"
#elif NXFONTS_FONTID == 23
#  include "nxfonts_x11-misc-fixed-5x8.h"
#elif NXFONTS_FONTID == 24
#  include "nxfonts_x11-misc-fixed-6x9.h"
#elif NXFONTS_FONTID == 25
#  include "nxfonts_x11-misc-fixed-6x10.h"
#elif NXFONTS_FONTID == 26
#  include "nxfonts_x11-misc-fixed-6x12.h"
#elif NXFONTS_FONTID == 27
#  include "nxfonts_x11-misc-fixed-6x13.h"
#elif NXFONTS_FONTID == 28
#  include "nxfonts_x11-misc-fixed-6x13B.h"
#elif NXFONTS_FONTID == 29
#  include "nxfonts_x11-misc-fixed-6x13O.h"
#elif NXFONTS_FONTID == 30
#  include "nxfonts_x11-misc-fixed-7x13.h"
#elif NXFONTS_FONTID == 31
#  include "nxfonts_x11-misc-fixed-7x13B.h"
#elif NXFONTS_FONTID == 32
#  include "nxfonts_x11-misc-fixed-7x13O.h"
#elif NXFONTS_FONTID == 33
#  include "nxfonts_x11-misc-fixed-7x14.h"
#elif NXFONTS_FONTID == 34
#  include "nxfonts_x11-misc-fixed-7x14B.h"
#elif NXFONTS_FONTID == 35
#  include "nxfonts_x11-misc-fixed-8x13.h"
#elif NXFONTS_FONTID == 36
#  include "nxfonts_x11-misc-fixed-8x13B.h"
#elif NXFONTS_FONTID == 37
#  include "nxfonts_x11-misc-fixed-8x13O.h"
#elif NXFONTS_FONTID == 38
#  include "nxfonts_x11-misc-fixed-9x15.h"
#elif NXFONTS_FONTID == 39
#  include "nxfonts_x11-misc-fixed-9x15B.h"
#elif NXFONTS_FONTID == 40
#  include "nxfonts_x11-misc-fixed-9x18.h"
#elif NXFONTS_FONTID == 41
#  include "nxfonts_x11-misc-fixed-9x18B.h"
#elif NXFONTS_FONTID == 42
#  include "nxfonts_x11-misc-fixed-10x20.h"
#elif NXFONTS_FONTID == 43
#  include "nxfonts_tom-thumb-4x6.h"
#else
#  error "No font ID specified"
#endif

/****************************************************************************
 * Pre-Processor Definitions
 ****************************************************************************/

#define NXFONT_N7BITFONTS (NXFONT_MAX7BIT - NXFONT_MIN7BIT + 1)
#define NXFONT_N8BITFONTS (NXFONT_MAX8BIT - NXFONT_MIN8BIT + 1)

#define NXFONT_CONCAT(a,b) a##b
#define NXFONT_DEFBITMAP(n) \
static const uint8_t NXFONT_CONCAT(g_bitmap_,n)[] = NXFONT_CONCAT(NXFONT_BITMAP_,n)
#define NXFONT_DEFMETRIC(n) \
  { NXFONT_CONCAT(NXFONT_METRICS_,n), NXFONT_CONCAT(g_bitmap_,n) }
#define NXF_SYMNAME(a,b)  NXFONT_CONCAT(a,b)

/****************************************************************************
 * Private Data
 ****************************************************************************/

#if NXFONT_MIN7BIT <= 0 && NXFONT_MAX7BIT >= 0
NXFONT_DEFBITMAP(0);
#endif
#if NXFONT_MIN7BIT <= 1 && NXFONT_MAX7BIT >= 1
NXFONT_DEFBITMAP(1);
#endif
#if NXFONT_MIN7BIT <= 2 && NXFONT_MAX7BIT >= 2
NXFONT_DEFBITMAP(2);
#endif
#if NXFONT_MIN7BIT <= 3 && NXFONT_MAX7BIT >= 3
NXFONT_DEFBITMAP(3);
#endif
#if NXFONT_MIN7BIT <= 4 && NXFONT_MAX7BIT >= 4
NXFONT_DEFBITMAP(4);
#endif
#if NXFONT_MIN7BIT <= 5 && NXFONT_MAX7BIT >= 5
NXFONT_DEFBITMAP(5);
#endif
#if NXFONT_MIN7BIT <= 6 && NXFONT_MAX7BIT >= 6
NXFONT_DEFBITMAP(6);
#endif
#if NXFONT_MIN7BIT <= 7 && NXFONT_MAX7BIT >= 7
NXFONT_DEFBITMAP(7);
#endif
#if NXFONT_MIN7BIT <= 8 && NXFONT_MAX7BIT >= 8
NXFONT_DEFBITMAP(8);
#endif
#if NXFONT_MIN7BIT <= 9 && NXFONT_MAX7BIT >= 9
NXFONT_DEFBITMAP(9);
#endif
#if NXFONT_MIN7BIT <= 10 && NXFONT_MAX7BIT >= 10
NXFONT_DEFBITMAP(10);
#endif
#if NXFONT_MIN7BIT <= 11 && NXFONT_MAX7BIT >= 11
NXFONT_DEFBITMAP(11);
#endif
#if NXFONT_MIN7BIT <= 12 && NXFONT_MAX7BIT >= 12
NXFONT_DEFBITMAP(12);
#endif
#if NXFONT_MIN7BIT <= 13 && NXFONT_MAX7BIT >= 13
NXFONT_DEFBITMAP(13);
#endif
#if NXFONT_MIN7BIT <= 14 && NXFONT_MAX7BIT >= 14
NXFONT_DEFBITMAP(14);
#endif
#if NXFONT_MIN7BIT <= 15 && NXFONT_MAX7BIT >= 15
NXFONT_DEFBITMAP(15);
#endif
#if NXFONT_MIN7BIT <= 16 && NXFONT_MAX7BIT >= 16
NXFONT_DEFBITMAP(16);
#endif
#if NXFONT_MIN7BIT <= 17 && NXFONT_MAX7BIT >= 17
NXFONT_DEFBITMAP(17);
#endif
#if NXFONT_MIN7BIT <= 18 && NXFONT_MAX7BIT >= 18
NXFONT_DEFBITMAP(18);
#endif
#if NXFONT_MIN7BIT <= 19 && NXFONT_MAX7BIT >= 19
NXFONT_DEFBITMAP(19);
#endif
#if NXFONT_MIN7BIT <= 20 && NXFONT_MAX7BIT >= 20
NXFONT_DEFBITMAP(20);
#endif
#if NXFONT_MIN7BIT <= 21 && NXFONT_MAX7BIT >= 21
NXFONT_DEFBITMAP(21);
#endif
#if NXFONT_MIN7BIT <= 22 && NXFONT_MAX7BIT >= 22
NXFONT_DEFBITMAP(22);
#endif
#if NXFONT_MIN7BIT <= 23 && NXFONT_MAX7BIT >= 23
NXFONT_DEFBITMAP(23);
#endif
#if NXFONT_MIN7BIT <= 24 && NXFONT_MAX7BIT >= 24
NXFONT_DEFBITMAP(24);
#endif
#if NXFONT_MIN7BIT <= 25 && NXFONT_MAX7BIT >= 25
NXFONT_DEFBITMAP(25);
#endif
#if NXFONT_MIN7BIT <= 26 && NXFONT_MAX7BIT >= 26
NXFONT_DEFBITMAP(26);
#endif
#if NXFONT_MIN7BIT <= 27 && NXFONT_MAX7BIT >= 27
NXFONT_DEFBITMAP(27);
#endif
#if NXFONT_MIN7BIT <= 28 && NXFONT_MAX7BIT >= 28
NXFONT_DEFBITMAP(28);
#endif
#if NXFONT_MIN7BIT <= 29 && NXFONT_MAX7BIT >= 29
NXFONT_DEFBITMAP(29);
#endif
#if NXFONT_MIN7BIT <= 30 && NXFONT_MAX7BIT >= 30
NXFONT_DEFBITMAP(30);
#endif
#if NXFONT_MIN7BIT <= 31 && NXFONT_MAX7BIT >= 31
NXFONT_DEFBITMAP(31);
#endif
#if NXFONT_MIN7BIT <= 32 && NXFONT_MAX7BIT >= 32
NXFONT_DEFBITMAP(32);
#endif
#if NXFONT_MIN7BIT <= 33 && NXFONT_MAX7BIT >= 33
NXFONT_DEFBITMAP(33);
#endif
#if NXFONT_MIN7BIT <= 34 && NXFONT_MAX7BIT >= 34
NXFONT_DEFBITMAP(34);
#endif
#if NXFONT_MIN7BIT <= 35 && NXFONT_MAX7BIT >= 35
NXFONT_DEFBITMAP(35);
#endif
#if NXFONT_MIN7BIT <= 36 && NXFONT_MAX7BIT >= 36
NXFONT_DEFBITMAP(36);
#endif
#if NXFONT_MIN7BIT <= 37 && NXFONT_MAX7BIT >= 37
NXFONT_DEFBITMAP(37);
#endif
#if NXFONT_MIN7BIT <= 38 && NXFONT_MAX7BIT >= 38
NXFONT_DEFBITMAP(38);
#endif
#if NXFONT_MIN7BIT <= 39 && NXFONT_MAX7BIT >= 39
NXFONT_DEFBITMAP(39);
#endif
#if NXFONT_MIN7BIT <= 40 && NXFONT_MAX7BIT >= 40
NXFONT_DEFBITMAP(40);
#endif
#if NXFONT_MIN7BIT <= 41 && NXFONT_MAX7BIT >= 41
NXFONT_DEFBITMAP(41);
#endif
#if NXFONT_MIN7BIT <= 42 && NXFONT_MAX7BIT >= 42
NXFONT_DEFBITMAP(42);
#endif
#if NXFONT_MIN7BIT <= 43 && NXFONT_MAX7BIT >= 43
NXFONT_DEFBITMAP(43);
#endif
#if NXFONT_MIN7BIT <= 44 && NXFONT_MAX7BIT >= 44
NXFONT_DEFBITMAP(44);
#endif
#if NXFONT_MIN7BIT <= 45 && NXFONT_MAX7BIT >= 45
NXFONT_DEFBITMAP(45);
#endif
#if NXFONT_MIN7BIT <= 46 && NXFONT_MAX7BIT >= 46
NXFONT_DEFBITMAP(46);
#endif
#if NXFONT_MIN7BIT <= 47 && NXFONT_MAX7BIT >= 47
NXFONT_DEFBITMAP(47);
#endif
#if NXFONT_MIN7BIT <= 48 && NXFONT_MAX7BIT >= 48
NXFONT_DEFBITMAP(48);
#endif
#if NXFONT_MIN7BIT <= 49 && NXFONT_MAX7BIT >= 49
NXFONT_DEFBITMAP(49);
#endif
#if NXFONT_MIN7BIT <= 50 && NXFONT_MAX7BIT >= 50
NXFONT_DEFBITMAP(50);
#endif
#if NXFONT_MIN7BIT <= 51 && NXFONT_MAX7BIT >= 51
NXFONT_DEFBITMAP(51);
#endif
#if NXFONT_MIN7BIT <= 52 && NXFONT_MAX7BIT >= 52
NXFONT_DEFBITMAP(52);
#endif
#if NXFONT_MIN7BIT <= 53 && NXFONT_MAX7BIT >= 53
NXFONT_DEFBITMAP(53);
#endif
#if NXFONT_MIN7BIT <= 54 && NXFONT_MAX7BIT >= 54
NXFONT_DEFBITMAP(54);
#endif
#if NXFONT_MIN7BIT <= 55 && NXFONT_MAX7BIT >= 55
NXFONT_DEFBITMAP(55);
#endif
#if NXFONT_MIN7BIT <= 56 && NXFONT_MAX7BIT >= 56
NXFONT_DEFBITMAP(56);
#endif
#if NXFONT_MIN7BIT <= 57 && NXFONT_MAX7BIT >= 57
NXFONT_DEFBITMAP(57);
#endif
#if NXFONT_MIN7BIT <= 58 && NXFONT_MAX7BIT >= 58
NXFONT_DEFBITMAP(58);
#endif
#if NXFONT_MIN7BIT <= 59 && NXFONT_MAX7BIT >= 59
NXFONT_DEFBITMAP(59);
#endif
#if NXFONT_MIN7BIT <= 60 && NXFONT_MAX7BIT >= 60
NXFONT_DEFBITMAP(60);
#endif
#if NXFONT_MIN7BIT <= 61 && NXFONT_MAX7BIT >= 61
NXFONT_DEFBITMAP(61);
#endif
#if NXFONT_MIN7BIT <= 62 && NXFONT_MAX7BIT >= 62
NXFONT_DEFBITMAP(62);
#endif
#if NXFONT_MIN7BIT <= 63 && NXFONT_MAX7BIT >= 63
NXFONT_DEFBITMAP(63);
#endif
#if NXFONT_MIN7BIT <= 64 && NXFONT_MAX7BIT >= 64
NXFONT_DEFBITMAP(64);
#endif
#if NXFONT_MIN7BIT <= 65 && NXFONT_MAX7BIT >= 65
NXFONT_DEFBITMAP(65);
#endif
#if NXFONT_MIN7BIT <= 66 && NXFONT_MAX7BIT >= 66
NXFONT_DEFBITMAP(66);
#endif
#if NXFONT_MIN7BIT <= 67 && NXFONT_MAX7BIT >= 67
NXFONT_DEFBITMAP(67);
#endif
#if NXFONT_MIN7BIT <= 68 && NXFONT_MAX7BIT >= 68
NXFONT_DEFBITMAP(68);
#endif
#if NXFONT_MIN7BIT <= 69 && NXFONT_MAX7BIT >= 69
NXFONT_DEFBITMAP(69);
#endif
#if NXFONT_MIN7BIT <= 70 && NXFONT_MAX7BIT >= 70
NXFONT_DEFBITMAP(70);
#endif
#if NXFONT_MIN7BIT <= 71 && NXFONT_MAX7BIT >= 71
NXFONT_DEFBITMAP(71);
#endif
#if NXFONT_MIN7BIT <= 72 && NXFONT_MAX7BIT >= 72
NXFONT_DEFBITMAP(72);
#endif
#if NXFONT_MIN7BIT <= 73 && NXFONT_MAX7BIT >= 73
NXFONT_DEFBITMAP(73);
#endif
#if NXFONT_MIN7BIT <= 74 && NXFONT_MAX7BIT >= 74
NXFONT_DEFBITMAP(74);
#endif
#if NXFONT_MIN7BIT <= 75 && NXFONT_MAX7BIT >= 75
NXFONT_DEFBITMAP(75);
#endif
#if NXFONT_MIN7BIT <= 76 && NXFONT_MAX7BIT >= 76
NXFONT_DEFBITMAP(76);
#endif
#if NXFONT_MIN7BIT <= 77 && NXFONT_MAX7BIT >= 77
NXFONT_DEFBITMAP(77);
#endif
#if NXFONT_MIN7BIT <= 78 && NXFONT_MAX7BIT >= 78
NXFONT_DEFBITMAP(78);
#endif
#if NXFONT_MIN7BIT <= 79 && NXFONT_MAX7BIT >= 79
NXFONT_DEFBITMAP(79);
#endif
#if NXFONT_MIN7BIT <= 80 && NXFONT_MAX7BIT >= 80
NXFONT_DEFBITMAP(80);
#endif
#if NXFONT_MIN7BIT <= 81 && NXFONT_MAX7BIT >= 81
NXFONT_DEFBITMAP(81);
#endif
#if NXFONT_MIN7BIT <= 82 && NXFONT_MAX7BIT >= 82
NXFONT_DEFBITMAP(82);
#endif
#if NXFONT_MIN7BIT <= 83 && NXFONT_MAX7BIT >= 83
NXFONT_DEFBITMAP(83);
#endif
#if NXFONT_MIN7BIT <= 84 && NXFONT_MAX7BIT >= 84
NXFONT_DEFBITMAP(84);
#endif
#if NXFONT_MIN7BIT <= 85 && NXFONT_MAX7BIT >= 85
NXFONT_DEFBITMAP(85);
#endif
#if NXFONT_MIN7BIT <= 86 && NXFONT_MAX7BIT >= 86
NXFONT_DEFBITMAP(86);
#endif
#if NXFONT_MIN7BIT <= 87 && NXFONT_MAX7BIT >= 87
NXFONT_DEFBITMAP(87);
#endif
#if NXFONT_MIN7BIT <= 88 && NXFONT_MAX7BIT >= 88
NXFONT_DEFBITMAP(88);
#endif
#if NXFONT_MIN7BIT <= 89 && NXFONT_MAX7BIT >= 89
NXFONT_DEFBITMAP(89);
#endif
#if NXFONT_MIN7BIT <= 90 && NXFONT_MAX7BIT >= 90
NXFONT_DEFBITMAP(90);
#endif
#if NXFONT_MIN7BIT <= 91 && NXFONT_MAX7BIT >= 91
NXFONT_DEFBITMAP(91);
#endif
#if NXFONT_MIN7BIT <= 92 && NXFONT_MAX7BIT >= 92
NXFONT_DEFBITMAP(92);
#endif
#if NXFONT_MIN7BIT <= 93 && NXFONT_MAX7BIT >= 93
NXFONT_DEFBITMAP(93);
#endif
#if NXFONT_MIN7BIT <= 94 && NXFONT_MAX7BIT >= 94
NXFONT_DEFBITMAP(94);
#endif
#if NXFONT_MIN7BIT <= 95 && NXFONT_MAX7BIT >= 95
NXFONT_DEFBITMAP(95);
#endif
#if NXFONT_MIN7BIT <= 96 && NXFONT_MAX7BIT >= 96
NXFONT_DEFBITMAP(96);
#endif
#if NXFONT_MIN7BIT <= 97 && NXFONT_MAX7BIT >= 97
NXFONT_DEFBITMAP(97);
#endif
#if NXFONT_MIN7BIT <= 98 && NXFONT_MAX7BIT >= 98
NXFONT_DEFBITMAP(98);
#endif
#if NXFONT_MIN7BIT <= 99 && NXFONT_MAX7BIT >= 99
NXFONT_DEFBITMAP(99);
#endif
#if NXFONT_MIN7BIT <= 100 && NXFONT_MAX7BIT >= 100
NXFONT_DEFBITMAP(100);
#endif
#if NXFONT_MIN7BIT <= 101 && NXFONT_MAX7BIT >= 101
NXFONT_DEFBITMAP(101);
#endif
#if NXFONT_MIN7BIT <= 102 && NXFONT_MAX7BIT >= 102
NXFONT_DEFBITMAP(102);
#endif
#if NXFONT_MIN7BIT <= 103 && NXFONT_MAX7BIT >= 103
NXFONT_DEFBITMAP(103);
#endif
#if NXFONT_MIN7BIT <= 104 && NXFONT_MAX7BIT >= 104
NXFONT_DEFBITMAP(104);
#endif
#if NXFONT_MIN7BIT <= 105 && NXFONT_MAX7BIT >= 105
NXFONT_DEFBITMAP(105);
#endif
#if NXFONT_MIN7BIT <= 106 && NXFONT_MAX7BIT >= 106
NXFONT_DEFBITMAP(106);
#endif
#if NXFONT_MIN7BIT <= 107 && NXFONT_MAX7BIT >= 107
NXFONT_DEFBITMAP(107);
#endif
#if NXFONT_MIN7BIT <= 108 && NXFONT_MAX7BIT >= 108
NXFONT_DEFBITMAP(108);
#endif
#if NXFONT_MIN7BIT <= 109 && NXFONT_MAX7BIT >= 109
NXFONT_DEFBITMAP(109);
#endif
#if NXFONT_MIN7BIT <= 110 && NXFONT_MAX7BIT >= 110
NXFONT_DEFBITMAP(110);
#endif
#if NXFONT_MIN7BIT <= 111 && NXFONT_MAX7BIT >= 111
NXFONT_DEFBITMAP(111);
#endif
#if NXFONT_MIN7BIT <= 112 && NXFONT_MAX7BIT >= 112
NXFONT_DEFBITMAP(112);
#endif
#if NXFONT_MIN7BIT <= 113 && NXFONT_MAX7BIT >= 113
NXFONT_DEFBITMAP(113);
#endif
#if NXFONT_MIN7BIT <= 114 && NXFONT_MAX7BIT >= 114
NXFONT_DEFBITMAP(114);
#endif
#if NXFONT_MIN7BIT <= 115 && NXFONT_MAX7BIT >= 115
NXFONT_DEFBITMAP(115);
#endif
#if NXFONT_MIN7BIT <= 116 && NXFONT_MAX7BIT >= 116
NXFONT_DEFBITMAP(116);
#endif
#if NXFONT_MIN7BIT <= 117 && NXFONT_MAX7BIT >= 117
NXFONT_DEFBITMAP(117);
#endif
#if NXFONT_MIN7BIT <= 118 && NXFONT_MAX7BIT >= 118
NXFONT_DEFBITMAP(118);
#endif
#if NXFONT_MIN7BIT <= 119 && NXFONT_MAX7BIT >= 119
NXFONT_DEFBITMAP(119);
#endif
#if NXFONT_MIN7BIT <= 120 && NXFONT_MAX7BIT >= 120
NXFONT_DEFBITMAP(120);
#endif
#if NXFONT_MIN7BIT <= 121 && NXFONT_MAX7BIT >= 121
NXFONT_DEFBITMAP(121);
#endif
#if NXFONT_MIN7BIT <= 122 && NXFONT_MAX7BIT >= 122
NXFONT_DEFBITMAP(122);
#endif
#if NXFONT_MIN7BIT <= 123 && NXFONT_MAX7BIT >= 123
NXFONT_DEFBITMAP(123);
#endif
#if NXFONT_MIN7BIT <= 124 && NXFONT_MAX7BIT >= 124
NXFONT_DEFBITMAP(124);
#endif
#if NXFONT_MIN7BIT <= 125 && NXFONT_MAX7BIT >= 125
NXFONT_DEFBITMAP(125);
#endif
#if NXFONT_MIN7BIT <= 126 && NXFONT_MAX7BIT >= 126
NXFONT_DEFBITMAP(126);
#endif
#if NXFONT_MIN7BIT <= 127 && NXFONT_MAX7BIT >= 127
NXFONT_DEFBITMAP(127);
#endif

#if CONFIG_NXFONTS_CHARBITS >= 8
#if NXFONT_MIN8BIT <= 128 && NXFONT_MAX8BIT >= 128
NXFONT_DEFBITMAP(128);
#endif
#if NXFONT_MIN8BIT <= 129 && NXFONT_MAX8BIT >= 129
NXFONT_DEFBITMAP(129);
#endif
#if NXFONT_MIN8BIT <= 130 && NXFONT_MAX8BIT >= 130
NXFONT_DEFBITMAP(130);
#endif
#if NXFONT_MIN8BIT <= 131 && NXFONT_MAX8BIT >= 131
NXFONT_DEFBITMAP(131);
#endif
#if NXFONT_MIN8BIT <= 132 && NXFONT_MAX8BIT >= 132
NXFONT_DEFBITMAP(132);
#endif
#if NXFONT_MIN8BIT <= 133 && NXFONT_MAX8BIT >= 133
NXFONT_DEFBITMAP(133);
#endif
#if NXFONT_MIN8BIT <= 134 && NXFONT_MAX8BIT >= 134
NXFONT_DEFBITMAP(134);
#endif
#if NXFONT_MIN8BIT <= 135 && NXFONT_MAX8BIT >= 135
NXFONT_DEFBITMAP(135);
#endif
#if NXFONT_MIN8BIT <= 136 && NXFONT_MAX8BIT >= 136
NXFONT_DEFBITMAP(136);
#endif
#if NXFONT_MIN8BIT <= 137 && NXFONT_MAX8BIT >= 137
NXFONT_DEFBITMAP(137);
#endif
#if NXFONT_MIN8BIT <= 138 && NXFONT_MAX8BIT >= 138
NXFONT_DEFBITMAP(138);
#endif
#if NXFONT_MIN8BIT <= 139 && NXFONT_MAX8BIT >= 139
NXFONT_DEFBITMAP(139);
#endif
#if NXFONT_MIN8BIT <= 140 && NXFONT_MAX8BIT >= 140
NXFONT_DEFBITMAP(140);
#endif
#if NXFONT_MIN8BIT <= 141 && NXFONT_MAX8BIT >= 141
NXFONT_DEFBITMAP(141);
#endif
#if NXFONT_MIN8BIT <= 142 && NXFONT_MAX8BIT >= 142
NXFONT_DEFBITMAP(142);
#endif
#if NXFONT_MIN8BIT <= 143 && NXFONT_MAX8BIT >= 143
NXFONT_DEFBITMAP(143);
#endif
#if NXFONT_MIN8BIT <= 144 && NXFONT_MAX8BIT >= 144
NXFONT_DEFBITMAP(144);
#endif
#if NXFONT_MIN8BIT <= 145 && NXFONT_MAX8BIT >= 145
NXFONT_DEFBITMAP(145);
#endif
#if NXFONT_MIN8BIT <= 146 && NXFONT_MAX8BIT >= 146
NXFONT_DEFBITMAP(146);
#endif
#if NXFONT_MIN8BIT <= 147 && NXFONT_MAX8BIT >= 147
NXFONT_DEFBITMAP(147);
#endif
#if NXFONT_MIN8BIT <= 148 && NXFONT_MAX8BIT >= 148
NXFONT_DEFBITMAP(148);
#endif
#if NXFONT_MIN8BIT <= 149 && NXFONT_MAX8BIT >= 149
NXFONT_DEFBITMAP(149);
#endif
#if NXFONT_MIN8BIT <= 150 && NXFONT_MAX8BIT >= 150
NXFONT_DEFBITMAP(150);
#endif
#if NXFONT_MIN8BIT <= 151 && NXFONT_MAX8BIT >= 151
NXFONT_DEFBITMAP(151);
#endif
#if NXFONT_MIN8BIT <= 152 && NXFONT_MAX8BIT >= 152
NXFONT_DEFBITMAP(152);
#endif
#if NXFONT_MIN8BIT <= 153 && NXFONT_MAX8BIT >= 153
NXFONT_DEFBITMAP(153);
#endif
#if NXFONT_MIN8BIT <= 154 && NXFONT_MAX8BIT >= 154
NXFONT_DEFBITMAP(154);
#endif
#if NXFONT_MIN8BIT <= 155 && NXFONT_MAX8BIT >= 155
NXFONT_DEFBITMAP(155);
#endif
#if NXFONT_MIN8BIT <= 156 && NXFONT_MAX8BIT >= 156
NXFONT_DEFBITMAP(156);
#endif
#if NXFONT_MIN8BIT <= 157 && NXFONT_MAX8BIT >= 157
NXFONT_DEFBITMAP(157);
#endif
#if NXFONT_MIN8BIT <= 158 && NXFONT_MAX8BIT >= 158
NXFONT_DEFBITMAP(158);
#endif
#if NXFONT_MIN8BIT <= 159 && NXFONT_MAX8BIT >= 159
NXFONT_DEFBITMAP(159);
#endif
#if NXFONT_MIN8BIT <= 160 && NXFONT_MAX8BIT >= 160
NXFONT_DEFBITMAP(160);
#endif
#if NXFONT_MIN8BIT <= 161 && NXFONT_MAX8BIT >= 161
NXFONT_DEFBITMAP(161);
#endif
#if NXFONT_MIN8BIT <= 162 && NXFONT_MAX8BIT >= 162
NXFONT_DEFBITMAP(162);
#endif
#if NXFONT_MIN8BIT <= 163 && NXFONT_MAX8BIT >= 163
NXFONT_DEFBITMAP(163);
#endif
#if NXFONT_MIN8BIT <= 164 && NXFONT_MAX8BIT >= 164
NXFONT_DEFBITMAP(164);
#endif
#if NXFONT_MIN8BIT <= 165 && NXFONT_MAX8BIT >= 165
NXFONT_DEFBITMAP(165);
#endif
#if NXFONT_MIN8BIT <= 166 && NXFONT_MAX8BIT >= 166
NXFONT_DEFBITMAP(166);
#endif
#if NXFONT_MIN8BIT <= 167 && NXFONT_MAX8BIT >= 167
NXFONT_DEFBITMAP(167);
#endif
#if NXFONT_MIN8BIT <= 168 && NXFONT_MAX8BIT >= 168
NXFONT_DEFBITMAP(168);
#endif
#if NXFONT_MIN8BIT <= 169 && NXFONT_MAX8BIT >= 169
NXFONT_DEFBITMAP(169);
#endif
#if NXFONT_MIN8BIT <= 170 && NXFONT_MAX8BIT >= 170
NXFONT_DEFBITMAP(170);
#endif
#if NXFONT_MIN8BIT <= 171 && NXFONT_MAX8BIT >= 171
NXFONT_DEFBITMAP(171);
#endif
#if NXFONT_MIN8BIT <= 172 && NXFONT_MAX8BIT >= 172
NXFONT_DEFBITMAP(172);
#endif
#if NXFONT_MIN8BIT <= 173 && NXFONT_MAX8BIT >= 173
NXFONT_DEFBITMAP(173);
#endif
#if NXFONT_MIN8BIT <= 174 && NXFONT_MAX8BIT >= 174
NXFONT_DEFBITMAP(174);
#endif
#if NXFONT_MIN8BIT <= 175 && NXFONT_MAX8BIT >= 175
NXFONT_DEFBITMAP(175);
#endif
#if NXFONT_MIN8BIT <= 176 && NXFONT_MAX8BIT >= 176
NXFONT_DEFBITMAP(176);
#endif
#if NXFONT_MIN8BIT <= 177 && NXFONT_MAX8BIT >= 177
NXFONT_DEFBITMAP(177);
#endif
#if NXFONT_MIN8BIT <= 178 && NXFONT_MAX8BIT >= 178
NXFONT_DEFBITMAP(178);
#endif
#if NXFONT_MIN8BIT <= 179 && NXFONT_MAX8BIT >= 179
NXFONT_DEFBITMAP(179);
#endif
#if NXFONT_MIN8BIT <= 180 && NXFONT_MAX8BIT >= 180
NXFONT_DEFBITMAP(180);
#endif
#if NXFONT_MIN8BIT <= 181 && NXFONT_MAX8BIT >= 181
NXFONT_DEFBITMAP(181);
#endif
#if NXFONT_MIN8BIT <= 182 && NXFONT_MAX8BIT >= 182
NXFONT_DEFBITMAP(182);
#endif
#if NXFONT_MIN8BIT <= 183 && NXFONT_MAX8BIT >= 183
NXFONT_DEFBITMAP(183);
#endif
#if NXFONT_MIN8BIT <= 184 && NXFONT_MAX8BIT >= 184
NXFONT_DEFBITMAP(184);
#endif
#if NXFONT_MIN8BIT <= 185 && NXFONT_MAX8BIT >= 185
NXFONT_DEFBITMAP(185);
#endif
#if NXFONT_MIN8BIT <= 186 && NXFONT_MAX8BIT >= 186
NXFONT_DEFBITMAP(186);
#endif
#if NXFONT_MIN8BIT <= 187 && NXFONT_MAX8BIT >= 187
NXFONT_DEFBITMAP(187);
#endif
#if NXFONT_MIN8BIT <= 188 && NXFONT_MAX8BIT >= 188
NXFONT_DEFBITMAP(188);
#endif
#if NXFONT_MIN8BIT <= 189 && NXFONT_MAX8BIT >= 189
NXFONT_DEFBITMAP(189);
#endif
#if NXFONT_MIN8BIT <= 190 && NXFONT_MAX8BIT >= 190
NXFONT_DEFBITMAP(190);
#endif
#if NXFONT_MIN8BIT <= 191 && NXFONT_MAX8BIT >= 191
NXFONT_DEFBITMAP(191);
#endif
#if NXFONT_MIN8BIT <= 192 && NXFONT_MAX8BIT >= 192
NXFONT_DEFBITMAP(192);
#endif
#if NXFONT_MIN8BIT <= 193 && NXFONT_MAX8BIT >= 193
NXFONT_DEFBITMAP(193);
#endif
#if NXFONT_MIN8BIT <= 194 && NXFONT_MAX8BIT >= 194
NXFONT_DEFBITMAP(194);
#endif
#if NXFONT_MIN8BIT <= 195 && NXFONT_MAX8BIT >= 195
NXFONT_DEFBITMAP(195);
#endif
#if NXFONT_MIN8BIT <= 196 && NXFONT_MAX8BIT >= 196
NXFONT_DEFBITMAP(196);
#endif
#if NXFONT_MIN8BIT <= 197 && NXFONT_MAX8BIT >= 197
NXFONT_DEFBITMAP(197);
#endif
#if NXFONT_MIN8BIT <= 198 && NXFONT_MAX8BIT >= 198
NXFONT_DEFBITMAP(198);
#endif
#if NXFONT_MIN8BIT <= 199 && NXFONT_MAX8BIT >= 199
NXFONT_DEFBITMAP(199);
#endif
#if NXFONT_MIN8BIT <= 200 && NXFONT_MAX8BIT >= 200
NXFONT_DEFBITMAP(200);
#endif
#if NXFONT_MIN8BIT <= 201 && NXFONT_MAX8BIT >= 201
NXFONT_DEFBITMAP(201);
#endif
#if NXFONT_MIN8BIT <= 202 && NXFONT_MAX8BIT >= 202
NXFONT_DEFBITMAP(202);
#endif
#if NXFONT_MIN8BIT <= 203 && NXFONT_MAX8BIT >= 203
NXFONT_DEFBITMAP(203);
#endif
#if NXFONT_MIN8BIT <= 204 && NXFONT_MAX8BIT >= 204
NXFONT_DEFBITMAP(204);
#endif
#if NXFONT_MIN8BIT <= 205 && NXFONT_MAX8BIT >= 205
NXFONT_DEFBITMAP(205);
#endif
#if NXFONT_MIN8BIT <= 206 && NXFONT_MAX8BIT >= 206
NXFONT_DEFBITMAP(206);
#endif
#if NXFONT_MIN8BIT <= 207 && NXFONT_MAX8BIT >= 207
NXFONT_DEFBITMAP(207);
#endif
#if NXFONT_MIN8BIT <= 208 && NXFONT_MAX8BIT >= 208
NXFONT_DEFBITMAP(208);
#endif
#if NXFONT_MIN8BIT <= 209 && NXFONT_MAX8BIT >= 209
NXFONT_DEFBITMAP(209);
#endif
#if NXFONT_MIN8BIT <= 210 && NXFONT_MAX8BIT >= 210
NXFONT_DEFBITMAP(210);
#endif
#if NXFONT_MIN8BIT <= 211 && NXFONT_MAX8BIT >= 211
NXFONT_DEFBITMAP(211);
#endif
#if NXFONT_MIN8BIT <= 212 && NXFONT_MAX8BIT >= 212
NXFONT_DEFBITMAP(212);
#endif
#if NXFONT_MIN8BIT <= 213 && NXFONT_MAX8BIT >= 213
NXFONT_DEFBITMAP(213);
#endif
#if NXFONT_MIN8BIT <= 214 && NXFONT_MAX8BIT >= 214
NXFONT_DEFBITMAP(214);
#endif
#if NXFONT_MIN8BIT <= 215 && NXFONT_MAX8BIT >= 215
NXFONT_DEFBITMAP(215);
#endif
#if NXFONT_MIN8BIT <= 216 && NXFONT_MAX8BIT >= 216
NXFONT_DEFBITMAP(216);
#endif
#if NXFONT_MIN8BIT <= 217 && NXFONT_MAX8BIT >= 217
NXFONT_DEFBITMAP(217);
#endif
#if NXFONT_MIN8BIT <= 218 && NXFONT_MAX8BIT >= 218
NXFONT_DEFBITMAP(218);
#endif
#if NXFONT_MIN8BIT <= 219 && NXFONT_MAX8BIT >= 219
NXFONT_DEFBITMAP(219);
#endif
#if NXFONT_MIN8BIT <= 220 && NXFONT_MAX8BIT >= 220
NXFONT_DEFBITMAP(220);
#endif
#if NXFONT_MIN8BIT <= 221 && NXFONT_MAX8BIT >= 221
NXFONT_DEFBITMAP(221);
#endif
#if NXFONT_MIN8BIT <= 222 && NXFONT_MAX8BIT >= 222
NXFONT_DEFBITMAP(222);
#endif
#if NXFONT_MIN8BIT <= 223 && NXFONT_MAX8BIT >= 223
NXFONT_DEFBITMAP(223);
#endif
#if NXFONT_MIN8BIT <= 224 && NXFONT_MAX8BIT >= 224
NXFONT_DEFBITMAP(224);
#endif
#if NXFONT_MIN8BIT <= 225 && NXFONT_MAX8BIT >= 225
NXFONT_DEFBITMAP(225);
#endif
#if NXFONT_MIN8BIT <= 226 && NXFONT_MAX8BIT >= 226
NXFONT_DEFBITMAP(226);
#endif
#if NXFONT_MIN8BIT <= 227 && NXFONT_MAX8BIT >= 227
NXFONT_DEFBITMAP(227);
#endif
#if NXFONT_MIN8BIT <= 228 && NXFONT_MAX8BIT >= 228
NXFONT_DEFBITMAP(228);
#endif
#if NXFONT_MIN8BIT <= 229 && NXFONT_MAX8BIT >= 229
NXFONT_DEFBITMAP(229);
#endif
#if NXFONT_MIN8BIT <= 230 && NXFONT_MAX8BIT >= 230
NXFONT_DEFBITMAP(230);
#endif
#if NXFONT_MIN8BIT <= 231 && NXFONT_MAX8BIT >= 231
NXFONT_DEFBITMAP(231);
#endif
#if NXFONT_MIN8BIT <= 232 && NXFONT_MAX8BIT >= 232
NXFONT_DEFBITMAP(232);
#endif
#if NXFONT_MIN8BIT <= 233 && NXFONT_MAX8BIT >= 233
NXFONT_DEFBITMAP(233);
#endif
#if NXFONT_MIN8BIT <= 234 && NXFONT_MAX8BIT >= 234
NXFONT_DEFBITMAP(234);
#endif
#if NXFONT_MIN8BIT <= 235 && NXFONT_MAX8BIT >= 235
NXFONT_DEFBITMAP(235);
#endif
#if NXFONT_MIN8BIT <= 236 && NXFONT_MAX8BIT >= 236
NXFONT_DEFBITMAP(236);
#endif
#if NXFONT_MIN8BIT <= 237 && NXFONT_MAX8BIT >= 237
NXFONT_DEFBITMAP(237);
#endif
#if NXFONT_MIN8BIT <= 238 && NXFONT_MAX8BIT >= 238
NXFONT_DEFBITMAP(238);
#endif
#if NXFONT_MIN8BIT <= 239 && NXFONT_MAX8BIT >= 239
NXFONT_DEFBITMAP(239);
#endif
#if NXFONT_MIN8BIT <= 240 && NXFONT_MAX8BIT >= 240
NXFONT_DEFBITMAP(240);
#endif
#if NXFONT_MIN8BIT <= 241 && NXFONT_MAX8BIT >= 241
NXFONT_DEFBITMAP(241);
#endif
#if NXFONT_MIN8BIT <= 242 && NXFONT_MAX8BIT >= 242
NXFONT_DEFBITMAP(242);
#endif
#if NXFONT_MIN8BIT <= 243 && NXFONT_MAX8BIT >= 243
NXFONT_DEFBITMAP(243);
#endif
#if NXFONT_MIN8BIT <= 244 && NXFONT_MAX8BIT >= 244
NXFONT_DEFBITMAP(244);
#endif
#if NXFONT_MIN8BIT <= 245 && NXFONT_MAX8BIT >= 245
NXFONT_DEFBITMAP(245);
#endif
#if NXFONT_MIN8BIT <= 246 && NXFONT_MAX8BIT >= 246
NXFONT_DEFBITMAP(246);
#endif
#if NXFONT_MIN8BIT <= 247 && NXFONT_MAX8BIT >= 247
NXFONT_DEFBITMAP(247);
#endif
#if NXFONT_MIN8BIT <= 248 && NXFONT_MAX8BIT >= 248
NXFONT_DEFBITMAP(248);
#endif
#if NXFONT_MIN8BIT <= 249 && NXFONT_MAX8BIT >= 249
NXFONT_DEFBITMAP(249);
#endif
#if NXFONT_MIN8BIT <= 250 && NXFONT_MAX8BIT >= 250
NXFONT_DEFBITMAP(250);
#endif
#if NXFONT_MIN8BIT <= 251 && NXFONT_MAX8BIT >= 251
NXFONT_DEFBITMAP(251);
#endif
#if NXFONT_MIN8BIT <= 252 && NXFONT_MAX8BIT >= 252
NXFONT_DEFBITMAP(252);
#endif
#if NXFONT_MIN8BIT <= 253 && NXFONT_MAX8BIT >= 253
NXFONT_DEFBITMAP(253);
#endif
#if NXFONT_MIN8BIT <= 254 && NXFONT_MAX8BIT >= 254
NXFONT_DEFBITMAP(254);
#endif
#if NXFONT_MIN8BIT <= 255 && NXFONT_MAX8BIT >= 255
NXFONT_DEFBITMAP(255);
#endif
#endif

static const struct nx_fontbitmap_s NXF_SYMNAME(NXFONTS_PREFIX,7bitmaps)[NXFONT_N7BITFONTS] =
{
#if NXFONT_MIN7BIT <= 0 && NXFONT_MAX7BIT >= 0
NXFONT_DEFMETRIC(0),
#endif
#if NXFONT_MIN7BIT <= 1 && NXFONT_MAX7BIT >= 1
NXFONT_DEFMETRIC(1),
#endif
#if NXFONT_MIN7BIT <= 2 && NXFONT_MAX7BIT >= 2
NXFONT_DEFMETRIC(2),
#endif
#if NXFONT_MIN7BIT <= 3 && NXFONT_MAX7BIT >= 3
NXFONT_DEFMETRIC(3),
#endif
#if NXFONT_MIN7BIT <= 4 && NXFONT_MAX7BIT >= 4
NXFONT_DEFMETRIC(4),
#endif
#if NXFONT_MIN7BIT <= 5 && NXFONT_MAX7BIT >= 5
NXFONT_DEFMETRIC(5),
#endif
#if NXFONT_MIN7BIT <= 6 && NXFONT_MAX7BIT >= 6
NXFONT_DEFMETRIC(6),
#endif
#if NXFONT_MIN7BIT <= 7 && NXFONT_MAX7BIT >= 7
NXFONT_DEFMETRIC(7),
#endif
#if NXFONT_MIN7BIT <= 8 && NXFONT_MAX7BIT >= 8
NXFONT_DEFMETRIC(8),
#endif
#if NXFONT_MIN7BIT <= 9 && NXFONT_MAX7BIT >= 9
NXFONT_DEFMETRIC(9),
#endif
#if NXFONT_MIN7BIT <= 10 && NXFONT_MAX7BIT >= 10
NXFONT_DEFMETRIC(10),
#endif
#if NXFONT_MIN7BIT <= 11 && NXFONT_MAX7BIT >= 11
NXFONT_DEFMETRIC(11),
#endif
#if NXFONT_MIN7BIT <= 12 && NXFONT_MAX7BIT >= 12
NXFONT_DEFMETRIC(12),
#endif
#if NXFONT_MIN7BIT <= 13 && NXFONT_MAX7BIT >= 13
NXFONT_DEFMETRIC(13),
#endif
#if NXFONT_MIN7BIT <= 14 && NXFONT_MAX7BIT >= 14
NXFONT_DEFMETRIC(14),
#endif
#if NXFONT_MIN7BIT <= 15 && NXFONT_MAX7BIT >= 15
NXFONT_DEFMETRIC(15),
#endif
#if NXFONT_MIN7BIT <= 16 && NXFONT_MAX7BIT >= 16
NXFONT_DEFMETRIC(16),
#endif
#if NXFONT_MIN7BIT <= 17 && NXFONT_MAX7BIT >= 17
NXFONT_DEFMETRIC(17),
#endif
#if NXFONT_MIN7BIT <= 18 && NXFONT_MAX7BIT >= 18
NXFONT_DEFMETRIC(18),
#endif
#if NXFONT_MIN7BIT <= 19 && NXFONT_MAX7BIT >= 19
NXFONT_DEFMETRIC(19),
#endif
#if NXFONT_MIN7BIT <= 20 && NXFONT_MAX7BIT >= 20
NXFONT_DEFMETRIC(20),
#endif
#if NXFONT_MIN7BIT <= 21 && NXFONT_MAX7BIT >= 21
NXFONT_DEFMETRIC(21),
#endif
#if NXFONT_MIN7BIT <= 22 && NXFONT_MAX7BIT >= 22
NXFONT_DEFMETRIC(22),
#endif
#if NXFONT_MIN7BIT <= 23 && NXFONT_MAX7BIT >= 23
NXFONT_DEFMETRIC(23),
#endif
#if NXFONT_MIN7BIT <= 24 && NXFONT_MAX7BIT >= 24
NXFONT_DEFMETRIC(24),
#endif
#if NXFONT_MIN7BIT <= 25 && NXFONT_MAX7BIT >= 25
NXFONT_DEFMETRIC(25),
#endif
#if NXFONT_MIN7BIT <= 26 && NXFONT_MAX7BIT >= 26
NXFONT_DEFMETRIC(26),
#endif
#if NXFONT_MIN7BIT <= 27 && NXFONT_MAX7BIT >= 27
NXFONT_DEFMETRIC(27),
#endif
#if NXFONT_MIN7BIT <= 28 && NXFONT_MAX7BIT >= 28
NXFONT_DEFMETRIC(28),
#endif
#if NXFONT_MIN7BIT <= 29 && NXFONT_MAX7BIT >= 29
NXFONT_DEFMETRIC(29),
#endif
#if NXFONT_MIN7BIT <= 30 && NXFONT_MAX7BIT >= 30
NXFONT_DEFMETRIC(30),
#endif
#if NXFONT_MIN7BIT <= 31 && NXFONT_MAX7BIT >= 31
NXFONT_DEFMETRIC(31),
#endif
#if NXFONT_MIN7BIT <= 32 && NXFONT_MAX7BIT >= 32
NXFONT_DEFMETRIC(32),
#endif
#if NXFONT_MIN7BIT <= 33 && NXFONT_MAX7BIT >= 33
NXFONT_DEFMETRIC(33),
#endif
#if NXFONT_MIN7BIT <= 34 && NXFONT_MAX7BIT >= 34
NXFONT_DEFMETRIC(34),
#endif
#if NXFONT_MIN7BIT <= 35 && NXFONT_MAX7BIT >= 35
NXFONT_DEFMETRIC(35),
#endif
#if NXFONT_MIN7BIT <= 36 && NXFONT_MAX7BIT >= 36
NXFONT_DEFMETRIC(36),
#endif
#if NXFONT_MIN7BIT <= 37 && NXFONT_MAX7BIT >= 37
NXFONT_DEFMETRIC(37),
#endif
#if NXFONT_MIN7BIT <= 38 && NXFONT_MAX7BIT >= 38
NXFONT_DEFMETRIC(38),
#endif
#if NXFONT_MIN7BIT <= 39 && NXFONT_MAX7BIT >= 39
NXFONT_DEFMETRIC(39),
#endif
#if NXFONT_MIN7BIT <= 40 && NXFONT_MAX7BIT >= 40
NXFONT_DEFMETRIC(40),
#endif
#if NXFONT_MIN7BIT <= 41 && NXFONT_MAX7BIT >= 41
NXFONT_DEFMETRIC(41),
#endif
#if NXFONT_MIN7BIT <= 42 && NXFONT_MAX7BIT >= 42
NXFONT_DEFMETRIC(42),
#endif
#if NXFONT_MIN7BIT <= 43 && NXFONT_MAX7BIT >= 43
NXFONT_DEFMETRIC(43),
#endif
#if NXFONT_MIN7BIT <= 44 && NXFONT_MAX7BIT >= 44
NXFONT_DEFMETRIC(44),
#endif
#if NXFONT_MIN7BIT <= 45 && NXFONT_MAX7BIT >= 45
NXFONT_DEFMETRIC(45),
#endif
#if NXFONT_MIN7BIT <= 46 && NXFONT_MAX7BIT >= 46
NXFONT_DEFMETRIC(46),
#endif
#if NXFONT_MIN7BIT <= 47 && NXFONT_MAX7BIT >= 47
NXFONT_DEFMETRIC(47),
#endif
#if NXFONT_MIN7BIT <= 48 && NXFONT_MAX7BIT >= 48
NXFONT_DEFMETRIC(48),
#endif
#if NXFONT_MIN7BIT <= 49 && NXFONT_MAX7BIT >= 49
NXFONT_DEFMETRIC(49),
#endif
#if NXFONT_MIN7BIT <= 50 && NXFONT_MAX7BIT >= 50
NXFONT_DEFMETRIC(50),
#endif
#if NXFONT_MIN7BIT <= 51 && NXFONT_MAX7BIT >= 51
NXFONT_DEFMETRIC(51),
#endif
#if NXFONT_MIN7BIT <= 52 && NXFONT_MAX7BIT >= 52
NXFONT_DEFMETRIC(52),
#endif
#if NXFONT_MIN7BIT <= 53 && NXFONT_MAX7BIT >= 53
NXFONT_DEFMETRIC(53),
#endif
#if NXFONT_MIN7BIT <= 54 && NXFONT_MAX7BIT >= 54
NXFONT_DEFMETRIC(54),
#endif
#if NXFONT_MIN7BIT <= 55 && NXFONT_MAX7BIT >= 55
NXFONT_DEFMETRIC(55),
#endif
#if NXFONT_MIN7BIT <= 56 && NXFONT_MAX7BIT >= 56
NXFONT_DEFMETRIC(56),
#endif
#if NXFONT_MIN7BIT <= 57 && NXFONT_MAX7BIT >= 57
NXFONT_DEFMETRIC(57),
#endif
#if NXFONT_MIN7BIT <= 58 && NXFONT_MAX7BIT >= 58
NXFONT_DEFMETRIC(58),
#endif
#if NXFONT_MIN7BIT <= 59 && NXFONT_MAX7BIT >= 59
NXFONT_DEFMETRIC(59),
#endif
#if NXFONT_MIN7BIT <= 60 && NXFONT_MAX7BIT >= 60
NXFONT_DEFMETRIC(60),
#endif
#if NXFONT_MIN7BIT <= 61 && NXFONT_MAX7BIT >= 61
NXFONT_DEFMETRIC(61),
#endif
#if NXFONT_MIN7BIT <= 62 && NXFONT_MAX7BIT >= 62
NXFONT_DEFMETRIC(62),
#endif
#if NXFONT_MIN7BIT <= 63 && NXFONT_MAX7BIT >= 63
NXFONT_DEFMETRIC(63),
#endif
#if NXFONT_MIN7BIT <= 64 && NXFONT_MAX7BIT >= 64
NXFONT_DEFMETRIC(64),
#endif
#if NXFONT_MIN7BIT <= 65 && NXFONT_MAX7BIT >= 65
NXFONT_DEFMETRIC(65),
#endif
#if NXFONT_MIN7BIT <= 66 && NXFONT_MAX7BIT >= 66
NXFONT_DEFMETRIC(66),
#endif
#if NXFONT_MIN7BIT <= 67 && NXFONT_MAX7BIT >= 67
NXFONT_DEFMETRIC(67),
#endif
#if NXFONT_MIN7BIT <= 68 && NXFONT_MAX7BIT >= 68
NXFONT_DEFMETRIC(68),
#endif
#if NXFONT_MIN7BIT <= 69 && NXFONT_MAX7BIT >= 69
NXFONT_DEFMETRIC(69),
#endif
#if NXFONT_MIN7BIT <= 70 && NXFONT_MAX7BIT >= 70
NXFONT_DEFMETRIC(70),
#endif
#if NXFONT_MIN7BIT <= 71 && NXFONT_MAX7BIT >= 71
NXFONT_DEFMETRIC(71),
#endif
#if NXFONT_MIN7BIT <= 72 && NXFONT_MAX7BIT >= 72
NXFONT_DEFMETRIC(72),
#endif
#if NXFONT_MIN7BIT <= 73 && NXFONT_MAX7BIT >= 73
NXFONT_DEFMETRIC(73),
#endif
#if NXFONT_MIN7BIT <= 74 && NXFONT_MAX7BIT >= 74
NXFONT_DEFMETRIC(74),
#endif
#if NXFONT_MIN7BIT <= 75 && NXFONT_MAX7BIT >= 75
NXFONT_DEFMETRIC(75),
#endif
#if NXFONT_MIN7BIT <= 76 && NXFONT_MAX7BIT >= 76
NXFONT_DEFMETRIC(76),
#endif
#if NXFONT_MIN7BIT <= 77 && NXFONT_MAX7BIT >= 77
NXFONT_DEFMETRIC(77),
#endif
#if NXFONT_MIN7BIT <= 78 && NXFONT_MAX7BIT >= 78
NXFONT_DEFMETRIC(78),
#endif
#if NXFONT_MIN7BIT <= 79 && NXFONT_MAX7BIT >= 79
NXFONT_DEFMETRIC(79),
#endif
#if NXFONT_MIN7BIT <= 80 && NXFONT_MAX7BIT >= 80
NXFONT_DEFMETRIC(80),
#endif
#if NXFONT_MIN7BIT <= 81 && NXFONT_MAX7BIT >= 81
NXFONT_DEFMETRIC(81),
#endif
#if NXFONT_MIN7BIT <= 82 && NXFONT_MAX7BIT >= 82
NXFONT_DEFMETRIC(82),
#endif
#if NXFONT_MIN7BIT <= 83 && NXFONT_MAX7BIT >= 83
NXFONT_DEFMETRIC(83),
#endif
#if NXFONT_MIN7BIT <= 84 && NXFONT_MAX7BIT >= 84
NXFONT_DEFMETRIC(84),
#endif
#if NXFONT_MIN7BIT <= 85 && NXFONT_MAX7BIT >= 85
NXFONT_DEFMETRIC(85),
#endif
#if NXFONT_MIN7BIT <= 86 && NXFONT_MAX7BIT >= 86
NXFONT_DEFMETRIC(86),
#endif
#if NXFONT_MIN7BIT <= 87 && NXFONT_MAX7BIT >= 87
NXFONT_DEFMETRIC(87),
#endif
#if NXFONT_MIN7BIT <= 88 && NXFONT_MAX7BIT >= 88
NXFONT_DEFMETRIC(88),
#endif
#if NXFONT_MIN7BIT <= 89 && NXFONT_MAX7BIT >= 89
NXFONT_DEFMETRIC(89),
#endif
#if NXFONT_MIN7BIT <= 90 && NXFONT_MAX7BIT >= 90
NXFONT_DEFMETRIC(90),
#endif
#if NXFONT_MIN7BIT <= 91 && NXFONT_MAX7BIT >= 91
NXFONT_DEFMETRIC(91),
#endif
#if NXFONT_MIN7BIT <= 92 && NXFONT_MAX7BIT >= 92
NXFONT_DEFMETRIC(92),
#endif
#if NXFONT_MIN7BIT <= 93 && NXFONT_MAX7BIT >= 93
NXFONT_DEFMETRIC(93),
#endif
#if NXFONT_MIN7BIT <= 94 && NXFONT_MAX7BIT >= 94
NXFONT_DEFMETRIC(94),
#endif
#if NXFONT_MIN7BIT <= 95 && NXFONT_MAX7BIT >= 95
NXFONT_DEFMETRIC(95),
#endif
#if NXFONT_MIN7BIT <= 96 && NXFONT_MAX7BIT >= 96
NXFONT_DEFMETRIC(96),
#endif
#if NXFONT_MIN7BIT <= 97 && NXFONT_MAX7BIT >= 97
NXFONT_DEFMETRIC(97),
#endif
#if NXFONT_MIN7BIT <= 98 && NXFONT_MAX7BIT >= 98
NXFONT_DEFMETRIC(98),
#endif
#if NXFONT_MIN7BIT <= 99 && NXFONT_MAX7BIT >= 99
NXFONT_DEFMETRIC(99),
#endif
#if NXFONT_MIN7BIT <= 100 && NXFONT_MAX7BIT >= 100
NXFONT_DEFMETRIC(100),
#endif
#if NXFONT_MIN7BIT <= 101 && NXFONT_MAX7BIT >= 101
NXFONT_DEFMETRIC(101),
#endif
#if NXFONT_MIN7BIT <= 102 && NXFONT_MAX7BIT >= 102
NXFONT_DEFMETRIC(102),
#endif
#if NXFONT_MIN7BIT <= 103 && NXFONT_MAX7BIT >= 103
NXFONT_DEFMETRIC(103),
#endif
#if NXFONT_MIN7BIT <= 104 && NXFONT_MAX7BIT >= 104
NXFONT_DEFMETRIC(104),
#endif
#if NXFONT_MIN7BIT <= 105 && NXFONT_MAX7BIT >= 105
NXFONT_DEFMETRIC(105),
#endif
#if NXFONT_MIN7BIT <= 106 && NXFONT_MAX7BIT >= 106
NXFONT_DEFMETRIC(106),
#endif
#if NXFONT_MIN7BIT <= 107 && NXFONT_MAX7BIT >= 107
NXFONT_DEFMETRIC(107),
#endif
#if NXFONT_MIN7BIT <= 108 && NXFONT_MAX7BIT >= 108
NXFONT_DEFMETRIC(108),
#endif
#if NXFONT_MIN7BIT <= 109 && NXFONT_MAX7BIT >= 109
NXFONT_DEFMETRIC(109),
#endif
#if NXFONT_MIN7BIT <= 110 && NXFONT_MAX7BIT >= 110
NXFONT_DEFMETRIC(110),
#endif
#if NXFONT_MIN7BIT <= 111 && NXFONT_MAX7BIT >= 111
NXFONT_DEFMETRIC(111),
#endif
#if NXFONT_MIN7BIT <= 112 && NXFONT_MAX7BIT >= 112
NXFONT_DEFMETRIC(112),
#endif
#if NXFONT_MIN7BIT <= 113 && NXFONT_MAX7BIT >= 113
NXFONT_DEFMETRIC(113),
#endif
#if NXFONT_MIN7BIT <= 114 && NXFONT_MAX7BIT >= 114
NXFONT_DEFMETRIC(114),
#endif
#if NXFONT_MIN7BIT <= 115 && NXFONT_MAX7BIT >= 115
NXFONT_DEFMETRIC(115),
#endif
#if NXFONT_MIN7BIT <= 116 && NXFONT_MAX7BIT >= 116
NXFONT_DEFMETRIC(116),
#endif
#if NXFONT_MIN7BIT <= 117 && NXFONT_MAX7BIT >= 117
NXFONT_DEFMETRIC(117),
#endif
#if NXFONT_MIN7BIT <= 118 && NXFONT_MAX7BIT >= 118
NXFONT_DEFMETRIC(118),
#endif
#if NXFONT_MIN7BIT <= 119 && NXFONT_MAX7BIT >= 119
NXFONT_DEFMETRIC(119),
#endif
#if NXFONT_MIN7BIT <= 120 && NXFONT_MAX7BIT >= 120
NXFONT_DEFMETRIC(120),
#endif
#if NXFONT_MIN7BIT <= 121 && NXFONT_MAX7BIT >= 121
NXFONT_DEFMETRIC(121),
#endif
#if NXFONT_MIN7BIT <= 122 && NXFONT_MAX7BIT >= 122
NXFONT_DEFMETRIC(122),
#endif
#if NXFONT_MIN7BIT <= 123 && NXFONT_MAX7BIT >= 123
NXFONT_DEFMETRIC(123),
#endif
#if NXFONT_MIN7BIT <= 124 && NXFONT_MAX7BIT >= 124
NXFONT_DEFMETRIC(124),
#endif
#if NXFONT_MIN7BIT <= 125 && NXFONT_MAX7BIT >= 125
NXFONT_DEFMETRIC(125),
#endif
#if NXFONT_MIN7BIT <= 126 && NXFONT_MAX7BIT >= 126
NXFONT_DEFMETRIC(126),
#endif
#if NXFONT_MIN7BIT <= 127 && NXFONT_MAX7BIT >= 127
NXFONT_DEFMETRIC(127),
#endif
};

#if CONFIG_NXFONTS_CHARBITS >= 8
static const struct nx_fontbitmap_s NXF_SYMNAME(NXFONTS_PREFIX,8bitmaps)[NXFONT_N8BITFONTS] =
{
#if NXFONT_MIN8BIT <= 128 && NXFONT_MAX8BIT >= 128
NXFONT_DEFMETRIC(128),
#endif
#if NXFONT_MIN8BIT <= 129 && NXFONT_MAX8BIT >= 129
NXFONT_DEFMETRIC(129),
#endif
#if NXFONT_MIN8BIT <= 130 && NXFONT_MAX8BIT >= 130
NXFONT_DEFMETRIC(130),
#endif
#if NXFONT_MIN8BIT <= 131 && NXFONT_MAX8BIT >= 131
NXFONT_DEFMETRIC(131),
#endif
#if NXFONT_MIN8BIT <= 132 && NXFONT_MAX8BIT >= 132
NXFONT_DEFMETRIC(132),
#endif
#if NXFONT_MIN8BIT <= 133 && NXFONT_MAX8BIT >= 133
NXFONT_DEFMETRIC(133),
#endif
#if NXFONT_MIN8BIT <= 134 && NXFONT_MAX8BIT >= 134
NXFONT_DEFMETRIC(134),
#endif
#if NXFONT_MIN8BIT <= 135 && NXFONT_MAX8BIT >= 135
NXFONT_DEFMETRIC(135),
#endif
#if NXFONT_MIN8BIT <= 136 && NXFONT_MAX8BIT >= 136
NXFONT_DEFMETRIC(136),
#endif
#if NXFONT_MIN8BIT <= 137 && NXFONT_MAX8BIT >= 137
NXFONT_DEFMETRIC(137),
#endif
#if NXFONT_MIN8BIT <= 138 && NXFONT_MAX8BIT >= 138
NXFONT_DEFMETRIC(138),
#endif
#if NXFONT_MIN8BIT <= 139 && NXFONT_MAX8BIT >= 139
NXFONT_DEFMETRIC(139),
#endif
#if NXFONT_MIN8BIT <= 140 && NXFONT_MAX8BIT >= 140
NXFONT_DEFMETRIC(140),
#endif
#if NXFONT_MIN8BIT <= 141 && NXFONT_MAX8BIT >= 141
NXFONT_DEFMETRIC(141),
#endif
#if NXFONT_MIN8BIT <= 142 && NXFONT_MAX8BIT >= 142
NXFONT_DEFMETRIC(142),
#endif
#if NXFONT_MIN8BIT <= 143 && NXFONT_MAX8BIT >= 143
NXFONT_DEFMETRIC(143),
#endif
#if NXFONT_MIN8BIT <= 144 && NXFONT_MAX8BIT >= 144
NXFONT_DEFMETRIC(144),
#endif
#if NXFONT_MIN8BIT <= 145 && NXFONT_MAX8BIT >= 145
NXFONT_DEFMETRIC(145),
#endif
#if NXFONT_MIN8BIT <= 146 && NXFONT_MAX8BIT >= 146
NXFONT_DEFMETRIC(146),
#endif
#if NXFONT_MIN8BIT <= 147 && NXFONT_MAX8BIT >= 147
NXFONT_DEFMETRIC(147),
#endif
#if NXFONT_MIN8BIT <= 148 && NXFONT_MAX8BIT >= 148
NXFONT_DEFMETRIC(148),
#endif
#if NXFONT_MIN8BIT <= 149 && NXFONT_MAX8BIT >= 149
NXFONT_DEFMETRIC(149),
#endif
#if NXFONT_MIN8BIT <= 150 && NXFONT_MAX8BIT >= 150
NXFONT_DEFMETRIC(150),
#endif
#if NXFONT_MIN8BIT <= 151 && NXFONT_MAX8BIT >= 151
NXFONT_DEFMETRIC(151),
#endif
#if NXFONT_MIN8BIT <= 152 && NXFONT_MAX8BIT >= 152
NXFONT_DEFMETRIC(152),
#endif
#if NXFONT_MIN8BIT <= 153 && NXFONT_MAX8BIT >= 153
NXFONT_DEFMETRIC(153),
#endif
#if NXFONT_MIN8BIT <= 154 && NXFONT_MAX8BIT >= 154
NXFONT_DEFMETRIC(154),
#endif
#if NXFONT_MIN8BIT <= 155 && NXFONT_MAX8BIT >= 155
NXFONT_DEFMETRIC(155),
#endif
#if NXFONT_MIN8BIT <= 156 && NXFONT_MAX8BIT >= 156
NXFONT_DEFMETRIC(156),
#endif
#if NXFONT_MIN8BIT <= 157 && NXFONT_MAX8BIT >= 157
NXFONT_DEFMETRIC(157),
#endif
#if NXFONT_MIN8BIT <= 158 && NXFONT_MAX8BIT >= 158
NXFONT_DEFMETRIC(158),
#endif
#if NXFONT_MIN8BIT <= 159 && NXFONT_MAX8BIT >= 159
NXFONT_DEFMETRIC(159),
#endif
#if NXFONT_MIN8BIT <= 160 && NXFONT_MAX8BIT >= 160
NXFONT_DEFMETRIC(160),
#endif
#if NXFONT_MIN8BIT <= 161 && NXFONT_MAX8BIT >= 161
NXFONT_DEFMETRIC(161),
#endif
#if NXFONT_MIN8BIT <= 162 && NXFONT_MAX8BIT >= 162
NXFONT_DEFMETRIC(162),
#endif
#if NXFONT_MIN8BIT <= 163 && NXFONT_MAX8BIT >= 163
NXFONT_DEFMETRIC(163),
#endif
#if NXFONT_MIN8BIT <= 164 && NXFONT_MAX8BIT >= 164
NXFONT_DEFMETRIC(164),
#endif
#if NXFONT_MIN8BIT <= 165 && NXFONT_MAX8BIT >= 165
NXFONT_DEFMETRIC(165),
#endif
#if NXFONT_MIN8BIT <= 166 && NXFONT_MAX8BIT >= 166
NXFONT_DEFMETRIC(166),
#endif
#if NXFONT_MIN8BIT <= 167 && NXFONT_MAX8BIT >= 167
NXFONT_DEFMETRIC(167),
#endif
#if NXFONT_MIN8BIT <= 168 && NXFONT_MAX8BIT >= 168
NXFONT_DEFMETRIC(168),
#endif
#if NXFONT_MIN8BIT <= 169 && NXFONT_MAX8BIT >= 169
NXFONT_DEFMETRIC(169),
#endif
#if NXFONT_MIN8BIT <= 170 && NXFONT_MAX8BIT >= 170
NXFONT_DEFMETRIC(170),
#endif
#if NXFONT_MIN8BIT <= 171 && NXFONT_MAX8BIT >= 171
NXFONT_DEFMETRIC(171),
#endif
#if NXFONT_MIN8BIT <= 172 && NXFONT_MAX8BIT >= 172
NXFONT_DEFMETRIC(172),
#endif
#if NXFONT_MIN8BIT <= 173 && NXFONT_MAX8BIT >= 173
NXFONT_DEFMETRIC(173),
#endif
#if NXFONT_MIN8BIT <= 174 && NXFONT_MAX8BIT >= 174
NXFONT_DEFMETRIC(174),
#endif
#if NXFONT_MIN8BIT <= 175 && NXFONT_MAX8BIT >= 175
NXFONT_DEFMETRIC(175),
#endif
#if NXFONT_MIN8BIT <= 176 && NXFONT_MAX8BIT >= 176
NXFONT_DEFMETRIC(176),
#endif
#if NXFONT_MIN8BIT <= 177 && NXFONT_MAX8BIT >= 177
NXFONT_DEFMETRIC(177),
#endif
#if NXFONT_MIN8BIT <= 178 && NXFONT_MAX8BIT >= 178
NXFONT_DEFMETRIC(178),
#endif
#if NXFONT_MIN8BIT <= 179 && NXFONT_MAX8BIT >= 179
NXFONT_DEFMETRIC(179),
#endif
#if NXFONT_MIN8BIT <= 180 && NXFONT_MAX8BIT >= 180
NXFONT_DEFMETRIC(180),
#endif
#if NXFONT_MIN8BIT <= 181 && NXFONT_MAX8BIT >= 181
NXFONT_DEFMETRIC(181),
#endif
#if NXFONT_MIN8BIT <= 182 && NXFONT_MAX8BIT >= 182
NXFONT_DEFMETRIC(182),
#endif
#if NXFONT_MIN8BIT <= 183 && NXFONT_MAX8BIT >= 183
NXFONT_DEFMETRIC(183),
#endif
#if NXFONT_MIN8BIT <= 184 && NXFONT_MAX8BIT >= 184
NXFONT_DEFMETRIC(184),
#endif
#if NXFONT_MIN8BIT <= 185 && NXFONT_MAX8BIT >= 185
NXFONT_DEFMETRIC(185),
#endif
#if NXFONT_MIN8BIT <= 186 && NXFONT_MAX8BIT >= 186
NXFONT_DEFMETRIC(186),
#endif
#if NXFONT_MIN8BIT <= 187 && NXFONT_MAX8BIT >= 187
NXFONT_DEFMETRIC(187),
#endif
#if NXFONT_MIN8BIT <= 188 && NXFONT_MAX8BIT >= 188
NXFONT_DEFMETRIC(188),
#endif
#if NXFONT_MIN8BIT <= 189 && NXFONT_MAX8BIT >= 189
NXFONT_DEFMETRIC(189),
#endif
#if NXFONT_MIN8BIT <= 190 && NXFONT_MAX8BIT >= 190
NXFONT_DEFMETRIC(190),
#endif
#if NXFONT_MIN8BIT <= 191 && NXFONT_MAX8BIT >= 191
NXFONT_DEFMETRIC(191),
#endif
#if NXFONT_MIN8BIT <= 192 && NXFONT_MAX8BIT >= 192
NXFONT_DEFMETRIC(192),
#endif
#if NXFONT_MIN8BIT <= 193 && NXFONT_MAX8BIT >= 193
NXFONT_DEFMETRIC(193),
#endif
#if NXFONT_MIN8BIT <= 194 && NXFONT_MAX8BIT >= 194
NXFONT_DEFMETRIC(194),
#endif
#if NXFONT_MIN8BIT <= 195 && NXFONT_MAX8BIT >= 195
NXFONT_DEFMETRIC(195),
#endif
#if NXFONT_MIN8BIT <= 196 && NXFONT_MAX8BIT >= 196
NXFONT_DEFMETRIC(196),
#endif
#if NXFONT_MIN8BIT <= 197 && NXFONT_MAX8BIT >= 197
NXFONT_DEFMETRIC(197),
#endif
#if NXFONT_MIN8BIT <= 198 && NXFONT_MAX8BIT >= 198
NXFONT_DEFMETRIC(198),
#endif
#if NXFONT_MIN8BIT <= 199 && NXFONT_MAX8BIT >= 199
NXFONT_DEFMETRIC(199),
#endif
#if NXFONT_MIN8BIT <= 200 && NXFONT_MAX8BIT >= 200
NXFONT_DEFMETRIC(200),
#endif
#if NXFONT_MIN8BIT <= 201 && NXFONT_MAX8BIT >= 201
NXFONT_DEFMETRIC(201),
#endif
#if NXFONT_MIN8BIT <= 202 && NXFONT_MAX8BIT >= 202
NXFONT_DEFMETRIC(202),
#endif
#if NXFONT_MIN8BIT <= 203 && NXFONT_MAX8BIT >= 203
NXFONT_DEFMETRIC(203),
#endif
#if NXFONT_MIN8BIT <= 204 && NXFONT_MAX8BIT >= 204
NXFONT_DEFMETRIC(204),
#endif
#if NXFONT_MIN8BIT <= 205 && NXFONT_MAX8BIT >= 205
NXFONT_DEFMETRIC(205),
#endif
#if NXFONT_MIN8BIT <= 206 && NXFONT_MAX8BIT >= 206
NXFONT_DEFMETRIC(206),
#endif
#if NXFONT_MIN8BIT <= 207 && NXFONT_MAX8BIT >= 207
NXFONT_DEFMETRIC(207),
#endif
#if NXFONT_MIN8BIT <= 208 && NXFONT_MAX8BIT >= 208
NXFONT_DEFMETRIC(208),
#endif
#if NXFONT_MIN8BIT <= 209 && NXFONT_MAX8BIT >= 209
NXFONT_DEFMETRIC(209),
#endif
#if NXFONT_MIN8BIT <= 210 && NXFONT_MAX8BIT >= 210
NXFONT_DEFMETRIC(210),
#endif
#if NXFONT_MIN8BIT <= 211 && NXFONT_MAX8BIT >= 211
NXFONT_DEFMETRIC(211),
#endif
#if NXFONT_MIN8BIT <= 212 && NXFONT_MAX8BIT >= 212
NXFONT_DEFMETRIC(212),
#endif
#if NXFONT_MIN8BIT <= 213 && NXFONT_MAX8BIT >= 213
NXFONT_DEFMETRIC(213),
#endif
#if NXFONT_MIN8BIT <= 214 && NXFONT_MAX8BIT >= 214
NXFONT_DEFMETRIC(214),
#endif
#if NXFONT_MIN8BIT <= 215 && NXFONT_MAX8BIT >= 215
NXFONT_DEFMETRIC(215),
#endif
#if NXFONT_MIN8BIT <= 216 && NXFONT_MAX8BIT >= 216
NXFONT_DEFMETRIC(216),
#endif
#if NXFONT_MIN8BIT <= 217 && NXFONT_MAX8BIT >= 217
NXFONT_DEFMETRIC(217),
#endif
#if NXFONT_MIN8BIT <= 218 && NXFONT_MAX8BIT >= 218
NXFONT_DEFMETRIC(218),
#endif
#if NXFONT_MIN8BIT <= 219 && NXFONT_MAX8BIT >= 219
NXFONT_DEFMETRIC(219),
#endif
#if NXFONT_MIN8BIT <= 220 && NXFONT_MAX8BIT >= 220
NXFONT_DEFMETRIC(220),
#endif
#if NXFONT_MIN8BIT <= 221 && NXFONT_MAX8BIT >= 221
NXFONT_DEFMETRIC(221),
#endif
#if NXFONT_MIN8BIT <= 222 && NXFONT_MAX8BIT >= 222
NXFONT_DEFMETRIC(222),
#endif
#if NXFONT_MIN8BIT <= 223 && NXFONT_MAX8BIT >= 223
NXFONT_DEFMETRIC(223),
#endif
#if NXFONT_MIN8BIT <= 224 && NXFONT_MAX8BIT >= 224
NXFONT_DEFMETRIC(224),
#endif
#if NXFONT_MIN8BIT <= 225 && NXFONT_MAX8BIT >= 225
NXFONT_DEFMETRIC(225),
#endif
#if NXFONT_MIN8BIT <= 226 && NXFONT_MAX8BIT >= 226
NXFONT_DEFMETRIC(226),
#endif
#if NXFONT_MIN8BIT <= 227 && NXFONT_MAX8BIT >= 227
NXFONT_DEFMETRIC(227),
#endif
#if NXFONT_MIN8BIT <= 228 && NXFONT_MAX8BIT >= 228
NXFONT_DEFMETRIC(228),
#endif
#if NXFONT_MIN8BIT <= 229 && NXFONT_MAX8BIT >= 229
NXFONT_DEFMETRIC(229),
#endif
#if NXFONT_MIN8BIT <= 230 && NXFONT_MAX8BIT >= 230
NXFONT_DEFMETRIC(230),
#endif
#if NXFONT_MIN8BIT <= 231 && NXFONT_MAX8BIT >= 231
NXFONT_DEFMETRIC(231),
#endif
#if NXFONT_MIN8BIT <= 232 && NXFONT_MAX8BIT >= 232
NXFONT_DEFMETRIC(232),
#endif
#if NXFONT_MIN8BIT <= 233 && NXFONT_MAX8BIT >= 233
NXFONT_DEFMETRIC(233),
#endif
#if NXFONT_MIN8BIT <= 234 && NXFONT_MAX8BIT >= 234
NXFONT_DEFMETRIC(234),
#endif
#if NXFONT_MIN8BIT <= 235 && NXFONT_MAX8BIT >= 235
NXFONT_DEFMETRIC(235),
#endif
#if NXFONT_MIN8BIT <= 236 && NXFONT_MAX8BIT >= 236
NXFONT_DEFMETRIC(236),
#endif
#if NXFONT_MIN8BIT <= 237 && NXFONT_MAX8BIT >= 237
NXFONT_DEFMETRIC(237),
#endif
#if NXFONT_MIN8BIT <= 238 && NXFONT_MAX8BIT >= 238
NXFONT_DEFMETRIC(238),
#endif
#if NXFONT_MIN8BIT <= 239 && NXFONT_MAX8BIT >= 239
NXFONT_DEFMETRIC(239),
#endif
#if NXFONT_MIN8BIT <= 240 && NXFONT_MAX8BIT >= 240
NXFONT_DEFMETRIC(240),
#endif
#if NXFONT_MIN8BIT <= 241 && NXFONT_MAX8BIT >= 241
NXFONT_DEFMETRIC(241),
#endif
#if NXFONT_MIN8BIT <= 242 && NXFONT_MAX8BIT >= 242
NXFONT_DEFMETRIC(242),
#endif
#if NXFONT_MIN8BIT <= 243 && NXFONT_MAX8BIT >= 243
NXFONT_DEFMETRIC(243),
#endif
#if NXFONT_MIN8BIT <= 244 && NXFONT_MAX8BIT >= 244
NXFONT_DEFMETRIC(244),
#endif
#if NXFONT_MIN8BIT <= 245 && NXFONT_MAX8BIT >= 245
NXFONT_DEFMETRIC(245),
#endif
#if NXFONT_MIN8BIT <= 246 && NXFONT_MAX8BIT >= 246
NXFONT_DEFMETRIC(246),
#endif
#if NXFONT_MIN8BIT <= 247 && NXFONT_MAX8BIT >= 247
NXFONT_DEFMETRIC(247),
#endif
#if NXFONT_MIN8BIT <= 248 && NXFONT_MAX8BIT >= 248
NXFONT_DEFMETRIC(248),
#endif
#if NXFONT_MIN8BIT <= 249 && NXFONT_MAX8BIT >= 249
NXFONT_DEFMETRIC(249),
#endif
#if NXFONT_MIN8BIT <= 250 && NXFONT_MAX8BIT >= 250
NXFONT_DEFMETRIC(250),
#endif
#if NXFONT_MIN8BIT <= 251 && NXFONT_MAX8BIT >= 251
NXFONT_DEFMETRIC(251),
#endif
#if NXFONT_MIN8BIT <= 252 && NXFONT_MAX8BIT >= 252
NXFONT_DEFMETRIC(252),
#endif
#if NXFONT_MIN8BIT <= 253 && NXFONT_MAX8BIT >= 253
NXFONT_DEFMETRIC(253),
#endif
#if NXFONT_MIN8BIT <= 254 && NXFONT_MAX8BIT >= 254
NXFONT_DEFMETRIC(254),
#endif
#if NXFONT_MIN8BIT <= 255 && NXFONT_MAX8BIT >= 255
NXFONT_DEFMETRIC(255),
#endif
};
#endif

/****************************************************************************
 * Public Data
 ****************************************************************************/

const struct nx_fontpackage_s NXF_SYMNAME(NXFONTS_PREFIX,package) =
{
  NXFONT_ID,                             /* The font ID */
  {                                      /*  Font set metrics: */
    NXFONT_MAXHEIGHT,                    /*   Max. height of a glyph in rows */
    NXFONT_MAXWIDTH,                     /*   Max. width of a glyph in pixels */
    CONFIG_NXFONTS_CHARBITS,             /*   Max number of bits per character code */
    NXFONT_SPACEWIDTH,                   /*   The width of a space in pixels */
  },
  {                                      /* Fonts for 7-bit encoding */
    NXFONT_MIN7BIT,                      /* First glyph code */
    NXFONT_N7BITFONTS,                   /* Number of bitmap glyphs */
    NXF_SYMNAME(NXFONTS_PREFIX,7bitmaps) /* List of glyphs */
  }
#if CONFIG_NXFONTS_CHARBITS >= 8
, {                                      /* Fonts for 8-bit encoding */
    NXFONT_MIN8BIT,                      /* First glyph code */
    NXFONT_N8BITFONTS,                   /* Number of bitmap glyphs */
    NXF_SYMNAME(NXFONTS_PREFIX,8bitmaps) /* List of glyphs */
  }
#endif
};

/****************************************************************************
 * Private Functions
 ****************************************************************************/

/****************************************************************************
 * Public Functions
 ****************************************************************************/

