/****************************************************************************
 * configs/skp16c26/scripts/skp16c26.ld
 *
 *   Copyright (C) 2009, 2017 Gregory Nutt. All rights reserved.
 *   Author: Gregory Nutt <gnutt@nuttx.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name NuttX nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

OUTPUT_ARCH(m32c)
ENTRY(_stext)
SECTIONS
{
	/* "Far" flash memory begins at address 0xf0000 for the M20262F8 part and
	 * ends at address 0xfffff (all parts).  The program entry point is
	 * the first address in flash
	 */

	. = 0xf0000;
	.text : {
		_stext = ABSOLUTE(.);
		*(.text)
		*(.fixup)
		*(.gnu.warning)
		*(.rodata)
		*(.glue_7)
		*(.glue_7t)
		*(.got)			/* Global offset table		*/
		_etext = ABSOLUTE(.);
	}

	_enronly = ABSOLUTE(.);		/* End of read-only values      */
					/* .ndata will be relocated     */
					/* from this address            */

	/* The "variable" vector table will be fixed at the following address */

	. = 0xffd00;
	.varvect : {
		_svarvect = ABSOLUTE(.);
		*(.varvect)
		_evarvect = ABSOLUTE(.);
	}

	/* Followed by the special page/fixed vector table. */

	. = 0xffe00;
	.specpg : {
		_sspecpg = ABSOLUTE(.);
		*(.specpg)
		_especpg = ABSOLUTE(.);
	}

	. = 0xfffdc;
	.fixvect : {
		_sfixvect = ABSOLUTE(.);
		*(.fixvect)
		_efixvect = ABSOLUTE(.);
	}

	/* Internal "near" RAM begins at address 0x00400 (all parts) and ends at
	 * address 0x00bff (M20262F6 and M20262F8 parts).  With the RAM
	 * region, used is .data followed by .bss.  The remainder of RAM
	 * carved up by the start-up code into stacks and heaps.
	 */

	. = 0x00400;

	.ndata : {
		_sndata = ABSOLUTE(.);
		*(.data)
		CONSTRUCTORS
		_endata = ABSOLUTE(.);
	}

	.nbss : {			/* BSS				*/
		_snbss = ABSOLUTE(.);
		*(.bss)
		*(COMMON)
		_enbss = ABSOLUTE(.);
	}

	/* "Far" RAM begins at 0x10000.  The SKP16C26 has no far RAM */

	. = 0x10000;

	.fdata : {
		_sfdata = ABSOLUTE(.);
		*(.fdata)
		CONSTRUCTORS
		_efdata = ABSOLUTE(.);
	}

	.fbss : {			/* BSS				*/
		_sfbss = ABSOLUTE(.);
		*(.fbss)
		*(COMMON)
		_efbss = ABSOLUTE(.);
	}
					/* Stabs debugging sections.	*/
	.stab 0 : { *(.stab) }
	.stabstr 0 : { *(.stabstr) }
	.stab.excl 0 : { *(.stab.excl) }
	.stab.exclstr 0 : { *(.stab.exclstr) }
	.stab.index 0 : { *(.stab.index) }
	.stab.indexstr 0 : { *(.stab.indexstr) }
	.comment 0 : { *(.comment) }
	.debug_abbrev 0 : { *(.debug_abbrev) }
	.debug_info 0 : { *(.debug_info) }
	.debug_line 0 : { *(.debug_line) }
	.debug_pubnames 0 : { *(.debug_pubnames) }
	.debug_aranges 0 : { *(.debug_aranges) }
}
