/*****************************************************************************************************
 * arch/arm/src/imxrt/chip/imxrt105x_pinmux.h
 *
 *   Copyright (C) 2018 Gregory Nutt. All rights reserved.
 *   Authors: Gregory Nutt <gnutt@nuttx.org>
 *            David Sidrane <david_s5@nscdg.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name NuttX nor the names of its contributors may be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************************************/

#ifndef __ARCH_ARM_SRC_IMXRT_CHIP_IMXRT106X_PINMUX_H
#define __ARCH_ARM_SRC_IMXRT_CHIP_IMXRT106X_PINMUX_H

/*****************************************************************************************************
 * Included Files
 *****************************************************************************************************/

#include <nuttx/config.h>
#include "chip/imxrt_iomuxc.h"

/*****************************************************************************************************
 * Pre-processor Definitions
 *****************************************************************************************************/

/* Alternate Pin Functions.
 *
 * Alternative pin selections are provided with a numeric suffix like _1, _2, etc.  Drivers, however,
 * will use the pin selection without the numeric suffix.  Additional definitions are required in the
 * board.h file.  For example, if LPUART1 CTS connects via the AD_B1_04 pin, then the following
 * definition should appear in the board.h header file for that board:
 *
 *   #define GPIO_LPUART3_CTS GPIO_LPUART3_CTS_1
 *
 * The driver will then automatically configure to use the AD_B1_04 pin for LPUART1 CTS.
 */

/* WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!! WARNING!!!
 * Additional effort is required to select specific IOMUX options such as frequency, open-drain,
 * push-pull, and pull-up/down!  Just the basics are defined for most pins in this file.  See the
 * upper imxrt_gpio.h and imxrt_iomuxc.h header files for available definitions.
 */

/* Analog Comparator (ACMP) */

#define GPIO_ACMP_OUT00                (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_12_INDEX))
#define GPIO_ACMP_OUT01                (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_13_INDEX))
#define GPIO_ACMP_OUT02                (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_14_INDEX))
#define GPIO_ACMP_OUT03                (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_15_INDEX))

/* ARM */

#define GPIO_ARM_CM7_RXEV              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_15_INDEX))
#define GPIO_ARM_CM7_TXEV              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_14_INDEX))

/* Clock Controller Module (CCM) */

#define GPIO_CCM_CLKO1                 (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_04_INDEX))
#define GPIO_CCM_CLKO2                 (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_05_INDEX))
#define GPIO_CCM_PMIC_RDY              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_32_INDEX))
#define GPIO_CCM_PMIC_READY_1          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_12_INDEX))
#define GPIO_CCM_PMIC_READY_2          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_08_INDEX))
#define GPIO_CCM_PMIC_READY_3          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_01_INDEX))
#define GPIO_CCM_PMIC_READY_4          (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_03_INDEX))
#define GPIO_CCM_PMIC_VSTBY_REQ        (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_PMIC_STBY_REQ_INDEX))
#define GPIO_CCM_REF_EN                (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_07_INDEX))
#define GPIO_CCM_STOP                  (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_04_INDEX))
#define GPIO_CCM_WAIT                  (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_02_INDEX))

/* CMOS Sensor Interface (CSI) */

#define GPIO_CSI_DATA00                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_10_INDEX))
#define GPIO_CSI_DATA01                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_11_INDEX))
#define GPIO_CSI_DATA02_1              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_11_INDEX))
#define GPIO_CSI_DATA02_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_15_INDEX))
#define GPIO_CSI_DATA03_1              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_10_INDEX))
#define GPIO_CSI_DATA03_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_14_INDEX))
#define GPIO_CSI_DATA04_1              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_09_INDEX))
#define GPIO_CSI_DATA04_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_13_INDEX))
#define GPIO_CSI_DATA05_1              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_08_INDEX))
#define GPIO_CSI_DATA05_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_12_INDEX))
#define GPIO_CSI_DATA06_1              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_07_INDEX))
#define GPIO_CSI_DATA06_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_11_INDEX))
#define GPIO_CSI_DATA07_1              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_06_INDEX))
#define GPIO_CSI_DATA07_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_10_INDEX))
#define GPIO_CSI_DATA08_1              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_05_INDEX))
#define GPIO_CSI_DATA08_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_09_INDEX))
#define GPIO_CSI_DATA09_1              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_04_INDEX))
#define GPIO_CSI_DATA09_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_08_INDEX))
#define GPIO_CSI_DATA10                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_09_INDEX))
#define GPIO_CSI_DATA11                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_08_INDEX))
#define GPIO_CSI_DATA12                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_07_INDEX))
#define GPIO_CSI_DATA13                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_06_INDEX))
#define GPIO_CSI_DATA14                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_05_INDEX))
#define GPIO_CSI_DATA15                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_04_INDEX))
#define GPIO_CSI_DATA16                (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_37_INDEX))
#define GPIO_CSI_DATA17                (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_36_INDEX))
#define GPIO_CSI_DATA18                (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_35_INDEX))
#define GPIO_CSI_DATA19                (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_34_INDEX))
#define GPIO_CSI_DATA20                (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_33_INDEX))
#define GPIO_CSI_DATA21                (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_32_INDEX))
#define GPIO_CSI_DATA22                (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_31_INDEX))
#define GPIO_CSI_DATA23                (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_30_INDEX))
#define GPIO_CSI_FIELD                 (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_38_INDEX))
#define GPIO_CSI_HSYNC_1               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_14_INDEX))
#define GPIO_CSI_HSYNC_2               (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_15_INDEX))
#define GPIO_CSI_HSYNC_3               (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_07_INDEX))
#define GPIO_CSI_MCLK_1                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_15_INDEX))
#define GPIO_CSI_MCLK_2                (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_05_INDEX))
#define GPIO_CSI_PIXCLK_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_12_INDEX))
#define GPIO_CSI_PIXCLK_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_04_INDEX))
#define GPIO_CSI_VSYNC_1               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_13_INDEX))
#define GPIO_CSI_VSYNC_2               (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_14_INDEX))
#define GPIO_CSI_VSYNC_3               (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_06_INDEX))

/* Ethernet (ENET) */

#define GPIO_ENET_1588_EVENT0_IN_1     (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_15_INDEX))
#define GPIO_ENET_1588_EVENT0_IN_2     (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_12_INDEX))
#define GPIO_ENET_1588_EVENT0_IN_3     (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_11_INDEX))
#define GPIO_ENET_1588_EVENT0_OUT_1    (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_14_INDEX))
#define GPIO_ENET_1588_EVENT0_OUT_2    (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_13_INDEX))
#define GPIO_ENET_1588_EVENT0_OUT_3    (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_10_INDEX))
#define GPIO_ENET_1588_EVENT1_IN       (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_13_INDEX))
#define GPIO_ENET_1588_EVENT1_OUT      (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_12_INDEX))
#define GPIO_ENET_1588_EVENT2_IN       (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_03_INDEX))
#define GPIO_ENET_1588_EVENT2_OUT      (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_02_INDEX))
#define GPIO_ENET_1588_EVENT3_IN       (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_08_INDEX))
#define GPIO_ENET_1588_EVENT3_OUT      (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_07_INDEX))
#define GPIO_ENET_COL                  (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_11_INDEX))
#define GPIO_ENET_CRS                  (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_10_INDEX))
#define GPIO_ENET_MDC_1                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_14_INDEX))
#define GPIO_ENET_MDC_2                (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_04_INDEX))
#define GPIO_ENET_MDC_3                (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_40_INDEX) | \
                                        IOMUX_SLEW_FAST | IOMUX_DRIVE_50OHM | IOMUX_SPEED_MAX | \
                                        IOMUX_PULL_UP_100K | _IOMUX_PULL_ENABLE)
#define GPIO_ENET_MDIO_1               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_15_INDEX))
#define GPIO_ENET_MDIO_2               (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_05_INDEX))
#define GPIO_ENET_MDIO_3               (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_41_INDEX) | \
                                        IOMUX_SLEW_FAST | IOMUX_DRIVE_50OHM | IOMUX_OPENDRAIN | \
                                        IOMUX_SPEED_LOW | IOMUX_PULL_UP_100K | _IOMUX_PULL_ENABLE)
#define GPIO_ENET_RDATA00              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_20_INDEX))
#define GPIO_ENET_RDATA01              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_19_INDEX))
#define GPIO_ENET_REF_CLK_1            (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_25_INDEX))
#define GPIO_ENET_REF_CLK_2            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_10_INDEX) | \
                                        IOMUX_SLEW_FAST | IOMUX_DRIVE_40OHM | IOMUX_SPEED_LOW | \
                                        IOMUX_PULL_DOWN_100K | IOMUX_PULL_KEEP)
#define GPIO_ENET_RX_CLK               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_06_INDEX))
#define GPIO_ENET_RX_DATA00            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_04_INDEX) | \
                                        IOMUX_SLEW_FAST | IOMUX_DRIVE_50OHM | IOMUX_SPEED_MAX | \
                                        IOMUX_PULL_UP_100K | _IOMUX_PULL_ENABLE)
#define GPIO_ENET_RX_DATA01            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_05_INDEX) | \
                                        IOMUX_SLEW_FAST | IOMUX_DRIVE_50OHM | IOMUX_SPEED_MAX | \
                                        IOMUX_PULL_UP_100K | _IOMUX_PULL_ENABLE)
#define GPIO_ENET_RX_DATA02            (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_09_INDEX))
#define GPIO_ENET_RX_DATA03            (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_08_INDEX))
#define GPIO_ENET_RX_EN_1              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_06_INDEX) | \
                                        IOMUX_SLEW_FAST | IOMUX_DRIVE_50OHM | IOMUX_SPEED_MAX | \
                                        IOMUX_PULL_UP_100K | _IOMUX_PULL_ENABLE)
#define GPIO_ENET_RX_EN_2              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_23_INDEX))
#define GPIO_ENET_RX_ER_1              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_11_INDEX) | \
                                        IOMUX_SLEW_FAST | IOMUX_DRIVE_50OHM | IOMUX_SPEED_MAX | \
                                        IOMUX_PULL_UP_100K | _IOMUX_PULL_ENABLE)
#define GPIO_ENET_RX_ER_2              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_26_INDEX))
#define GPIO_ENET_TDATA00              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_22_INDEX))
#define GPIO_ENET_TDATA01              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_21_INDEX))
#define GPIO_ENET_TX_CLK_1             (GPIO_PERIPH | GPIO_ALT6 | GPIO_SION_ENABLE | \
                                        GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_10_INDEX) | \
                                        IOMUX_SLEW_FAST | IOMUX_DRIVE_40OHM | IOMUX_SPEED_LOW | \
                                        IOMUX_PULL_DOWN_100K | IOMUX_PULL_KEEP)
#define GPIO_ENET_TX_CLK_2             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_25_INDEX))
#define GPIO_ENET_TX_DATA00            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_07_INDEX) | \
                                        IOMUX_SLEW_FAST | IOMUX_DRIVE_50OHM | IOMUX_SPEED_MAX | \
                                        IOMUX_PULL_UP_100K | _IOMUX_PULL_ENABLE)
#define GPIO_ENET_TX_DATA01            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_08_INDEX) | \
                                        IOMUX_SLEW_FAST | IOMUX_DRIVE_50OHM | IOMUX_SPEED_MAX | \
                                        IOMUX_PULL_UP_100K | _IOMUX_PULL_ENABLE)
#define GPIO_ENET_TX_DATA02            (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_05_INDEX))
#define GPIO_ENET_TX_DATA03            (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_04_INDEX))
#define GPIO_ENET_TX_EN_1              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_09_INDEX) | \
                                        IOMUX_SLEW_FAST | IOMUX_DRIVE_50OHM | IOMUX_SPEED_MAX | \
                                        IOMUX_PULL_UP_100K | _IOMUX_PULL_ENABLE)
#define GPIO_ENET_TX_EN_2              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_24_INDEX))
#define GPIO_ENET_TX_ER                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_07_INDEX))

/* External Watchdog Monitor (EWM) */

#define GPIO_EWM_OUT_1                 (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_11_INDEX))
#define GPIO_EWM_OUT_2                 (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_13_INDEX))
#define GPIO_EWM_OUT_3                 (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_01_INDEX))

/* Flexible Controller Area Network (FLEXCAN) */

#define GPIO_FLEXCAN1_RX_1             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_09_INDEX))
#define GPIO_FLEXCAN1_RX_2             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_03_INDEX))
#define GPIO_FLEXCAN1_RX_3             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_18_INDEX))
#define GPIO_FLEXCAN1_RX_4             (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_03_INDEX))
#define GPIO_FLEXCAN1_TX_1             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_08_INDEX))
#define GPIO_FLEXCAN1_TX_2             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_02_INDEX))
#define GPIO_FLEXCAN1_TX_3             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_17_INDEX))
#define GPIO_FLEXCAN1_TX_4             (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_02_INDEX))

#define GPIO_FLEXCAN2_RX_1             (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_03_INDEX))
#define GPIO_FLEXCAN2_RX_2             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_10_INDEX))
#define GPIO_FLEXCAN2_RX_3             (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_15_INDEX))
#define GPIO_FLEXCAN2_RX_4             (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_09_INDEX))
#define GPIO_FLEXCAN2_TX_1             (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_02_INDEX))
#define GPIO_FLEXCAN2_TX_2             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_09_INDEX))
#define GPIO_FLEXCAN2_TX_3             (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_14_INDEX))
#define GPIO_FLEXCAN2_TX_4             (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_08_INDEX))

#define GPIO_FLEXCAN3_RX_1             (GPIO_PERIPH | GPIO_ALT8 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_11_INDEX))
#define GPIO_FLEXCAN3_RX_2             (GPIO_PERIPH | GPIO_ALT8 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_15_INDEX))
#define GPIO_FLEXCAN3_RX_3             (GPIO_PERIPH | GPIO_ALT9 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_37_INDEX))
#define GPIO_FLEXCAN3_TX_1             (GPIO_PERIPH | GPIO_ALT8 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_10_INDEX))
#define GPIO_FLEXCAN3_TX_2             (GPIO_PERIPH | GPIO_ALT8 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_14_INDEX))
#define GPIO_FLEXCAN3_TX_3             (GPIO_PERIPH | GPIO_ALT9 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_36_INDEX))

/* Flexible I/O (FlexIO) */

#define GPIO_FLEXIO1_FLEXIO00          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_00_INDEX))
#define GPIO_FLEXIO1_FLEXIO01          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_01_INDEX))
#define GPIO_FLEXIO1_FLEXIO02          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_02_INDEX))
#define GPIO_FLEXIO1_FLEXIO03          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_03_INDEX))
#define GPIO_FLEXIO1_FLEXIO04          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_04_INDEX))
#define GPIO_FLEXIO1_FLEXIO05          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_05_INDEX))
#define GPIO_FLEXIO1_FLEXIO06          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_06_INDEX))
#define GPIO_FLEXIO1_FLEXIO07          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_07_INDEX))
#define GPIO_FLEXIO1_FLEXIO08          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_08_INDEX))
#define GPIO_FLEXIO1_FLEXIO09          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_09_INDEX))
#define GPIO_FLEXIO1_FLEXIO10          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_10_INDEX))
#define GPIO_FLEXIO1_FLEXIO11          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_11_INDEX))
#define GPIO_FLEXIO1_FLEXIO12          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_26_INDEX))
#define GPIO_FLEXIO1_FLEXIO13          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_27_INDEX))
#define GPIO_FLEXIO1_FLEXIO14          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_28_INDEX))
#define GPIO_FLEXIO1_FLEXIO15          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_29_INDEX))

#define GPIO_FLEXIO2_FLEXIO00          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_00_INDEX))
#define GPIO_FLEXIO2_FLEXIO01          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_01_INDEX))
#define GPIO_FLEXIO2_FLEXIO02          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_02_INDEX))
#define GPIO_FLEXIO2_FLEXIO03          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_03_INDEX))
#define GPIO_FLEXIO2_FLEXIO04          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_04_INDEX))
#define GPIO_FLEXIO2_FLEXIO05          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_05_INDEX))
#define GPIO_FLEXIO2_FLEXIO06          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_06_INDEX))
#define GPIO_FLEXIO2_FLEXIO07          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_07_INDEX))
#define GPIO_FLEXIO2_FLEXIO08          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_08_INDEX))
#define GPIO_FLEXIO2_FLEXIO09          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_09_INDEX))
#define GPIO_FLEXIO2_FLEXIO10          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_10_INDEX))
#define GPIO_FLEXIO2_FLEXIO11          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_11_INDEX))
#define GPIO_FLEXIO2_FLEXIO12          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_12_INDEX))
#define GPIO_FLEXIO2_FLEXIO13          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_13_INDEX))
#define GPIO_FLEXIO2_FLEXIO14          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_14_INDEX))
#define GPIO_FLEXIO2_FLEXIO15          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_15_INDEX))
#define GPIO_FLEXIO2_FLEXIO16          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_00_INDEX))
#define GPIO_FLEXIO2_FLEXIO17          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_01_INDEX))
#define GPIO_FLEXIO2_FLEXIO18          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_02_INDEX))
#define GPIO_FLEXIO2_FLEXIO19          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_03_INDEX))
#define GPIO_FLEXIO2_FLEXIO20          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_04_INDEX))
#define GPIO_FLEXIO2_FLEXIO21          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_05_INDEX))
#define GPIO_FLEXIO2_FLEXIO22          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_06_INDEX))
#define GPIO_FLEXIO2_FLEXIO23          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_07_INDEX))
#define GPIO_FLEXIO2_FLEXIO24          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_08_INDEX))
#define GPIO_FLEXIO2_FLEXIO25          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_09_INDEX))
#define GPIO_FLEXIO2_FLEXIO26          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_10_INDEX))
#define GPIO_FLEXIO2_FLEXIO27          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_11_INDEX))
#define GPIO_FLEXIO2_FLEXIO28          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_12_INDEX))
#define GPIO_FLEXIO2_FLEXIO29          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_13_INDEX))
#define GPIO_FLEXIO2_FLEXIO30          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_14_INDEX))
#define GPIO_FLEXIO2_FLEXIO31          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_15_INDEX))

/* Enhanced Flex Pulse Width Modulator (eFlexPWM) */

#define GPIO_FLEXPWM1_PWMA00_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_23_INDEX))
#define GPIO_FLEXPWM1_PWMA00_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_00_INDEX))
#define GPIO_FLEXPWM1_PWMA01_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_25_INDEX))
#define GPIO_FLEXPWM1_PWMA01_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_02_INDEX))
#define GPIO_FLEXPWM1_PWMA02_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_27_INDEX))
#define GPIO_FLEXPWM1_PWMA02_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_04_INDEX))
#define GPIO_FLEXPWM1_PWMA03_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_10_INDEX))
#define GPIO_FLEXPWM1_PWMA03_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_38_INDEX))
#define GPIO_FLEXPWM1_PWMA03_3         (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_00_INDEX))
#define GPIO_FLEXPWM1_PWMA03_4         (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_12_INDEX))
#define GPIO_FLEXPWM1_PWMA03_5         (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_00_INDEX))
#define GPIO_FLEXPWM1_PWMB00_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_24_INDEX))
#define GPIO_FLEXPWM1_PWMB00_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_01_INDEX))
#define GPIO_FLEXPWM1_PWMB01_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_26_INDEX))
#define GPIO_FLEXPWM1_PWMB01_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_03_INDEX))
#define GPIO_FLEXPWM1_PWMB02_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_28_INDEX))
#define GPIO_FLEXPWM1_PWMB02_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_05_INDEX))
#define GPIO_FLEXPWM1_PWMB03_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_11_INDEX))
#define GPIO_FLEXPWM1_PWMB03_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_39_INDEX))
#define GPIO_FLEXPWM1_PWMB03_3         (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_01_INDEX))
#define GPIO_FLEXPWM1_PWMB03_4         (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_13_INDEX))
#define GPIO_FLEXPWM1_PWMB03_5         (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_01_INDEX))
#define GPIO_FLEXPWM1_PWMX00           (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_02_INDEX))
#define GPIO_FLEXPWM1_PWMX01           (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_03_INDEX))
#define GPIO_FLEXPWM1_PWMX02           (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_12_INDEX))
#define GPIO_FLEXPWM1_PWMX03           (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_13_INDEX))

#define GPIO_FLEXPWM2_PWMA00_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_06_INDEX))
#define GPIO_FLEXPWM2_PWMA00_2         (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_06_INDEX))
#define GPIO_FLEXPWM2_PWMA01_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_08_INDEX))
#define GPIO_FLEXPWM2_PWMA01_2         (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_08_INDEX))
#define GPIO_FLEXPWM2_PWMA02_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_10_INDEX))
#define GPIO_FLEXPWM2_PWMA02_2         (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_10_INDEX))
#define GPIO_FLEXPWM2_PWMA03_1         (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_00_INDEX))
#define GPIO_FLEXPWM2_PWMA03_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_09_INDEX))
#define GPIO_FLEXPWM2_PWMA03_3         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_19_INDEX))
#define GPIO_FLEXPWM2_PWMA03_4         (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_02_INDEX))
#define GPIO_FLEXPWM2_PWMA03_5         (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_02_INDEX))
#define GPIO_FLEXPWM2_PWMB00_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_07_INDEX))
#define GPIO_FLEXPWM2_PWMB00_2         (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_07_INDEX))
#define GPIO_FLEXPWM2_PWMB01_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_09_INDEX))
#define GPIO_FLEXPWM2_PWMB01_2         (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_09_INDEX))
#define GPIO_FLEXPWM2_PWMB02_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_11_INDEX))
#define GPIO_FLEXPWM2_PWMB02_2         (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_11_INDEX))
#define GPIO_FLEXPWM2_PWMB03_1         (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_01_INDEX))
#define GPIO_FLEXPWM2_PWMB03_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_20_INDEX))
#define GPIO_FLEXPWM2_PWMB03_3         (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_03_INDEX))
#define GPIO_FLEXPWM2_PWMB03_4         (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_03_INDEX))

#define GPIO_FLEXPWM3_PWMA00           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_29_INDEX))
#define GPIO_FLEXPWM3_PWMA01           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_31_INDEX))
#define GPIO_FLEXPWM3_PWMA02           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_33_INDEX))
#define GPIO_FLEXPWM3_PWMA03           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_21_INDEX))
#define GPIO_FLEXPWM3_PWMB00           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_30_INDEX))
#define GPIO_FLEXPWM3_PWMB01           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_32_INDEX))
#define GPIO_FLEXPWM3_PWMB02           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_34_INDEX))
#define GPIO_FLEXPWM3_PWMB03           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_22_INDEX))

#define GPIO_FLEXPWM4_PWMA00_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_08_INDEX))
#define GPIO_FLEXPWM4_PWMA00_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_00_INDEX))
#define GPIO_FLEXPWM4_PWMA01_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_09_INDEX))
#define GPIO_FLEXPWM4_PWMA01_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_02_INDEX))
#define GPIO_FLEXPWM4_PWMA02_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_14_INDEX))
#define GPIO_FLEXPWM4_PWMA02_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_04_INDEX))
#define GPIO_FLEXPWM4_PWMA03_1         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_15_INDEX))
#define GPIO_FLEXPWM4_PWMA03_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_17_INDEX))
#define GPIO_FLEXPWM4_PWMB00           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_01_INDEX))
#define GPIO_FLEXPWM4_PWMB01           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_03_INDEX))
#define GPIO_FLEXPWM4_PWMB02           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_05_INDEX))
#define GPIO_FLEXPWM4_PWMB03           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_18_INDEX))

/* Flexible SPI (FlexSPI) */

#define GPIO_FLEXSPIA_DATA00_1         (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_13_INDEX))
#define GPIO_FLEXSPIA_DATA00_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_08_INDEX))
#define GPIO_FLEXSPIA_DATA01_1         (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_12_INDEX))
#define GPIO_FLEXSPIA_DATA01_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_09_INDEX))
#define GPIO_FLEXSPIA_DATA02_1         (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_11_INDEX))
#define GPIO_FLEXSPIA_DATA02_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_10_INDEX))
#define GPIO_FLEXSPIA_DATA03_1         (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_10_INDEX))
#define GPIO_FLEXSPIA_DATA03_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_11_INDEX))
#define GPIO_FLEXSPIA_DQS_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_09_INDEX))
#define GPIO_FLEXSPIA_DQS_2            (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_05_INDEX))
#define GPIO_FLEXSPIA_SCLK_1           (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_14_INDEX))
#define GPIO_FLEXSPIA_SCLK_2           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_07_INDEX))
#define GPIO_FLEXSPIA_SS0_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_15_INDEX))
#define GPIO_FLEXSPIA_SS0_2            (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_06_INDEX))
#define GPIO_FLEXSPIA_SS1_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_08_INDEX))
#define GPIO_FLEXSPIA_SS1_2            (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_04_INDEX))
#define GPIO_FLEXSPIA_SS1_3            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_00_INDEX))

#define GPIO_FLEXSPIB_DATA00_1         (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_07_INDEX))
#define GPIO_FLEXSPIB_DATA00_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_03_INDEX))
#define GPIO_FLEXSPIB_DATA01_1         (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_06_INDEX))
#define GPIO_FLEXSPIB_DATA01_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_02_INDEX))
#define GPIO_FLEXSPIB_DATA02_1         (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_05_INDEX))
#define GPIO_FLEXSPIB_DATA02_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_01_INDEX))
#define GPIO_FLEXSPIB_DATA03_1         (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_04_INDEX))
#define GPIO_FLEXSPIB_DATA03_2         (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_00_INDEX))
#define GPIO_FLEXSPIB_DQS              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_05_INDEX))
#define GPIO_FLEXSPIB_SCLK             (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_04_INDEX))
#define GPIO_FLEXSPIB_SS0_1            (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_04_INDEX))
#define GPIO_FLEXSPIB_SS0_2            (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_05_INDEX))
#define GPIO_FLEXSPIB_SS1              (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_01_INDEX))

/* GPIO */

#define GPIO_GPIO1_IO00                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_00_INDEX))
#define GPIO_GPIO1_IO01                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_01_INDEX))
#define GPIO_GPIO1_IO02                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_02_INDEX))
#define GPIO_GPIO1_IO03                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_03_INDEX))
#define GPIO_GPIO1_IO04                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_04_INDEX))
#define GPIO_GPIO1_IO05                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_05_INDEX))
#define GPIO_GPIO1_IO06                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_06_INDEX))
#define GPIO_GPIO1_IO07                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_07_INDEX))
#define GPIO_GPIO1_IO08                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_08_INDEX))
#define GPIO_GPIO1_IO09                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_09_INDEX))
#define GPIO_GPIO1_IO10                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_10_INDEX))
#define GPIO_GPIO1_IO11                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_11_INDEX))
#define GPIO_GPIO1_IO12                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_12_INDEX))
#define GPIO_GPIO1_IO13                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_13_INDEX))
#define GPIO_GPIO1_IO14                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_14_INDEX))
#define GPIO_GPIO1_IO15                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_15_INDEX))
#define GPIO_GPIO1_IO16                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_00_INDEX))
#define GPIO_GPIO1_IO17                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_01_INDEX))
#define GPIO_GPIO1_IO18                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_02_INDEX))
#define GPIO_GPIO1_IO19                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_03_INDEX))
#define GPIO_GPIO1_IO20                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_04_INDEX))
#define GPIO_GPIO1_IO21                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_05_INDEX))
#define GPIO_GPIO1_IO22                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_06_INDEX))
#define GPIO_GPIO1_IO23                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_07_INDEX))
#define GPIO_GPIO1_IO24                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_08_INDEX))
#define GPIO_GPIO1_IO25                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_09_INDEX))
#define GPIO_GPIO1_IO26                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_10_INDEX))
#define GPIO_GPIO1_IO27                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_11_INDEX))
#define GPIO_GPIO1_IO28                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_12_INDEX))
#define GPIO_GPIO1_IO29                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_13_INDEX))
#define GPIO_GPIO1_IO30                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_14_INDEX))
#define GPIO_GPIO1_IO31                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_15_INDEX))

#define GPIO_GPIO2_IO00                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_00_INDEX))
#define GPIO_GPIO2_IO01                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_01_INDEX))
#define GPIO_GPIO2_IO02                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_02_INDEX))
#define GPIO_GPIO2_IO03                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_03_INDEX))
#define GPIO_GPIO2_IO04                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_04_INDEX))
#define GPIO_GPIO2_IO05                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_05_INDEX))
#define GPIO_GPIO2_IO06                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_06_INDEX))
#define GPIO_GPIO2_IO07                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_07_INDEX))
#define GPIO_GPIO2_IO08                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_08_INDEX))
#define GPIO_GPIO2_IO09                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_09_INDEX))
#define GPIO_GPIO2_IO10                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_10_INDEX))
#define GPIO_GPIO2_IO11                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_11_INDEX))
#define GPIO_GPIO2_IO12                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_12_INDEX))
#define GPIO_GPIO2_IO13                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_13_INDEX))
#define GPIO_GPIO2_IO14                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_14_INDEX))
#define GPIO_GPIO2_IO15                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_15_INDEX))
#define GPIO_GPIO2_IO16                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_00_INDEX))
#define GPIO_GPIO2_IO17                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_01_INDEX))
#define GPIO_GPIO2_IO18                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_02_INDEX))
#define GPIO_GPIO2_IO19                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_03_INDEX))
#define GPIO_GPIO2_IO20                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_04_INDEX))
#define GPIO_GPIO2_IO21                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_05_INDEX))
#define GPIO_GPIO2_IO22                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_06_INDEX))
#define GPIO_GPIO2_IO23                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_07_INDEX))
#define GPIO_GPIO2_IO24                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_08_INDEX))
#define GPIO_GPIO2_IO25                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_09_INDEX))
#define GPIO_GPIO2_IO26                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_10_INDEX))
#define GPIO_GPIO2_IO27                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_11_INDEX))
#define GPIO_GPIO2_IO28                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_12_INDEX))
#define GPIO_GPIO2_IO29                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_13_INDEX))
#define GPIO_GPIO2_IO30                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_14_INDEX))
#define GPIO_GPIO2_IO31                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_15_INDEX))

#define GPIO_GPIO3_IO00                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_00_INDEX))
#define GPIO_GPIO3_IO01                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_01_INDEX))
#define GPIO_GPIO3_IO02                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_02_INDEX))
#define GPIO_GPIO3_IO03                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_03_INDEX))
#define GPIO_GPIO3_IO04                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_04_INDEX))
#define GPIO_GPIO3_IO05                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_05_INDEX))
#define GPIO_GPIO3_IO06                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_06_INDEX))
#define GPIO_GPIO3_IO07                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_07_INDEX))
#define GPIO_GPIO3_IO08                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_08_INDEX))
#define GPIO_GPIO3_IO09                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_09_INDEX))
#define GPIO_GPIO3_IO10                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_10_INDEX))
#define GPIO_GPIO3_IO11                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_11_INDEX))
#define GPIO_GPIO3_IO12                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_00_INDEX))
#define GPIO_GPIO3_IO13                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_01_INDEX))
#define GPIO_GPIO3_IO14                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_02_INDEX))
#define GPIO_GPIO3_IO15                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_03_INDEX))
#define GPIO_GPIO3_IO16                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_04_INDEX))
#define GPIO_GPIO3_IO17                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_05_INDEX))
#define GPIO_GPIO3_IO18                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_32_INDEX))
#define GPIO_GPIO3_IO19                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_33_INDEX))
#define GPIO_GPIO3_IO20                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_34_INDEX))
#define GPIO_GPIO3_IO21                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_35_INDEX))
#define GPIO_GPIO3_IO22                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_36_INDEX))
#define GPIO_GPIO3_IO23                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_37_INDEX))
#define GPIO_GPIO3_IO24                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_38_INDEX))
#define GPIO_GPIO3_IO25                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_39_INDEX))
#define GPIO_GPIO3_IO26                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_40_INDEX))
#define GPIO_GPIO3_IO27                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_41_INDEX))

#define GPIO_GPIO4_IO00                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_00_INDEX))
#define GPIO_GPIO4_IO01                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_01_INDEX))
#define GPIO_GPIO4_IO02                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_02_INDEX))
#define GPIO_GPIO4_IO03                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_03_INDEX))
#define GPIO_GPIO4_IO04                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_04_INDEX))
#define GPIO_GPIO4_IO05                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_05_INDEX))
#define GPIO_GPIO4_IO06                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_06_INDEX))
#define GPIO_GPIO4_IO07                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_07_INDEX))
#define GPIO_GPIO4_IO08                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_08_INDEX))
#define GPIO_GPIO4_IO09                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_09_INDEX))
#define GPIO_GPIO4_IO10                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_10_INDEX))
#define GPIO_GPIO4_IO11                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_11_INDEX))
#define GPIO_GPIO4_IO12                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_12_INDEX))
#define GPIO_GPIO4_IO13                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_13_INDEX))
#define GPIO_GPIO4_IO14                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_14_INDEX))
#define GPIO_GPIO4_IO15                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_15_INDEX))
#define GPIO_GPIO4_IO16                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_16_INDEX))
#define GPIO_GPIO4_IO17                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_17_INDEX))
#define GPIO_GPIO4_IO18                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_18_INDEX))
#define GPIO_GPIO4_IO19                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_19_INDEX))
#define GPIO_GPIO4_IO20                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_20_INDEX))
#define GPIO_GPIO4_IO21                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_21_INDEX))
#define GPIO_GPIO4_IO22                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_22_INDEX))
#define GPIO_GPIO4_IO23                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_23_INDEX))
#define GPIO_GPIO4_IO24                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_24_INDEX))
#define GPIO_GPIO4_IO25                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_25_INDEX))
#define GPIO_GPIO4_IO26                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_26_INDEX))
#define GPIO_GPIO4_IO27                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_27_INDEX))
#define GPIO_GPIO4_IO28                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_28_INDEX))
#define GPIO_GPIO4_IO29                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_29_INDEX))
#define GPIO_GPIO4_IO30                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_30_INDEX))
#define GPIO_GPIO4_IO31                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_31_INDEX))

#define GPIO_GPIO5_IO00                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_WAKEUP_INDEX))
#define GPIO_GPIO5_IO01                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_PMIC_ON_REQ_INDEX))
#define GPIO_GPIO5_IO02                (GPIO_PERIPH | GPIO_ALT5 | GPIO_PADMUX(IMXRT_PADMUX_PMIC_STBY_REQ_INDEX))

/* General Purpose Timer (GPT) */

#define GPIO_GPT1_CAPTURE1             (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_24_INDEX))
#define GPIO_GPT1_CAPTURE2             (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_23_INDEX))
#define GPIO_GPT1_CLK                  (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_13_INDEX))
#define GPIO_GPT1_COMPARE1             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_35_INDEX))
#define GPIO_GPT1_COMPARE2             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_36_INDEX))
#define GPIO_GPT1_COMPARE3             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_37_INDEX))

#define GPIO_GPT2_CAPTURE1             (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_41_INDEX))
#define GPIO_GPT2_CAPTURE2             (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_40_INDEX))
#define GPIO_GPT2_CLK                  (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_09_INDEX))
#define GPIO_GPT2_COMPARE2             (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_07_INDEX))
#define GPIO_GPT2_COMPARE3             (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_08_INDEX))

/* JTAG */

#define GPIO_JTAG_ACTIVE               (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_03_INDEX))
#define GPIO_JTAG_DE                   (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_01_INDEX))
#define GPIO_JTAG_DONE                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_00_INDEX))
#define GPIO_JTAG_FAIL                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_02_INDEX))
#define GPIO_JTAG_MOD                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_08_INDEX))
#define GPIO_JTAG_TCK                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_07_INDEX))
#define GPIO_JTAG_TDI                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_09_INDEX))
#define GPIO_JTAG_TDO                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_10_INDEX))
#define GPIO_JTAG_TRSTB                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_11_INDEX))

/* Keypad Port (KPP) */

#define GPIO_KPP_COL00                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_15_INDEX))
#define GPIO_KPP_COL01                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_13_INDEX))
#define GPIO_KPP_COL02                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_11_INDEX))
#define GPIO_KPP_COL03                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_09_INDEX))
#define GPIO_KPP_COL04                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_07_INDEX))
#define GPIO_KPP_COL05                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_05_INDEX))
#define GPIO_KPP_COL06                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_03_INDEX))
#define GPIO_KPP_COL07                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_01_INDEX))
#define GPIO_KPP_ROW00                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_14_INDEX))
#define GPIO_KPP_ROW01                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_12_INDEX))
#define GPIO_KPP_ROW02                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_10_INDEX))
#define GPIO_KPP_ROW03                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_08_INDEX))
#define GPIO_KPP_ROW04                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_06_INDEX))
#define GPIO_KPP_ROW05                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_04_INDEX))
#define GPIO_KPP_ROW06                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_02_INDEX))
#define GPIO_KPP_ROW07                 (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_00_INDEX))

/* LCD */

#define GPIO_LCD_CLK                   (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_00_INDEX))
#define GPIO_LCD_DATA00                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_04_INDEX))
#define GPIO_LCD_DATA01                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_05_INDEX))
#define GPIO_LCD_DATA02                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_06_INDEX))
#define GPIO_LCD_DATA03                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_07_INDEX))
#define GPIO_LCD_DATA04                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_08_INDEX))
#define GPIO_LCD_DATA05                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_09_INDEX))
#define GPIO_LCD_DATA06                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_10_INDEX))
#define GPIO_LCD_DATA07                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_11_INDEX))
#define GPIO_LCD_DATA08                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_12_INDEX))
#define GPIO_LCD_DATA09                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_13_INDEX))
#define GPIO_LCD_DATA10                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_14_INDEX))
#define GPIO_LCD_DATA11                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_15_INDEX))
#define GPIO_LCD_DATA12                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_00_INDEX))
#define GPIO_LCD_DATA13                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_01_INDEX))
#define GPIO_LCD_DATA14                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_02_INDEX))
#define GPIO_LCD_DATA15                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_03_INDEX))
#define GPIO_LCD_DATA16                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_04_INDEX))
#define GPIO_LCD_DATA17                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_05_INDEX))
#define GPIO_LCD_DATA18                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_06_INDEX))
#define GPIO_LCD_DATA19                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_07_INDEX))
#define GPIO_LCD_DATA20                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_08_INDEX))
#define GPIO_LCD_DATA21                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_09_INDEX))
#define GPIO_LCD_DATA22                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_10_INDEX))
#define GPIO_LCD_DATA23                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_11_INDEX))
#define GPIO_LCD_ENABLE                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_01_INDEX))
#define GPIO_LCD_HSYNC                 (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_02_INDEX))
#define GPIO_LCD_VSYNC                 (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_03_INDEX))

/* Low Power Inter-Integrated Circuit (LPI2C) */

#define GPIO_LPI2C1_HREQ               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_02_INDEX))
#define GPIO_LPI2C1_SCL_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_04_INDEX))
#define GPIO_LPI2C1_SCL_2              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_00_INDEX) | \
                                        GPIO_SION_ENABLE | IOMUX_PULL_UP_22K | IOMUX_OPENDRAIN | \
                                        IOMUX_SPEED_MEDIUM | IOMUX_DRIVE_33OHM)
#define GPIO_LPI2C1_SCLS               (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_00_INDEX))
#define GPIO_LPI2C1_SDA_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_05_INDEX))
#define GPIO_LPI2C1_SDA_2              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_01_INDEX) | \
                                        GPIO_SION_ENABLE | IOMUX_PULL_UP_22K | IOMUX_OPENDRAIN | \
                                        IOMUX_SPEED_MEDIUM | IOMUX_DRIVE_33OHM)
#define GPIO_LPI2C1_SDAS               (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_01_INDEX))

#define GPIO_LPI2C2_SCL_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_04_INDEX))
#define GPIO_LPI2C2_SCL_2              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_11_INDEX))
#define GPIO_LPI2C2_SDA_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_05_INDEX))
#define GPIO_LPI2C2_SDA_2              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_10_INDEX))

#define GPIO_LPI2C3_SCL_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_07_INDEX))
#define GPIO_LPI2C3_SCL_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_22_INDEX) | \
                                        GPIO_SION_ENABLE | IOMUX_OPENDRAIN | IOMUX_SPEED_MEDIUM | IOMUX_DRIVE_33OHM)
#define GPIO_LPI2C3_SCL_3              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_00_INDEX))
#define GPIO_LPI2C3_SDA_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_06_INDEX))
#define GPIO_LPI2C3_SDA_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_21_INDEX) | \
                                        GPIO_SION_ENABLE | IOMUX_OPENDRAIN | IOMUX_SPEED_MEDIUM | IOMUX_DRIVE_33OHM)
#define GPIO_LPI2C3_SDA_3              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_01_INDEX))

#define GPIO_LPI2C4_SCL_1              (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_12_INDEX))
#define GPIO_LPI2C4_SCL_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_12_INDEX) | \
                                        GPIO_SION_ENABLE | IOMUX_OPENDRAIN | IOMUX_SPEED_MEDIUM | IOMUX_DRIVE_33OHM)
#define GPIO_LPI2C4_SDA_1              (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_13_INDEX))
#define GPIO_LPI2C4_SDA_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_11_INDEX) | \
                                        GPIO_SION_ENABLE | IOMUX_OPENDRAIN | IOMUX_SPEED_MEDIUM | IOMUX_DRIVE_33OHM)

/* Low Power Serial Peripheral Interface (LPSPI) */

#define IOMUX_LPSPI                    (IOMUX_PULL_UP_100K | IOMUX_CMOS_OUTPUT | IOMUX_DRIVE_40OHM | \
                                        IOMUX_SLEW_FAST | IOMUX_SPEED_MEDIUM)

#define GPIO_LPSPI1_PCS0_1             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_30_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI1_PCS0_2             (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_01_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI1_PCS1               (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_31_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI1_PCS2               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_40_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI1_PCS3               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_41_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI1_SCK_1              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_27_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI1_SCK_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_00_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI1_SDI_1              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_29_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI1_SDI_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_03_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI1_SDO_1              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_28_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI1_SDO_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_02_INDEX) | IOMUX_LPSPI)

#define GPIO_LPSPI2_PCS0_1             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_01_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI2_PCS0_2             (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_06_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI2_PCS1               (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_14_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI2_PCS2               (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_10_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI2_PCS3               (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_11_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI2_SCK_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_00_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI2_SCK_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_07_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI2_SDI_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_03_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI2_SDI_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_09_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI2_SDO_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_02_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI2_SDO_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_08_INDEX) | IOMUX_LPSPI)

#define GPIO_LPSPI3_PCS0_1             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_12_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI3_PCS0_2             (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_03_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI3_PCS1               (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_04_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI3_PCS2               (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_05_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI3_PCS3               (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_06_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI3_SCK_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_15_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI3_SCK_2              (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_00_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI3_SDI_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_13_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI3_SDI_2              (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_02_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI3_SDO_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_14_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI3_SDO_2              (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_01_INDEX) | IOMUX_LPSPI)

#define GPIO_LPSPI4_PCS0_1             (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_04_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI4_PCS0_2             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_00_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI4_PCS1               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_03_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI4_PCS2               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_02_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI4_PCS3               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_11_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI4_SCK_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_07_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI4_SCK_2              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_03_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI4_SDI_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_05_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI4_SDI_2              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_01_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI4_SDO_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_06_INDEX) | IOMUX_LPSPI)
#define GPIO_LPSPI4_SDO_2              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_02_INDEX) | IOMUX_LPSPI)

/* Low Power Universal Asynchronous Receiver/Transmitter (LPUART) */

#define IOMUX_UART                     (IOMUX_PULL_UP_100K | IOMUX_CMOS_OUTPUT | IOMUX_DRIVE_40OHM | \
                                        IOMUX_SLEW_FAST | IOMUX_SPEED_MEDIUM | IOMUX_SCHMITT_TRIGGER)

#define GPIO_LPUART1_CTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_14_INDEX))
#define GPIO_LPUART1_RTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_15_INDEX))
#define GPIO_LPUART1_RX                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_13_INDEX) | IOMUX_UART)
#define GPIO_LPUART1_TX                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_12_INDEX) | IOMUX_UART)

#define GPIO_LPUART2_CTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_00_INDEX))
#define GPIO_LPUART2_RTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_01_INDEX))
#define GPIO_LPUART2_RX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_03_INDEX) | IOMUX_UART)
#define GPIO_LPUART2_RX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_10_INDEX) | IOMUX_UART)
#define GPIO_LPUART2_TX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_02_INDEX) | IOMUX_UART)
#define GPIO_LPUART2_TX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_11_INDEX) | IOMUX_UART)

#define GPIO_LPUART3_CTS_1             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_04_INDEX))
#define GPIO_LPUART3_CTS_2             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_15_INDEX))
#define GPIO_LPUART3_RTS_1             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_05_INDEX))
#define GPIO_LPUART3_RTS_2             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_16_INDEX))
#define GPIO_LPUART3_RX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_07_INDEX) | IOMUX_UART)
#define GPIO_LPUART3_RX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_14_INDEX)   | IOMUX_UART)
#define GPIO_LPUART3_RX_3              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_09_INDEX)    | IOMUX_UART)
#define GPIO_LPUART3_TX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_06_INDEX) | IOMUX_UART)
#define GPIO_LPUART3_TX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_13_INDEX)   | IOMUX_UART)
#define GPIO_LPUART3_TX_3              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_08_INDEX)    | IOMUX_UART)

#define GPIO_LPUART4_CTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_17_INDEX))
#define GPIO_LPUART4_RTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_18_INDEX))
#define GPIO_LPUART4_RX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_01_INDEX)    | IOMUX_UART)
#define GPIO_LPUART4_RX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_20_INDEX)   | IOMUX_UART)
#define GPIO_LPUART4_RX_3              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_01_INDEX) | IOMUX_UART)
#define GPIO_LPUART4_TX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_00_INDEX)    | IOMUX_UART)
#define GPIO_LPUART4_TX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_19_INDEX)   | IOMUX_UART)
#define GPIO_LPUART4_TX_3              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_00_INDEX) | IOMUX_UART)

#define GPIO_LPUART5_CTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_28_INDEX))
#define GPIO_LPUART5_RTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_27_INDEX))
#define GPIO_LPUART5_RX_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_13_INDEX)    | IOMUX_UART)
#define GPIO_LPUART5_RX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_24_INDEX))
#define GPIO_LPUART5_TX_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_12_INDEX)    | IOMUX_UART)
#define GPIO_LPUART5_TX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_23_INDEX))

#define GPIO_LPUART6_CTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_30_INDEX))
#define GPIO_LPUART6_RTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_29_INDEX))
#define GPIO_LPUART6_RX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_03_INDEX) | IOMUX_UART)
#define GPIO_LPUART6_RX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_26_INDEX)   | IOMUX_UART)
#define GPIO_LPUART6_TX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_02_INDEX) | IOMUX_UART)
#define GPIO_LPUART6_TX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_25_INDEX)   | IOMUX_UART)
#define GPIO_LPUART6_TX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_25_INDEX)   | IOMUX_UART)

#define GPIO_LPUART7_CTS_1             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_06_INDEX))
#define GPIO_LPUART7_RTS_2             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_07_INDEX))
#define GPIO_LPUART7_RX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_32_INDEX))
#define GPIO_LPUART7_RX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_09_INDEX))
#define GPIO_LPUART7_TX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_31_INDEX))
#define GPIO_LPUART7_TX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_08_INDEX))

#define GPIO_LPUART8_CTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_02_INDEX))
#define GPIO_LPUART8_RTS               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_03_INDEX))
#define GPIO_LPUART8_RX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_11_INDEX) | IOMUX_UART)
#define GPIO_LPUART8_RX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_39_INDEX)   | IOMUX_UART)
#define GPIO_LPUART8_RX_3              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_05_INDEX) | IOMUX_UART)
#define GPIO_LPUART8_TX_1              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_10_INDEX) | IOMUX_UART)
#define GPIO_LPUART8_TX_2              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_38_INDEX)   | IOMUX_UART)
#define GPIO_LPUART8_TX_3              (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_04_INDEX) | IOMUX_UART)

/* Medium Quality Sound (MQS) */

#define GPIO_MQS_LEFT_1                (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_05_INDEX))
#define GPIO_MQS_LEFT_2                (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_01_INDEX))
#define GPIO_MQS_LEFT_3                (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_14_INDEX))
#define GPIO_MQS_RIGHT_1               (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_04_INDEX))
#define GPIO_MQS_RIGHT_2               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_00_INDEX))
#define GPIO_MQS_RIGHT_3               (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_13_INDEX))

/* NMI */

#define GPIO_NMI_GLUE_NMI              (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_WAKEUP_INDEX))

/* Periodic Interrupt Timer (PIT) */

#define GPIO_PIT_TRIGGER00             (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_04_INDEX))

/* Quad Timer (QTimer) */

#define GPIO_QTIMER1_TIMER0            (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_00_INDEX))
#define GPIO_QTIMER1_TIMER1            (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_01_INDEX))
#define GPIO_QTIMER1_TIMER2            (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_02_INDEX))
#define GPIO_QTIMER1_TIMER3            (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_08_INDEX))

#define GPIO_QTIMER2_TIMER0_1          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_03_INDEX))
#define GPIO_QTIMER2_TIMER0_2          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_19_INDEX))
#define GPIO_QTIMER2_TIMER1_1          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_04_INDEX))
#define GPIO_QTIMER2_TIMER1_2          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_20_INDEX))
#define GPIO_QTIMER2_TIMER2_1          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_05_INDEX))
#define GPIO_QTIMER2_TIMER2_2          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_21_INDEX))
#define GPIO_QTIMER2_TIMER3_1          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_09_INDEX))
#define GPIO_QTIMER2_TIMER3_2          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_22_INDEX))

#define GPIO_QTIMER3_TIMER0_1          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_00_INDEX))
#define GPIO_QTIMER3_TIMER0_2          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_06_INDEX))
#define GPIO_QTIMER3_TIMER0_3          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_15_INDEX))
#define GPIO_QTIMER3_TIMER1_1          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_01_INDEX))
#define GPIO_QTIMER3_TIMER1_2          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_07_INDEX))
#define GPIO_QTIMER3_TIMER1_3          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_16_INDEX))
#define GPIO_QTIMER3_TIMER2_1          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_02_INDEX))
#define GPIO_QTIMER3_TIMER2_2          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_08_INDEX))
#define GPIO_QTIMER3_TIMER2_3          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_17_INDEX))
#define GPIO_QTIMER3_TIMER3_1          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_03_INDEX))
#define GPIO_QTIMER3_TIMER3_2          (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_10_INDEX))
#define GPIO_QTIMER3_TIMER3_3          (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_18_INDEX))

#define GPIO_QTIMER4_TIMER0            (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_09_INDEX))
#define GPIO_QTIMER4_TIMER1            (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_10_INDEX))
#define GPIO_QTIMER4_TIMER2            (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_11_INDEX))
#define GPIO_QTIMER4_TIMER3            (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_11_INDEX))

/* XTALOSC Reference Clock */

#define GPIO_REF_CLK_24M_1             (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_01_INDEX))
#define GPIO_REF_CLK_24M_2             (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_03_INDEX))
#define GPIO_REF_CLK_24M_3             (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_13_INDEX))
#define GPIO_REF_CLK_32K               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_00_INDEX))

/* Synchronous Audio Interface (SAI) */

#define GPIO_SAI1_MCLK_1               (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_09_INDEX))
#define GPIO_SAI1_MCLK_2               (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_13_INDEX))
#define GPIO_SAI1_MCLK_3               (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_03_INDEX))
#define GPIO_SAI1_RX_BCLK_1            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_11_INDEX))
#define GPIO_SAI1_RX_BCLK_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_15_INDEX))
#define GPIO_SAI1_RX_BCLK_3            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_05_INDEX))
#define GPIO_SAI1_RX_DATA00_1          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_12_INDEX))
#define GPIO_SAI1_RX_DATA00_2          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_00_INDEX))
#define GPIO_SAI1_RX_DATA00_3          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_06_INDEX))
#define GPIO_SAI1_RX_SYNC_1            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_10_INDEX))
#define GPIO_SAI1_RX_SYNC_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_14_INDEX))
#define GPIO_SAI1_RX_SYNC_3            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_04_INDEX))
#define GPIO_SAI1_TX_BCLK_1            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_14_INDEX))
#define GPIO_SAI1_TX_BCLK_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_02_INDEX))
#define GPIO_SAI1_TX_BCLK_3            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_08_INDEX))
#define GPIO_SAI1_TX_DATA00_1          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_13_INDEX))
#define GPIO_SAI1_TX_DATA00_2          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_01_INDEX))
#define GPIO_SAI1_TX_DATA00_3          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_07_INDEX))
#define GPIO_SAI1_TX_DATA01_1          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_12_INDEX))
#define GPIO_SAI1_TX_DATA01_2          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_02_INDEX))
#define GPIO_SAI1_TX_DATA02_1          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_11_INDEX))
#define GPIO_SAI1_TX_DATA02_2          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_01_INDEX))
#define GPIO_SAI1_TX_DATA03_1          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_10_INDEX))
#define GPIO_SAI1_TX_DATA03_2          (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_00_INDEX))
#define GPIO_SAI1_TX_SYNC_1            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_15_INDEX))
#define GPIO_SAI1_TX_SYNC_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_03_INDEX))
#define GPIO_SAI1_TX_SYNC_3            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_09_INDEX))

#define GPIO_SAI2_MCLK_1               (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_07_INDEX))
#define GPIO_SAI2_MCLK_2               (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_10_INDEX))
#define GPIO_SAI2_RX_BCLK_1            (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_10_INDEX))
#define GPIO_SAI2_RX_BCLK_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_06_INDEX))
#define GPIO_SAI2_RX_DATA_1            (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_08_INDEX))
#define GPIO_SAI2_RX_DATA_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_08_INDEX))
#define GPIO_SAI2_RX_SYNC_1            (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_09_INDEX))
#define GPIO_SAI2_RX_SYNC_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_07_INDEX))
#define GPIO_SAI2_TX_BCLK_1            (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_06_INDEX))
#define GPIO_SAI2_TX_BCLK_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_05_INDEX))
#define GPIO_SAI2_TX_DATA_1            (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_04_INDEX))
#define GPIO_SAI2_TX_DATA_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_09_INDEX))
#define GPIO_SAI2_TX_SYNC_1            (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_05_INDEX))
#define GPIO_SAI2_TX_SYNC_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_04_INDEX))

#define GPIO_SAI3_MCLK                 (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_37_INDEX))
#define GPIO_SAI3_RX_BCLK              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_35_INDEX))
#define GPIO_SAI3_RX_DATA              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_33_INDEX))
#define GPIO_SAI3_RX_SYNC              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_34_INDEX))
#define GPIO_SAI3_TX_BCLK              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_38_INDEX))
#define GPIO_SAI3_TX_DATA              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_36_INDEX))
#define GPIO_SAI3_TX_SYNC              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_39_INDEX))

/* Smart External Memory Controller (SEMC) */

#define GPIO_SEMC_ADDR00               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_09_INDEX))
#define GPIO_SEMC_ADDR01               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_10_INDEX))
#define GPIO_SEMC_ADDR02               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_11_INDEX))
#define GPIO_SEMC_ADDR03               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_12_INDEX))
#define GPIO_SEMC_ADDR04               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_13_INDEX))
#define GPIO_SEMC_ADDR05               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_14_INDEX))
#define GPIO_SEMC_ADDR06               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_15_INDEX))
#define GPIO_SEMC_ADDR07               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_16_INDEX))
#define GPIO_SEMC_ADDR08               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_17_INDEX))
#define GPIO_SEMC_ADDR09               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_18_INDEX))
#define GPIO_SEMC_ADDR10               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_23_INDEX))
#define GPIO_SEMC_ADDR11               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_19_INDEX))
#define GPIO_SEMC_ADDR12               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_20_INDEX))
#define GPIO_SEMC_BA0                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_21_INDEX))
#define GPIO_SEMC_BA1                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_22_INDEX))
#define GPIO_SEMC_CAS                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_24_INDEX))
#define GPIO_SEMC_CKE                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_27_INDEX))
#define GPIO_SEMC_CLK                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_26_INDEX))
#define GPIO_SEMC_CS0                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_29_INDEX))
#define GPIO_SEMC_CSX00                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_41_INDEX))
#define GPIO_SEMC_CSX01_1              (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_07_INDEX))
#define GPIO_SEMC_CSX01_2              (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_00_INDEX))
#define GPIO_SEMC_CSX02_1              (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_01_INDEX))
#define GPIO_SEMC_CSX02_2              (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_08_INDEX))
#define GPIO_SEMC_CSX03                (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_02_INDEX))
#define GPIO_SEMC_DATA00               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_00_INDEX))
#define GPIO_SEMC_DATA01               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_01_INDEX))
#define GPIO_SEMC_DATA02               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_02_INDEX))
#define GPIO_SEMC_DATA03               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_03_INDEX))
#define GPIO_SEMC_DATA04               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_04_INDEX))
#define GPIO_SEMC_DATA05               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_05_INDEX))
#define GPIO_SEMC_DATA06               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_06_INDEX))
#define GPIO_SEMC_DATA07               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_07_INDEX))
#define GPIO_SEMC_DATA08               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_30_INDEX))
#define GPIO_SEMC_DATA09               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_31_INDEX))
#define GPIO_SEMC_DATA10               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_32_INDEX))
#define GPIO_SEMC_DATA11               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_33_INDEX))
#define GPIO_SEMC_DATA12               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_34_INDEX))
#define GPIO_SEMC_DATA13               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_35_INDEX))
#define GPIO_SEMC_DATA14               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_36_INDEX))
#define GPIO_SEMC_DATA15               (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_37_INDEX))
#define GPIO_SEMC_DM00                 (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_08_INDEX))
#define GPIO_SEMC_DM01                 (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_38_INDEX))
#define GPIO_SEMC_DQS                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_39_INDEX))
#define GPIO_SEMC_RAS                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_25_INDEX))
#define GPIO_SEMC_RDY                  (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_40_INDEX))
#define GPIO_SEMC_WE                   (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_28_INDEX))

/* Secure Non-Volatile Storage (SNVS) */

#define GPIO_SNVS_LP_PMIC_ON_REQ       (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_PMIC_ON_REQ_INDEX))
#define GPIO_SNVS_VIO_5                (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_19_INDEX))
#define GPIO_SNVS_VIO_5_CTL            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_18_INDEX))

/* Sony/Philips Digital Interface (SPDIF) */

#define GPIO_SPDIF_EXT_CLK             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_07_INDEX))
#define GPIO_SPDIF_IN_1                (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_03_INDEX))
#define GPIO_SPDIF_IN_2                (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_16_INDEX))
#define GPIO_SPDIF_LOCK                (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_06_INDEX))
#define GPIO_SPDIF_OUT_1               (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_02_INDEX))
#define GPIO_SPDIF_OUT_2               (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_05_INDEX))
#define GPIO_SPDIF_OUT_3               (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_15_INDEX))
#define GPIO_SPDIF_SR_CLK              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_04_INDEX))

/* Boot Configuration */

#define GPIO_SRC_BOOT_CFG00            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_04_INDEX))
#define GPIO_SRC_BOOT_CFG01            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_05_INDEX))
#define GPIO_SRC_BOOT_CFG02            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_06_INDEX))
#define GPIO_SRC_BOOT_CFG03            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_07_INDEX))
#define GPIO_SRC_BOOT_CFG04            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_08_INDEX))
#define GPIO_SRC_BOOT_CFG05            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_09_INDEX))
#define GPIO_SRC_BOOT_CFG06            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_10_INDEX))
#define GPIO_SRC_BOOT_CFG07            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_11_INDEX))
#define GPIO_SRC_BOOT_CFG08            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_12_INDEX))
#define GPIO_SRC_BOOT_CFG09            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_13_INDEX))
#define GPIO_SRC_BOOT_CFG10            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_14_INDEX))
#define GPIO_SRC_BOOT_CFG11            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_15_INDEX))
#define GPIO_SRC_BOOT_MODE00           (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_04_INDEX))
#define GPIO_SRC_BOOT_MODE01           (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_05_INDEX))

/* USB OTG */

#define GPIO_USB_OTG1_ID_1             (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_02_INDEX))
#define GPIO_USB_OTG1_ID_2             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_01_INDEX))
#define GPIO_USB_OTG1_OC_1             (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_03_INDEX))
#define GPIO_USB_OTG1_OC_2             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_03_INDEX))
#define GPIO_USB_OTG1_PWR_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_01_INDEX))
#define GPIO_USB_OTG1_PWR_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_02_INDEX))

#define GPIO_USB_OTG2_ID_1             (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_00_INDEX))
#define GPIO_USB_OTG2_ID_2             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_00_INDEX))
#define GPIO_USB_OTG2_OC_1             (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_14_INDEX))
#define GPIO_USB_OTG2_OC_2             (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_40_INDEX))
#define GPIO_USB_OTG2_PWR_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_15_INDEX))
#define GPIO_USB_OTG2_PWR_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_41_INDEX))

/* Ultra Secured Digital Host Controller (uSDHC) */

#define GPIO_USDHC1_CD_1               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_02_INDEX))
#define GPIO_USDHC1_CD_2               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_12_INDEX))
#define GPIO_USDHC1_CD_3               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_35_INDEX))
#define GPIO_USDHC1_CLK                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_01_INDEX))
#define GPIO_USDHC1_CMD                (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_00_INDEX))
#define GPIO_USDHC1_DATA0              (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_02_INDEX))
#define GPIO_USDHC1_DATA1              (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_03_INDEX))
#define GPIO_USDHC1_DATA2              (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_04_INDEX))
#define GPIO_USDHC1_DATA3              (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_05_INDEX))
#define GPIO_USDHC1_RESET_1            (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_33_INDEX))
#define GPIO_USDHC1_RESET_2            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_00_INDEX))
#define GPIO_USDHC1_RESET_3            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_15_INDEX))
#define GPIO_USDHC1_VSELECT_1          (GPIO_PERIPH | GPIO_ALT2 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_34_INDEX))
#define GPIO_USDHC1_VSELECT_2          (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_01_INDEX))
#define GPIO_USDHC1_VSELECT_3          (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_14_INDEX))
#define GPIO_USDHC1_VSELECT_4          (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_41_INDEX))
#define GPIO_USDHC1_WP_1               (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_12_INDEX))
#define GPIO_USDHC1_WP_2               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_00_INDEX))
#define GPIO_USDHC1_WP_3               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_13_INDEX))
#define GPIO_USDHC1_WP_4               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_36_INDEX))

#define GPIO_USDHC2_CD_1               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_03_INDEX))
#define GPIO_USDHC2_CD_2               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_39_INDEX))
#define GPIO_USDHC2_CLK_1              (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_04_INDEX))
#define GPIO_USDHC2_CLK_2              (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_09_INDEX))
#define GPIO_USDHC2_CMD_1              (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_05_INDEX))
#define GPIO_USDHC2_CMD_2              (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_08_INDEX))
#define GPIO_USDHC2_DATA0_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_03_INDEX))
#define GPIO_USDHC2_DATA0_2            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_04_INDEX))
#define GPIO_USDHC2_DATA1_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_02_INDEX))
#define GPIO_USDHC2_DATA1_2            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_05_INDEX))
#define GPIO_USDHC2_DATA2_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_01_INDEX))
#define GPIO_USDHC2_DATA2_2            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_06_INDEX))
#define GPIO_USDHC2_DATA3_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_00_INDEX))
#define GPIO_USDHC2_DATA3_2            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_07_INDEX))
#define GPIO_USDHC2_DATA4_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_08_INDEX))
#define GPIO_USDHC2_DATA4_2            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_12_INDEX))
#define GPIO_USDHC2_DATA5_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_09_INDEX))
#define GPIO_USDHC2_DATA5_2            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_13_INDEX))
#define GPIO_USDHC2_DATA6_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_10_INDEX))
#define GPIO_USDHC2_DATA6_2            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_14_INDEX))
#define GPIO_USDHC2_DATA7_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_11_INDEX))
#define GPIO_USDHC2_DATA7_2            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_15_INDEX))
#define GPIO_USDHC2_RESET_1            (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B1_06_INDEX))
#define GPIO_USDHC2_RESET_2            (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_11_INDEX))
#define GPIO_USDHC2_RESET_3            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_11_INDEX))
#define GPIO_USDHC2_RESET_4            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_40_INDEX))
#define GPIO_USDHC2_VSELECT            (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_38_INDEX))
#define GPIO_USDHC2_WP_1               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_10_INDEX))
#define GPIO_USDHC2_WP_2               (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_37_INDEX))

/* Watchdog Timer (WDOG1-2) */

#define GPIO_WDOG1_1                   (GPIO_PERIPH | GPIO_ALT0 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_13_INDEX))
#define GPIO_WDOG1_2                   (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_10_INDEX))
#define GPIO_WDOG1_3                   (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B1_00_INDEX))
#define GPIO_WDOG1_WDOG_1              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_11_INDEX))
#define GPIO_WDOG1_WDOG_2              (GPIO_PERIPH | GPIO_ALT4 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_39_INDEX))
#define GPIO_WDOG1_WDOG_RST_DEB        (GPIO_PERIPH | GPIO_ALT7 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_15_INDEX))

#define GPIO_WDOG2_RESET_DEB           (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_03_INDEX))
#define GPIO_WDOG2_WDOG                (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_12_INDEX))

/* Inter-Peripheral Crossbar Switch A (XBARA) */

#define GPIO_XBAR1_IN02                (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_14_INDEX))
#define GPIO_XBAR1_IN03_1              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_15_INDEX))
#define GPIO_XBAR1_IN03_2              (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_01_INDEX))
#define GPIO_XBAR1_IN20_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_15_INDEX))
#define GPIO_XBAR1_IN20_2              (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_08_INDEX))
#define GPIO_XBAR1_IN21_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_16_INDEX))
#define GPIO_XBAR1_IN21_2              (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_09_INDEX))
#define GPIO_XBAR1_IN22_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_36_INDEX))
#define GPIO_XBAR1_IN22_2              (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_10_INDEX))
#define GPIO_XBAR1_IN23_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_37_INDEX))
#define GPIO_XBAR1_IN23_2              (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_11_INDEX))
#define GPIO_XBAR1_IN24_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_14_INDEX))
#define GPIO_XBAR1_IN24_2              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_12_INDEX))
#define GPIO_XBAR1_IN25_1              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_15_INDEX))
#define GPIO_XBAR1_IN25_2              (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_13_INDEX))
#define GPIO_XBAR1_INOUT04_1           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_02_INDEX))
#define GPIO_XBAR1_INOUT04_2           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_00_INDEX))
#define GPIO_XBAR1_INOUT05_1           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_03_INDEX))
#define GPIO_XBAR1_INOUT05_2           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_01_INDEX))
#define GPIO_XBAR1_INOUT06_1           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_04_INDEX))
#define GPIO_XBAR1_INOUT06_2           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_02_INDEX))
#define GPIO_XBAR1_INOUT07_1           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_05_INDEX))
#define GPIO_XBAR1_INOUT07_2           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_03_INDEX))
#define GPIO_XBAR1_INOUT08_1           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_06_INDEX))
#define GPIO_XBAR1_INOUT08_2           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_04_INDEX))
#define GPIO_XBAR1_INOUT09_1           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_07_INDEX))
#define GPIO_XBAR1_INOUT09_2           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_SD_B0_05_INDEX))
#define GPIO_XBAR1_INOUT10             (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_12_INDEX))
#define GPIO_XBAR1_INOUT11             (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_13_INDEX))
#define GPIO_XBAR1_INOUT12             (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_14_INDEX))
#define GPIO_XBAR1_INOUT13             (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B0_15_INDEX))
#define GPIO_XBAR1_INOUT14_1           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_00_INDEX))
#define GPIO_XBAR1_INOUT14_2           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_00_INDEX))
#define GPIO_XBAR1_INOUT15_1           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_01_INDEX))
#define GPIO_XBAR1_INOUT15_2           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_01_INDEX))
#define GPIO_XBAR1_INOUT16_1           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_02_INDEX))
#define GPIO_XBAR1_INOUT16_2           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_02_INDEX))
#define GPIO_XBAR1_INOUT17_1           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_03_INDEX))
#define GPIO_XBAR1_INOUT17_2           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_B1_03_INDEX))
#define GPIO_XBAR1_INOUT17_3           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_08_INDEX))
#define GPIO_XBAR1_INOUT17_4           (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_05_INDEX))
#define GPIO_XBAR1_INOUT18_1           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_35_INDEX))
#define GPIO_XBAR1_INOUT18_2           (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_06_INDEX))
#define GPIO_XBAR1_INOUT19_3           (GPIO_PERIPH | GPIO_ALT1 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_14_INDEX))
#define GPIO_XBAR1_INOUT19_4           (GPIO_PERIPH | GPIO_ALT6 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_AD_B0_07_INDEX))
#define GPIO_XBAR1_XBAR_IN02           (GPIO_PERIPH | GPIO_ALT3 | GPIO_PADMUX(IMXRT_PADMUX_GPIO_EMC_00_INDEX))

#endif /* __ARCH_ARM_SRC_IMXRT_CHIP_IMXRT106X_PINMUX_H */
