<?php

namespace App\Models;

use App\Models\Post;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Category extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'description',
        'slug'
    ];

    /**
     * Get all posts by Category
     *
     * @return Post
     */
    public function posts()
    {
        return $this->hasMany(Post::class);
    }
}
